/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.numbertheory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.numbertheory.Multiset;
import org.matheclipse.core.numbertheory.SortedMultiset;

public class SortedMultiset_BottomUp<T extends Comparable<T>>
extends TreeMap<T, Integer>
implements SortedMultiset<T> {
    private static final long serialVersionUID = -6604624351619809213L;
    private static final Logger LOGGER = LogManager.getLogger();

    public SortedMultiset_BottomUp() {
    }

    public SortedMultiset_BottomUp(Collection<T> values) {
        this();
        this.addAll(values);
    }

    public SortedMultiset_BottomUp(T[] values) {
        this();
        for (T value : values) {
            this.add(value);
        }
    }

    public SortedMultiset_BottomUp(Multiset<T> original) {
        this();
        this.addAll(original);
    }

    @Override
    public int add(T entry) {
        Integer myMult = (Integer)super.get(entry);
        int oldMult = myMult != null ? myMult : 0;
        int newMult = oldMult + 1;
        super.put(entry, newMult);
        return oldMult;
    }

    @Override
    public int add(T entry, int mult) {
        int oldMult;
        Integer myMult = (Integer)super.get(entry);
        int n = oldMult = myMult != null ? myMult : 0;
        if (mult > 0) {
            int newMult = oldMult + mult;
            super.put(entry, newMult);
        }
        return oldMult;
    }

    @Override
    public void addAll(Multiset<T> other) {
        if (other != null) {
            for (Map.Entry<T, Integer> entry : other.entrySet()) {
                this.add((T)((Comparable)entry.getKey()), (int)entry.getValue());
            }
        }
    }

    @Override
    public void addAll(Collection<T> values) {
        if (values != null) {
            for (Comparable value : values) {
                this.add((T)value);
            }
        }
    }

    @Override
    public void addAll(T[] values) {
        if (values != null) {
            for (T value : values) {
                this.add(value);
            }
        }
    }

    @Override
    public Integer remove(Object key) {
        int imult;
        Integer mult = (Integer)this.get(key);
        if (mult != null && (imult = mult.intValue()) > 0) {
            if (imult > 1) {
                Comparable castedKey = (Comparable)key;
                this.put(castedKey, imult - 1);
            } else {
                super.remove(key);
            }
        }
        return mult;
    }

    @Override
    public int remove(T key, int mult) {
        int oldMult;
        Integer myMult = (Integer)super.get(key);
        int n = oldMult = myMult != null ? myMult : 0;
        if (oldMult > 0) {
            int newMult = Math.max(0, oldMult - mult);
            if (newMult > 0) {
                super.put(key, newMult);
                return oldMult;
            }
            return (Integer)super.remove(key);
        }
        return 0;
    }

    @Override
    public int removeAll(T key) {
        Integer mult = (Integer)this.get(key);
        if (mult != null) {
            int imult = mult;
            if (imult > 0) {
                super.remove(key);
            }
            return imult;
        }
        return 0;
    }

    @Override
    public SortedMultiset<T> intersect(Multiset<T> other) {
        SortedMultiset_BottomUp<Comparable> resultset = new SortedMultiset_BottomUp<Comparable>();
        if (other != null) {
            for (Map.Entry myEntry : this.entrySet()) {
                int jointMult;
                Comparable myKey;
                Integer otherMult;
                int myMult = (Integer)myEntry.getValue();
                if (myMult <= 0 || (otherMult = other.get(myKey = (Comparable)myEntry.getKey())) == null || (jointMult = Math.min(myMult, otherMult)) <= 0) continue;
                resultset.add(myKey, jointMult);
            }
        }
        return resultset;
    }

    @Override
    public int totalCount() {
        int sum = 0;
        for (Integer mult : this.values()) {
            sum += mult.intValue();
        }
        return sum;
    }

    @Override
    public T getSmallestElement() {
        return (T)(this.size() > 0 ? (Comparable)this.keySet().iterator().next() : null);
    }

    @Override
    public T getBiggestElement() {
        return (T)((Comparable)((SortedSet)this.keySet()).last());
    }

    @Override
    public List<T> toList() {
        ArrayList<Comparable> flatList = new ArrayList<Comparable>(this.totalCount());
        for (Map.Entry entry : this.entrySet()) {
            Comparable value = (Comparable)entry.getKey();
            int multiplicity = (Integer)entry.getValue();
            for (int i = 0; i < multiplicity; ++i) {
                flatList.add(value);
            }
        }
        return flatList;
    }

    @Override
    public Iterator<Map.Entry<T, Integer>> getTopDownIterator() {
        return this.descendingMap().entrySet().iterator();
    }

    @Override
    public int compareTo(SortedMultiset<T> other) {
        if (other == null) {
            return Integer.MAX_VALUE;
        }
        Iterator<Map.Entry<T, Integer>> myEntryIter = this.getTopDownIterator();
        Iterator<Map.Entry<T, Integer>> otherEntryIter = other.getTopDownIterator();
        while (myEntryIter.hasNext() && otherEntryIter.hasNext()) {
            Comparable otherKey;
            Map.Entry<T, Integer> myEntry = myEntryIter.next();
            Comparable myKey = myEntry != null ? (Comparable)myEntry.getKey() : null;
            Map.Entry<T, Integer> otherEntry = otherEntryIter.next();
            Comparable comparable = otherKey = otherEntry != null ? (Comparable)otherEntry.getKey() : null;
            if (myKey != null && otherKey != null) {
                Integer otherMultiplicity;
                int otherMult;
                int keyCmp = myKey.compareTo(otherKey);
                if (keyCmp != 0) {
                    return keyCmp;
                }
                Integer myMultiplicity = myEntry.getValue();
                int myMult = myMultiplicity != null ? myMultiplicity : 0;
                int multCmp = myMult - (otherMult = (otherMultiplicity = otherEntry.getValue()) != null ? otherMultiplicity : 0);
                if (multCmp == 0) continue;
                return multCmp;
            }
            if (myKey != null && otherKey == null) {
                return Integer.MAX_VALUE;
            }
            if (myKey != null || otherKey == null) continue;
            return Integer.MIN_VALUE;
        }
        if (myEntryIter.hasNext()) {
            return Integer.MAX_VALUE;
        }
        if (otherEntryIter.hasNext()) {
            return Integer.MIN_VALUE;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof SortedMultiset) {
            SortedMultiset other = (SortedMultiset)o;
            if (this.size() != other.size()) {
                return false;
            }
            Iterator<Map.Entry<T, Integer>> myEntryIter = this.getTopDownIterator();
            Iterator otherEntryIter = other.getTopDownIterator();
            while (myEntryIter.hasNext()) {
                Map.Entry otherEntry;
                if (!otherEntryIter.hasNext()) {
                    return false;
                }
                Map.Entry<T, Integer> myEntry = myEntryIter.next();
                if (myEntry.equals(otherEntry = otherEntryIter.next())) continue;
                return false;
            }
            return !otherEntryIter.hasNext();
        }
        return false;
    }

    @Override
    public int hashCode() {
        throw new IllegalStateException("SortedMultisets are not ready to be used in hash structures");
    }

    @Override
    public String toString(String entrySep, String expSep) {
        Object ret = "";
        for (Map.Entry entry : this.entrySet()) {
            ret = (String)ret + entry.getKey();
            int exp = (Integer)entry.getValue();
            if (exp > 1) {
                ret = (String)ret + expSep + exp;
            }
            ret = (String)ret + " " + entrySep + " ";
        }
        if (((String)ret).length() > 0) {
            ret = ((String)ret).substring(0, ((String)ret).length() - 3);
        }
        return ret;
    }
}

