/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.numbertheory;

import java.math.BigInteger;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.expression.ComplexSym;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;

public final class GaussianInteger {
    private BigInteger[] Primes;
    private int[] Exponents;
    private BigInteger ValA;
    private BigInteger ValB;
    private int Ind;

    public static IAST factorize(BigInteger re, BigInteger im, IExpr num) {
        ComplexSym key;
        GaussianInteger g = new GaussianInteger();
        TreeMap<ComplexSym, Integer> complexMap = new TreeMap<ComplexSym, Integer>();
        g.gaussianFactorization2(re, im, complexMap);
        IASTAppendable list = F.ListAlloc(complexMap.size() + 1);
        IExpr factor = F.C1;
        IASTAppendable ast = F.TimesAlloc(complexMap.size());
        for (Map.Entry entry : complexMap.entrySet()) {
            key = (ComplexSym)entry.getKey();
            int i = (Integer)entry.getValue();
            if (i == 1) {
                ast.append(key);
                continue;
            }
            IInteger is = F.ZZ(i);
            ast.append(F.Power((IExpr)key, is));
        }
        factor = F.eval(F.Divide(num, ast));
        if (!factor.isOne()) {
            list.append(F.list(factor, F.C1));
        }
        for (Map.Entry entry : complexMap.entrySet()) {
            key = (ComplexSym)entry.getKey();
            IInteger is = F.ZZ((Integer)entry.getValue());
            list.append(F.list(key, is));
        }
        return list;
    }

    void gaussianFactorization2(BigInteger re, BigInteger im, SortedMap<ComplexSym, Integer> complexMap) {
        BigInteger BigInt2 = BigInteger.valueOf(2L);
        this.ValA = re;
        this.ValB = im;
        BigInteger norm = this.ValA.multiply(this.ValA).add(this.ValB.multiply(this.ValB));
        this.Ind = 0;
        if (norm.signum() == 0) {
            return;
        }
        if (norm.compareTo(BigInteger.ONE) > 0) {
            SortedMap<BigInteger, Integer> bigMap = Config.PRIME_FACTORS.factorInteger(norm);
            this.Ind = bigMap.size();
            this.Primes = new BigInteger[this.Ind];
            this.Exponents = new int[this.Ind];
            int i = 0;
            for (Map.Entry<BigInteger, Integer> entry : bigMap.entrySet()) {
                this.Primes[i] = entry.getKey();
                this.Exponents[i++] = entry.getValue();
            }
            for (int index = 0; index < this.Ind; ++index) {
                int index2;
                BigInteger p = this.Primes[index];
                if (p.equals(BigInt2)) {
                    for (index2 = 0; index2 < this.Exponents[index]; ++index2) {
                        this.divideGaussian(BigInteger.ONE, BigInteger.ONE, complexMap);
                        this.divideGaussian(BigInteger.ONE, BigInteger.ONE.negate(), complexMap);
                    }
                    continue;
                }
                if (!p.testBit(1)) {
                    BigInteger Tmp;
                    BigInteger Mult1;
                    BigInteger q = p.subtract(BigInteger.ONE);
                    BigInteger K = BigInteger.ONE;
                    while ((Mult1 = (K = K.add(BigInteger.ONE)).modPow(q.shiftRight(2), p)).equals(BigInteger.ONE) || Mult1.equals(q)) {
                    }
                    BigInteger Mult2 = BigInteger.ONE;
                    while (!(K = Mult1.multiply(Mult1).add(Mult2.multiply(Mult2)).divide(p)).equals(BigInteger.ONE)) {
                        BigInteger M1 = Mult1.mod(K);
                        BigInteger M2 = Mult2.mod(K);
                        if (M1.compareTo(K.shiftRight(1)) > 0) {
                            M1 = M1.subtract(K);
                        }
                        if (M2.compareTo(K.shiftRight(1)) > 0) {
                            M2 = M2.subtract(K);
                        }
                        Tmp = Mult1.multiply(M1).add(Mult2.multiply(M2)).divide(K);
                        Mult2 = Mult1.multiply(M2).subtract(Mult2.multiply(M1)).divide(K);
                        Mult1 = Tmp;
                    }
                    if (Mult1.abs().compareTo(Mult2.abs()) < 0) {
                        Tmp = Mult1;
                        Mult1 = Mult2;
                        Mult2 = Tmp;
                    }
                    for (index2 = 0; index2 < this.Exponents[index]; ++index2) {
                        this.divideGaussian(Mult1, Mult2, complexMap);
                        this.divideGaussian(Mult1, Mult2.negate(), complexMap);
                    }
                    continue;
                }
                for (index2 = 0; index2 < this.Exponents[index]; ++index2) {
                    this.divideGaussian(this.Primes[index], BigInteger.ZERO, complexMap);
                }
            }
        }
    }

    private void divideGaussian(BigInteger real, BigInteger imag, SortedMap<ComplexSym, Integer> complexMap) {
        real = real.abs();
        BigInteger norm = real.multiply(real).add(imag.multiply(imag));
        BigInteger realNum = this.ValA.multiply(real).add(this.ValB.multiply(imag));
        BigInteger imagNum = this.ValB.multiply(real).subtract(this.ValA.multiply(imag));
        if (realNum.mod(norm).signum() == 0 && imagNum.mod(norm).signum() == 0) {
            this.ValA = realNum.divide(norm);
            this.ValB = imagNum.divide(norm);
            if (real.signum() < 0) {
                real = real.negate();
                if (imag.signum() > 0) {
                    BigInteger temp = imag;
                    imag = real;
                    real = temp;
                } else {
                    imag = imag.negate();
                }
            } else if (imag.signum() < 0) {
                BigInteger temp = imag = imag.negate();
                imag = real;
                real = temp;
            }
            ComplexSym c = ComplexSym.valueOf(F.ZZ(real), F.ZZ(imag));
            Integer value = (Integer)complexMap.get(c);
            if (value == null) {
                complexMap.put(c, 1);
            } else {
                complexMap.put(c, value + 1);
            }
        }
    }

    public static IInteger[] quotientRemainder(IInteger[] c1, IInteger[] c2) {
        IInteger fReal = c1[0];
        IInteger fImaginary = c1[1];
        IInteger re = c2[0];
        IInteger im = c2[1];
        IInteger numeratorReal = fReal.multiply(re).add(fImaginary.multiply(im));
        IInteger numeratorImaginary = fReal.multiply(im.negate()).add(re.multiply(fImaginary));
        IInteger denominator = re.multiply(re).add(im.multiply(im));
        if (denominator.isZero()) {
            throw new IllegalArgumentException("Denominator can not be zero.");
        }
        IInteger divisionReal = numeratorReal.divideBy(denominator).roundExpr();
        IInteger divisionImaginary = numeratorImaginary.divideBy(denominator).roundExpr();
        IInteger remainderReal = fReal.subtract(re.multiply(divisionReal)).add(im.multiply(divisionImaginary));
        IInteger remainderImaginary = fImaginary.subtract(re.multiply(divisionImaginary)).subtract(im.multiply(divisionReal));
        return new IInteger[]{divisionReal, divisionImaginary, remainderReal, remainderImaginary};
    }

    public static IInteger[] gcd(IInteger[] g1, IInteger[] g2) {
        IInteger fReal = g1[0];
        IInteger fImaginary = g1[1];
        if (fReal.isZero() && fImaginary.isZero() || g2[0].isZero() && g2[1].isZero()) {
            return new IInteger[]{F.C0, F.C0};
        }
        IInteger dividendRe = fReal;
        IInteger dividendIm = fImaginary;
        IInteger dividersRe = g2[0];
        IInteger dividersIm = g2[1];
        while (!dividersRe.isZero() || !dividersIm.isZero()) {
            IInteger[] integerAndRemainder = GaussianInteger.quotientRemainder(new IInteger[]{dividendRe, dividendIm}, new IInteger[]{dividersRe, dividersIm});
            dividendRe = dividersRe;
            dividendIm = dividersIm;
            dividersRe = integerAndRemainder[2];
            dividersIm = integerAndRemainder[3];
        }
        if (dividendRe.isMinusOne() && dividendIm.isZero() || dividendRe.isZero() && dividendIm.isOne() || dividendRe.isZero() && dividendIm.isMinusOne()) {
            return new IInteger[]{F.C1, F.C0};
        }
        return new IInteger[]{dividendRe, dividendIm};
    }
}

