/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.io;

public enum Extension {
    BMP,
    CSV,
    DAT,
    DOT,
    EXPRESSIONJSON,
    GIF,
    GRAPHML,
    GZ,
    JPG,
    JSON,
    M,
    PNG,
    STRING,
    TABLE,
    TSV,
    TXT,
    WXF;


    public static boolean isAllowedExtension(String extensionString) {
        try {
            Extension ext = Extension.valueOf(extensionString.toUpperCase());
            if (ext != null) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    public static Extension exportFilename(String filename) {
        try {
            int pos = filename.lastIndexOf(46);
            if (pos >= 1) {
                String ucExtension = filename.substring(pos + 1).toUpperCase();
                if (ucExtension.equals("DATA")) {
                    return DAT;
                }
                if (ucExtension.equals("ExpressionJSON")) {
                    return EXPRESSIONJSON;
                }
                return Extension.valueOf(ucExtension);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return DAT;
    }

    public static Extension exportExtension(String extensionString) {
        try {
            if (extensionString.equals("ExpressionJSON")) {
                return EXPRESSIONJSON;
            }
            String ucExtension = extensionString.toUpperCase();
            if (ucExtension.equals("DATA")) {
                return DAT;
            }
            return Extension.valueOf(extensionString.toUpperCase());
        }
        catch (RuntimeException runtimeException) {
            return DAT;
        }
    }

    public static Extension importFilename(String filename) {
        try {
            int pos = filename.lastIndexOf(46);
            if (pos >= 1) {
                return Extension.valueOf(filename.substring(pos + 1).toUpperCase());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return STRING;
    }

    public static Extension importExtension(String extensionString) {
        try {
            return Extension.valueOf(extensionString.toUpperCase());
        }
        catch (RuntimeException runtimeException) {
            if (extensionString.equals("Text")) {
                return TXT;
            }
            return STRING;
        }
    }
}

