/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.interfaces;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import org.matheclipse.core.convert.Object2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcherAndInvoker;
import org.matheclipse.core.patternmatching.RulesData;

public interface ISymbol
extends IExpr {
    public static final int CONSTANT = 2;
    public static final int FLAT = 8;
    public static final int HOLDFIRST = 32;
    public static final int HOLDREST = 64;
    public static final int HOLDALL = 96;
    public static final int HOLDCOMPLETE = 224;
    public static final int SEQUENCEHOLD = 262144;
    public static final int HOLDALLCOMPLETE = 262624;
    public static final int LISTABLE = 512;
    public static final int NHOLDFIRST = 8192;
    public static final int NHOLDREST = 16384;
    public static final int NHOLDALL = 24576;
    public static final int NOATTRIBUTE = 0;
    public static final int NUMERICFUNCTION = 1024;
    public static final int PACKAGE_LOADED = 2048;
    public static final int ONEIDENTITY = 1;
    public static final int ORDERLESS = 4;
    public static final int FLATORDERLESS = 12;
    public static final int PROTECTED = 32768;
    public static final int READPROTECTED = 65536;
    public static final int DIRTY_FLAG_ASSIGNED_VALUE = 1;
    public static final int SETDELAYED_FLAG_ASSIGNED_VALUE = 0x10000002;

    public void addAttributes(int var1);

    default public void assignValue(IExpr value) {
        this.assignValue(value, false);
    }

    public void assignValue(IExpr var1, boolean var2);

    public IExpr assignedValue();

    public void clear(EvalEngine var1);

    public void clearValue();

    public void clearAll(EvalEngine var1);

    public void clearAttributes(int var1);

    public void clearEvalFlags(int var1);

    public boolean containsRules();

    public RulesData createRulesData(int[] var1);

    public IAST definition();

    public String definitionToString() throws IOException;

    public IExpr evalDownRule(EvalEngine var1, IExpr var2);

    public IExpr evalMessage(String var1);

    public IExpr evalUpRules(IExpr var1, EvalEngine var2);

    default public IAST f(IExpr arg1) {
        return F.unaryAST1(this, arg1);
    }

    default public IAST f(IExpr arg1, IExpr arg2) {
        return F.binaryAST2((IExpr)this, arg1, arg2);
    }

    default public IAST f(IExpr arg1, IExpr arg2, IExpr arg3) {
        return F.ternaryAST3(this, arg1, arg2, arg3);
    }

    @Deprecated
    default public IExpr get() {
        return this.assignedValue();
    }

    public int getAttributes();

    public Context getContext();

    public IExpr getDefaultValue();

    public IExpr getDefaultValue(int var1);

    public RulesData getRulesData();

    public String getSymbolName();

    default public String getContextSymbolName() {
        return this.getContext().getContextName() + this.getSymbolName();
    }

    public boolean hasAssignedSymbolValue();

    public boolean hasFlatAttribute();

    public boolean hasHoldAllCompleteAttribute();

    public boolean hasListableAttribute();

    public static boolean hasFlatAttribute(int attributes) {
        return (attributes & 8) == 8;
    }

    public static boolean hasHoldAllCompleteAttribute(int attributes) {
        return (attributes & 0x401E0) == 262624;
    }

    public static boolean hasListableAttribute(int attributes) {
        return (attributes & 0x200) == 512;
    }

    public static boolean hasOrderlessAttribute(int attributes) {
        return (attributes & 4) == 4;
    }

    public static boolean hasOrderlessFlatAttribute(int attributes) {
        return (attributes & 0xC) == 12;
    }

    public boolean hasOneIdentityAttribute();

    public boolean hasOrderlessAttribute();

    public boolean hasOrderlessFlatAttribute();

    @Override
    default public boolean isBooleanFormula() {
        return !this.isConstantAttribute() || this.isTrue() || this.isFalse();
    }

    @Override
    default public boolean isConstantAttribute() {
        return (this.getAttributes() & 2) == 2;
    }

    default public boolean isContext(Context context) {
        return context == this.getContext();
    }

    public boolean isLocked();

    public boolean isLocked(boolean var1);

    @Override
    default public boolean isNumericFunction(boolean allowList) {
        return this.isConstantAttribute();
    }

    default public boolean isNumericFunctionAttribute() {
        return (this.getAttributes() & 0x400) == 1024;
    }

    default public boolean isProtected() {
        return (this.getAttributes() & 0x8000) == 32768;
    }

    @Override
    public boolean isString(String var1);

    public boolean isSymbolName(String var1);

    default public boolean isSymbolID(int ... ids) {
        return false;
    }

    @Override
    default public IExpr[] linear(IExpr variable) {
        if (this.equals(variable)) {
            return new IExpr[]{F.C0, F.C1};
        }
        return new IExpr[]{this, F.C0};
    }

    @Override
    default public IExpr[] linearPower(IExpr variable) {
        if (this.equals(variable)) {
            return new IExpr[]{F.C0, F.C1, F.C1};
        }
        return new IExpr[]{this, F.C0, F.C1};
    }

    default public IExpr mapConstantDouble(DoubleFunction<IExpr> function) {
        return F.NIL;
    }

    public IExpr of(EvalEngine var1, IExpr ... var2);

    public IExpr of1(EvalEngine var1, IExpr var2, IExpr ... var3);

    default public IExpr of(IExpr ... args) {
        return this.of(EvalEngine.get(), args);
    }

    default public IExpr of(int ... args) {
        IExpr[] array = new IExpr[args.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = F.ZZ(args[i]);
        }
        return this.of(array);
    }

    default public double ofN(double ... args) throws ArgumentTypeException {
        IExpr[] array = new IExpr[args.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = F.num(args[i]);
        }
        return this.of(array).evalDouble();
    }

    default public IExpr of(String ... args) {
        IExpr[] array = new IExpr[args.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = F.stringx(args[i]);
        }
        return this.of(array);
    }

    default public IExpr of(boolean ... args) {
        IExpr[] array = new IExpr[args.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = args[i] ? S.True : S.False;
        }
        return this.of(array);
    }

    public IExpr ofNIL(EvalEngine var1, IExpr ... var2);

    public boolean ofQ(EvalEngine var1, IExpr ... var2);

    public boolean ofQ(IExpr ... var1);

    default public IExpr ofObject(Object ... args) {
        IExpr[] array = new IExpr[args.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Object2Expr.convert(args[i], true, false);
        }
        return this.of(array);
    }

    default public int ordinal() {
        return -1;
    }

    public void putDownRule(int var1, boolean var2, IExpr var3, IExpr var4, boolean var5);

    public void putDownRule(int var1, boolean var2, IExpr var3, IExpr var4, int var5, boolean var6);

    public void putDownRule(PatternMatcherAndInvoker var1);

    public void putMessage(int var1, String var2, IStringX var3);

    public IPatternMatcher putUpRule(int var1, boolean var2, IAST var3, IExpr var4);

    public IPatternMatcher putUpRule(int var1, boolean var2, IAST var3, IExpr var4, int var5);

    public void readRules(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    public IExpr[] reassignSymbolValue(Function<IExpr, IExpr> var1, ISymbol var2, EvalEngine var3);

    public IExpr[] reassignSymbolValue(IASTMutable var1, ISymbol var2, EvalEngine var3);

    public boolean removeRule(int var1, boolean var2, IExpr var3, boolean var4);

    public void setAttributes(int var1);

    public void setDefaultValue(IExpr var1);

    public void setDefaultValue(int var1, IExpr var2);

    public void setRulesData(RulesData var1);

    public boolean writeRules(ObjectOutputStream var1) throws IOException;
}

