/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.interfaces;

import org.apfloat.Apfloat;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;

public interface ISignedNumber
extends INumber {
    @Override
    public ISignedNumber abs();

    public ApfloatNum apfloatNumValue();

    public Apfloat apfloatValue();

    @Override
    default public IExpr complexArg() {
        if (this.complexSign() < 0) {
            return S.Pi;
        }
        return F.C0;
    }

    @Override
    default public ISignedNumber conjugate() {
        return this;
    }

    public ISignedNumber divideBy(ISignedNumber var1);

    public double doubleValue();

    @Override
    default public double evalDouble() throws ArgumentTypeException {
        return this.doubleValue();
    }

    @Override
    default public Complex evalComplex() throws ArgumentTypeException {
        return new Complex(this.doubleValue());
    }

    @Override
    public IInteger ceilFraction() throws ArithmeticException;

    @Override
    public IInteger floorFraction() throws ArithmeticException;

    @Override
    public ISignedNumber fractionalPart();

    @Override
    public IInteger integerPart();

    @Override
    public ISignedNumber inverse();

    public boolean isGT(ISignedNumber var1);

    default public boolean isGE(ISignedNumber that) {
        return !this.isLT(that);
    }

    @Deprecated
    default public boolean isGreaterThan(ISignedNumber that) {
        return this.isGT(that);
    }

    public boolean isLT(ISignedNumber var1);

    default public boolean isLE(ISignedNumber that) {
        return !this.isGT(that);
    }

    @Deprecated
    default public boolean isLessThan(ISignedNumber that) {
        return this.isLT(that);
    }

    @Override
    public boolean isNegative();

    @Override
    default public boolean isNegativeResult() {
        return this.isNegative();
    }

    @Override
    default public boolean isNonNegativeResult() {
        return !this.isNegative();
    }

    @Override
    public boolean isPositive();

    @Override
    default public boolean isPositiveResult() {
        return this.isPositive();
    }

    @Override
    public boolean isZero();

    @Override
    default public IExpr lower() {
        return this;
    }

    @Override
    public ISignedNumber negate();

    public INum numValue();

    @Override
    public ISignedNumber opposite();

    @Override
    public IInteger roundExpr();

    public ISignedNumber roundClosest(ISignedNumber var1);

    @Override
    public int complexSign();

    public ISignedNumber subtractFrom(ISignedNumber var1);

    public int toInt() throws ArithmeticException;

    default public boolean isRange(ISignedNumber from, ISignedNumber to) {
        return this.isGE(from) && this.isLE(to);
    }

    default public boolean isRangeExclExcl(ISignedNumber from, ISignedNumber to) {
        return this.isGT(from) && this.isLT(to);
    }

    default public boolean isRangeExclIncl(ISignedNumber from, ISignedNumber to) {
        return this.isGT(from) && this.isLE(to);
    }

    default public boolean isRangeInclExcl(ISignedNumber from, ISignedNumber to) {
        return this.isGE(from) && this.isLT(to);
    }

    public long toLong() throws ArithmeticException;

    @Override
    default public IExpr unitStep() {
        return this.isNegative() ? F.C0 : F.C1;
    }

    @Override
    default public IExpr upper() {
        return this;
    }

    @Override
    default public IAST toPolarCoordinates() {
        if (this.isNegative()) {
            return F.list(this.negate(), S.Pi);
        }
        return F.list(this, F.C0);
    }
}

