/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.interfaces;

import java.math.BigInteger;
import org.hipparchus.fraction.BigFraction;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IBigNumber;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISignedNumber;

public interface IRational
extends ISignedNumber,
IBigNumber {
    @Override
    public IRational abs();

    public IRational add(IRational var1);

    @Override
    public IInteger ceil();

    public void checkBitLength();

    public int compareInt(int var1);

    @Override
    public IRational dec();

    public IInteger denominator();

    public IRational divideBy(IRational var1);

    public boolean equalsFraction(int var1, int var2);

    public IASTAppendable factorInteger();

    public IAST factorSmallPrimes(int var1, int var2);

    @Override
    public IInteger floor();

    @Override
    public IRational fractionalPart();

    @Deprecated
    default public IInteger getDenominator() {
        return this.denominator();
    }

    @Deprecated
    default public BigFraction getFraction() {
        return this.toBigFraction();
    }

    @Deprecated
    default public IInteger getNumerator() {
        return this.numerator();
    }

    @Override
    default public IRational imRational() {
        return F.C0;
    }

    @Override
    public IRational inc();

    @Override
    public IRational inverse();

    default public IRational mod(IRational m) {
        return this.subtract(m.multiply(this.divideBy(m).floorFraction()));
    }

    @Override
    public IRational multiply(int var1);

    public IRational multiply(IRational var1);

    @Override
    public IRational negate();

    public IRational normalize();

    public IInteger numerator();

    public IRational powerRational(long var1) throws ArithmeticException;

    @Override
    default public IRational reRational() {
        return this;
    }

    @Override
    public IRational roundClosest(ISignedNumber var1);

    public IRational subtract(IRational var1);

    public BigInteger toBigDenominator();

    public BigFraction toBigFraction();

    public BigInteger toBigNumerator();

    default public IInteger trunc() {
        return this.isNegative() ? this.ceil() : this.floor();
    }
}

