/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.interfaces;

import org.apfloat.Apcomplex;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;

public interface INumber
extends IExpr {
    @Override
    public IExpr abs();

    public ApcomplexNum apcomplexNumValue();

    public Apcomplex apcomplexValue();

    public INumber ceilFraction() throws ArithmeticException;

    public int compareAbsValueToOne();

    @Override
    public IExpr complexArg();

    public ComplexNum complexNumValue();

    public int complexSign();

    @Override
    public INumber conjugate();

    @Deprecated
    default public IExpr eabs() {
        return this.abs();
    }

    public boolean equalsInt(int var1);

    default public INumber evaluatePrecision(EvalEngine engine) {
        return this;
    }

    public INumber floorFraction() throws ArithmeticException;

    public INumber fractionalPart();

    public INumber integerPart();

    @Deprecated
    default public double getImaginary() {
        return this.imDoubleValue();
    }

    @Override
    @Deprecated
    default public double getReal() {
        return this.reDoubleValue();
    }

    @Override
    default public boolean isNumber() {
        return true;
    }

    @Override
    default public boolean isNumericFunction(boolean allowList) {
        return true;
    }

    @Override
    public ISignedNumber im();

    public double imDoubleValue();

    @Override
    default public IExpr[] linear(IExpr variable) {
        return new IExpr[]{this, F.C0};
    }

    @Override
    default public IExpr[] linearPower(IExpr variable) {
        return new IExpr[]{this, F.C0, F.C1};
    }

    @Override
    public INumber opposite();

    default public IRational rationalFactor() {
        if (this instanceof IRational) {
            return (IRational)this;
        }
        return null;
    }

    @Override
    public ISignedNumber re();

    public double reDoubleValue();

    public IExpr roundExpr();

    public IAST toPolarCoordinates();

    @Override
    default public Complex evalComplex() throws ArgumentTypeException {
        return new Complex(this.reDoubleValue(), this.imDoubleValue());
    }
}

