/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.interfaces;

import java.math.BigInteger;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IRational;

public interface IInteger
extends IRational {
    public static final int PRIME_CERTAINTY = 32;

    @Override
    public void checkBitLength();

    @Override
    public IInteger abs();

    public IInteger add(IInteger var1);

    public long bitLength();

    public IInteger charmichaelLambda();

    @Override
    public IInteger dec();

    @Override
    public IInteger inc();

    public IInteger div(IInteger var1);

    default public IInteger div(int that) {
        if (that == 1) {
            return this;
        }
        return this.div(F.ZZ(that));
    }

    public IInteger[] divideAndRemainder(IInteger var1);

    public IInteger iquo(IInteger var1);

    public IInteger irem(IInteger var1);

    public IAST divisors();

    public IInteger eulerPhi() throws ArithmeticException;

    public IExpr exponent(IInteger var1);

    public IInteger factorial();

    public IInteger gcd(IInteger var1);

    public long integerLength(IInteger var1);

    public byte byteValue();

    public int intValue();

    public boolean isEven();

    public boolean isOdd();

    public boolean isProbablePrime();

    public boolean isProbablePrime(int var1);

    public IInteger jacobiSymbol(IInteger var1);

    public IInteger jacobiSymbolF();

    public IInteger jacobiSymbolG(IInteger var1);

    public IInteger lcm(IInteger var1);

    public long longValue();

    public IInteger mod(IInteger var1);

    default public IInteger mod(int that) {
        if (that == 1) {
            return F.C0;
        }
        return this.mod(F.ZZ(that));
    }

    public IInteger modInverse(IInteger var1);

    public IInteger modPow(IInteger var1, IInteger var2);

    public IInteger moebiusMu();

    public IInteger multiply(IInteger var1);

    @Override
    public IInteger multiply(int var1);

    @Override
    public IInteger negate();

    public IExpr nthRoot(int var1);

    public IInteger[] nthRootSplit(int var1);

    @Override
    public IInteger powerRational(long var1) throws ArithmeticException;

    public IInteger[] primitiveRootList() throws ArithmeticException;

    public IInteger quotient(IInteger var1);

    public IInteger shiftLeft(int var1);

    public IInteger shiftRight(int var1);

    public IInteger[] sqrtAndRemainder();

    public IInteger subtract(IInteger var1);

    @Override
    public BigInteger toBigNumerator();

    public byte[] toByteArray();
}

