/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.interfaces;

import edu.jas.structure.ElemFactory;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.complex.Complex;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.FieldSinhCosh;
import org.jgrapht.GraphType;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.BooleanFunctions;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.PredicateQ;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.util.AbstractAssumptions;
import org.matheclipse.core.expression.ASTRealMatrix;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.output.WolframFormFactory;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTDataset;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.polynomials.longexponent.ExprRingFactory;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;
import org.matheclipse.core.visit.VisitorBooleanLevelSpecification;
import org.matheclipse.core.visit.VisitorReplaceAll;
import org.matheclipse.core.visit.VisitorReplacePart;
import org.matheclipse.core.visit.VisitorReplaceSlots;

public interface IExpr
extends Comparable<IExpr>,
GcdRingElem<IExpr>,
Serializable,
CalculusFieldElement<IExpr> {
    public static final int ASTID = 1024;
    public static final int BLANKID = 4096;
    public static final int COMPLEXID = 32;
    public static final int DOUBLECOMPLEXID = 4;
    public static final int DOUBLEID = 2;
    public static final int FRACTIONID = 16;
    public static final int INTEGERID = 8;
    public static final int METHODSYMBOLID = 8192;
    public static final int PATTERNID = 2048;
    public static final int SERIESID = 64;
    public static final int QUANTITYID = 128;
    public static final int STRINGID = 256;
    public static final int SYMBOLID = 512;
    public static final int DATASETID = 16384;
    public static final int DATAID = 32786;
    public static final int BYTEARRAYID = 32787;
    public static final int COMPILEFUNCTONID = 32788;
    public static final int GEOPOSITIONID = 32789;
    public static final int GRAPHEXPRID = 32790;
    public static final int DATEOBJECTEXPRID = 32791;
    public static final int TIMEOBJECTEXPRID = 32792;
    public static final int FITTEDMODELID = 32793;
    public static final int INTERPOLATEDFUNCTONID = 32794;
    public static final int SPARSEARRAYID = 32795;
    public static final int NUMERICARRAYID = 32796;
    public static final int DISPATCHID = 32797;
    public static final int TESTREPORTOBJECT = 32798;
    public static final int TESTRESULTOBJECT = 32799;
    public static final int FILEEXPRID = 32801;
    public static final int OUTPUTSTREAMEXPRID = 32802;
    public static final int INPUTSTREAMEXPRID = 32803;
    public static final int JAVACLASSEXPRID = 32804;
    public static final int JAVAOBJECTEXPRID = 32805;
    public static final int LINEARSOLVEUNCTONID = 32806;
    public static final int BIOSEQUENCEID = 32807;
    public static final int IMAGEID = 32808;

    public static IExpr convertToExpr(COMPARE_TERNARY temp) {
        if (temp == COMPARE_TERNARY.TRUE) {
            return S.True;
        }
        if (temp == COMPARE_TERNARY.FALSE) {
            return S.False;
        }
        return F.NIL;
    }

    public static IExpr ofNullable(IExpr value) {
        return value == null ? F.NIL : value;
    }

    default public IExpr $div(IExpr that) {
        return this.divide(that);
    }

    default public IExpr $minus(IExpr that) {
        return this.minus(that);
    }

    default public IExpr $plus(IExpr that) {
        return this.plus(that);
    }

    default public IExpr $times(IExpr that) {
        return this.times(that);
    }

    default public IExpr $up(IExpr that) {
        return this.power(that);
    }

    default public IExpr abs() {
        return F.eval(F.Abs(this));
    }

    public IExpr accept(IVisitor var1);

    public boolean accept(IVisitorBoolean var1);

    public int accept(IVisitorInt var1);

    public long accept(IVisitorLong var1);

    default public IExpr add(IExpr that) {
        return this.plus(that);
    }

    default public IExpr addEvalFlags(int evalFlags) {
        return this;
    }

    @Deprecated
    default public IExpr and(IExpr that) {
        return F.And(this, that);
    }

    default public IExpr apply(IExpr ... leaves) {
        return F.ast(leaves, this.head());
    }

    default public IExpr apply(List<? extends IExpr> leaves) {
        return F.ast(leaves.toArray(new IExpr[leaves.size()]), this.head());
    }

    default public int argSize() {
        return -1;
    }

    default public Object asType(Class<?> clazz) {
        if (clazz.equals(Boolean.class)) {
            if (this.isTrue()) {
                return Boolean.TRUE;
            }
            if (this.isFalse()) {
                return Boolean.FALSE;
            }
        } else if (clazz.equals(Integer.class)) {
            if (this.isReal()) {
                try {
                    return ((ISignedNumber)this).toInt();
                }
                catch (ArithmeticException arithmeticException) {}
            }
        } else if (clazz.equals(BigInteger.class)) {
            if (this instanceof IInteger) {
                return new BigInteger(((IInteger)this).toByteArray());
            }
        } else if (clazz.equals(String.class)) {
            return this.toString();
        }
        throw new UnsupportedOperationException("ExprImpl.asType() - cast not supported.");
    }

    default public IExpr base() {
        if (Config.FUZZ_TESTING && !this.isPower() && !this.isAST(S.Surd)) {
            throw new NullPointerException();
        }
        return this.first();
    }

    @Override
    default public int compareTo(IExpr expr) {
        int y;
        if (expr.isAST()) {
            return -1 * expr.compareTo(this);
        }
        int x = this.hierarchy();
        return x < (y = expr.hierarchy()) ? -1 : (x == y ? 0 : 1);
    }

    default public IExpr complexArg() {
        return F.eval(F.Arg(this));
    }

    default public IExpr conjugate() {
        return F.eval(F.Conjugate(this));
    }

    default public IASTAppendable constantArray(IExpr head, int startPosition, int ... arr) {
        int size = arr[startPosition];
        if (Config.MAX_AST_SIZE < size) {
            ASTElementLimitExceeded.throwIt(size);
        }
        if (arr.length - 1 == startPosition) {
            IExpr[] exprArr = new IExpr[size];
            for (int i = 0; i < size; ++i) {
                exprArr[i] = this;
            }
            return F.ast(exprArr, head);
        }
        IExpr[] exprArr = new IExpr[size];
        for (int i = 0; i < size; ++i) {
            exprArr[i] = this.constantArray(head, startPosition + 1, arr);
        }
        return F.ast(exprArr, head);
    }

    default public IExpr copySign(ISignedNumber number) {
        return number.complexSign() < 0 ? this.negate() : this;
    }

    default public IExpr dec() {
        return this.plus(F.CN1);
    }

    default public int depth() {
        return 1;
    }

    default public long determinePrecision() {
        return -1L;
    }

    default public IExpr divide(IExpr that) {
        if (that.isOne()) {
            return this;
        }
        if (that.isMinusOne()) {
            return this.negate();
        }
        EvalEngine engine = EvalEngine.get();
        IExpr inverse = that.inverse();
        if (this.isOne()) {
            return inverse;
        }
        if (this.isMinusOne()) {
            return inverse.negate();
        }
        if (engine.isTogetherMode() && (this.isPlusTimesPower() || inverse.isPlusTimesPower())) {
            if (this.isNumber() && inverse.isPlus()) {
                return engine.evaluate(F.Expand(F.Times(this, inverse)));
            }
            if (inverse.isNumber() && this.isPlus()) {
                return engine.evaluate(F.Expand(F.Times(inverse, this)));
            }
            if (this.isNumber() && inverse.isTimes() || inverse.isNumber() && this.isTimes()) {
                return engine.evaluate(F.Times(this, inverse));
            }
            return engine.evaluate(F.Together(F.Times(this, inverse)));
        }
        return engine.evaluate(F.Times(this, inverse));
    }

    default public IExpr[] egcd(IExpr b) {
        throw new UnsupportedOperationException(this.toString());
    }

    default public boolean equalsAt(int position, IExpr expr) {
        return false;
    }

    default public IExpr equalTo(IExpr that) {
        COMPARE_TERNARY temp = this.equalTernary(that, EvalEngine.get());
        return IExpr.convertToExpr(temp);
    }

    default public COMPARE_TERNARY equalTernary(IExpr that, EvalEngine engine) {
        IExpr difference;
        if (this.isIndeterminate() || that.isIndeterminate()) {
            return COMPARE_TERNARY.UNDECIDABLE;
        }
        if (this == that) {
            return COMPARE_TERNARY.TRUE;
        }
        IExpr arg1 = this;
        IExpr arg2 = that;
        if (!arg1.isReal() && arg1.isNumericFunction((IExpr x) -> x.isDirectedInfinity() ? "" : null)) {
            arg1 = engine.evalN(arg1);
        }
        if (!arg2.isReal() && arg2.isNumericFunction((IExpr x) -> x.isDirectedInfinity() ? "" : null)) {
            arg2 = engine.evalN(arg2);
        }
        if (arg2.isInexactNumber() && arg1.isExactNumber()) {
            arg1 = engine.evalN(arg1);
        }
        if (arg1.isInexactNumber() && arg2.isExactNumber()) {
            arg2 = engine.evalN(arg2);
        }
        if (this.isSame(that)) {
            return COMPARE_TERNARY.TRUE;
        }
        if (this.isConstantAttribute() && that.isConstantAttribute()) {
            return COMPARE_TERNARY.FALSE;
        }
        if (this.isString() && that.isString()) {
            return COMPARE_TERNARY.FALSE;
        }
        if (arg2.isDirectedInfinity()) {
            if (arg1.isNumber()) {
                return COMPARE_TERNARY.FALSE;
            }
            if (arg1.isDirectedInfinity()) {
                return arg1.equals(arg2) ? COMPARE_TERNARY.TRUE : COMPARE_TERNARY.FALSE;
            }
        }
        if (arg1.isDirectedInfinity()) {
            if (arg2.isNumber()) {
                return COMPARE_TERNARY.FALSE;
            }
            if (arg2.isDirectedInfinity()) {
                return arg1.equals(arg2) ? COMPARE_TERNARY.TRUE : COMPARE_TERNARY.FALSE;
            }
        }
        if ((difference = engine.evaluate(F.Subtract(arg1, arg2))).isNumber()) {
            if (difference.isZero()) {
                return COMPARE_TERNARY.TRUE;
            }
            return COMPARE_TERNARY.FALSE;
        }
        if (difference.isConstantAttribute()) {
            return COMPARE_TERNARY.FALSE;
        }
        if (arg1.isNumber() && arg2.isNumber()) {
            return COMPARE_TERNARY.FALSE;
        }
        return COMPARE_TERNARY.UNDECIDABLE;
    }

    default public Complex evalComplex() throws ArgumentTypeException {
        return EvalEngine.get().evalComplex(this);
    }

    default public double evalDouble() throws ArgumentTypeException {
        return EvalEngine.get().evalDouble(this);
    }

    default public double getReal() throws ArgumentTypeException {
        if (this.isInfinity()) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.isNegativeInfinity()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.evalDouble();
    }

    default public INumber evalNumber() {
        IExpr result;
        if (this.isNumber() && (result = EvalEngine.get().evalN(this)).isNumber()) {
            return (INumber)result;
        }
        return null;
    }

    default public ISignedNumber evalReal() {
        if (this.isReal()) {
            return (ISignedNumber)this;
        }
        return null;
    }

    @Deprecated
    default public ISignedNumber evalSignedNumber() {
        return this.evalReal();
    }

    default public IExpr evaluate(EvalEngine engine) {
        return F.NIL;
    }

    default public IExpr evaluateHead(IAST ast, EvalEngine engine) {
        IExpr result = engine.evaluateNIL(this);
        if (result.isPresent()) {
            return ast.apply(result);
        }
        return F.NIL;
    }

    default public IExpr exponent() {
        if (Config.FUZZ_TESTING && !this.isPower() && !this.isAST(S.Surd)) {
            throw new NullPointerException();
        }
        return this.second();
    }

    default public ElemFactory<IExpr> factory() {
        return ExprRingFactory.CONST;
    }

    default public IExpr first() {
        return F.NIL;
    }

    default public String fullFormString() {
        return this.toString();
    }

    default public IInteger[] gaussianIntegers() {
        return null;
    }

    default public IExpr gcd(IExpr that) {
        return S.GCD.of(this, that);
    }

    default public IExpr getAt(int index) {
        return S.Part.of(this, F.ZZ(index));
    }

    default public Field<IExpr> getField() {
        return F.EXPR_FIELD;
    }

    default public IExpr getOptionalValue() {
        return null;
    }

    default public IExpr greater(IExpr a1) {
        if (this.isReal() && a1.isReal()) {
            return ((ISignedNumber)this).isGT((ISignedNumber)a1) ? S.True : S.False;
        }
        EvalEngine engine = EvalEngine.get();
        return engine.evaluate(F.Greater(this, a1));
    }

    default public IExpr greaterEqual(IExpr a1) {
        if (this.isReal() && a1.isReal()) {
            return ((ISignedNumber)this).isLT((ISignedNumber)a1) ? S.False : S.True;
        }
        EvalEngine engine = EvalEngine.get();
        return engine.evaluate(F.GreaterEqual(this, a1));
    }

    default public IExpr greaterEqualThan(IExpr that) {
        COMPARE_TERNARY temp = BooleanFunctions.CONST_GREATER_EQUAL.prepareCompare(this, that);
        return IExpr.convertToExpr(temp);
    }

    default public IExpr greaterThan(IExpr that) {
        COMPARE_TERNARY temp = BooleanFunctions.CONST_GREATER.prepareCompare(this, that);
        return IExpr.convertToExpr(temp);
    }

    default public boolean has(IExpr pattern) {
        return this.has(pattern, true);
    }

    default public boolean has(IExpr pattern, boolean heads) {
        if (pattern.isSymbol() || pattern.isNumber() || pattern.isString()) {
            return this.has((IExpr x) -> x.equals(pattern), heads);
        }
        PatternMatcher matcher = new PatternMatcher(pattern);
        return this.has(matcher, heads);
    }

    default public boolean has(Predicate<IExpr> predicate, boolean heads) {
        return predicate.test(this);
    }

    default public boolean hasComplexNumber() {
        return !this.isFree((IExpr x) -> x.isComplex() || x.isComplexNumeric() || x == S.I || x.isAST(S.Complex), false);
    }

    public IExpr head();

    default public int headID() {
        IExpr head = this.head();
        return head.isBuiltInSymbol() ? ((IBuiltInSymbol)head).ordinal() : -1;
    }

    public int hierarchy();

    default public IExpr ifPresent(Function<? super IExpr, IExpr> function) {
        return this.isPresent() ? function.apply(this) : F.NIL;
    }

    default public IExpr im() {
        return S.Im.of(this);
    }

    default public IExpr inc() {
        return this.plus(F.C1);
    }

    default public int indexOf(IExpr expr) {
        return -1;
    }

    default public int indexOf(Predicate<? super IExpr> predicate) {
        return this.indexOf(predicate, 1);
    }

    default public int indexOf(Predicate<? super IExpr> predicate, int fromIndex) {
        return -1;
    }

    default public CharSequence internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        return this.toString();
    }

    default public CharSequence internalJavaString(SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        return this.toString();
    }

    default public CharSequence internalScalaString(boolean symbolsAsFactoryMethod, int depth) {
        return this.toString();
    }

    default public IExpr inverse() {
        return this.power(F.CN1);
    }

    default public boolean isAbs() {
        return false;
    }

    default public boolean isAllExpanded() {
        return true;
    }

    default public boolean isAlternatives() {
        return false;
    }

    default public boolean isAnd() {
        return false;
    }

    default public boolean isArcCos() {
        return false;
    }

    default public boolean isArcCosh() {
        return false;
    }

    default public boolean isArcSin() {
        return false;
    }

    default public boolean isArcSinh() {
        return false;
    }

    default public boolean isArcTan() {
        return false;
    }

    default public boolean isArcTanh() {
        return false;
    }

    default public boolean isAssociation() {
        return false;
    }

    default public boolean isAST() {
        return false;
    }

    default public boolean isAST(IExpr header) {
        return false;
    }

    default public boolean isAST(IExpr header, int length) {
        return false;
    }

    default public boolean isRGBColor() {
        return this.isAST((IExpr)S.RGBColor, 4, 5) || this.isAST(S.RGBColor, 1) && ((IAST)this).arg1().isAST((IExpr)S.List, 4, 5);
    }

    default public boolean isAST(IExpr header, int length, IExpr ... args) {
        return false;
    }

    default public boolean isAST(IExpr header, int minLength, int maxLength) {
        return false;
    }

    default public boolean isAST(String headerStr) {
        return false;
    }

    default public boolean isAST(String headerStr, int length) {
        return false;
    }

    default public boolean isASTOrAssociation() {
        return false;
    }

    default public boolean isAST0() {
        return false;
    }

    default public boolean isAST1() {
        return false;
    }

    default public boolean isAST2() {
        return false;
    }

    default public boolean isAST3() {
        return false;
    }

    default public boolean isASTSizeGE(IExpr header, int length) {
        return false;
    }

    default public boolean isAtom() {
        return true;
    }

    default public boolean isBlank() {
        return false;
    }

    default public boolean isBooleanFormula() {
        return false;
    }

    default public boolean isBooleanFormulaSymbol() {
        return false;
    }

    default public boolean isBooleanFunction() {
        return false;
    }

    default public boolean isBooleanResult() {
        if (S.True.equals(AbstractAssumptions.assumeBoolean(this))) {
            return true;
        }
        return this.isBooleanFormula();
    }

    default public boolean isBuiltInSymbol() {
        return this instanceof IBuiltInSymbol;
    }

    default public boolean isComparatorFunction() {
        return false;
    }

    default public boolean isComparatorFunctionSymbol() {
        return false;
    }

    default public boolean isComplex() {
        return this instanceof IComplex;
    }

    default public boolean isComplexInfinity() {
        return false;
    }

    default public boolean isComplexNumeric() {
        return this instanceof IComplexNum;
    }

    default public boolean isCondition() {
        return false;
    }

    default public boolean isConditionalExpression() {
        return false;
    }

    default public boolean isConjugate() {
        return false;
    }

    default public boolean isConstantAttribute() {
        return false;
    }

    default public boolean isContinuousDistribution() {
        return false;
    }

    default public boolean isCoreFunctionSymbol() {
        return false;
    }

    default public boolean isCos() {
        return false;
    }

    default public boolean isCosh() {
        return false;
    }

    default public boolean isDataset() {
        return this instanceof IASTDataset;
    }

    default public boolean isDefer() {
        return false;
    }

    default public IAST[] isDerivative() {
        return null;
    }

    default public IAST[] isDerivativeAST1() {
        return null;
    }

    default public boolean isDirectedInfinity() {
        return false;
    }

    default public boolean isDirectedInfinity(IExpr x) {
        return false;
    }

    default public boolean isDiscreteDistribution() {
        return false;
    }

    default public boolean isDistribution() {
        return false;
    }

    default public boolean isE() {
        return false;
    }

    default public boolean isEdge() {
        return false;
    }

    default public boolean isEmptyList() {
        return false;
    }

    default public boolean isEqual() {
        return false;
    }

    default public boolean isEvalFlagOff(int flags) {
        return true;
    }

    default public boolean isEvalFlagOn(int flags) {
        return false;
    }

    default public boolean isEvenResult() {
        IAST timesAST;
        if (this.isInteger()) {
            return ((IInteger)this).isEven();
        }
        return this.isIntegerResult() && this.isTimes() && (timesAST = (IAST)this).exists(x -> x.isInteger() && ((IInteger)x).isEven());
    }

    default public boolean isExactNumber() {
        return this instanceof IRational || this instanceof IComplex;
    }

    default public boolean isExcept() {
        return false;
    }

    default public boolean isExp() {
        return this.isPower() && this.first().isE();
    }

    default public boolean isExpanded() {
        return true;
    }

    default public boolean isFalse() {
        return false;
    }

    default public boolean isFlatAST() {
        return false;
    }

    default public boolean isFraction() {
        return this instanceof IFraction;
    }

    default public boolean isFree(IExpr pattern) {
        return this.isFree(pattern, true);
    }

    default public boolean isFree(IExpr pattern, boolean heads) {
        Predicate<IExpr> matcher = Predicates.toFreeQ(pattern);
        return this.isFree(matcher, heads);
    }

    default public boolean isFree(IPatternMatcher predicate, boolean heads) {
        return !predicate.test(this);
    }

    default public boolean isFree(Predicate<IExpr> predicate, boolean heads) {
        return !predicate.test(this);
    }

    default public boolean isFreeAST(IExpr pattern) {
        return true;
    }

    default public boolean isFreeAST(Predicate<IExpr> predicate) {
        return true;
    }

    default public boolean isFreeOfPatterns() {
        return true;
    }

    default public boolean isFunction() {
        return false;
    }

    default public boolean isGEOrdered(IExpr expr) {
        return this.compareTo(expr) >= 0;
    }

    default public boolean isGTOrdered(IExpr expr) {
        return this.compareTo(expr) > 0;
    }

    default public boolean isHoldAllCompleteAST() {
        return false;
    }

    default public boolean isHoldOrHoldFormOrDefer() {
        return false;
    }

    default public boolean isHoldPatternOrLiteral() {
        return false;
    }

    default public boolean isHyperbolicFunction() {
        return false;
    }

    default public boolean isImaginaryUnit() {
        return false;
    }

    default public boolean isIndeterminate() {
        return false;
    }

    default public boolean isInexactNumber() {
        return this instanceof INum || this instanceof IComplexNum;
    }

    default public boolean isInfinity() {
        return false;
    }

    default public boolean isInteger() {
        return this instanceof IInteger;
    }

    default public boolean isIntegerResult() {
        if (S.True.equals(AbstractAssumptions.assumeInteger(this))) {
            return true;
        }
        return this instanceof IInteger;
    }

    default public boolean isInterval() {
        return false;
    }

    default public boolean isInterval1() {
        return false;
    }

    default public boolean isLEOrdered(IExpr expr) {
        return this.compareTo(expr) <= 0;
    }

    default public boolean isList() {
        return false;
    }

    default public boolean isListableAST() {
        return false;
    }

    default public boolean isList(Predicate<IExpr> predicate) {
        return false;
    }

    default public boolean isList1() {
        return this.isList() && this.size() == 2;
    }

    default public boolean isList2() {
        return this.isList() && this.size() == 3;
    }

    default public boolean isList3() {
        return this.isList() && this.size() == 4;
    }

    default public GraphType isListOfEdges() {
        return null;
    }

    default public boolean isListOfLists() {
        return false;
    }

    default public boolean isListOfMatrices() {
        return false;
    }

    default public boolean isListOfRules() {
        return this.isListOfRules(false);
    }

    default public boolean isListOfRules(boolean ignoreEmptySublists) {
        return false;
    }

    default public boolean isListOfRulesOrAssociation(boolean ignoreEmptySublists) {
        return false;
    }

    default public boolean isListOfStrings() {
        return false;
    }

    default public boolean isListOrAssociation() {
        return this.isList();
    }

    default public boolean isLog() {
        return false;
    }

    default public boolean isLTOrdered(IExpr expr) {
        return this.compareTo(expr) < 0;
    }

    default public boolean isMachineNumber() {
        return this instanceof Num || this instanceof ComplexNum;
    }

    default public int[] isMatrix() {
        return this.isMatrix(true);
    }

    default public int[] isMatrix(boolean setMatrixFormat) {
        return null;
    }

    default public int[] isMatrixIgnore() {
        return this.isMatrix(true);
    }

    default public boolean isMember(IExpr pattern) {
        return this.isMember(pattern, false, null);
    }

    default public boolean isMember(IExpr pattern, boolean heads, IVisitorBoolean visitor) {
        PatternMatcher predicate = pattern.isSymbol() || pattern.isNumber() || pattern.isString() ? x -> x.equals(pattern) : new PatternMatcher(pattern);
        if (visitor == null) {
            visitor = new VisitorBooleanLevelSpecification((Predicate<IExpr>)predicate, 1, heads);
        }
        return this.accept(visitor);
    }

    default public boolean isMinusOne() {
        return false;
    }

    default public boolean isModule() {
        return false;
    }

    default public boolean isModuleOrWithCondition() {
        return false;
    }

    default public boolean isNegative() {
        return false;
    }

    default public boolean isNegativeImaginaryUnit() {
        return false;
    }

    default public boolean isNegativeInfinity() {
        return false;
    }

    default public boolean isNegativeResult() {
        return AbstractAssumptions.assumeNegative(this);
    }

    default public boolean isNegativeSigned() {
        IExpr arg1;
        return this.isNumber() ? ((INumber)this).complexSign() < 0 : (this.isTimes() ? ((arg1 = this.first()).isNumber() ? ((INumber)arg1).complexSign() < 0 : arg1.isNegativeInfinity()) : (this.isPlus() ? ((arg1 = this.first()).isNumber() ? ((INumber)arg1).complexSign() < 0 : arg1.isNegativeInfinity()) : this.isNegativeInfinity()));
    }

    default public boolean isNonEmptyList() {
        return false;
    }

    default public boolean isNonNegativeResult() {
        return AbstractAssumptions.assumeNonNegative(this);
    }

    default public boolean isNonZeroComplexResult() {
        if (this.isZero()) {
            return false;
        }
        if (this.isNonZeroRealResult()) {
            return true;
        }
        return this.isNumber();
    }

    default public boolean isNonZeroRealResult() {
        if (this.isZero()) {
            return false;
        }
        if (this.isNegativeResult() || this.isPositiveResult()) {
            return true;
        }
        if (this.isReal()) {
            return true;
        }
        return this.isNegativeInfinity() || this.isInfinity();
    }

    default public boolean isNot() {
        return false;
    }

    default public boolean isNotDefined() {
        return this.isIndeterminate() || this.isDirectedInfinity();
    }

    default public boolean isNumber() {
        return false;
    }

    default public boolean isNumEqualInteger(IInteger value) throws ArithmeticException {
        return false;
    }

    default public boolean isNumEqualRational(IRational value) throws ArithmeticException {
        return false;
    }

    @Deprecated
    default public boolean isNumeric() {
        return this.isInexactNumber();
    }

    default public boolean isNumericArray() {
        return false;
    }

    default public boolean isNumericArgument() {
        return this instanceof INum || this instanceof IComplexNum || this instanceof ASTRealVector || this instanceof ASTRealMatrix;
    }

    default public boolean isNumericAST() {
        return false;
    }

    default public boolean isNumericFunction() {
        return this.isNumericFunction(false);
    }

    default public boolean isNumericFunction(boolean allowList) {
        return false;
    }

    default public boolean isNumericFunction(VariablesSet varSet) {
        return this.isNumericFunction(true) || varSet.contains(this);
    }

    default public boolean isNumericFunction(IExpr variable) {
        return this.isNumericFunction(true) || variable.equals(this);
    }

    default public boolean isNumericFunction(Function<IExpr, String> list) {
        return this.isNumericFunction(true) || list.apply(this) != null;
    }

    default public boolean isNumericMode() {
        return this.isInexactNumber();
    }

    default public boolean isNumIntValue() {
        return false;
    }

    default public boolean isOne() {
        return false;
    }

    @Deprecated
    default public boolean isONE() {
        return this.isOne();
    }

    default public boolean isOneIdentityAST1() {
        return false;
    }

    default public boolean isOptional() {
        return false;
    }

    default public boolean isOptionsPattern() {
        return false;
    }

    default public boolean isOr() {
        return false;
    }

    default public boolean isOrderlessAST() {
        return false;
    }

    default public boolean isPattern() {
        return false;
    }

    default public boolean isPatternDefault() {
        return false;
    }

    default public boolean isPatternExpr() {
        return false;
    }

    default public boolean isPatternMatchingFunction() {
        return false;
    }

    default public boolean isPatternOptional() {
        return false;
    }

    default public boolean isPatternSequence(boolean testNullSequence) {
        return false;
    }

    default public boolean isPatternTest() {
        return false;
    }

    default public boolean isPi() {
        return false;
    }

    default public int[] isPiecewise() {
        return null;
    }

    default public boolean isPlus() {
        return false;
    }

    default public boolean isPlus2() {
        return false;
    }

    default public boolean isPlus3() {
        return false;
    }

    default public boolean isPlusTimesPower() {
        return false;
    }

    default public boolean isPolynomial(IAST variables) {
        return this.isNumber();
    }

    default public boolean isPolynomial(IExpr variable) {
        return this.isNumber();
    }

    default public boolean isPolynomialOfMaxDegree(ISymbol variable, long maxDegree) {
        return this.isPolynomial(F.List(variable));
    }

    default public boolean isPolynomialStruct() {
        return this.isExactNumber();
    }

    default public boolean isPositive() {
        return false;
    }

    default public boolean isPositiveResult() {
        return AbstractAssumptions.assumePositive(this);
    }

    default public boolean isPower() {
        return false;
    }

    default public boolean isPowerReciprocal() {
        return this.isPower() && this.second().isMinusOne();
    }

    default public boolean isPredicateFunctionSymbol() {
        return false;
    }

    default public boolean isPresent() {
        return true;
    }

    default public boolean isPureFunction() {
        return false;
    }

    default public boolean isQuantity() {
        return false;
    }

    default public boolean isRational() {
        return this instanceof IRational;
    }

    default public boolean isRationalResult() {
        if (S.True.equals(AbstractAssumptions.assumeRational(this))) {
            return true;
        }
        return this instanceof IRational;
    }

    default public boolean isRationalValue(IRational value) {
        return false;
    }

    default public boolean isReal() {
        return this instanceof ISignedNumber;
    }

    default public boolean isRealConstant() {
        return false;
    }

    default public boolean isRealMatrix() {
        return false;
    }

    @Deprecated
    default public boolean isRealNumber() {
        return this.isReal();
    }

    default public boolean isRealResult() {
        if (S.True.equals(AbstractAssumptions.assumeReal(this))) {
            return true;
        }
        return this instanceof ISignedNumber;
    }

    default public boolean isRealVector() {
        return false;
    }

    default public boolean isRepeated() {
        return false;
    }

    default public boolean isRule() {
        return false;
    }

    default public boolean isRuleAST() {
        return false;
    }

    default public boolean isRuleDelayed() {
        return false;
    }

    default public boolean isSame(IExpr expression) {
        return this.isSame(expression, Config.DOUBLE_EPSILON);
    }

    default public boolean isSame(IExpr expression, double epsilon) {
        return this.equals(expression);
    }

    default public boolean isSameHeadSizeGE(ISymbol head, int length) {
        return false;
    }

    default public boolean isSequence() {
        return false;
    }

    @Deprecated
    default public boolean isSignedNumber() {
        return this.isReal();
    }

    @Deprecated
    default public boolean isSignedNumberConstant() {
        return this.isRealConstant();
    }

    default public boolean isSin() {
        return false;
    }

    default public boolean isSinh() {
        return false;
    }

    default public boolean isSlot() {
        return false;
    }

    default public boolean isSlotSequence() {
        return false;
    }

    default public int[] isSpan(int size) {
        return null;
    }

    default public boolean isSparseArray() {
        return false;
    }

    default public boolean isSqrt() {
        return this.isPower() && this.second().isNumEqualRational(F.C1D2);
    }

    default public boolean isSqrtExpr() {
        if (this.isSqrt()) {
            return true;
        }
        return this.isTimes() && this.first().equals(F.CN1) && this.size() == 3 && this.second().isPower() && this.second().second().isNumEqualRational(F.C1D2);
    }

    default public boolean isFactorSqrtExpr() {
        IExpr factor2;
        if (this.isSqrt()) {
            IExpr base = this.first();
            return base.isRational() && base.isPositive();
        }
        return this.isTimes() && this.first().isRational() && this.size() == 3 && (factor2 = this.second()).isSqrt() && factor2.first().isRational() && factor2.first().isPositive();
    }

    default public boolean isString() {
        return this instanceof IStringX;
    }

    default public boolean isString(String str) {
        return this instanceof IStringX && this.toString().equals(str);
    }

    default public boolean isStringIgnoreCase(String str) {
        return this instanceof IStringX && this.toString().equalsIgnoreCase(str);
    }

    default public boolean isSubscript() {
        return false;
    }

    default public boolean isSymbol() {
        return this instanceof ISymbol;
    }

    default public boolean isSymbolOrPattern() {
        return this instanceof ISymbol || this instanceof IPatternObject;
    }

    default public boolean isTan() {
        return false;
    }

    default public boolean isTanh() {
        return false;
    }

    default public boolean isTimes() {
        return false;
    }

    default public boolean isTimes2() {
        return false;
    }

    default public boolean isTimes3() {
        return false;
    }

    default public boolean isTrigFunction() {
        return false;
    }

    default public boolean isTrue() {
        return false;
    }

    default public boolean isUnevaluated() {
        return false;
    }

    default public boolean isUnit() {
        return true;
    }

    default public boolean isValue() {
        return false;
    }

    default public boolean isVariable() {
        return false;
    }

    default public int isVector() {
        return -1;
    }

    default public boolean isWith() {
        return false;
    }

    default public boolean isZero() {
        return false;
    }

    default public boolean isZeroResult() {
        return this.isZero() || AbstractAssumptions.assumeEqual(this, F.C0);
    }

    default public boolean isPossibleZero(boolean fastTest) {
        return this.isZero();
    }

    default public boolean isZERO() {
        if (this.isNumber()) {
            return this.isZero();
        }
        return this.isAST() && PredicateQ.isPossibleZeroQ((IAST)this, false, EvalEngine.get());
    }

    default public IExpr last() {
        return F.NIL;
    }

    default public long leafCount() {
        return this.isAtom() ? 1L : 0L;
    }

    default public long leafCountSimplify() {
        return this.leafCount();
    }

    default public IExpr less(IExpr a1) {
        if (this.isReal() && a1.isReal()) {
            return ((ISignedNumber)this).isLT((ISignedNumber)a1) ? S.True : S.False;
        }
        EvalEngine engine = EvalEngine.get();
        return engine.evaluate(F.Less(this, a1));
    }

    default public IExpr lessEqual(IExpr a1) {
        if (this.isReal() && a1.isReal()) {
            return ((ISignedNumber)this).isGT((ISignedNumber)a1) ? S.False : S.True;
        }
        EvalEngine engine = EvalEngine.get();
        return engine.evaluate(F.LessEqual(this, a1));
    }

    default public IExpr lessEqualThan(IExpr that) {
        COMPARE_TERNARY temp = BooleanFunctions.CONST_LESS_EQUAL.prepareCompare(this, that);
        return IExpr.convertToExpr(temp);
    }

    default public IExpr lessThan(IExpr that) {
        COMPARE_TERNARY temp = BooleanFunctions.CONST_LESS.prepareCompare(this, that);
        return IExpr.convertToExpr(temp);
    }

    default public IExpr[] linear(IExpr variable) {
        return null;
    }

    default public IExpr[] linearPower(IExpr variable) {
        return null;
    }

    default public IExpr lower() {
        return F.NIL;
    }

    default public IExpr mapExpr(Function<? super IExpr, ? extends IExpr> mapper) {
        return mapper.apply(this);
    }

    default public IExpr mapMatrixColumns(int[] dim, Function<IExpr, IExpr> f) {
        return F.NIL;
    }

    default public IExpr minus(IExpr that) {
        return this.subtract(that);
    }

    default public IExpr mod(IExpr that) {
        return S.Mod.of(this, that);
    }

    default public IExpr most() {
        return F.NIL;
    }

    default public IExpr multiply(IExpr that) {
        return this.times(that);
    }

    default public IExpr multiply(int n) {
        if (this.isPlus()) {
            return F.evalExpand(this.times(F.ZZ(n)));
        }
        return this.times(F.ZZ(n));
    }

    default public IExpr multiplyDistributed(IExpr that) {
        if (this.isZero()) {
            return this;
        }
        if (that.isZero()) {
            return that;
        }
        if (this.isOne()) {
            return that;
        }
        if (that.isOne()) {
            return this;
        }
        if (this.isPlus()) {
            if (that.isPlus()) {
                IAST temp = ((IAST)this).map(x -> x.multiplyDistributed(that), 1);
                return EvalEngine.get().evaluate(temp);
            }
            IASTMutable temp = ((IAST)this).mapThread(F.binaryAST2((IExpr)S.Times, F.Slot1, that), 1);
            return EvalEngine.get().evaluate(temp);
        }
        if (that.isPlus()) {
            IASTMutable temp = ((IAST)that).mapThread(F.binaryAST2((IExpr)S.Times, this, (IExpr)F.Slot1), 2);
            return EvalEngine.get().evaluate(temp);
        }
        return this.times(that);
    }

    default public IExpr negate() {
        return this.opposite();
    }

    default public IExpr negative() {
        return this.opposite();
    }

    default public IExpr nest(IExpr head, int n) {
        IExpr temp = this;
        Function<IExpr, IExpr> function = x -> F.unaryAST1(head, x);
        for (int i = 0; i < n; ++i) {
            temp = function.apply(temp);
        }
        return temp;
    }

    default public IExpr normal(boolean nilIfUnevaluated) {
        return nilIfUnevaluated ? F.NIL : this;
    }

    default public IExpr opposite() {
        return this.times(F.CN1);
    }

    default public IExpr optional() {
        return S.exprID(this);
    }

    @Deprecated
    default public IExpr or(IExpr that) {
        return F.Or(this, that);
    }

    default public IExpr orElse(IExpr other) {
        return this;
    }

    default public IExpr orElseGet(Supplier<? extends IExpr> other) {
        return this;
    }

    default public <X extends Throwable> IExpr orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return this;
    }

    default public IAST orNewList() {
        return this.isList() ? (IAST)this : F.List(this);
    }

    default public IAST partition(ISymbol operator, Predicate<? super IExpr> predicate, IExpr initTrue, IExpr initFalse, ISymbol combiner, ISymbol action) {
        return F.NIL;
    }

    default public IAST partitionPlus(Predicate<? super IExpr> predicate, IExpr initTrue, IExpr initFalse, ISymbol action) {
        return F.NIL;
    }

    default public IAST partitionTimes(Predicate<? super IExpr> predicate, IExpr initTrue, IExpr initFalse, ISymbol action) {
        return F.NIL;
    }

    default public IExpr plus(IExpr that) {
        if (that.isZero()) {
            return this;
        }
        EvalEngine engine = EvalEngine.get();
        if (engine.isTogetherMode() && (this.isPlusTimesPower() || that.isPlusTimesPower())) {
            return engine.evaluate(F.Together(F.Plus(this, that)));
        }
        return engine.evaluate(F.Plus(this, that));
    }

    default public IExpr power(IExpr that) {
        EvalEngine engine;
        if (that.isZero()) {
            if (!this.isZero()) {
                return F.C1;
            }
        } else {
            if (that.isOne()) {
                return this;
            }
            if (that.isMinusOne()) {
                if (this.isPlus() && this.size() == 3 && (this.first().isRational() || this.first().isFactorSqrtExpr()) && this.second().isFactorSqrtExpr()) {
                    IExpr p1 = this.first();
                    IExpr p2 = this.second();
                    IRational denominator = (IRational)F.Subtract.of(F.Sqr(p1), F.Sqr(p2));
                    denominator = denominator.inverse();
                    p1 = denominator.multiply(p1);
                    p2 = denominator.multiply(p2);
                    return p1.subtract(p2);
                }
                if (this.isFactorSqrtExpr()) {
                    if (this.isSqrt()) {
                        return F.Times.of(this.first().inverse(), this);
                    }
                    if (this.isTimes()) {
                        IRational rat1 = (IRational)this.first();
                        IRational rat2 = (IRational)this.second().first();
                        return F.Times.of(rat1.inverse(), rat2.inverse(), this.second());
                    }
                }
            }
        }
        if ((engine = EvalEngine.get()).isTogetherMode() && (this.isPlusTimesPower() || that.isPlusTimesPower())) {
            return S.Together.of(engine, F.Power(this, that));
        }
        return S.Power.of(engine, this, that);
    }

    default public IExpr power(long n) {
        if (n == 0L) {
            if (!this.isZero()) {
                return F.C1;
            }
            return F.Power(this, F.C0);
        }
        if (n == 1L) {
            return this;
        }
        if (this.isNumber()) {
            INumber r;
            long exp = n;
            if (n < 0L) {
                exp *= -1L;
            }
            int b2pow = 0;
            while ((exp & 1L) == 0L) {
                ++b2pow;
                exp >>= 1;
            }
            INumber x = r = (INumber)this;
            while ((exp >>= 1) > 0L) {
                x = (INumber)x.times(x);
                if ((exp & 1L) == 0L) continue;
                r = (INumber)r.times(x);
            }
            while (b2pow-- > 0) {
                r = (INumber)r.times(r);
            }
            if (n < 0L) {
                return r.inverse();
            }
            return r;
        }
        return F.Power(this, F.ZZ(n));
    }

    default public IExpr re() {
        return S.Re.of(this);
    }

    default public IExpr reciprocal() throws MathRuntimeException {
        return this.inverse();
    }

    default public IExpr remainder(IExpr that) {
        if (this.equals(that)) {
            return F.C0;
        }
        return this;
    }

    default public IExpr replaceAll(Function<IExpr, IExpr> function) {
        return this.accept(new VisitorReplaceAll(function));
    }

    default public IExpr replaceAll(IAST listOfRules) {
        return this.accept(new VisitorReplaceAll(listOfRules));
    }

    default public IExpr replaceAll(Map<? extends IExpr, ? extends IExpr> map) {
        return this.accept(new VisitorReplaceAll(map));
    }

    default public IExpr replacePart(IAST astRules, COMPARE_TERNARY heads) {
        return this.accept(new VisitorReplacePart(astRules, heads));
    }

    default public IExpr replaceRepeated(Function<IExpr, IExpr> function) {
        return this.replaceRepeated(new VisitorReplaceAll(function), -1);
    }

    default public IExpr replaceRepeated(IAST astRules) {
        return this.replaceRepeated(new VisitorReplaceAll(astRules), -1);
    }

    default public IExpr replaceRepeated(VisitorReplaceAll visitor, int maxIterations) {
        IExpr result = this;
        IExpr temp = this.accept(visitor);
        EvalEngine engine = EvalEngine.get();
        int iterationLimit = engine.getIterationLimit();
        if (maxIterations > 0 && maxIterations < iterationLimit) {
            iterationLimit = maxIterations;
        }
        int iterationCounter = 0;
        while (temp.isPresent()) {
            result = engine.evaluate(temp);
            if (iterationLimit >= 0 && iterationLimit <= ++iterationCounter) {
                IOFunctions.printMessage(S.ReplaceRepeated, "rrlim", F.List(this, F.ZZ(iterationLimit)), engine);
                return result;
            }
            temp = result.accept(visitor);
        }
        return result;
    }

    @Deprecated
    default public IExpr replaceSlots(IAST slotsList) {
        return this.accept(new VisitorReplaceSlots(slotsList));
    }

    default public IAST rest() {
        return F.NIL;
    }

    default public IExpr rewrite(int functionID) {
        return F.NIL;
    }

    default public IExpr second() {
        return F.NIL;
    }

    @Deprecated
    default public int signum() {
        if (this.isZero()) {
            return 0;
        }
        if (this instanceof INumber) {
            return ((INumber)this).complexSign();
        }
        return 1;
    }

    default public int size() {
        return 0;
    }

    default public IExpr sqrt() {
        if (this.isPower()) {
            return F.Power(this.base(), F.Times((IExpr)F.C1D2, this.exponent()));
        }
        if (this.isTimes()) {
            IAST times = (IAST)this;
            int size = times.size();
            IASTAppendable timesSqrt = F.TimesAlloc(size);
            IASTAppendable timesRest = F.TimesAlloc(size);
            for (int i = 1; i < size; ++i) {
                IExpr arg = times.get(i);
                if (arg.isPower()) {
                    timesRest.append(F.Power(arg.base(), F.Times((IExpr)F.C1D2, arg.exponent())));
                    continue;
                }
                timesSqrt.append(arg);
            }
            return F.Times((IExpr)timesRest, (IExpr)F.Sqrt(timesSqrt));
        }
        return F.Sqrt(this);
    }

    default public IExpr subtract(IExpr that) {
        if (that.isZero()) {
            return this;
        }
        return this.plus(that.negate());
    }

    default public IExpr sum(IExpr that) {
        return this.add(that);
    }

    default public IExpr times(IExpr that) {
        if (that.isZero()) {
            return F.C0;
        }
        if (that.isOne()) {
            return this;
        }
        EvalEngine engine = EvalEngine.get();
        if (engine.isTogetherMode() && (this.isPlusTimesPower() || that.isPlusTimesPower())) {
            if (this.isNumber() && that.isPlus()) {
                return engine.evaluate(F.Expand(F.Times(this, that)));
            }
            if (that.isNumber() && this.isPlus()) {
                return engine.evaluate(F.Expand(F.Times(that, this)));
            }
            if (this.isNumber() && that.isTimes() || that.isNumber() && this.isTimes()) {
                return engine.evaluate(F.Times(that, this));
            }
            return engine.evaluate(F.Together(F.Times(this, that)));
        }
        return engine.evaluate(F.Times(this, that));
    }

    default public IExpr timesDistributed(IExpr that) {
        return this.times(that);
    }

    default public Complex[] toComplexVector() {
        return null;
    }

    default public byte[][] toByteMatrix() {
        return null;
    }

    default public double[][] toDoubleMatrix() {
        return null;
    }

    default public double[][] toDoubleMatrixIgnore() {
        return this.toDoubleMatrix();
    }

    default public double[] toDoubleVector() {
        return null;
    }

    default public double[] toDoubleVectorIgnore() {
        return this.toDoubleVector();
    }

    default public double toDoubleDefault() {
        return EvalEngine.get().evalDouble(this, Double.MIN_VALUE);
    }

    default public double toDoubleDefault(double defaultValue) {
        return EvalEngine.get().evalDouble(this, defaultValue);
    }

    default public int[][] toIntMatrix() {
        return null;
    }

    default public int toIntDefault() {
        return this.toIntDefault(Integer.MIN_VALUE);
    }

    default public int toIntDefault(int defaultValue) {
        return defaultValue;
    }

    default public long toLongDefault() {
        return this.toLongDefault(Long.MIN_VALUE);
    }

    default public long toLongDefault(long defaultValue) {
        return defaultValue;
    }

    default public int[] toIntVector() {
        return null;
    }

    default public ISymbol topHead() {
        return (ISymbol)this.head();
    }

    default public RealMatrix toRealMatrix() {
        double[][] elements = this.toDoubleMatrix();
        if (elements != null && elements.length > 0 && elements[0].length > 0) {
            return new Array2DRowRealMatrix(elements, false);
        }
        return null;
    }

    default public RealMatrix toRealMatrixIgnore() {
        return null;
    }

    default public RealVector toRealVector() {
        double[] elements = this.toDoubleVector();
        if (elements != null) {
            return new ArrayRealVector(elements, false);
        }
        return null;
    }

    default public String toMMA() {
        return WolframFormFactory.get().toString(this);
    }

    default public String toScript() {
        return this.toString();
    }

    default public String toScriptFactory() {
        throw new UnsupportedOperationException(this.toString());
    }

    default public IExpr unequalTo(IExpr that) {
        COMPARE_TERNARY temp = this.equalTernary(that, EvalEngine.get());
        if (temp == COMPARE_TERNARY.TRUE) {
            return S.False;
        }
        if (temp == COMPARE_TERNARY.FALSE) {
            return S.True;
        }
        return F.NIL;
    }

    default public IExpr unitStep() {
        if (this.isNegativeResult()) {
            return F.C0;
        }
        if (this.isNonNegativeResult()) {
            return F.C1;
        }
        return F.UnitStep(this);
    }

    default public IExpr upper() {
        return F.NIL;
    }

    default public IExpr variables2Slots(Map<IExpr, IExpr> map, Collection<IExpr> variableCollector) {
        return this;
    }

    default public IExpr sign() {
        return S.Sign.of(this);
    }

    default public IExpr acos() {
        return S.ArcCos.of(this);
    }

    default public IExpr acosh() {
        return S.ArcCosh.of(this);
    }

    default public IExpr add(double that) {
        return this.plus(F.num(that));
    }

    default public IExpr asin() {
        return S.ArcSin.of(this);
    }

    default public IExpr asinh() {
        return S.ArcSinh.of(this);
    }

    default public IExpr atan() {
        return S.ArcTan.of(this);
    }

    default public IExpr atan2(IExpr that) throws MathIllegalArgumentException {
        return S.ArcTan.of(that, this);
    }

    default public IExpr atanh() {
        return S.ArcTanh.of(this);
    }

    default public IExpr cbrt() {
        return S.Power.of(this, F.C1D3);
    }

    default public IExpr ceil() {
        return S.Ceiling.of(this);
    }

    default public IExpr copySign(double that) {
        return this.copySign(F.num(that));
    }

    default public IExpr copySign(IExpr that) {
        return this.abs().times(that.sign());
    }

    default public IExpr cos() {
        return S.Cos.of(this);
    }

    default public IExpr cosh() {
        return S.Cosh.of(this);
    }

    default public IExpr divide(double arg0) {
        return this.divide(F.num(arg0));
    }

    default public boolean exists(Predicate<? super IExpr> predicate) {
        return false;
    }

    default public IExpr exp() {
        return S.Exp.of(this);
    }

    default public IExpr expm1() {
        return S.Exp.of(this).subtract(F.C1);
    }

    default public IExpr floor() {
        return S.Floor.of(this);
    }

    default public boolean forAll(Predicate<? super IExpr> predicate) {
        return false;
    }

    default public IExpr hypot(IExpr y) throws MathIllegalArgumentException {
        return S.Sqrt.of(F.Plus((IExpr)F.Sqr(this), (IExpr)F.Sqr(y)));
    }

    default public IExpr linearCombination(double a1, IExpr b1, double a2, IExpr b2, double a3, IExpr b3, double a4, IExpr b4) {
        return this.linearCombination(new double[]{a1, a2, a3, a4}, new IExpr[]{b1, b2, b3, b4});
    }

    default public IExpr linearCombination(double a1, IExpr b1, double a2, IExpr b2, double a3, IExpr b3) {
        return this.linearCombination(new double[]{a1, a2, a3}, new IExpr[]{b1, b2, b3});
    }

    default public IExpr linearCombination(double a1, IExpr b1, double a2, IExpr b2) {
        return this.linearCombination(new double[]{a1, a2}, new IExpr[]{b1, b2});
    }

    default public IExpr linearCombination(double[] a, IExpr[] b) throws MathIllegalArgumentException {
        IASTAppendable result = F.PlusAlloc(a.length);
        for (int i = 0; i < a.length; ++i) {
            result.append(F.Times((IExpr)F.num(a[i]), b[i]));
        }
        return result;
    }

    default public IExpr linearCombination(IExpr a1, IExpr b1, IExpr a2, IExpr b2, IExpr a3, IExpr b3, IExpr a4, IExpr b4) {
        return this.linearCombination(new IExpr[]{a1, a2, a3, a4}, new IExpr[]{b1, b2, b3, b4});
    }

    default public IExpr linearCombination(IExpr a1, IExpr b1, IExpr a2, IExpr b2, IExpr a3, IExpr b3) {
        return this.linearCombination(new IExpr[]{a1, a2, a3}, new IExpr[]{b1, b2, b3});
    }

    default public IExpr linearCombination(IExpr a1, IExpr b1, IExpr a2, IExpr b2) {
        return this.linearCombination(new IExpr[]{a1, a2}, new IExpr[]{b1, b2});
    }

    default public IExpr linearCombination(IExpr[] a, IExpr[] b) throws MathIllegalArgumentException {
        IASTAppendable result = F.PlusAlloc(a.length);
        for (int i = 0; i < a.length; ++i) {
            result.append(F.Times(a[i], b[i]));
        }
        return result;
    }

    default public IExpr log() {
        return S.Log.of(this);
    }

    default public IExpr log10() {
        return S.Log.of(F.C10, this);
    }

    default public IExpr log1p() {
        return S.Log.of(this.inc());
    }

    default public IExpr multiply(double that) {
        return this.times(F.num(that));
    }

    default public IExpr newInstance(double arg) {
        return F.num(arg);
    }

    default public IExpr pow(double n) {
        return S.Power.of(this, F.num(n));
    }

    default public IExpr pow(IExpr n) throws MathIllegalArgumentException {
        return S.Power.of(this, n);
    }

    default public IExpr pow(int n) {
        return S.Power.of(this, F.ZZ(n));
    }

    default public IExpr remainder(double arg0) {
        return S.Mod.of(this);
    }

    default public IExpr rint() {
        return S.IntegerPart.of(this);
    }

    default public IExpr rootN(int n) {
        return S.Power.of(this, F.QQ(1L, n));
    }

    default public IExpr scalb(int n) {
        return this.times(F.C2.pow(n));
    }

    default public IExpr sin() {
        return S.Sin.of(this);
    }

    default public FieldSinCos<IExpr> sinCos() {
        return new FieldSinCos((Object)this.sin(), (Object)this.cos());
    }

    default public IExpr sinh() {
        return S.Sinh.of(this);
    }

    default public FieldSinhCosh<IExpr> sinhCosh() {
        return new FieldSinhCosh((Object)this.sinh(), (Object)this.cosh());
    }

    default public IExpr subtract(double arg0) {
        return this.subtract(F.num(arg0));
    }

    default public IExpr tan() {
        return S.Tan.of(this);
    }

    default public IExpr tanh() {
        return S.Tanh.of(this);
    }

    default public IExpr ulp() {
        return F.C0;
    }

    default public IExpr getPi() {
        return S.Pi;
    }

    default public IExpr toDegrees() {
        return F.Times(this, (IExpr)F.ZZ(180), (IExpr)F.Inverse(S.Pi));
    }

    default public IExpr toRadians() {
        return F.Times((IExpr)F.QQ(1L, 180L), this, (IExpr)S.Pi);
    }

    default public String toWolframString() {
        return this.toString();
    }

    public static class SourceCodeProperties {
        public final boolean symbolsAsFactoryMethod;
        public final boolean useOperators;
        public final Prefix prefix;
        public final boolean noSymbolPrefix;

        private SourceCodeProperties(boolean symbolsAsFactoryMethod, boolean useOperators, Prefix prefix, boolean noSymbolPrefix) {
            this.symbolsAsFactoryMethod = symbolsAsFactoryMethod;
            this.useOperators = useOperators;
            this.prefix = Objects.requireNonNull(prefix, "Method prefix must not be null");
            this.noSymbolPrefix = noSymbolPrefix;
        }

        public static SourceCodeProperties of(boolean symbolsAsFactoryMethod, boolean useOperators, Prefix prefix, boolean noSymbolPrefix) {
            return new SourceCodeProperties(symbolsAsFactoryMethod, useOperators, prefix, noSymbolPrefix);
        }

        public static SourceCodeProperties copyWithoutSymbolsAsFactoryMethod(SourceCodeProperties o) {
            return !o.symbolsAsFactoryMethod ? o : new SourceCodeProperties(false, o.useOperators, o.prefix, o.noSymbolPrefix);
        }

        public static enum Prefix {
            NONE,
            CLASS_NAME,
            FULLY_QUALIFIED_CLASS_NAME;

        }
    }

    public static enum COMPARE_TERNARY {
        TRUE,
        FALSE,
        UNDECIDABLE;

    }
}

