/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.interfaces;

import org.matheclipse.core.eval.util.Assumptions;
import org.matheclipse.core.eval.util.IAssumptions;
import org.matheclipse.core.interfaces.IDistribution;
import org.matheclipse.core.interfaces.IExpr;

public interface IDiscreteDistribution
extends IDistribution {
    default public int[] range(IExpr discreteDistribution, IExpr predicate, IExpr x) {
        IAssumptions assumptions = Assumptions.getInstance(predicate);
        if (assumptions != null) {
            int[] result = new int[]{this.getSupportLowerBound(discreteDistribution), this.getSupportUpperBound(discreteDistribution)};
            return assumptions.reduceRange(x, result);
        }
        return null;
    }

    default public int getSupportLowerBound(IExpr discreteDistribution) {
        return 0;
    }

    default public int getSupportUpperBound(IExpr discreteDistribution) {
        return Integer.MAX_VALUE;
    }
}

