/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.interfaces;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;

public interface IASTAppendable
extends IASTMutable {
    public static Collector<IExpr, ?, IASTAppendable> toAST(IExpr head, int initialCapacity) {
        Supplier<IASTAppendable> supplier = () -> F.ast(head, initialCapacity);
        return new CollectorImpl(supplier, IASTAppendable::append, (r1, r2) -> {
            r1.append((IExpr)r2);
            return r1;
        });
    }

    public static Collector<IExpr, ?, IASTAppendable> toAST(IExpr head) {
        return IASTAppendable.toAST(head, 5);
    }

    public static Collector<IExpr, ?, IASTAppendable> toAST(IASTAppendable appendable) {
        return new CollectorImpl(() -> appendable.copyAppendable(), IASTAppendable::append, (r1, r2) -> {
            r1.append((IExpr)r2);
            return r1;
        });
    }

    public boolean append(IExpr var1);

    default public boolean append(long value) {
        return this.append(F.ZZ(value));
    }

    default public boolean append(double value) {
        return this.append(F.num(value));
    }

    default public boolean append(String value) {
        return this.append(F.stringx(value));
    }

    default public boolean append(char value) {
        return this.append(F.stringx(value));
    }

    default public boolean append(boolean value) {
        return this.append(F.bool(value));
    }

    public void append(int var1, IExpr var2);

    default public void append(int location, long value) {
        this.append(location, F.ZZ(value));
    }

    public boolean appendAll(Collection<? extends IExpr> var1);

    public boolean appendAll(Map<? extends IExpr, ? extends IExpr> var1);

    public boolean appendAll(IAST var1, int var2, int var3);

    public boolean appendAll(int var1, Collection<? extends IExpr> var2);

    public boolean appendAll(List<? extends IExpr> var1, int var2, int var3);

    public boolean appendAll(IExpr[] var1, int var2, int var3);

    public boolean appendArgs(IAST var1);

    public boolean appendArgs(IAST var1, int var2);

    public IASTAppendable appendArgs(int var1, int var2, IntFunction<IExpr> var3);

    public IASTAppendable appendArgs(int var1, IntFunction<IExpr> var2);

    public IAST appendOneIdentity(IAST var1);

    default public void appendRule(IExpr expr) {
        this.append(expr);
    }

    default public void prependRule(IExpr rule) {
        this.append(1, rule);
    }

    public void clear();

    default public void ifAppendable(Consumer<? super IASTAppendable> consumer) {
        consumer.accept(this);
    }

    public IExpr remove(int var1);

    public void removeRange(int var1, int var2);

    public static final class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return i -> i;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

