/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.interfaces;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.ObjIntPredicate;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.interfaces.IUnaryIndexFunction;
import org.matheclipse.core.visit.IVisitor;

public interface IAST
extends IExpr,
Iterable<IExpr> {
    public static final int NO_FLAG = 0;
    public static final int CONTAINS_PATTERN = 1;
    public static final int CONTAINS_PATTERN_SEQUENCE = 2;
    public static final int CONTAINS_DEFAULT_PATTERN = 4;
    public static final int CONTAINS_NO_PATTERN = 8;
    public static final int CONTAINS_PATTERN_EXPR = 7;
    public static final int CONTAINS_NO_DEFAULT_PATTERN_MASK = 65531;
    public static final int IS_MATRIX = 32;
    public static final int IS_VECTOR = 64;
    public static final int IS_MATRIX_OR_VECTOR = 96;
    public static final int IS_DECOMPOSED_PARTIAL_FRACTION = 128;
    public static final int IS_FLATTENED = 256;
    public static final int IS_SORTED = 512;
    public static final int IS_LISTABLE_THREADED = 1024;
    public static final int IS_FLATTENED_OR_SORTED_MASK = 768;
    public static final int IS_FLAT_ORDERLESS_EVALED = 2048;
    public static final int IS_EXPANDED = 4096;
    public static final int IS_ALL_EXPANDED = 8192;
    public static final int IS_HASH_EVALED = 16384;
    public static final int IS_DERIVATIVE_EVALED = 32768;
    public static final int CONTAINS_NUMERIC_ARG = 65536;
    public static final int BUILT_IN_EVALED = 262144;
    public static final int SEQUENCE_FLATTENED = 524288;
    public static final int OUTPUT_MULTILINE = 0x100000;
    public static final int TIMES_PARSED_IMPLICIT = 0x200000;
    public static final int IS_NUMERIC_FUNCTION = 0x400000;
    public static final int IS_NOT_NUMERIC_FUNCTION = 0x800000;
    public static final int IS_NUMERIC_FUNCTION_OR_LIST = 0x1000000;
    public static final int IS_NOT_NUMERIC_FUNCTION_OR_LIST = 0x2000000;
    public static final int IS_NUMERIC_MASK = 0x3C00000;

    default public IExpr acceptChecked(IVisitor visitor) {
        try {
            return this.accept(visitor);
        }
        catch (StackOverflowError soe) {
            RecursionLimitExceeded.throwIt(Integer.MAX_VALUE, this);
            return F.NIL;
        }
    }

    @Override
    public IAST addEvalFlags(int var1);

    public IASTAppendable appendAtClone(int var1, IExpr var2);

    public IASTAppendable appendClone(IExpr var1);

    public IASTAppendable apply(IExpr var1);

    public IAST apply(IExpr var1, int var2);

    public IAST apply(IExpr var1, int var2, int var3);

    public IExpr arg1();

    default public IExpr getUnevaluated(int position) {
        return this.get(position);
    }

    public IExpr arg2();

    public IExpr arg3();

    public IExpr arg4();

    public IExpr arg5();

    @Override
    default public int argSize() {
        return this.size() - 1;
    }

    public Set<IExpr> asSet();

    public void clearHashCache();

    public boolean compareAdjacent(BiPredicate<IExpr, IExpr> var1);

    public boolean contains(Object var1);

    default public boolean containsAll(Collection<?> collection) {
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public IASTMutable copy();

    default public IASTMutable copyAST() {
        return this.copy();
    }

    public IASTAppendable copyAppendable();

    public IASTAppendable copyAppendable(int var1);

    public IASTAppendable copyFrom(int var1);

    public IASTAppendable copyHead();

    public IASTAppendable copyHead(int var1);

    default public List<IExpr> copyTo() {
        return (List)this.copyTo(new ArrayList<IExpr>(this.size()));
    }

    default public Collection<IExpr> copyTo(Collection<IExpr> collection) {
        for (int i = 1; i < this.size(); ++i) {
            collection.add(this.get(i));
        }
        return collection;
    }

    public IASTAppendable copyUntil(int var1);

    public IASTAppendable copyUntil(int var1, int var2);

    @Override
    public boolean equalsAt(int var1, IExpr var2);

    default public boolean exists(ObjIntPredicate<? super IExpr> predicate) {
        return this.exists(predicate, 1);
    }

    public boolean exists(ObjIntPredicate<? super IExpr> var1, int var2);

    @Override
    default public boolean exists(Predicate<? super IExpr> predicate) {
        return this.exists(predicate, 1);
    }

    public boolean exists(Predicate<? super IExpr> var1, int var2);

    default public boolean existsLeft(BiPredicate<IExpr, IExpr> stopPredicate) {
        int size = this.size();
        for (int i = 2; i < size; ++i) {
            if (!stopPredicate.test(this.get(i - 1), this.get(i))) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    default public IASTAppendable extract(int fromIndex, int toIndex) {
        return this.slice(fromIndex, toIndex);
    }

    public IExpr extractConditionalExpression(boolean var1);

    public IAST filter(IASTAppendable var1, IASTAppendable var2, Predicate<? super IExpr> var3);

    public IAST filter(IASTAppendable var1, IExpr var2);

    public IAST filter(IASTAppendable var1, Predicate<? super IExpr> var2);

    public IAST filter(IASTAppendable var1, Predicate<? super IExpr> var2, int var3);

    public IAST select(Predicate<? super IExpr> var1);

    public IAST select(Predicate<? super IExpr> var1, int var2);

    public IAST[] filter(Predicate<? super IExpr> var1);

    public IASTAppendable[] filterNIL(Function<IExpr, IExpr> var1);

    public IExpr findFirst(Function<IExpr, IExpr> var1);

    @Deprecated
    default public int findFirstEquals(IExpr expr) {
        return this.indexOf(expr);
    }

    @Override
    default public IExpr first() {
        if (this instanceof IAST && this.size() < 2) {
            return F.NIL;
        }
        return this.arg1();
    }

    public IExpr foldLeft(BiFunction<IExpr, IExpr, ? extends IExpr> var1, IExpr var2, int var3);

    public IExpr foldRight(BiFunction<IExpr, IExpr, ? extends IExpr> var1, IExpr var2, int var3);

    default public boolean forAll(ObjIntPredicate<? super IExpr> predicate) {
        return this.forAll(predicate, 1);
    }

    public boolean forAll(ObjIntPredicate<? super IExpr> var1, int var2);

    @Override
    default public boolean forAll(Predicate<? super IExpr> predicate) {
        return this.forAll(predicate, 1);
    }

    public boolean forAll(Predicate<? super IExpr> var1, int var2);

    public boolean forAllLeaves(Predicate<? super IExpr> var1, int var2);

    @Override
    public void forEach(Consumer<? super IExpr> var1);

    public void forEach(Consumer<? super IExpr> var1, int var2);

    default public void forEach(int end, Consumer<? super IExpr> action) {
        this.forEach(1, end, action);
    }

    default public void forEach(int start, int end, Consumer<? super IExpr> action) {
        for (int i = start; i < end; ++i) {
            action.accept(this.get(i));
        }
    }

    default public void forEach(int start, int end, ObjIntConsumer<? super IExpr> action) {
        for (int i = start; i < end; ++i) {
            action.accept(this.get(i), i);
        }
    }

    default public void forEach(int end, ObjIntConsumer<? super IExpr> action) {
        this.forEach(1, end, action);
    }

    @Override
    default public void forEach(ObjIntConsumer<? super IExpr> action) {
        this.forEach(1, this.size(), action);
    }

    public IExpr get(IInteger var1);

    public IExpr get(int var1);

    default public IExpr getValue(int position) {
        return this.get(position);
    }

    default public IAST getRule(String key) {
        int index = this.indexOf((? super IExpr x) -> x.isRuleAST() && x.first().equals(F.$str(key)));
        if (index > 0) {
            return (IAST)this.get(index);
        }
        return F.NIL;
    }

    default public IAST getRule(IExpr key) {
        int index = this.indexOf((? super IExpr x) -> x.isRuleAST() && x.first().equals(key));
        if (index > 0) {
            return (IAST)this.get(index);
        }
        return F.NIL;
    }

    public IAST getItems(int[] var1, int var2);

    public IAST getAST(int var1);

    public int getEvalFlags();

    public int getHashCache();

    public IInteger getInt(int var1);

    public IAST getList(int var1);

    public INumber getNumber(int var1);

    public IExpr getPart(int ... var1) throws IndexOutOfBoundsException;

    public IExpr getPart(IntList var1);

    default public IExpr getRule(int position) {
        return this.get(position);
    }

    default public boolean hasNumericArgument() {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            if (!this.get(i).isNumericArgument()) continue;
            return true;
        }
        return false;
    }

    default public boolean hasOptionalArgument() {
        return this.size() > 1 && this.last().isPatternDefault();
    }

    public boolean hasTrigonometricFunction();

    public boolean isEmpty();

    @Override
    default public boolean isASTOrAssociation() {
        return true;
    }

    @Override
    public boolean isEvalFlagOff(int var1);

    @Override
    public boolean isEvalFlagOn(int var1);

    public boolean isFreeAt(int var1, IExpr var2);

    @Override
    default public boolean isNotDefined() {
        if (this.isIndeterminate() || this.isDirectedInfinity()) {
            return true;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).isIndeterminate() && !this.get(i).isDirectedInfinity()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPatternMatchingFunction();

    @Override
    default public boolean isSameHeadSizeGE(ISymbol head, int length) {
        return this.head() == head && length <= this.size();
    }

    @Override
    public boolean isTimes();

    @Override
    public Iterator<IExpr> iterator();

    default public void joinToString(StringBuilder builder, CharSequence delimiter) {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            builder.append(this.get(i).toString());
            if (i >= size - 1) continue;
            builder.append(delimiter);
        }
    }

    default public void joinToString(StringBuilder builder, BiConsumer<StringBuilder, IExpr> consumer, CharSequence delimiter) {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            consumer.accept(builder, this.get(i));
            if (i >= size - 1) continue;
            builder.append(delimiter);
        }
    }

    public int lastIndexOf(IExpr var1);

    public IAST map(Function<IExpr, IExpr> var1);

    public IAST map(Function<IExpr, IExpr> var1, int var2);

    public IAST map(IASTAppendable var1, IAST var2, BiFunction<IExpr, IExpr, IExpr> var3);

    public IASTAppendable map(IASTAppendable var1, IUnaryIndexFunction<IExpr, IExpr> var2);

    public IAST map(IASTMutable var1, Function<IExpr, IExpr> var2);

    public IAST map(IExpr var1, Function<IExpr, IExpr> var2);

    default public IAST mapAt(IASTAppendable replacement, int position) {
        return this.mapThread(replacement, position);
    }

    public IAST mapLeft(IASTAppendable var1, BiFunction<IExpr, IExpr, IExpr> var2, IExpr var3);

    @Override
    public IExpr mapMatrixColumns(int[] var1, Function<IExpr, IExpr> var2);

    public IAST mapReverse(Function<IExpr, IExpr> var1);

    public IAST mapRight(IASTAppendable var1, BiFunction<IExpr, IExpr, IExpr> var2, IExpr var3);

    public IASTMutable mapThread(IAST var1, int var2);

    public IASTMutable mapThreadEvaled(EvalEngine var1, IAST var2, int var3);

    public IASTMutable mapThread(Function<IExpr, IExpr> var1);

    public IASTAppendable mapThreadEvaled(EvalEngine var1, IASTAppendable var2, IAST var3, int var4);

    @Override
    default public IAST most() {
        switch (this.size()) {
            case 0: {
                return this;
            }
            case 1: {
                return this;
            }
        }
        return this.splice(this.argSize());
    }

    public IExpr oneIdentity(IExpr var1);

    default public IExpr oneIdentity0() {
        return this.oneIdentity(F.C0);
    }

    default public IExpr oneIdentity1() {
        return this.oneIdentity(F.C1);
    }

    public IAST orElse(IAST var1);

    public int patternHashCode();

    public IASTAppendable prependClone(IExpr var1);

    public IASTAppendable remove(Predicate<? super IExpr> var1);

    public IASTAppendable removeAtClone(int var1);

    public IASTMutable removeAtCopy(int var1);

    default public IAST removeFromEnd(int fromPosition) {
        if (0 < fromPosition && fromPosition <= this.size()) {
            if (fromPosition == this.size()) {
                return this;
            }
            IASTAppendable ast = F.ast(this.head(), fromPosition);
            ast.appendArgs(this, fromPosition);
            return ast;
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(fromPosition) + ", Size: " + this.size());
    }

    default public IAST removeFromStart(int firstPosition) {
        if (0 < firstPosition && firstPosition <= this.size()) {
            if (firstPosition == 1) {
                return this;
            }
            int last = this.size();
            int size = last - firstPosition + 1;
            switch (size) {
                case 1: {
                    return F.headAST0(this.head());
                }
                case 2: {
                    return F.unaryAST1(this.head(), this.get(last - 1));
                }
                case 3: {
                    return F.binaryAST2(this.head(), this.get(last - 2), this.get(last - 1));
                }
                case 4: {
                    return F.ternaryAST3(this.head(), this.get(last - 3), this.get(last - 2), this.get(last - 1));
                }
            }
            return this.copyFrom(firstPosition);
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(firstPosition) + ", Size: " + this.size());
    }

    public IAST removeIf(Predicate<? super IExpr> var1);

    @Override
    default public IAST rest() {
        switch (this.size()) {
            case 0: {
                return this;
            }
            case 1: {
                return this;
            }
            case 2: {
                return F.headAST0(this.head());
            }
            case 3: {
                return F.unaryAST1(this.head(), this.arg2());
            }
            case 4: {
                return F.binaryAST2(this.head(), this.arg2(), this.arg3());
            }
            case 5: {
                return F.ternaryAST3(this.head(), this.arg2(), this.arg3(), this.arg4());
            }
        }
        return this.removeAtClone(1);
    }

    public IASTAppendable reverse(IASTAppendable var1);

    public IAST rotateLeft(IASTAppendable var1, int var2);

    public IAST rotateRight(IASTAppendable var1, int var2);

    @Override
    default public IExpr second() {
        return this.arg2();
    }

    public IASTAppendable setAtClone(int var1, IExpr var2);

    default public IASTMutable setAtCopy(int i, IExpr expr) {
        IASTMutable ast = this.copy();
        ast.set(i, expr);
        return ast;
    }

    public void setEvalFlags(int var1);

    @Override
    public int size();

    default public IASTAppendable slice(int start, int end) {
        if (0 < start && start <= this.size() && start < end && end <= this.size()) {
            IASTAppendable ast = F.ast(this.head(), end - start);
            for (int i = start; i < end; ++i) {
                ast.append(this.get(i));
            }
            return ast;
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(start) + ", Size: " + this.size());
    }

    default public IAST splice(int index) {
        return this.removeAtCopy(index);
    }

    public IAST splice(int var1, int var2, IExpr ... var3);

    public Stream<IExpr> stream();

    public Stream<IExpr> stream(int var1, int var2);

    default public Stream<IExpr> stream0() {
        return this.stream(0, this.size());
    }

    public IExpr[] toArray();

    @Override
    public ISymbol topHead();

    public static enum PROPERTY {
        CSS;

    }
}

