/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.img;

import java.util.stream.IntStream;
import org.matheclipse.core.convert.RGBColor;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;

public enum ColorFormat {

    private static final IExpr[] LOOKUP = new IExpr[256];

    public static IAST toVector(RGBColor color) {
        return F.List(LOOKUP[color.getRed()], LOOKUP[color.getGreen()], LOOKUP[color.getBlue()], LOOKUP[color.getAlpha()]);
    }

    public static IAST toVector(int argb) {
        return ColorFormat.toVector(new RGBColor(argb, true));
    }

    public static RGBColor toColor(IAST vector) {
        if (vector.size() != 5) {
            throw new IllegalArgumentException("ColorFormat#toColor() exppects 4 arguments");
        }
        return new RGBColor(((IInteger)vector.arg1()).toInt(), ((IInteger)vector.arg2()).toInt(), ((IInteger)vector.arg3()).toInt(), ((IInteger)vector.arg4()).toInt());
    }

    public static int toInt(IAST vector) {
        return ColorFormat.toColor(vector).getRGB();
    }

    static {
        IntStream.range(0, 256).forEach(index -> {
            ColorFormat.LOOKUP[index] = F.ZZ(index);
        });
    }
}

