/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.graphics;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.graphics.Dimensions2D;
import org.matheclipse.core.graphics.Show2SVG;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;

public class Show3D2ThreeJS {
    private static final Logger LOGGER = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static void graphics3dToSVG(IAST ast, StringBuilder buf) {
        EvalEngine engine = EvalEngine.get();
        IAST numericAST = (IAST)engine.evalN(ast);
        double[] viewpoints = new double[]{1.3, -2.4, 2.0};
        if (numericAST.size() > 2) {
            OptionArgs options = new OptionArgs(numericAST.topHead(), numericAST, 2, engine);
            Show3D2ThreeJS.optionViewPoint(options, viewpoints);
        }
        int width = 400;
        int height = 200;
        Dimensions2D dim = new Dimensions2D(width, height);
        buf.append("<graphics3d data=\"{");
        StringBuilder builder = new StringBuilder(1024);
        Show3D2ThreeJS.appendDoubleArray(builder, "viewpoint", viewpoints);
        try {
            for (int i = 1; i < numericAST.size(); ++i) {
                if (numericAST.get(i).isSameHeadSizeGE(S.Polygon, 2)) {
                    Show3D2ThreeJS.elements("polygon", numericAST.getAST(i), builder, dim);
                    continue;
                }
                if (!numericAST.get(i).isSameHeadSizeGE(S.Point, 2)) continue;
                Show3D2ThreeJS.elements("point", numericAST.getAST(i), builder, dim);
            }
        }
        finally {
            builder.append("\"lighting\": [{\"color\": [0.3, 0.2, 0.4], \"type\": \"Ambient\"}, {\"color\": [0.8, 0.0, 0.0], \"position\": [2.0, 0.0, 2.0], \"type\": \"Directional\"}, {\"color\": [0.0, 0.8, 0.0], \"position\": [2.0, 2.0, 2.0], \"type\": \"Directional\"}, {\"color\": [0.0, 0.0, 0.8], \"position\": [0.0, 2.0, 2.0], \"type\": \"Directional\"}], \"axes\": {\"hasaxes\": [false, false, false], \"ticks\": [[[0.0, 0.2, 0.4, 0.6000000000000001, 0.8, 1.0], [0.05, 0.1, 0.15000000000000002, 0.25, 0.30000000000000004, 0.35000000000000003, 0.45, 0.5, 0.55, 0.65, 0.7000000000000001, 0.75, 0.8500000000000001, 0.9, 0.9500000000000001], [\"0.0\", \"0.2\", \"0.4\", \"0.6\", \"0.8\", \"1.0\"]], [[0.0, 0.2, 0.4, 0.6000000000000001, 0.8, 1.0], [0.05, 0.1, 0.15000000000000002, 0.25, 0.30000000000000004, 0.35000000000000003, 0.45, 0.5, 0.55, 0.65, 0.7000000000000001, 0.75, 0.8500000000000001, 0.9, 0.9500000000000001], [\"0.0\", \"0.2\", \"0.4\", \"0.6\", \"0.8\", \"1.0\"]], [[0.0, 0.2, 0.4, 0.6000000000000001, 0.8, 1.0], [0.05, 0.1, 0.15000000000000002, 0.25, 0.30000000000000004, 0.35000000000000003, 0.45, 0.5, 0.55, 0.65, 0.7000000000000001, 0.75, 0.8500000000000001, 0.9, 0.9500000000000001], [\"0.0\", \"0.2\", \"0.4\", \"0.6\", \"0.8\", \"1.0\"]]]}, \"extent\": {\"zmax\": 1.0, \"ymax\": 1.0, \"zmin\": 0.0, \"xmax\": 1.0, \"xmin\": 0.0, \"ymin\": 0.0}");
            Escaper escaper = HtmlEscapers.htmlEscaper();
            buf.append(escaper.escape(builder.toString()));
            buf.append("}\" />");
        }
    }

    static void optionViewPoint(OptionArgs options, double[] viewpoints) {
        block2: {
            IExpr option;
            block3: {
                String viewpoint;
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    option = options.getOption(S.ViewPoint);
                                    if (!option.isPresent()) break block2;
                                    if (!option.isSymbol()) break block3;
                                    viewpoint = option.toString().toLowerCase();
                                    if (!viewpoint.equals("above")) break block4;
                                    viewpoints[0] = 0.0;
                                    viewpoints[1] = 0.0;
                                    viewpoints[2] = 2.0;
                                    break block2;
                                }
                                if (!viewpoint.equals("below")) break block5;
                                viewpoints[0] = 0.0;
                                viewpoints[1] = 0.0;
                                viewpoints[2] = -2.0;
                                break block2;
                            }
                            if (!viewpoint.equals("front")) break block6;
                            viewpoints[0] = 0.0;
                            viewpoints[1] = -2.0;
                            viewpoints[2] = 0.0;
                            break block2;
                        }
                        if (!viewpoint.equals("back")) break block7;
                        viewpoints[0] = 0.0;
                        viewpoints[1] = 2.0;
                        viewpoints[2] = 0.0;
                        break block2;
                    }
                    if (!viewpoint.equals("left")) break block8;
                    viewpoints[0] = -2.0;
                    viewpoints[1] = 0.0;
                    viewpoints[2] = 0.0;
                    break block2;
                }
                if (!viewpoint.equals("right")) break block2;
                viewpoints[0] = 2.0;
                viewpoints[1] = 0.0;
                viewpoints[2] = 0.0;
                break block2;
            }
            if (option.isList() && option.isAST3()) {
                IAST list = (IAST)option;
                for (int i = 1; i < list.size(); ++i) {
                    viewpoints[i - 1] = ((ISignedNumber)list.getAt(i)).doubleValue();
                }
            }
        }
    }

    private static void appendDoubleArray(StringBuilder builder, String tag, double[] viewpoints) {
        builder.append("\"");
        builder.append(tag);
        builder.append("\": [");
        for (int i = 0; i < viewpoints.length; ++i) {
            builder.append(Show2SVG.FORMATTER.format(viewpoints[i]));
            if (i >= viewpoints.length - 1) continue;
            builder.append(", ");
        }
        builder.append("], ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void elements(String type, IAST ast, StringBuilder buf, Dimensions2D dim) {
        block10: {
            try {
                IExpr arg1 = ast.arg1();
                if (arg1.isListOfLists()) {
                    IAST list = (IAST)ast.arg1();
                    if (list.size() <= 1) break block10;
                    try {
                        buf.append("\"elements\": [{\"coords\": [");
                        for (int i = 1; i < list.size(); ++i) {
                            IAST point = list.getAST(i);
                            Show3D2ThreeJS.addCoordsToElements(buf, point);
                            if (i >= list.argSize()) continue;
                            buf.append(", ");
                        }
                        buf.append("], \"type\": \"");
                        buf.append(type);
                        buf.append("\", \"faceColor\": [1, 1, 1, 1]");
                        break block10;
                    }
                    finally {
                        buf.append("}], ");
                    }
                }
                if (!arg1.isList() || !((IAST)arg1).isAST3()) break block10;
                try {
                    buf.append("\"elements\": [{\"coords\": [");
                    Show3D2ThreeJS.addCoordsToElements(buf, (IAST)arg1);
                    buf.append("], \"type\": \"");
                    buf.append(type);
                    buf.append("\", \"faceColor\": [1, 1, 1, 1]");
                }
                finally {
                    buf.append("}], ");
                }
            }
            catch (RuntimeException ex) {
                LOGGER.error("Show3D2ThreeJS.elements() failed", (Throwable)ex);
            }
        }
    }

    private static void addCoordsToElements(StringBuilder buf, IAST point) {
        if (point.isList() && point.isAST3()) {
            buf.append("[[");
            for (int j = 1; j < point.size(); ++j) {
                buf.append(Show2SVG.FORMATTER.format(((ISignedNumber)point.getAt(j)).doubleValue()));
                if (j >= point.argSize()) continue;
                buf.append(", ");
            }
            buf.append("], null]");
        }
    }
}

