/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.graphics;

import org.matheclipse.core.convert.RGBColor;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.ISignedNumber;

public class Dimensions2D {
    public RGBColor color = RGBColor.BLACK;
    public int width;
    public int height;
    public double xMin;
    public double xMax;
    public double yMin;
    public double yMax;
    public boolean plotRange;
    public boolean axes;

    public Dimensions2D() {
        this(600, 400);
    }

    public Dimensions2D(int width, int height) {
        this.width = width;
        this.height = height;
        this.xMin = Double.MAX_VALUE;
        this.xMax = -1.7976931348623157E308;
        this.yMin = Double.MAX_VALUE;
        this.yMax = -1.7976931348623157E308;
        this.plotRange = false;
        this.axes = false;
    }

    public void getColorRGB(StringBuilder buf) {
        float[] rgb = this.color.getRGBColorComponents(null);
        buf.append(Float.toString(rgb[0] * 100.0f));
        buf.append("%, ");
        buf.append(Float.toString(rgb[1] * 100.0f));
        buf.append("%, ");
        buf.append(Float.toString(rgb[2] * 100.0f));
        buf.append("%");
    }

    public double getXScale() {
        double diff = this.xMax - this.xMin;
        if (F.isZero(diff)) {
            return 0.0;
        }
        return (double)this.width / diff;
    }

    public double getYScale() {
        double diff = this.yMax - this.yMin;
        if (F.isZero(diff)) {
            return 0.0;
        }
        return (double)this.height / (this.yMax - this.yMin);
    }

    public boolean isAxes() {
        return this.axes;
    }

    public boolean isValidRange() {
        return this.xMin != Double.MAX_VALUE && this.xMax != -1.7976931348623157E308 && this.yMin != Double.MAX_VALUE && this.yMax != -1.7976931348623157E308;
    }

    public void minMax(double xmin, double xmax, double ymin, double ymax) {
        if (!this.plotRange) {
            if (xmin < this.xMin) {
                this.xMin = xmin;
            }
            if (xmax > this.xMax) {
                this.xMax = xmax;
            }
            if (ymin < this.yMin) {
                this.yMin = ymin;
            }
            if (ymax > this.yMax) {
                this.yMax = ymax;
            }
        }
    }

    public void setAxes(boolean axes) {
        this.axes = axes;
    }

    public void setColorRGB(IAST rgbColor) {
        if (rgbColor.size() == 4 || rgbColor.size() == 5) {
            float r = (float)rgbColor.arg1().evalDouble();
            float g = (float)rgbColor.arg2().evalDouble();
            float b = (float)rgbColor.arg3().evalDouble();
            this.color = new RGBColor(r, g, b);
        }
    }

    public void setPlotRange(IAST p1, IAST p2) {
        double x1 = ((ISignedNumber)p1.arg1()).doubleValue();
        double y1 = ((ISignedNumber)p1.arg2()).doubleValue();
        double x2 = ((ISignedNumber)p2.arg1()).doubleValue();
        double y2 = ((ISignedNumber)p2.arg2()).doubleValue();
        this.minMax(x1, y1, x2, y2);
        this.plotRange = true;
    }
}

