/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class UnaryVariable2Slot
implements Function<IExpr, IExpr> {
    private final Map<IExpr, IExpr> fMap;
    private final Collection<IExpr> fVariableList;
    private int fSlotCounter;

    public UnaryVariable2Slot(Map<IExpr, IExpr> map, Collection<IExpr> variableList) {
        this.fMap = map;
        this.fVariableList = variableList;
        this.fSlotCounter = 0;
    }

    @Override
    public IExpr apply(IExpr firstArg) {
        if (firstArg.isVariable()) {
            if (firstArg.toString().charAt(0) >= 'A' && firstArg.toString().charAt(0) <= 'Z') {
                if (((ISymbol)firstArg).hasOrderlessAttribute()) {
                    return F.NIL;
                }
                if (firstArg.equals(S.Print)) {
                    return F.NIL;
                }
                return firstArg;
            }
            if (Config.SERVER_MODE && firstArg.toString().charAt(0) == '$') {
                return F.NIL;
            }
        } else {
            return F.NIL;
        }
        IExpr result = this.fMap.get(firstArg);
        if (result == null) {
            result = F.Slot(F.ZZ(++this.fSlotCounter));
            this.fMap.put(firstArg, result);
            this.fVariableList.add(firstArg);
        }
        return result != null ? result : F.NIL;
    }
}

