/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import java.util.function.DoubleFunction;
import java.util.function.Function;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableFunction;
import org.hipparchus.complex.Complex;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.DoubleStackEvaluator;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;

public class UnaryNumerical
implements Function<IExpr, IExpr>,
UnivariateDifferentiableFunction,
DoubleFunction<IExpr> {
    final IExpr fFunction;
    final ISymbol fVariable;
    final EvalEngine fEngine;
    UnaryNumerical fFirstDerivative = null;

    public UnaryNumerical(IExpr function, ISymbol variable) {
        this(function, variable, EvalEngine.get(), false);
    }

    public UnaryNumerical(IExpr function, ISymbol variable, EvalEngine engine) {
        this(function, variable, engine, false);
    }

    public UnaryNumerical(IExpr function, ISymbol variable, EvalEngine engine, boolean firstDerivative) {
        if (!variable.isVariable() || variable.isBuiltInSymbol()) {
            throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list(variable), EvalEngine.get()));
        }
        this.fVariable = variable;
        this.fFunction = function;
        this.fEngine = engine;
        if (firstDerivative) {
            IExpr temp = engine.evaluate(F.D(this.fFunction, this.fVariable));
            this.fFirstDerivative = new UnaryNumerical(temp, this.fVariable, engine, false);
        }
    }

    @Override
    public IExpr apply(IExpr arg1) {
        return this.fEngine.evalN(F.subst(this.fFunction, F.Rule((IExpr)this.fVariable, arg1)));
    }

    @Override
    public IExpr apply(double value) {
        return this.fEngine.evalN(F.subst(this.fFunction, F.Rule((IExpr)this.fVariable, (IExpr)F.num(value))));
    }

    public double value(double x) {
        double result = 0.0;
        double[] stack = new double[10];
        try {
            IExpr temp = F.subs(this.fFunction, this.fVariable, Num.valueOf(x));
            result = DoubleStackEvaluator.eval(stack, 0, temp);
        }
        catch (RuntimeException rex) {
            return Double.NaN;
        }
        return result;
    }

    public <T extends Derivative<T>> T value(T x) throws MathIllegalArgumentException {
        return (T)((Derivative)x.compose(new double[]{this.value(x.getReal()), this.fFirstDerivative.value(x.getReal())}));
    }

    public UnivariateFunction derivative() {
        if (this.fFirstDerivative != null) {
            return this.fFirstDerivative;
        }
        IAST ast = F.D(this.fFunction, this.fVariable);
        IExpr expr = this.fEngine.evaluate(ast);
        this.fFirstDerivative = new UnaryNumerical(expr, this.fVariable, this.fEngine, false);
        return this.fFirstDerivative;
    }

    public ComplexNum value(ComplexNum z) {
        IExpr temp = this.apply(z);
        if (temp instanceof ComplexNum) {
            return (ComplexNum)temp;
        }
        if (temp instanceof INum) {
            return ComplexNum.valueOf((INum)temp);
        }
        throw new ArithmeticException("Expected numerical complex value object!");
    }

    public Complex value(Complex z) {
        IExpr temp = this.apply(F.complexNum(z));
        if (temp instanceof ComplexNum) {
            return ((ComplexNum)temp).complexValue();
        }
        if (temp instanceof INum) {
            return Complex.valueOf((double)((INum)temp).doubleValue());
        }
        throw new ArithmeticException("Expected numerical complex value object!");
    }

    public INum value(INum z) {
        IExpr temp = this.apply(z);
        if (temp instanceof INum) {
            return (INum)temp;
        }
        throw new ArithmeticException("Expected numerical double value object!");
    }
}

