/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import java.util.function.Supplier;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IDimensionFunction;
import org.matheclipse.core.interfaces.IExpr;

public class Tensors {
    public static IASTMutable build(Supplier<IExpr> supplier, int[] dimension) {
        ArraySupplierBuilder builder = new ArraySupplierBuilder(supplier, dimension);
        return builder.createArray(S.List);
    }

    public static IASTMutable build(IDimensionFunction<IExpr> function, int[] dimension) {
        ArrayIndexBuilder builder = new ArrayIndexBuilder(function, dimension);
        return builder.createArray(S.List);
    }

    private static class ArrayIndexBuilder {
        final IDimensionFunction<IExpr> function;
        final int[] dimension;

        public ArrayIndexBuilder(IDimensionFunction<IExpr> function, int[] dimension) {
            this.function = function;
            this.dimension = dimension;
        }

        private void createArrayRecursive(IASTMutable list, int position, int[] index) {
            int size = this.dimension[position];
            if (this.dimension.length - 1 == position) {
                for (int i = 1; i <= size; ++i) {
                    index[position] = i;
                    list.set(i, this.function.apply(index));
                }
                return;
            }
            int size2 = this.dimension[position + 1];
            for (int i = 1; i <= size; ++i) {
                index[position] = i;
                IASTMutable currentList = F.astMutable(S.List, size2);
                list.set(i, currentList);
                this.createArrayRecursive(currentList, position + 1, index);
            }
        }

        private IASTMutable createArray(IExpr head) {
            IASTMutable list = F.astMutable(head, this.dimension[0]);
            int[] index = this.startIndex();
            this.createArrayRecursive(list, 0, index);
            return list;
        }

        private int[] startIndex() {
            int[] index = new int[this.dimension.length];
            for (int i = 0; i < index.length; ++i) {
                index[i] = 1;
            }
            return index;
        }
    }

    private static class ArraySupplierBuilder {
        final Supplier<IExpr> supplier;
        final int[] dimension;

        private ArraySupplierBuilder(Supplier<IExpr> supplier, int[] dimension) {
            this.supplier = supplier;
            this.dimension = dimension;
        }

        private void createArrayRecursive(IASTMutable list, int position) {
            if (this.dimension.length - 1 == position) {
                int size = this.dimension[position];
                for (int i = 1; i <= size; ++i) {
                    list.set(i, this.supplier.get());
                }
                return;
            }
            int size1 = this.dimension[position];
            int size2 = this.dimension[position + 1];
            for (int i = 1; i <= size1; ++i) {
                IASTMutable currentList = F.astMutable(S.List, size2);
                list.set(i, currentList);
                this.createArrayRecursive(currentList, position + 1);
            }
        }

        private IASTMutable createArray(IExpr head) {
            IASTMutable list = F.astMutable(head, this.dimension[0]);
            this.createArrayRecursive(list, 0);
            return list;
        }
    }
}

