/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import java.io.Serializable;
import java.util.Comparator;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class Predicates {
    public static Predicate<IExpr> in(IAST ast) {
        return new InASTPredicate(ast);
    }

    public static Predicate<IExpr> in(IExpr expr) {
        return new InASTPredicate(F.list(expr));
    }

    public static Predicate<IExpr> isAST(final ISymbol[] heads) {
        return new Predicate<IExpr>(){

            @Override
            public boolean test(IExpr input) {
                for (int i = 0; i < heads.length; ++i) {
                    if (!input.isAST(heads[i])) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static BiPredicate<IExpr, IExpr> isBinaryFalse(IExpr expr) {
        return new IsBinaryFalse(expr, EvalEngine.get());
    }

    public static BiPredicate<IExpr, IExpr> isBinaryTrue(IExpr expr) {
        return new IsBinaryTrue(expr, EvalEngine.get());
    }

    public static Predicate<IExpr> isTrue(EvalEngine engine, IExpr head) {
        IEvaluator eval;
        if (head.isBuiltInSymbol() && (eval = ((IBuiltInSymbol)head).getEvaluator()) instanceof Predicate) {
            return (Predicate)((Object)eval);
        }
        return x -> engine.evalTrue(head, (IExpr)x);
    }

    public static Predicate<IExpr> isUnaryVariableOrPattern() {
        return new Predicate<IExpr>(){

            @Override
            public boolean test(IExpr firstArg) {
                if (firstArg instanceof ISymbol) {
                    return true;
                }
                return firstArg instanceof IPattern;
            }
        };
    }

    public static Predicate<IExpr> toFreeQ(IExpr pattern) {
        PatternMatcher matcher;
        if (pattern.isSymbol() || pattern.isNumber() || pattern.isString()) {
            return x -> x.equals(pattern);
        }
        if (pattern.isOrderlessAST() && pattern.isFreeOfPatterns()) {
            IPatternSequence blankNullRest = F.$ps(null, true);
            IASTAppendable newPattern = ((IAST)pattern).copyAppendable();
            newPattern.append(blankNullRest);
            matcher = new PatternMatcher(newPattern);
        } else {
            matcher = new PatternMatcher(pattern);
        }
        return matcher;
    }

    public static Predicate<IExpr> toMemberQ(IExpr pattern) {
        if (pattern.isSymbol() || pattern.isNumber() || pattern.isString()) {
            return x -> x.equals(pattern);
        }
        return new PatternMatcher(pattern);
    }

    private Predicates() {
    }

    public static class IsBinaryTrue
    implements BiPredicate<IExpr, IExpr>,
    Comparator<IExpr> {
        protected final EvalEngine engine;
        protected final IExpr head;

        public IsBinaryTrue(IExpr head) {
            this(head, EvalEngine.get());
        }

        public IsBinaryTrue(IExpr head, EvalEngine engine) {
            this.engine = engine;
            this.head = head;
        }

        @Override
        public int compare(IExpr firstArg, IExpr secondArg) {
            IASTMutable ast = F.binaryAST2(this.head, firstArg, secondArg);
            IExpr temp = this.engine.evaluate(ast);
            if (temp.isTrue()) {
                return 1;
            }
            if (temp.isFalse()) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean test(IExpr firstArg, IExpr secondArg) {
            IASTMutable ast = F.binaryAST2(this.head, firstArg, secondArg);
            return this.engine.evaluate(ast).isTrue();
        }
    }

    public static class IsBinaryFalse
    implements BiPredicate<IExpr, IExpr>,
    Comparator<IExpr> {
        protected final EvalEngine engine;
        protected final IExpr head;

        public IsBinaryFalse(IExpr head) {
            this(head, EvalEngine.get());
        }

        public IsBinaryFalse(IExpr head, EvalEngine engine) {
            this.engine = engine;
            this.head = head;
        }

        @Override
        public int compare(IExpr firstArg, IExpr secondArg) {
            IASTMutable ast = F.binaryAST2(this.head, firstArg, secondArg);
            IExpr temp = this.engine.evaluate(ast);
            if (temp.isFalse()) {
                return 1;
            }
            if (temp.isTrue()) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean test(IExpr firstArg, IExpr secondArg) {
            IASTMutable ast = F.binaryAST2(this.head, firstArg, secondArg);
            return this.engine.evaluate(ast).isFalse();
        }
    }

    private static class InASTPredicate
    implements Predicate<IExpr>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final IAST target;

        private InASTPredicate(IAST target) {
            this.target = target;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof InASTPredicate) {
                InASTPredicate that = (InASTPredicate)obj;
                return this.target.equals(that.target);
            }
            return false;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        @Override
        public boolean test(IExpr t) {
            for (IExpr expr : this.target) {
                if (!expr.equals(t)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "In(" + this.target + ")";
        }
    }
}

