/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import org.hipparchus.analysis.MultivariateVectorFunction;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.DoubleStackEvaluator;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;

public class MultiVariateVectorGradient
implements MultivariateVectorFunction {
    final IExpr fFunction;
    final IAST fGradientFunctions;
    final IAST fVariableList;
    final EvalEngine fEngine;

    public MultiVariateVectorGradient(IExpr function, IAST variablesList) {
        this(function, variablesList, EvalEngine.get());
    }

    public MultiVariateVectorGradient(IExpr function, IAST variablesList, EvalEngine engine) {
        this.fVariableList = variablesList;
        this.fEngine = engine;
        this.fFunction = function;
        IExpr gradientList = S.Grad.of(engine, function, this.fVariableList);
        if (!gradientList.isList() || gradientList.size() != variablesList.size()) {
            throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list(gradientList), EvalEngine.get()));
        }
        this.fGradientFunctions = (IAST)gradientList;
        variablesList.exists(x -> {
            if (!x.isVariable() || x.isBuiltInSymbol()) {
                throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list(x), EvalEngine.get()));
            }
            return false;
        });
    }

    public double[] value(double[] point) throws IllegalArgumentException {
        double[] result = new double[point.length];
        double[] stack = new double[10];
        try {
            int i;
            IASTAppendable rules = F.ListAlloc(this.fVariableList.size());
            for (i = 0; i < point.length; ++i) {
                rules.append(F.Rule(this.fVariableList.get(i + 1), (IExpr)F.num(point[i])));
            }
            for (i = 1; i < this.fGradientFunctions.size(); ++i) {
                double d;
                IExpr temp = F.subst(this.fGradientFunctions.get(i), rules);
                result[i - 1] = d = DoubleStackEvaluator.eval(stack, 0, temp);
            }
        }
        catch (RuntimeException rex) {
            return null;
        }
        return result;
    }
}

