/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import org.hipparchus.analysis.MultivariateFunction;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.DoubleStackEvaluator;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;

public class MultiVariateFunction
implements MultivariateFunction {
    final IExpr fFunction;
    final IAST fVariableList;
    final EvalEngine fEngine;

    public MultiVariateFunction(IExpr function, IAST variablesList) {
        this(function, variablesList, EvalEngine.get());
    }

    public MultiVariateFunction(IExpr function, IAST variablesList, EvalEngine engine) {
        this.fFunction = function;
        this.fVariableList = variablesList;
        this.fEngine = engine;
        variablesList.exists(x -> {
            if (!x.isVariable() || x.isBuiltInSymbol()) {
                throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list(x), EvalEngine.get()));
            }
            return false;
        });
    }

    public double value(double[] point) {
        double result = 0.0;
        double[] stack = new double[10];
        try {
            IASTAppendable list = F.ListAlloc();
            for (int i = 0; i < point.length; ++i) {
                list.append(F.Rule(this.fVariableList.get(i + 1), (IExpr)F.num(point[i])));
            }
            IExpr temp = F.subst(this.fFunction, list);
            result = DoubleStackEvaluator.eval(stack, 0, temp);
        }
        catch (RuntimeException rex) {
            return Double.NaN;
        }
        return result;
    }
}

