/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.util.OpenFixedSizeMap;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.parser.ExprParser;
import org.matheclipse.core.patternmatching.PatternMatcherAndEvaluator;
import org.matheclipse.core.patternmatching.PatternMatcherList;

public class Functors {
    private static Predicate<IExpr> PATTERNQ_PREDICATE = new Predicate<IExpr>(){

        @Override
        public boolean test(IExpr input) {
            return input.isBlank() || input.isPattern() || input.isPatternSequence(false) || input.isAlternatives() || input.isExcept();
        }
    };

    public static Function<IExpr, IExpr> rules(Map<? extends IExpr, ? extends IExpr> rulesMap) {
        return new RulesFunctor(rulesMap);
    }

    public static Function<IExpr, IExpr> equalRule(IAST rule) {
        if (rule.first().isAST(S.HoldPattern, 2)) {
            return new SingleRuleFunctor(rule.setAtCopy(1, rule.first().first()));
        }
        return new SingleRuleFunctor(rule);
    }

    public static Function<IExpr, IExpr> rules(String[] strRules) {
        IASTAppendable astRules = F.ListAlloc(strRules.length);
        EvalEngine engine = EvalEngine.get();
        ExprParser parser = new ExprParser(engine);
        for (String str : strRules) {
            IExpr expr = parser.parse(str);
            expr = engine.evaluate(expr);
            astRules.append(expr);
        }
        return Functors.rules(astRules, engine);
    }

    public static Function<IExpr, IExpr> rules(IAST astRules, EvalEngine engine) {
        ArrayList<PatternMatcherAndEvaluator> matchers = new ArrayList<PatternMatcherAndEvaluator>();
        if (astRules.isList()) {
            return Functors.rulesFromNestedList(astRules, engine, matchers);
        }
        if (!astRules.isRuleAST()) {
            throw new ArgumentTypeException("rule expression (x->y or x:>y) expected instead of " + astRules.toString());
        }
        IAST rule = astRules;
        OpenFixedSizeMap<IExpr, IExpr> equalRules = new OpenFixedSizeMap<IExpr, IExpr>(3);
        Functors.addRuleToCollection(equalRules, matchers, rule);
        if (matchers.size() > 0) {
            return new RulesPatternFunctor(equalRules, matchers, engine);
        }
        return Functors.equalRule(rule);
    }

    public static Function<IExpr, IExpr> equalRules(IAST lhsAST, IAST rhsAST) {
        if (lhsAST.size() > 1 && lhsAST.size() == rhsAST.size()) {
            int argsSize = lhsAST.argSize();
            AbstractMap equalRules = argsSize <= 5 ? new OpenFixedSizeMap(argsSize * 3 - 1) : new HashMap();
            for (int i = 1; i < lhsAST.size(); ++i) {
                equalRules.put(lhsAST.get(i), rhsAST.get(i));
            }
            return Functors.rules(equalRules);
        }
        HashMap equalRules = new HashMap();
        return Functors.rules(equalRules);
    }

    private static Function<IExpr, IExpr> rulesFromNestedList(IAST astRules, EvalEngine engine, List<PatternMatcherAndEvaluator> matchers) {
        if (astRules.size() > 1) {
            int argsSize = astRules.argSize();
            AbstractMap equalRules = argsSize <= 5 ? new OpenFixedSizeMap(argsSize * 3 - 1) : new HashMap();
            for (IExpr expr : astRules) {
                if (expr.isRuleAST()) {
                    IAST rule = (IAST)expr;
                    Functors.addRuleToCollection(equalRules, matchers, rule);
                    continue;
                }
                if (astRules.isList()) {
                    return Functors.rulesFromNestedList((IAST)expr, engine, matchers);
                }
                throw new ArgumentTypeException("rule expression (x->y or x:>y) expected instead of " + expr.toString());
            }
            if (matchers.size() > 0) {
                return new RulesPatternFunctor(equalRules, matchers, engine);
            }
            if (argsSize == 1) {
                return Functors.equalRule((IAST)astRules.arg1());
            }
            return Functors.rules(equalRules);
        }
        HashMap equalRules = new HashMap();
        return Functors.rules(equalRules);
    }

    public static Function<IExpr, IExpr> listRules(IAST astRules, IASTAppendable result, EvalEngine engine) {
        AbstractMap equalRules;
        ArrayList<PatternMatcherList> matchers = new ArrayList<PatternMatcherList>();
        if (astRules.isList()) {
            if (astRules.size() > 1) {
                int argsSize = astRules.argSize();
                equalRules = argsSize <= 5 ? new OpenFixedSizeMap(argsSize * 3 - 1) : new HashMap();
                for (IExpr expr : astRules) {
                    if (expr.isRuleAST()) {
                        IAST rule = (IAST)expr;
                        Functors.createPatternMatcherList(equalRules, matchers, rule);
                        continue;
                    }
                    throw new ArgumentTypeException("rule expression (x->y or x:>y) expected instead of " + expr.toString());
                }
            } else {
                equalRules = new HashMap();
            }
        } else if (astRules.isRuleAST()) {
            equalRules = new OpenFixedSizeMap(3);
            Functors.createPatternMatcherList(equalRules, matchers, astRules);
        } else {
            throw new ArgumentTypeException("rule expression (x->y or x:>y) expected instead of " + astRules.toString());
        }
        if (matchers.size() > 0) {
            return new ListRulesPatternFunctor(equalRules, matchers, result, engine);
        }
        return Functors.listRules(equalRules, result);
    }

    public static Function<IExpr, IExpr> listRules(Map<IExpr, IExpr> rulesMap, IASTAppendable result) {
        return new ListRulesPatternFunctor(rulesMap, result);
    }

    private static void addRuleToCollection(Map<IExpr, IExpr> equalRules, List<PatternMatcherAndEvaluator> matchers, IAST rule) {
        IExpr lhs = rule.arg1();
        IExpr rhs = rule.arg2();
        if (lhs.isAST(S.HoldPattern, 2)) {
            lhs = lhs.first();
        }
        if (lhs.isFree(PATTERNQ_PREDICATE, true)) {
            IExpr temp = equalRules.get(lhs);
            if (temp == null) {
                if (lhs.isOrderlessAST() || lhs.isFlatAST()) {
                    if (rule.isRuleDelayed()) {
                        matchers.add(new PatternMatcherAndEvaluator(2, lhs, rhs));
                    } else {
                        matchers.add(new PatternMatcherAndEvaluator(1, lhs, Functors.evalOneIdentity(rhs)));
                    }
                    return;
                }
                equalRules.put(lhs, rhs);
            }
        } else if (rule.isRuleDelayed()) {
            matchers.add(new PatternMatcherAndEvaluator(2, lhs, rhs));
        } else {
            matchers.add(new PatternMatcherAndEvaluator(1, lhs, Functors.evalOneIdentity(rhs)));
        }
    }

    private static void createPatternMatcherList(Map<IExpr, IExpr> equalRules, List<PatternMatcherList> matchers, IAST rule) {
        if (rule.arg1().isFree(PATTERNQ_PREDICATE, true)) {
            IExpr temp = equalRules.get(rule.arg1());
            if (temp == null) {
                if (rule.arg1().isOrderlessAST() || rule.arg1().isFlatAST()) {
                    if (rule.isRuleDelayed()) {
                        matchers.add(new PatternMatcherList(2, rule.arg1(), rule.arg2()));
                    } else {
                        matchers.add(new PatternMatcherList(1, rule.arg1(), Functors.evalOneIdentity(rule.arg2())));
                    }
                    return;
                }
                equalRules.put(rule.arg1(), rule.arg2());
            }
        } else if (rule.isRuleDelayed()) {
            matchers.add(new PatternMatcherList(2, rule.arg1(), rule.arg2()));
        } else {
            matchers.add(new PatternMatcherList(1, rule.arg1(), Functors.evalOneIdentity(rule.arg2())));
        }
    }

    private static IExpr evalOneIdentity(IExpr expr) {
        IAST arg2AST;
        if (expr.isAST() && (arg2AST = (IAST)expr).isAST1() && arg2AST.head().isSymbol() && ((ISymbol)arg2AST.head()).hasOneIdentityAttribute()) {
            expr = arg2AST.arg1();
        }
        return expr;
    }

    private Functors() {
    }

    private static class ListRulesPatternFunctor
    implements Function<IExpr, IExpr> {
        private final Map<IExpr, IExpr> fEqualRules;
        private final List<PatternMatcherList> fMatchers;
        private final EvalEngine fEngine;
        private IASTAppendable fResult;

        public ListRulesPatternFunctor(Map<IExpr, IExpr> equalRules, List<PatternMatcherList> matchers, IASTAppendable result, EvalEngine engine) {
            this.fEqualRules = equalRules;
            this.fMatchers = matchers;
            this.fResult = result;
            this.fEngine = engine;
        }

        public ListRulesPatternFunctor(Map<IExpr, IExpr> rulesMap, IASTAppendable result) {
            this.fEqualRules = rulesMap;
            this.fResult = result;
            this.fMatchers = null;
            this.fEngine = null;
        }

        @Override
        public IExpr apply(IExpr arg) {
            IExpr temp = this.fEqualRules.get(arg);
            if (temp != null) {
                this.fResult.append(temp);
                return temp;
            }
            if (this.fMatchers != null) {
                for (int i = 0; i < this.fMatchers.size(); ++i) {
                    PatternMatcherList matcher = this.fMatchers.get(i);
                    if (matcher == null) continue;
                    matcher.replace(arg, this.fEngine, false);
                    IASTAppendable list = matcher.getReplaceList();
                    if (list.size() <= 1) continue;
                    for (int j = 1; j < list.size(); ++j) {
                        this.fResult.append(list.get(j));
                    }
                    return list;
                }
            }
            return F.NIL;
        }
    }

    private static class RulesPatternFunctor
    implements Function<IExpr, IExpr> {
        private final Map<IExpr, IExpr> fEqualRules;
        private final List<PatternMatcherAndEvaluator> fMatchers;
        private final EvalEngine fEngine;

        public RulesPatternFunctor(Map<IExpr, IExpr> equalRules, List<PatternMatcherAndEvaluator> matchers, EvalEngine engine) {
            this.fEqualRules = equalRules;
            this.fMatchers = matchers;
            this.fEngine = engine;
        }

        @Override
        public IExpr apply(IExpr arg) {
            IExpr temp = this.fEqualRules.get(arg);
            if (temp != null) {
                return temp;
            }
            for (int i = 0; i < this.fMatchers.size(); ++i) {
                temp = this.fMatchers.get(i).replace(arg, this.fEngine, false);
                if (!temp.isPresent()) continue;
                return temp;
            }
            return F.NIL;
        }
    }

    private static class RulesFunctor
    implements Function<IExpr, IExpr> {
        private final Map<? extends IExpr, ? extends IExpr> fEqualRules;

        public RulesFunctor(Map<? extends IExpr, ? extends IExpr> rulesMap) {
            this.fEqualRules = rulesMap;
        }

        @Override
        public IExpr apply(IExpr arg) {
            IExpr temp = this.fEqualRules.get(arg);
            return temp != null ? temp : F.NIL;
        }
    }

    private static class SingleRuleFunctor
    implements Function<IExpr, IExpr> {
        private final IExpr lhs;
        private final IExpr rhs;

        public SingleRuleFunctor(IAST equalRule) {
            this.lhs = equalRule.arg1();
            this.rhs = equalRule.arg2();
        }

        @Override
        public IExpr apply(IExpr arg) {
            return this.lhs.equals(arg) ? this.rhs : F.NIL;
        }
    }
}

