/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import java.util.Comparator;
import java.util.function.BiPredicate;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IExpr;

public final class Comparators {
    public static final ExprComparator CANONICAL_COMPARATOR = new ExprComparator();
    public static final ExprReverseComparator REVERSE_CANONICAL_COMPARATOR = new ExprReverseComparator();

    private Comparators() {
    }

    public static Comparator<IExpr> binaryPredicateComparator(IExpr test) {
        return new BinaryEqualsComparator(test);
    }

    static final class BinaryEqualsComparator
    implements Comparator<IExpr> {
        BiPredicate<IExpr, IExpr> predicate;

        public BinaryEqualsComparator(IExpr test) {
            this.predicate = Predicates.isBinaryTrue(test);
        }

        @Override
        public int compare(IExpr e1, IExpr e2) {
            if (this.predicate.test(e1, e2)) {
                return 0;
            }
            return e1.compareTo(e2);
        }
    }

    static final class ExprReverseComparator
    implements Comparator<IExpr> {
        ExprReverseComparator() {
        }

        @Override
        public int compare(IExpr o1, IExpr o2) {
            return o2.compareTo(o1);
        }
    }

    static final class ExprComparator
    implements Comparator<IExpr> {
        ExprComparator() {
        }

        @Override
        public final int compare(IExpr o1, IExpr o2) {
            return o1.compareTo(o2);
        }
    }
}

