/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import java.util.function.BiFunction;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.DoubleStackEvaluator;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;

public class BinaryNumerical
implements BiFunction<IExpr, IExpr, IExpr> {
    final IExpr fun;
    final ISymbol variable1;
    final ISymbol variable2;
    final EvalEngine fEngine;

    public BinaryNumerical(IExpr fn, ISymbol v1, ISymbol v2, EvalEngine engine) {
        if (!v1.isVariable() || v1.isBuiltInSymbol()) {
            throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list(v1), EvalEngine.get()));
        }
        if (!v2.isVariable() || v2.isBuiltInSymbol()) {
            throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list(v2), EvalEngine.get()));
        }
        this.variable1 = v1;
        this.variable2 = v2;
        this.fun = fn;
        this.fEngine = engine;
    }

    @Override
    public IExpr apply(IExpr firstArg, IExpr secondArg) {
        return this.fEngine.evalN(F.subst(this.fun, F.list(F.Rule((IExpr)this.variable1, firstArg), F.Rule((IExpr)this.variable2, secondArg))));
    }

    public double value(double x, double y) {
        double result = 0.0;
        try {
            INum xValue = F.num(x);
            INum yValue = F.num(y);
            IExpr temp = F.subst(this.fun, arg -> {
                if (arg.equals(this.variable1)) {
                    return xValue;
                }
                return arg.equals(this.variable2) ? yValue : arg;
            });
            double[] stack = new double[10];
            result = DoubleStackEvaluator.eval(stack, 0, temp);
        }
        catch (RuntimeException rex) {
            return Double.NaN;
        }
        return result;
    }

    public ComplexNum value(ComplexNum z1, ComplexNum z2) {
        IExpr temp = this.apply(z1, z2);
        if (temp instanceof ComplexNum) {
            return (ComplexNum)temp;
        }
        if (temp instanceof Num) {
            return ComplexNum.valueOf(((Num)temp).getRealPart());
        }
        throw new ArithmeticException("Numerical complex value expected");
    }
}

