/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.frobenius;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.frobenius.OutputPortUnsafe;
import org.matheclipse.core.frobenius.SolutionProvider;
import org.matheclipse.core.interfaces.IInteger;

final class TotalSolutionProvider
implements OutputPortUnsafe<IInteger[]> {
    private final SolutionProvider[] providers;
    private boolean inited = false;

    public TotalSolutionProvider(SolutionProvider[] providers) {
        this.providers = providers;
    }

    @Override
    public IInteger[] take() {
        if (!this.inited) {
            for (SolutionProvider provider : this.providers) {
                provider.tick();
            }
            this.inited = true;
        }
        int iterationLimit = EvalEngine.get().getIterationLimit() * 100;
        int counter = 0;
        int i = this.providers.length - 1;
        IInteger[] solution = (IInteger[])this.providers[i].take();
        if (solution != null) {
            return solution;
        }
        block1: while (true) {
            boolean r;
            if (counter++ > iterationLimit && iterationLimit > 0) {
                IterationLimitExceeded.throwIt(counter, S.FrobeniusSolve);
            }
            while ((r = !this.providers[i--].tick()) && i >= 0) {
            }
            if (i == -1 && r) {
                return null;
            }
            i += 2;
            while (i < this.providers.length) {
                if (!this.providers[i].tick()) {
                    --i;
                    continue block1;
                }
                ++i;
            }
            assert (i == this.providers.length);
            if ((solution = (IInteger[])this.providers[--i].take()) != null) break;
        }
        return solution;
    }
}

