/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.frobenius;

import org.matheclipse.core.expression.F;
import org.matheclipse.core.frobenius.SolutionProvider;
import org.matheclipse.core.interfaces.IInteger;

abstract class SolutionProviderAbstract
implements SolutionProvider {
    private final SolutionProvider provider;
    final int position;
    final IInteger[] coefficients;
    IInteger[] currentSolution;
    IInteger currentCounter;
    IInteger[] currentRemainder;

    SolutionProviderAbstract(SolutionProvider provider, int position, IInteger[] coefficients) {
        this.provider = provider;
        this.position = position;
        this.coefficients = coefficients;
        this.currentCounter = F.C0;
    }

    @Override
    public boolean tick() {
        this.currentSolution = (IInteger[])this.provider.take();
        this.currentRemainder = this.provider.currentRemainders();
        this.currentCounter = F.C0;
        return this.currentSolution != null;
    }

    @Override
    public IInteger[] currentRemainders() {
        IInteger[] remainders = new IInteger[this.coefficients.length];
        IInteger factor = this.currentCounter.subtract(F.C1);
        for (int i = 0; i < this.coefficients.length; ++i) {
            remainders[i] = this.currentRemainder[i].subtract(this.coefficients[i].multiply(factor));
        }
        return remainders;
    }
}

