/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.frobenius;

import org.matheclipse.core.expression.F;
import org.matheclipse.core.frobenius.DummySolutionProvider;
import org.matheclipse.core.frobenius.FinalSolutionProvider;
import org.matheclipse.core.frobenius.OutputPortUnsafe;
import org.matheclipse.core.frobenius.SingleSolutionProvider;
import org.matheclipse.core.frobenius.SolutionProvider;
import org.matheclipse.core.frobenius.TotalSolutionProvider;
import org.matheclipse.core.interfaces.IInteger;

public final class FrobeniusSolver
implements OutputPortUnsafe<IInteger[]> {
    private final OutputPortUnsafe<IInteger[]> provider;

    public FrobeniusSolver(IInteger[] ... equations) {
        int j;
        int i;
        if (equations.length == 0) {
            throw new IllegalArgumentException();
        }
        int length = equations[0].length;
        if (length < 2) {
            throw new IllegalArgumentException();
        }
        for (i = 1; i < equations.length; ++i) {
            if (equations[i].length == length || this.assertEq(equations[i])) continue;
            throw new IllegalArgumentException();
        }
        IInteger[] initialSolution = new IInteger[length - 1];
        int zeroCoefficientsCount = 0;
        block1: for (i = 0; i < length - 1; ++i) {
            initialSolution[i] = F.C0;
            for (j = 0; j < equations.length; ++j) {
                if (!equations[j][i].isZero()) continue block1;
            }
            initialSolution[i] = F.CN1;
            ++zeroCoefficientsCount;
        }
        IInteger[] initialRemainders = new IInteger[equations.length];
        for (j = 0; j < equations.length; ++j) {
            initialRemainders[j] = equations[j][length - 1];
        }
        DummySolutionProvider dummy = new DummySolutionProvider(initialSolution, initialRemainders);
        int providersCount = length - 1 - zeroCoefficientsCount;
        SolutionProvider[] providers = new SolutionProvider[providersCount];
        int count = 0;
        for (i = 0; i < length - 1; ++i) {
            if (initialSolution[i].isMinusOne()) continue;
            IInteger[] coefficients = new IInteger[equations.length];
            for (j = 0; j < equations.length; ++j) {
                coefficients[j] = equations[j][i];
            }
            providers[count] = count == 0 ? (providersCount == 1 ? new FinalSolutionProvider(dummy, i, coefficients) : new SingleSolutionProvider(dummy, i, coefficients)) : (count == providersCount - 1 ? new FinalSolutionProvider(providers[count - 1], i, coefficients) : new SingleSolutionProvider(providers[count - 1], i, coefficients));
            ++count;
        }
        this.provider = new TotalSolutionProvider(providers);
    }

    @Override
    public IInteger[] take() {
        return this.provider.take();
    }

    private boolean assertEq(IInteger[] equation) {
        for (IInteger i : equation) {
            if (i.compareInt(0) != 0) continue;
            return false;
        }
        return true;
    }
}

