/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.frobenius;

import org.matheclipse.core.frobenius.SolutionProvider;
import org.matheclipse.core.frobenius.SolutionProviderAbstract;
import org.matheclipse.core.interfaces.IInteger;

final class FinalSolutionProvider
extends SolutionProviderAbstract {
    public FinalSolutionProvider(SolutionProvider provider, int position, IInteger[] coefficient) {
        super(provider, position, coefficient);
    }

    @Override
    public IInteger[] take() {
        if (this.currentSolution == null) {
            return null;
        }
        int i = 0;
        while (i < this.coefficients.length && this.coefficients[i++].isZero()) {
        }
        assert (--i == 0 || i != this.coefficients.length);
        if (!this.currentRemainder[i].mod(this.coefficients[i]).isZero()) {
            this.currentSolution = null;
            return null;
        }
        this.currentCounter = this.currentRemainder[i].div(this.coefficients[i]);
        for (i = 0; i < this.coefficients.length; ++i) {
            if (this.coefficients[i].isZero()) {
                if (this.currentRemainder[i].isZero()) continue;
                this.currentSolution = null;
                return null;
            }
            if (this.currentRemainder[i].mod(this.coefficients[i]).isZero() && this.currentRemainder[i].div(this.coefficients[i]).equals(this.currentCounter)) continue;
            this.currentSolution = null;
            return null;
        }
        IInteger[] solution = (IInteger[])this.currentSolution.clone();
        solution[this.position] = solution[this.position].add(this.currentCounter);
        this.currentSolution = null;
        return solution;
    }
}

