/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.tex;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.AbortException;
import org.matheclipse.core.eval.util.Lambda;
import org.matheclipse.core.expression.BuiltInDummy;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.operator.Operator;
import org.matheclipse.parser.trie.TrieBuilder;
import org.matheclipse.parser.trie.TrieMatch;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleSession;

public class TeXParser {
    private static final Logger LOGGER = LogManager.getLogger();
    static final boolean SHOW_UNICODE = false;
    static final PrefixOperator[] PREFIX_OPERATORS = new PrefixOperator[]{new PrefixOperator("+", "Plus", 670, x -> x), new PrefixOperator("-", "Minus", 485, x -> F.Negate(x)), new PrefixOperator("\u00ac", "Not", 230, x -> F.Not(x))};
    static final PostfixOperator[] POSTFIX_OPERATORS = new PostfixOperator[]{new PostfixOperator("!", "Factorial", 610, x -> F.Factorial(x))};
    static final BinaryOperator[] BINARY_OPERATORS = new BinaryOperator[]{new BinaryOperator("=", "Equal", 290, (lhs, rhs) -> F.Equal(lhs, rhs)), new BinaryOperator("\u2264", "LessEqual", 290, (lhs, rhs) -> F.LessEqual(lhs, rhs)), new BinaryOperator("\u2265", "GreaterEqual", 290, (lhs, rhs) -> F.GreaterEqual(lhs, rhs)), new BinaryOperator("<", "Less", 290, (lhs, rhs) -> F.Less(lhs, rhs)), new BinaryOperator(">", "Greater", 290, (lhs, rhs) -> F.Greater(lhs, rhs)), new BinaryOperator("\u2227", "And", 215, (lhs, rhs) -> F.And(lhs, rhs)), new BinaryOperator("\u2228", "Or", 213, (lhs, rhs) -> F.Or(lhs, rhs)), new BinaryOperator("\u21d2", "Implies", 120, (lhs, rhs) -> F.Implies(lhs, rhs)), new BinaryOperator("\u2192", "Rule", 120, (lhs, rhs) -> F.Rule(lhs, rhs)), new BinaryOperator("\u21d4", "Equivalent", 120, (lhs, rhs) -> F.Equivalent(lhs, rhs)), new BinaryOperator("\u2261", "Equivalent", 120, (lhs, rhs) -> F.Equivalent(lhs, rhs)), new BinaryOperator("+", "Plus", 310, (lhs, rhs) -> F.Plus(lhs, rhs)), new BinaryOperator("-", "Subtract", 310, (lhs, rhs) -> F.Subtract(lhs, rhs)), new BinaryOperator("*", "Times", 400, (lhs, rhs) -> F.Times(lhs, rhs)), new BinaryOperator("\u00d7", "Times", 400, (lhs, rhs) -> F.Times(lhs, rhs)), new BinaryOperator("\u2062", "Times", 400, (lhs, rhs) -> F.Times(lhs, rhs)), new BinaryOperator("/", "Divide", 470, (lhs, rhs) -> F.Divide(lhs, rhs)), new BinaryOperator("\u00f7", "Divide", 470, (lhs, rhs) -> F.Divide(lhs, rhs)), new BinaryOperator("\u2208", "Element", 250, (lhs, rhs) -> F.Element(lhs, rhs))};
    private static Map<String, IExpr> UNICODE_OPERATOR_MAP;
    private static Map<String, IExpr> FUNCTION_HEADER_MAP;
    private static Map<String, BinaryOperator> BINARY_OPERATOR_MAP;
    private static Map<String, PrefixOperator> PREFIX_OPERATOR_MAP;
    private static Map<String, PostfixOperator> POSTFIX_OPERATOR_MAP;
    int counter = 0;
    EvalEngine fEngine;

    public static void initialize() {
        Initializer.init();
    }

    private static String toUnicodeString(String unicodeInput, String inputEncoding) {
        StringBuilder unicodeStringBuilder = new StringBuilder();
        String unicodeString = null;
        try {
            String utf8String = new String(unicodeInput.getBytes(inputEncoding), "UTF-8");
            Object hexValueString = null;
            int hexValueLength = 0;
            for (int i = 0; i < utf8String.length(); ++i) {
                hexValueString = Integer.toHexString(utf8String.charAt(i));
                hexValueLength = ((String)hexValueString).length();
                if (hexValueLength < 4) {
                    for (int j = 0; j < 4 - hexValueLength; ++j) {
                        hexValueString = "0" + (String)hexValueString;
                    }
                }
                unicodeStringBuilder.append("\\u");
                unicodeStringBuilder.append((String)hexValueString);
            }
            unicodeString = unicodeStringBuilder.toString();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("TeXParser.toUnicodeString() failed", (Throwable)e);
        }
        return unicodeString;
    }

    public TeXParser(EvalEngine engine) {
        this.fEngine = engine;
    }

    private IExpr convert(NodeList list, int[] position, IExpr lhs, int precedence) {
        return this.convert(list, position, list.getLength(), lhs, precedence);
    }

    private IExpr convert(NodeList list, int[] position, int end, IExpr lhs, int precedence) {
        int listSize = list.getLength();
        if (end > 1) {
            if (lhs == null) {
                String text;
                PrefixOperator operator;
                int n = position[0];
                position[0] = n + 1;
                Node lhsNode = list.item(n);
                String name = lhsNode.getNodeName();
                if (name.equals("mo") && (operator = PREFIX_OPERATOR_MAP.get(text = lhsNode.getTextContent())) != null) {
                    int currPrec = operator.getPrecedence();
                    IExpr x = this.convert(list, position, end, null, currPrec);
                    lhs = operator.createFunction(x);
                }
                if (lhs == null) {
                    lhs = this.toHeadExpr(lhsNode, list, position, precedence);
                    if (position[0] >= listSize) {
                        return lhs;
                    }
                }
                int attribute = 0;
                if (lhs.isSymbol()) {
                    attribute = ((ISymbol)lhs).getAttributes();
                }
                if ((attribute & 2) != 2 && (lhs.isFunction() || lhs.isSymbol() || lhs.isDerivative() != null) && position[0] < listSize) {
                    boolean isNumericFunction = (attribute & 0x400) == 1024;
                    Node arg2 = list.item(position[0]);
                    if (arg2.getNodeName().equals("mfenced")) {
                        position[0] = position[0] + 1;
                        int[] position2 = new int[]{0};
                        NodeList childNodes = arg2.getChildNodes();
                        IExpr args = this.convertArgs(childNodes, position2);
                        if (args.isSequence()) {
                            ((IASTMutable)args).set(0, lhs);
                            return args;
                        }
                        lhs = F.unaryAST1(lhs, args);
                        if (position[0] == listSize) {
                            return lhs;
                        }
                    } else if (isNumericFunction || lhs.isBuiltInSymbol() && !(lhs instanceof BuiltInDummy) || lhs.isFunction()) {
                        if (lhs.equals(S.Integrate)) {
                            ISymbol test = F.Dummy("test");
                            return this.integrate(list, position, test, test);
                        }
                        IExpr args = this.convert(list, position, end, null, 0);
                        if (args.isSequence()) {
                            ((IASTMutable)args).set(0, lhs);
                            return args;
                        }
                        if (lhs.isFunction() && lhs.size() == 2) {
                            IExpr temp = Lambda.replaceSlots(lhs.first(), F.list(args));
                            if (temp.isPresent()) {
                                lhs = temp;
                            }
                        } else {
                            lhs = F.unaryAST1(lhs, args);
                        }
                        if (position[0] == listSize) {
                            return lhs;
                        }
                    }
                }
            }
            IExpr result = lhs;
            int currPrec = 0;
            while (position[0] < end) {
                Node op = list.item(position[0]);
                String name = op.getNodeName();
                if (name.equals("mo")) {
                    String text = op.getTextContent();
                    BinaryOperator binaryOperator = BINARY_OPERATOR_MAP.get(text);
                    if (binaryOperator != null) {
                        currPrec = binaryOperator.getPrecedence();
                        if (precedence >= currPrec) {
                            return result;
                        }
                        position[0] = position[0] + 1;
                        IExpr rhs = this.convert(list, position, end, null, currPrec);
                        result = binaryOperator.createFunction(result, rhs);
                        continue;
                    }
                    PostfixOperator postfixOperator = POSTFIX_OPERATOR_MAP.get(text);
                    if (postfixOperator != null) {
                        currPrec = postfixOperator.getPrecedence();
                        if (precedence >= currPrec) {
                            return result;
                        }
                        result = postfixOperator.createFunction(lhs);
                        position[0] = position[0] + 1;
                        continue;
                    }
                    throw new AbortException();
                }
                if (name.equals("mspace")) {
                    position[0] = position[0] + 1;
                    continue;
                }
                currPrec = 400;
                IExpr rhs = this.convert(list, position, end, null, currPrec);
                result = F.Times(lhs, rhs);
            }
            if (result.isPresent() && position[0] >= end) {
                return result;
            }
        }
        return this.convertArgs(list, position);
    }

    public IExpr convertArgs(NodeList list, int[] position) {
        IASTAppendable ast = F.Sequence();
        for (int i = 0; i < list.getLength(); ++i) {
            Node temp = list.item(i);
            IExpr ex = this.toExpr(temp);
            ast.append(ex);
        }
        if (ast.size() == 2) {
            return ast.arg1();
        }
        if (ast.size() > 1 && ast.arg1().isBuiltInSymbol()) {
            return F.unaryAST1(ast.arg1(), ast.arg2());
        }
        return ast;
    }

    private ISymbol identifier(NodeList list, int[] position) {
        Node temp;
        StringBuilder buf = new StringBuilder();
        boolean evaled = false;
        while (position[0] < list.getLength() && (temp = list.item(position[0])).getNodeName().equals("mi")) {
            position[0] = position[0] + 1;
            buf.append(temp.getTextContent());
            evaled = true;
        }
        if (evaled) {
            return F.$s(buf.toString());
        }
        throw new AbortException();
    }

    private IExpr integrate(NodeList parentList, int[] position, ISymbol dummySymbol, IExpr symbolOrList) {
        ISymbol x = null;
        IExpr dxValue = F.C1;
        int dxStart = -1;
        int dxEnd = -1;
        int[] dxPosition1 = new int[]{position[0]};
        while (dxPosition1[0] < parentList.getLength()) {
            ISymbol d;
            String dStr;
            IExpr frac;
            int n = dxPosition1[0];
            dxPosition1[0] = n + 1;
            Node nd = parentList.item(n);
            if (nd.getNodeName().equals("mi") && nd.getTextContent().equals("d")) {
                if (dxPosition1[0] >= parentList.getLength() || !(nd = parentList.item(dxPosition1[0])).getNodeName().equals("mi")) continue;
                dxStart = dxPosition1[0];
                ISymbol x1 = this.identifier(parentList, dxPosition1);
                dxEnd = dxPosition1[0];
                x = x1;
                break;
            }
            if (!nd.getNodeName().equals("mfrac") || !(frac = this.mfrac(nd.getChildNodes())).isTimes() || !frac.first().isSymbol() || !(dStr = (d = (ISymbol)frac.first()).getSymbolName()).startsWith("d")) continue;
            dxStart = dxPosition1[0];
            dxEnd = dxPosition1[0];
            x = F.$s(dStr.substring(1));
            dxValue = frac.second();
            break;
        }
        if (x == null) {
            throw new AbortException();
        }
        if (--dxStart > position[0]) {
            IExpr arg1 = this.convert(parentList, position, dxStart, null, 0);
            position[0] = dxEnd;
            arg1 = F.subs(arg1, dummySymbol, x);
            symbolOrList = F.subs(symbolOrList, dummySymbol, x);
            return F.binaryAST2((IExpr)S.Integrate, arg1, symbolOrList);
        }
        if (dxStart == position[0]) {
            position[0] = dxEnd;
            symbolOrList = F.subs(symbolOrList, dummySymbol, x);
            return F.binaryAST2((IExpr)S.Integrate, dxValue, symbolOrList);
        }
        throw new AbortException();
    }

    private IExpr mfrac(NodeList list) {
        String str;
        IExpr dDenominator;
        ISymbol d;
        IASTAppendable frac = F.TimesAlloc(2);
        if (list.getLength() > 0) {
            Node temp = list.item(0);
            frac.append(this.toExpr(temp));
            if (1 < list.getLength()) {
                temp = list.item(1);
                frac.append(F.Power(this.toExpr(temp), -1L));
            } else {
                throw new AbortException();
            }
        }
        if (frac.isTimes() && frac.first().isSymbol() && frac.size() == 3 && frac.second().isPowerReciprocal() && (d = (ISymbol)frac.first()).getSymbolName().equals("d") && (dDenominator = frac.second().first()).isSymbol() && (str = ((ISymbol)dDenominator).getSymbolName()).startsWith("d")) {
            str = str.substring(1);
            return F.Function(F.D(F.Slot1, F.$s(str)));
        }
        return frac;
    }

    private IExpr mi(Node node) {
        IExpr x;
        String text = node.getTextContent();
        if (text.length() == 1) {
            Node value;
            if (node.hasAttributes() && (value = node.getAttributes().getNamedItem("mathvariant")) != null && value.getTextContent().equals("double-struck")) {
                if (text.equals("B")) {
                    return S.Booleans;
                }
                if (text.equals("C")) {
                    return S.Complexes;
                }
                if (text.equals("P")) {
                    return S.Primes;
                }
                if (text.equals("Q")) {
                    return S.Rationals;
                }
                if (text.equals("Z")) {
                    return S.Integers;
                }
                if (text.equals("R")) {
                    return S.Reals;
                }
            }
            if ((x = UNICODE_OPERATOR_MAP.get(text)) != null) {
                return x;
            }
        }
        if ((x = FUNCTION_HEADER_MAP.get(text)) != null) {
            return x;
        }
        return F.$s(text);
    }

    private IExpr mn(Node node) {
        try {
            String text = node.getTextContent();
            if (text.contains(".") || text.contains("E")) {
                return F.num(text);
            }
            return F.integer(text, 10);
        }
        catch (RuntimeException rex) {
            LOGGER.debug("TeXParser.mn() failed", (Throwable)rex);
            throw new AbortException();
        }
    }

    private IExpr mo(Node node) {
        IExpr x;
        String text = node.getTextContent();
        if (text.length() == 1 && (x = UNICODE_OPERATOR_MAP.get(text)) != null) {
            return x;
        }
        return F.$s(text);
    }

    private IExpr mrow(Node node) {
        NodeList list = node.getChildNodes();
        boolean isSymbol = true;
        for (int i = 0; i < list.getLength(); ++i) {
            Node temp = list.item(i);
            String n = temp.getNodeName();
            if (n.equals("mi") && temp instanceof Element) continue;
            isSymbol = false;
            break;
        }
        if (isSymbol) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < list.getLength(); ++i) {
                Node temp = list.item(i);
                buf.append(temp.getTextContent());
            }
            return F.$s(buf.toString());
        }
        int[] position = new int[]{0};
        return this.convert(list, position, null, 0);
    }

    private IExpr msqrt(NodeList list) {
        if (list.getLength() > 0) {
            Node temp = list.item(0);
            return F.Power(this.toExpr(temp), F.C1D2);
        }
        return F.NIL;
    }

    private IExpr msubsup(NodeList list, NodeList parentList, int[] position, int precedence) {
        Node arg0;
        IExpr head;
        if (list.getLength() > 0 && (head = this.toExpr(arg0 = list.item(0))).isBuiltInSymbol()) {
            Object arg1;
            ISymbol dummySymbol;
            IExpr arg2 = dummySymbol = F.Dummy("msubsup$" + this.counter++);
            if (list.getLength() >= 2) {
                arg1 = list.item(1);
                IExpr a1 = this.toExpr((Node)arg1);
                if (list.getLength() == 3) {
                    IExpr a2 = this.toExpr(list.item(2));
                    arg2 = F.list(dummySymbol, a1, a2);
                } else if (list.getLength() == 2) {
                    arg2 = F.list(dummySymbol, a1);
                }
            }
            if (parentList != null && position[0] < parentList.getLength()) {
                if (head.equals(S.Integrate)) {
                    return this.integrate(parentList, position, dummySymbol, arg2);
                }
                arg1 = this.convert(parentList, position, null, Integer.MAX_VALUE);
                return F.binaryAST2(head, (IExpr)arg1, arg2);
            }
        }
        if (list.getLength() == 3) {
            Node node = list.item(0);
            IExpr a1 = this.toExpr(node);
            node = list.item(1);
            IExpr a2 = this.toExpr(node);
            node = list.item(2);
            IExpr a3 = this.toExpr(node);
            return F.ternaryAST3(S.Subsuperscript, a1, a2, a3);
        }
        throw new AbortException();
    }

    private IExpr msub(NodeList list) {
        if (list.getLength() == 2) {
            Node arg1 = list.item(0);
            Node arg2 = list.item(1);
            IExpr a1 = this.toExpr(arg1);
            IExpr a2 = this.toExpr(arg2);
            if (a1.equals(S.Limit)) {
                return F.Function(F.Limit(F.Slot1, a2));
            }
            return F.binaryAST2((IExpr)S.Subscript, a1, a2);
        }
        throw new AbortException();
    }

    private IExpr msup(NodeList list) {
        if (list.getLength() == 2) {
            Node arg1 = list.item(0);
            Node arg2 = list.item(1);
            return this.power(arg1, arg2);
        }
        throw new AbortException();
    }

    private IExpr munderover(NodeList list, NodeList parentList, int[] position, int precedence) {
        Node arg0;
        IExpr head;
        if (list.getLength() > 0 && (head = this.toExpr(arg0 = list.item(0))).isBuiltInSymbol()) {
            Object arg1;
            ISymbol sym;
            IExpr arg2 = sym = F.Dummy("munderover$" + this.counter++);
            if (list.getLength() >= 2) {
                arg1 = list.item(1);
                IExpr a1 = this.toExpr((Node)arg1);
                if (a1.isEqual() && a1.first().isSymbol()) {
                    arg2 = sym = (ISymbol)a1.first();
                    a1 = a1.second();
                }
                if (list.getLength() == 3) {
                    IExpr a2 = this.toExpr(list.item(2));
                    arg2 = F.list(sym, a1, a2);
                } else if (list.getLength() == 2) {
                    arg2 = F.list(sym, a1);
                }
            }
            if (parentList != null && position[0] < parentList.getLength()) {
                arg1 = this.convert(parentList, position, null, Integer.MAX_VALUE);
                return F.binaryAST2(head, (IExpr)arg1, arg2);
            }
        }
        throw new AbortException();
    }

    public IExpr power(Node arg1, Node arg2) {
        IExpr a1 = this.toExpr(arg1);
        String name2 = arg2.getNodeName();
        String text2 = arg2.getTextContent();
        if (name2.equals("mi") && text2.equals("'")) {
            return F.unaryAST1(F.Derivative(F.C1), a1);
        }
        IExpr a2 = this.toExpr(arg2);
        if (a1.isBuiltInSymbol() && a2.isMinusOne()) {
            IExpr value = F.getUnaryInverseFunction(a1);
            if (value != null) {
                return value;
            }
        } else if (a2.equals(S.Degree)) {
            return F.Times(a1, a2);
        }
        return F.Power(a1, a2);
    }

    private IExpr toExpr(Node node) {
        int[] position = new int[]{0};
        String name = node.getNodeName();
        if (name.equals("mi")) {
            return this.mi(node);
        }
        if (name.equals("mo")) {
            return this.mo(node);
        }
        if (name.equals("mn")) {
            return this.mn(node);
        }
        if (name.equals("math")) {
            return this.convert(node.getChildNodes(), position, null, 0);
        }
        if (name.equals("mfrac")) {
            return this.mfrac(node.getChildNodes());
        }
        if (name.equals("msqrt")) {
            return this.msqrt(node.getChildNodes());
        }
        if (name.equals("msub")) {
            return this.msub(node.getChildNodes());
        }
        if (name.equals("msup")) {
            return this.msup(node.getChildNodes());
        }
        if (name.equals("msubsup")) {
            return this.msubsup(node.getChildNodes(), null, position, 0);
        }
        if (name.equals("munderover")) {
            return this.munderover(node.getChildNodes(), null, position, 0);
        }
        if (name.equals("mrow")) {
            return this.mrow(node);
        }
        if (name.equals("mfenced")) {
            return this.convertArgs(node.getChildNodes(), position);
        }
        NodeList list = node.getChildNodes();
        return this.convert(list, position, null, 0);
    }

    public IExpr toExpression(String texStr) {
        SnuggleEngine engine = new SnuggleEngine();
        SnuggleSession session = engine.createSession();
        session.getConfiguration().setFailingFast(true);
        SnuggleInput input = new SnuggleInput("$$ " + texStr + " $$");
        try {
            if (session.parseInput(input)) {
                NodeList nodes = session.buildDOMSubtree();
                int[] position = new int[]{0};
                return this.convert(nodes, position, null, 0);
            }
            List errors = session.getErrors();
            for (int i = 0; i < errors.size(); ++i) {
                LOGGER.log(this.fEngine.getLogLevel(), errors.get(i));
            }
        }
        catch (Exception e) {
            LOGGER.debug("TeXParser.toExpression() failed", (Throwable)e);
        }
        return S.$Aborted;
    }

    private IExpr toHeadExpr(Node node, NodeList parentList, int[] position, int precedence) {
        String name = node.getNodeName();
        if (name.equals("mi")) {
            return this.mi(node);
        }
        if (name.equals("mo")) {
            return this.mo(node);
        }
        if (name.equals("mn")) {
            return this.mn(node);
        }
        if (name.equals("math")) {
            return this.convert(node.getChildNodes(), position, null, 0);
        }
        if (name.equals("mfrac")) {
            return this.mfrac(node.getChildNodes());
        }
        if (name.equals("msqrt")) {
            return this.msqrt(node.getChildNodes());
        }
        if (name.equals("msub")) {
            return this.msub(node.getChildNodes());
        }
        if (name.equals("msup")) {
            return this.msup(node.getChildNodes());
        }
        if (name.equals("msubsup")) {
            return this.msubsup(node.getChildNodes(), parentList, position, precedence);
        }
        if (name.equals("munderover")) {
            return this.munderover(node.getChildNodes(), parentList, position, precedence);
        }
        if (name.equals("mrow")) {
            return this.mrow(node);
        }
        if (name.equals("mfenced")) {
            return this.convertArgs(node.getChildNodes(), position);
        }
        NodeList list = node.getChildNodes();
        return this.convert(list, position, null, 0);
    }

    private static /* synthetic */ Object lambda$mo$28(String text) {
        return TeXParser.toUnicodeString(text, "UTF-8");
    }

    private static /* synthetic */ Object lambda$mo$27(String text) {
        return text;
    }

    private static /* synthetic */ Object lambda$mi$26(String text) {
        return TeXParser.toUnicodeString(text, "UTF-8");
    }

    private static /* synthetic */ Object lambda$mi$25(String text) {
        return text;
    }

    private static /* synthetic */ Object lambda$convert$24(String text) {
        return TeXParser.toUnicodeString(text, "UTF-8");
    }

    private static /* synthetic */ Object lambda$convert$23(String text) {
        return text;
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            UNICODE_OPERATOR_MAP = Config.TRIE_STRING2EXPR_BUILDER.withMatch(TrieMatch.EXACT).build();
            UNICODE_OPERATOR_MAP.put("\u2218", S.Degree);
            UNICODE_OPERATOR_MAP.put("\u00b0", S.Degree);
            UNICODE_OPERATOR_MAP.put("\u222b", S.Integrate);
            UNICODE_OPERATOR_MAP.put("\u2211", S.Sum);
            UNICODE_OPERATOR_MAP.put("\u220f", S.Product);
            UNICODE_OPERATOR_MAP.put("\u03c0", S.Pi);
            UNICODE_OPERATOR_MAP.put("\u221e", F.CInfinity);
            UNICODE_OPERATOR_MAP.put("\u2148", F.CI);
            UNICODE_OPERATOR_MAP.put("\u2149", F.CI);
            UNICODE_OPERATOR_MAP.put("\u2107", S.E);
            FUNCTION_HEADER_MAP = Config.TRIE_STRING2EXPR_BUILDER.withMatch(TrieMatch.EXACT).build();
            FUNCTION_HEADER_MAP.put("ln", S.Log);
            FUNCTION_HEADER_MAP.put("lim", S.Limit);
            TrieBuilder binaryBuilder = TrieBuilder.create();
            BINARY_OPERATOR_MAP = binaryBuilder.withMatch(TrieMatch.EXACT).build();
            for (int i = 0; i < BINARY_OPERATORS.length; ++i) {
                String headStr = BINARY_OPERATORS[i].getOperatorString();
                BINARY_OPERATOR_MAP.put(headStr, BINARY_OPERATORS[i]);
            }
            TrieBuilder prefixBuilder = TrieBuilder.create();
            PREFIX_OPERATOR_MAP = prefixBuilder.withMatch(TrieMatch.EXACT).build();
            for (int i = 0; i < PREFIX_OPERATORS.length; ++i) {
                String headStr = PREFIX_OPERATORS[i].getOperatorString();
                PREFIX_OPERATOR_MAP.put(headStr, PREFIX_OPERATORS[i]);
            }
            TrieBuilder postfixBuilder = TrieBuilder.create();
            POSTFIX_OPERATOR_MAP = postfixBuilder.withMatch(TrieMatch.EXACT).build();
            for (int i = 0; i < POSTFIX_OPERATORS.length; ++i) {
                String headStr = POSTFIX_OPERATORS[i].getOperatorString();
                POSTFIX_OPERATOR_MAP.put(headStr, POSTFIX_OPERATORS[i]);
            }
        }
    }

    static class PrefixOperator
    extends Operator {
        Function<IExpr, IExpr> function;

        public PrefixOperator(String oper, String functionName, int precedence, Function<IExpr, IExpr> function) {
            super(oper, functionName, precedence);
            this.function = function;
        }

        public IExpr createFunction(IExpr expr) {
            return this.function.apply(expr);
        }
    }

    static class PostfixOperator
    extends Operator {
        Function<IExpr, IExpr> function;

        public PostfixOperator(String oper, String functionName, int precedence, Function<IExpr, IExpr> function) {
            super(oper, functionName, precedence);
            this.function = function;
        }

        public IExpr createFunction(IExpr expr) {
            return this.function.apply(expr);
        }
    }

    static class BinaryOperator
    extends Operator {
        BiFunction<IExpr, IExpr, IExpr> binaryFunction;

        public BinaryOperator(String oper, String functionName, int precedence, BiFunction<IExpr, IExpr, IExpr> binaryFunction) {
            super(oper, functionName, precedence);
            this.binaryFunction = binaryFunction;
        }

        public IExpr createFunction(IExpr lhs, IExpr rhs) {
            return this.binaryFunction.apply(lhs, rhs);
        }
    }
}

