/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.tex;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Algebra;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.util.Iterator;
import org.matheclipse.core.expression.ASTRealMatrix;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntervalSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.ApfloatToMMA;
import org.matheclipse.core.form.DoubleToMMA;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IIterator;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.Characters;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.client.operator.ASTNodeFactory;
import org.matheclipse.parser.trie.TrieMatch;

public class TeXFormFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean NO_PLUS_CALL = false;
    public static final boolean PLUS_CALL = true;
    public static final Map<String, String> CONSTANT_SYMBOLS = ParserConfig.TRIE_STRING2STRING_BUILDER.withMatch(TrieMatch.EXACT).build();
    public static final Map<IExpr, String> CONSTANT_EXPRS = new HashMap<IExpr, String>(199);
    public static final Map<ISymbol, AbstractConverter> operTab = new HashMap<ISymbol, AbstractConverter>(199);
    public static final boolean USE_IDENTIFIERS = false;
    private int plusPrec;
    private boolean fUseSignificantFigures = false;
    private int fExponentFigures;
    private int fSignificantFigures;

    public TeXFormFactory() {
        this(-1, -1);
    }

    public TeXFormFactory(int exponentFigures, int significantFigures) {
        this.fExponentFigures = exponentFigures;
        this.fSignificantFigures = significantFigures;
        this.init();
    }

    public void convertApcomplex(StringBuilder buf, Apcomplex dc, int precedence, boolean caller) {
        if (310 < precedence) {
            if (caller) {
                buf.append(" + ");
                caller = false;
            }
            buf.append("\\left( ");
        }
        Apfloat realPart = dc.real();
        Apfloat imaginaryPart = dc.imag();
        boolean realZero = realPart.equals((Object)Apcomplex.ZERO);
        boolean imaginaryZero = imaginaryPart.equals((Object)Apcomplex.ZERO);
        if (realZero && imaginaryZero) {
            this.convertDoubleString(buf, "0.0", 310, false);
        } else if (!realZero) {
            buf.append(this.convertApfloatToFormattedString(realPart));
            if (!imaginaryZero) {
                buf.append(" + ");
                boolean isNegative = imaginaryPart.compareTo((Apfloat)Apcomplex.ZERO) < 0;
                this.convertDoubleString(buf, this.convertApfloatToFormattedString(imaginaryPart), 400, isNegative);
                buf.append("\\,");
                buf.append("i ");
            }
        } else {
            if (caller) {
                buf.append("+");
                caller = false;
            }
            boolean isNegative = imaginaryPart.compareTo((Apfloat)Apcomplex.ZERO) < 0;
            this.convertDoubleString(buf, this.convertApfloatToFormattedString(imaginaryPart), 400, isNegative);
            buf.append("\\,");
            buf.append("i ");
        }
        if (310 < precedence) {
            buf.append("\\right) ");
        }
    }

    private String convertApfloatToFormattedString(Apfloat value) {
        StringBuilder buf = new StringBuilder();
        int numericPrecision = (int)EvalEngine.get().getNumericPrecision();
        ApfloatToMMA.apfloatToTeX(buf, value, numericPrecision, numericPrecision, this.fUseSignificantFigures);
        return buf.toString();
    }

    public boolean convert(StringBuilder buf, IExpr o, int precedence) {
        try {
            this.convertInternal(buf, o, precedence);
            return buf.length() < Config.MAX_OUTPUT_SIZE;
        }
        catch (RuntimeException rex) {
            LOGGER.debug("TeXFormFactory.convert() failed", (Throwable)rex);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        return false;
    }

    private void convertInternal(StringBuilder buf, Object o, int precedence) {
        IExpr expr;
        String str;
        if (o instanceof IExpr && (str = CONSTANT_EXPRS.get(expr = (IExpr)o)) != null) {
            buf.append(str);
            return;
        }
        if (o instanceof IAST) {
            AbstractConverter converter;
            IAST f = (IAST)o;
            IExpr h = f.head();
            if (h.isSymbol() && (converter = operTab.get(h)) != null) {
                converter.setFactory(this);
                if (converter.convert(buf, f, precedence)) {
                    return;
                }
            }
            this.convertAST(buf, f, precedence);
            return;
        }
        if (o instanceof IInteger) {
            this.convertInteger(buf, (IInteger)o, precedence);
            return;
        }
        if (o instanceof IFraction) {
            this.convertFraction(buf, (IFraction)o, precedence);
            return;
        }
        if (o instanceof INum) {
            this.convertDouble(buf, (INum)o, precedence);
            return;
        }
        if (o instanceof IComplexNum) {
            if (o instanceof ApcomplexNum) {
                this.convertApcomplex(buf, ((ApcomplexNum)o).apcomplexValue(), precedence, false);
                return;
            }
            this.convertDoubleComplex(buf, (IComplexNum)o, precedence);
            return;
        }
        if (o instanceof IComplex) {
            this.convertComplex(buf, (IComplex)o, precedence);
            return;
        }
        if (o instanceof ISymbol) {
            this.convertSymbol(buf, (ISymbol)o);
            return;
        }
        this.convertString(buf, o.toString());
    }

    public void convertAST(StringBuilder buf, IAST list, int precedence) {
        int functionID;
        if (!list.isPresent()) {
            buf.append("NIL");
            return;
        }
        IExpr header = list.head();
        if (!header.isSymbol()) {
            IAST[] derivStruct = list.isDerivativeAST1();
            if (derivStruct != null) {
                IAST a1Head = derivStruct[0];
                IAST headAST = derivStruct[1];
                if (a1Head.isAST1() && headAST.isAST1() && (headAST.arg1().isSymbol() || headAST.arg1().isAST())) {
                    try {
                        IExpr symbolOrAST = headAST.arg1();
                        int n = a1Head.arg1().toIntDefault();
                        if (n == 1 || n == 2) {
                            this.convertInternal(buf, symbolOrAST, Integer.MAX_VALUE);
                            if (n == 1) {
                                buf.append("'");
                            } else if (n == 2) {
                                buf.append("''");
                            }
                            if (derivStruct[2] != null) {
                                this.convertArgs(buf, symbolOrAST, list);
                            }
                            return;
                        }
                        this.convertInternal(buf, symbolOrAST, Integer.MAX_VALUE);
                        buf.append("^{(");
                        this.convertInternal(buf, a1Head.arg1(), Integer.MIN_VALUE);
                        buf.append(")}");
                        if (derivStruct[2] != null) {
                            this.convertArgs(buf, symbolOrAST, list);
                        }
                        return;
                    }
                    catch (ArithmeticException symbolOrAST) {
                        // empty catch block
                    }
                }
            }
            this.convertInternal(buf, header, Integer.MIN_VALUE);
            this.convertFunctionArgs(buf, list);
            return;
        }
        if (header.isBuiltInSymbol() && (functionID = ((ISymbol)header).ordinal()) > -1) {
            switch (functionID) {
                case 644: {
                    if (list.size() <= 3 || !this.convertInequality(buf, list, precedence)) break;
                    return;
                }
                case 677: {
                    if (list.size() <= 1 || !list.first().isASTSizeGE(S.List, 2)) break;
                    IAST interval = IntervalSym.normalize(list);
                    buf.append("Interval(");
                    for (int i = 1; i < interval.size(); ++i) {
                        buf.append("\\{");
                        IAST subList = (IAST)interval.get(i);
                        IExpr min = subList.arg1();
                        IExpr max = subList.arg2();
                        if (min instanceof INum) {
                            this.convertDoubleString(buf, this.convertDoubleToFormattedString(min.evalDouble()), 0, false);
                        } else {
                            this.convertInternal(buf, min, 0);
                        }
                        buf.append(",");
                        if (max instanceof INum) {
                            this.convertDoubleString(buf, this.convertDoubleToFormattedString(max.evalDouble()), 0, false);
                        } else {
                            this.convertInternal(buf, max, 0);
                        }
                        buf.append("\\}");
                        if (i >= interval.size() - 1) continue;
                        buf.append(",");
                    }
                    buf.append(")");
                    return;
                }
                case 1207: {
                    if (!list.isSparseArray()) break;
                    buf.append("\\textnormal{");
                    buf.append(list.toString());
                    buf.append("}");
                    return;
                }
            }
        }
        if (list.isAssociation()) {
            this.convertAssociation(buf, (IAssociation)list, 0);
            return;
        }
        this.convertHead(buf, header);
        buf.append("(");
        for (int i = 1; i < list.size(); ++i) {
            this.convertInternal(buf, list.get(i), 0);
            if (i >= list.argSize()) continue;
            buf.append(',');
        }
        buf.append(")");
    }

    public void convertArgs(StringBuilder buf, IExpr head, IAST function) {
        int functionSize = function.size();
        if (head.isAST()) {
            buf.append("[");
        } else {
            buf.append("(");
        }
        if (functionSize > 1) {
            this.convertInternal(buf, function.arg1(), Integer.MIN_VALUE);
        }
        for (int i = 2; i < functionSize; ++i) {
            this.convertInternal(buf, function.get(i), 0);
            if (i >= function.argSize()) continue;
            buf.append(',');
        }
        if (head.isAST()) {
            buf.append("]");
        } else {
            buf.append(")");
        }
    }

    public void convertFunctionArgs(StringBuilder buf, IAST list) {
        buf.append("(");
        list.joinToString(buf, (b, x) -> this.convertInternal((StringBuilder)b, x, Integer.MIN_VALUE), ",");
        buf.append(")");
    }

    public boolean convertAssociation(StringBuilder buf, IAssociation assoc, int precedence) {
        IASTMutable ast = assoc.normal(false);
        buf.append("\\langle|");
        if (ast.size() > 1) {
            this.convertInternal(buf, ast.arg1(), 0);
            for (int i = 2; i < ast.size(); ++i) {
                buf.append(',');
                this.convertInternal(buf, ast.get(i), 0);
            }
        }
        buf.append("|\\rangle");
        return true;
    }

    private boolean convertInequality(StringBuilder buf, IAST inequality, int precedence) {
        StringBuilder tempBuffer = new StringBuilder();
        if (290 < precedence) {
            tempBuffer.append("(");
        }
        int listSize = inequality.size();
        int i = 1;
        while (i < listSize) {
            IExpr head;
            this.convertInternal(tempBuffer, inequality.get(i++), 0);
            if (i == listSize) {
                if (290 < precedence) {
                    tempBuffer.append(")");
                }
                buf.append((CharSequence)tempBuffer);
                return true;
            }
            if ((head = inequality.get(i++)).isBuiltInSymbol()) {
                int id = ((IBuiltInSymbol)head).ordinal();
                switch (id) {
                    case 423: {
                        tempBuffer.append(" == ");
                        break;
                    }
                    case 571: {
                        tempBuffer.append(" > ");
                        break;
                    }
                    case 572: {
                        tempBuffer.append("\\geq ");
                        break;
                    }
                    case 753: {
                        tempBuffer.append(" < ");
                        break;
                    }
                    case 754: {
                        tempBuffer.append("\\leq ");
                        break;
                    }
                    case 1381: {
                        tempBuffer.append("\\neq ");
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                continue;
            }
            return false;
        }
        if (290 < precedence) {
            tempBuffer.append(")");
        }
        buf.append((CharSequence)tempBuffer);
        return true;
    }

    public void convertAST(StringBuilder buf, IAST f, String headString) {
        if (!f.isPresent()) {
            buf.append("NIL");
            return;
        }
        buf.append(headString);
        buf.append("(");
        for (int i = 1; i < f.size(); ++i) {
            this.convertInternal(buf, f.get(i), 0);
            if (i >= f.argSize()) continue;
            buf.append(',');
        }
        buf.append(")");
    }

    public void convertComplex(StringBuilder buf, IComplex c, int precedence) {
        if (c.isImaginaryUnit()) {
            buf.append("i ");
            return;
        }
        if (c.isNegativeImaginaryUnit()) {
            if (precedence > this.plusPrec) {
                buf.append("\\left( ");
            }
            buf.append(" - i ");
            if (precedence > this.plusPrec) {
                buf.append("\\right) ");
            }
            return;
        }
        if (precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        IRational re = c.getRealPart();
        IRational im = c.getImaginaryPart();
        if (!re.isZero()) {
            this.convertInternal(buf, re, 0);
            if (im.compareInt(0) >= 0) {
                buf.append(" + ");
            } else {
                buf.append(" - ");
                im = im.negate();
            }
        }
        this.convertInternal(buf, im, 0);
        buf.append("\\,");
        buf.append("i ");
        if (precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    public void convertDouble(StringBuilder buf, INum d, int precedence) {
        if (d.isZero()) {
            buf.append(this.convertDoubleToFormattedString(0.0));
            return;
        }
        boolean isNegative = d.isNegative();
        if (d instanceof Num) {
            this.convertDoubleString(buf, this.convertDoubleToFormattedString(d.getRealPart()), precedence, isNegative);
        } else {
            this.convertDoubleString(buf, this.convertApfloatToFormattedString(((ApfloatNum)d).apfloatValue()), precedence, isNegative);
        }
    }

    public void convertDoubleComplex(StringBuilder buf, IComplexNum dc, int precedence) {
        double re = dc.getRealPart();
        double im = dc.getImaginaryPart();
        if (F.isZero(re)) {
            if (F.isNumIntValue(im, 1)) {
                buf.append("i ");
                return;
            }
            if (F.isNumIntValue(im, -1)) {
                if (precedence > this.plusPrec) {
                    buf.append("\\left( ");
                }
                buf.append(" - i ");
                if (precedence > this.plusPrec) {
                    buf.append("\\right) ");
                }
                return;
            }
        }
        if (precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        if (!F.isZero(re)) {
            buf.append(this.convertDoubleToFormattedString(re));
            if (im >= 0.0) {
                buf.append(" + ");
            } else {
                buf.append(" - ");
                im = -im;
            }
        }
        buf.append(this.convertDoubleToFormattedString(im));
        buf.append("\\,");
        buf.append("i ");
        if (precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    private void convertDoubleString(StringBuilder buf, String d, int precedence, boolean isNegative) {
        if (isNegative && 310 < precedence) {
            buf.append("\\left( ");
        }
        buf.append(d);
        if (isNegative && 310 < precedence) {
            buf.append("\\right) ");
        }
    }

    protected String convertDoubleToFormattedString(double dValue) {
        if (this.fSignificantFigures > 0) {
            try {
                StringBuilder buf = new StringBuilder();
                DoubleToMMA.doubleToMMA(buf, dValue, this.fExponentFigures, this.fSignificantFigures, true);
                return buf.toString();
            }
            catch (IOException ioex) {
                LOGGER.error("TeXFormFactory.convertDoubleToFormattedString() failed", (Throwable)ioex);
            }
        }
        return Double.toString(dValue);
    }

    public void convertFraction(StringBuilder buf, IFraction f, int precedence) {
        if (f.isNegative() && precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        if (f.denominator().isOne()) {
            buf.append(f.numerator().toString());
        } else {
            buf.append("\\frac{");
            buf.append(f.toBigNumerator().toString());
            buf.append("}{");
            buf.append(f.toBigDenominator().toString());
            buf.append('}');
        }
        if (f.isNegative() && precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    public void convertHead(StringBuilder buf, IExpr obj) {
        if (obj instanceof ISymbol) {
            String str = ((ISymbol)obj).getSymbolName();
            String ho = CONSTANT_SYMBOLS.get(((ISymbol)obj).getSymbolName());
            if (ho != null && ho.equals("true")) {
                buf.append('\\');
                buf.append(str);
                return;
            }
            this.convertHeader(buf, str);
            return;
        }
        this.convertInternal(buf, obj, 0);
    }

    private void convertHeader(StringBuilder buf, String str) {
        if (str.length() == 1) {
            buf.append(str);
        } else {
            buf.append("\\text{");
            String header = str;
            if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(header)) != null) {
                header = str;
            }
            buf.append(header);
            buf.append('}');
        }
    }

    public void convertInteger(StringBuilder buf, IInteger i, int precedence) {
        if (i.isNegative() && precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        buf.append(i.toBigNumerator().toString());
        if (i.isNegative() && precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    public void convertString(StringBuilder buf, String str) {
        buf.append("\\textnormal{");
        String text = str.replaceAll("\\&", "\\\\&");
        text = text.replaceAll("\\#", "\\\\#");
        text = text.replaceAll("\\%", "\\\\%");
        text = text.replace("$", "\\$");
        text = text.replaceAll("\\_", "\\\\_");
        text = text.replace("{", "\\{");
        text = text.replace("}", "\\}");
        text = text.replaceAll("\\<", "\\$<\\$");
        text = text.replaceAll("\\>", "\\$>\\$");
        buf.append(text);
        buf.append("}");
    }

    private void convertSubExpr(StringBuilder buf, IExpr o, int precedence) {
        if (o.isAST()) {
            buf.append("{");
        }
        this.convertInternal(buf, o, precedence);
        if (o.isAST()) {
            buf.append("}");
        }
    }

    public void convertSymbol(StringBuilder buf, ISymbol sym) {
        String convertedSymbol;
        String c;
        Context context = sym.getContext();
        if (context == Context.DUMMY) {
            buf.append(sym.getSymbolName());
            return;
        }
        String headStr = sym.getSymbolName();
        if (headStr.length() == 1 && (c = Characters.unicodeName((char)headStr.charAt(0))) != null && (convertedSymbol = CONSTANT_SYMBOLS.get(c)) != null) {
            this.convertConstantSymbol(buf, sym, convertedSymbol);
            return;
        }
        if (context.equals(Context.SYSTEM) || context.isGlobal()) {
            String convertedSymbol2;
            String str;
            if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && context.equals(Context.SYSTEM) && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(headStr)) != null) {
                headStr = str;
            }
            if ((convertedSymbol2 = CONSTANT_SYMBOLS.get(headStr)) == null) {
                buf.append(headStr);
            } else {
                this.convertConstantSymbol(buf, sym, convertedSymbol2);
            }
            return;
        }
        if (EvalEngine.get().getContextPath().contains(context)) {
            buf.append(sym.getSymbolName());
        } else {
            buf.append(context.toString() + sym.getSymbolName());
        }
    }

    private void convertConstantSymbol(StringBuilder buf, ISymbol sym, Object convertedSymbol) {
        if (convertedSymbol.equals("true")) {
            buf.append('\\');
            buf.append(sym.getSymbolName());
            return;
        }
        if (convertedSymbol instanceof Operator) {
            ((Operator)convertedSymbol).convert(buf);
            return;
        }
        buf.append(convertedSymbol.toString());
    }

    public void init() {
        this.plusPrec = ASTNodeFactory.RELAXED_STYLE_FACTORY.get("Plus").getPrecedence();
        operTab.put(S.Abs, new UnaryFunction("|", "|"));
        operTab.put(S.Binomial, new Binomial());
        operTab.put(S.Ceiling, new UnaryFunction(" \\left \\lceil ", " \\right \\rceil "));
        operTab.put(S.Conjugate, new Conjugate());
        operTab.put(S.Complex, new Complex());
        operTab.put(S.CompoundExpression, new AbstractOperator(ASTNodeFactory.MMA_STYLE_FACTORY.get("CompoundExpression").getPrecedence(), ", "));
        operTab.put(S.D, new D());
        operTab.put(S.Defer, new HoldForm());
        operTab.put(S.DirectedInfinity, new DirectedInfinity());
        operTab.put(S.Floor, new UnaryFunction(" \\left \\lfloor ", " \\right \\rfloor "));
        operTab.put(S.Function, new UnaryFunction("", "\\&"));
        operTab.put(S.HarmonicNumber, new HarmonicNumber());
        operTab.put(S.HoldForm, new HoldForm());
        operTab.put(S.HurwitzZeta, new Zeta());
        operTab.put(S.Integrate, new Integrate());
        operTab.put(S.Limit, new Limit());
        operTab.put(S.List, new List());
        operTab.put(S.MatrixForm, new MatrixForm());
        operTab.put(S.TableForm, new TableForm());
        operTab.put(S.Parenthesis, new Parenthesis());
        operTab.put(S.Part, new Part());
        operTab.put(S.Plus, new Plus());
        operTab.put(S.Power, new Power());
        operTab.put(S.Product, new Product());
        operTab.put(S.Rational, new Rational());
        operTab.put(S.Slot, new UnaryFunction("\\text{$\\#$", "}"));
        operTab.put(S.SlotSequence, new UnaryFunction("\\text{$\\#\\#$", "}"));
        operTab.put(S.Sqrt, new UnaryFunction("\\sqrt{", "}"));
        operTab.put(S.Style, new Style());
        operTab.put(S.Subscript, new Subscript());
        operTab.put(S.Subsuperscript, new Subsuperscript());
        operTab.put(S.Sum, new Sum());
        operTab.put(S.Superscript, new Superscript());
        operTab.put(S.Times, new Times());
        operTab.put(S.Zeta, new Zeta());
        operTab.put(S.Condition, new AbstractOperator(this, 130, "\\text{/;}"));
        operTab.put(S.Unset, new PostOperator(this, 670, "\\text{=.}"));
        operTab.put(S.UpSetDelayed, new AbstractOperator(this, 40, "\\text{^:=}"));
        operTab.put(S.UpSet, new AbstractOperator(this, 40, "\\text{^=}"));
        operTab.put(S.NonCommutativeMultiply, new AbstractOperator(this, 510, "\\text{**}"));
        operTab.put(S.PreDecrement, new PreOperator(this, 660, "\\text{--}"));
        operTab.put(S.ReplaceRepeated, new AbstractOperator(this, 110, "\\text{//.}"));
        operTab.put(S.MapAll, new AbstractOperator(this, 620, "\\text{//@}"));
        operTab.put(S.AddTo, new AbstractOperator(this, 100, "\\text{+=}"));
        operTab.put(S.Greater, new AbstractOperator(this, 290, " > "));
        operTab.put(S.GreaterEqual, new AbstractOperator(this, 290, "\\geq "));
        operTab.put(S.SubtractFrom, new AbstractOperator(this, 100, "\\text{-=}"));
        operTab.put(S.Subtract, new AbstractOperator(this, 310, " - "));
        operTab.put(S.CompoundExpression, new AbstractOperator(this, 10, ";"));
        operTab.put(S.DivideBy, new AbstractOperator(this, 100, "\\text{/=}"));
        operTab.put(S.StringJoin, new AbstractOperator(this, 600, "\\text{<>}"));
        operTab.put(S.UnsameQ, new AbstractOperator(this, 290, "\\text{=!=}"));
        operTab.put(S.Decrement, new PostOperator(this, 660, "\\text{--}"));
        operTab.put(S.LessEqual, new AbstractOperator(this, 290, "\\leq "));
        operTab.put(S.Colon, new AbstractOperator(this, 80, "\\text{:}"));
        operTab.put(S.Increment, new PostOperator(this, 660, "\\text{++}"));
        operTab.put(S.Alternatives, new AbstractOperator(this, 160, "\\text{|}"));
        operTab.put(S.Equal, new AbstractOperator(this, 290, " == "));
        operTab.put(S.DirectedEdge, new AbstractOperator(this, 120, "\\to "));
        operTab.put(S.Divide, new AbstractOperator(this, 470, "\\text{/}"));
        operTab.put(S.Apply, new AbstractOperator(this, 620, "\\text{@@}"));
        operTab.put(S.Set, new AbstractOperator(this, 40, " = "));
        operTab.put(S.Map, new AbstractOperator(this, 620, "\\text{/@}"));
        operTab.put(S.SameQ, new AbstractOperator(this, 290, "\\text{===}"));
        operTab.put(S.Less, new AbstractOperator(this, 290, " < "));
        operTab.put(S.PreIncrement, new PreOperator(this, 660, "\\text{++}"));
        operTab.put(S.Unequal, new AbstractOperator(this, 290, "\\neq "));
        operTab.put(S.Or, new AbstractOperator(this, 213, " \\lor "));
        operTab.put(S.TimesBy, new AbstractOperator(this, 100, "\\text{*=}"));
        operTab.put(S.And, new AbstractOperator(this, 215, " \\land "));
        operTab.put(S.Not, new PreOperator(this, 230, "\\neg "));
        operTab.put(S.Factorial, new PostOperator(this, 610, " ! "));
        operTab.put(S.Factorial2, new PostOperator(this, 610, " !! "));
        operTab.put(S.ReplaceAll, new AbstractOperator(this, 110, "\\text{/.}\\,"));
        operTab.put(S.ReplaceRepeated, new AbstractOperator(this, 110, "\\text{//.}\\,"));
        operTab.put(S.Rule, new AbstractOperator(this, 120, "\\to "));
        operTab.put(S.RuleDelayed, new AbstractOperator(this, 120, ":\\to "));
        operTab.put(S.Set, new AbstractOperator(this, 40, " = "));
        operTab.put(S.SetDelayed, new AbstractOperator(this, 40, "\\text{:=}\\,"));
        operTab.put(S.UndirectedEdge, new AbstractOperator(this, 120, "\\leftrightarrow "));
        operTab.put(S.TwoWayRule, new AbstractOperator(this, 125, "\\leftrightarrow "));
        operTab.put(S.CenterDot, new AbstractOperator(this, 410, "\\cdot "));
        operTab.put(S.CircleDot, new AbstractOperator(this, 520, "\\odot "));
        operTab.put(S.Sin, new TeXFunction(this, "sin "));
        operTab.put(S.Cos, new TeXFunction(this, "cos "));
        operTab.put(S.Tan, new TeXFunction(this, "tan "));
        operTab.put(S.Cot, new TeXFunction(this, "cot "));
        operTab.put(S.Sinh, new TeXFunction(this, "sinh "));
        operTab.put(S.Cosh, new TeXFunction(this, "cosh "));
        operTab.put(S.Tanh, new TeXFunction(this, "tanh "));
        operTab.put(S.Coth, new TeXFunction(this, "coth "));
        operTab.put(S.Csc, new TeXFunction(this, "csc "));
        operTab.put(S.Sec, new TeXFunction(this, "sec "));
        operTab.put(S.ArcSin, new TeXFunction(this, "arcsin "));
        operTab.put(S.ArcCos, new TeXFunction(this, "arccos "));
        operTab.put(S.ArcTan, new TeXFunction(this, "arctan "));
        operTab.put(S.ArcCot, new TeXFunction(this, "arccot "));
        operTab.put(S.ArcSinh, new TeXFunction(this, "arcsinh "));
        operTab.put(S.ArcCosh, new TeXFunction(this, "arccosh "));
        operTab.put(S.ArcTanh, new TeXFunction(this, "arctanh "));
        operTab.put(S.ArcCoth, new TeXFunction(this, "arccoth "));
        operTab.put(S.Log, new TeXFunction(this, "log "));
        CONSTANT_SYMBOLS.put("Alpha", "\\alpha");
        CONSTANT_SYMBOLS.put("Beta", "\\beta");
        CONSTANT_SYMBOLS.put("Chi", "\\chi");
        CONSTANT_SYMBOLS.put("Delta", "\\delta");
        CONSTANT_SYMBOLS.put("Epsilon", "\\epsilon");
        CONSTANT_SYMBOLS.put("Phi", "\\phi");
        CONSTANT_SYMBOLS.put("Gamma", "\\gamma");
        CONSTANT_SYMBOLS.put("Eta", "\\eta");
        CONSTANT_SYMBOLS.put("Iota", "\\iota");
        CONSTANT_SYMBOLS.put("Kappa", "\\kappa");
        CONSTANT_SYMBOLS.put("Lambda", "\\lambda");
        CONSTANT_SYMBOLS.put("Mu", "\\mu");
        CONSTANT_SYMBOLS.put("Nu", "\\nu");
        CONSTANT_SYMBOLS.put("Omicron", "\\omicron");
        CONSTANT_SYMBOLS.put("Theta", "\\theta");
        CONSTANT_SYMBOLS.put("Rho", "\\rho");
        CONSTANT_SYMBOLS.put("Sigma", "\\sigma");
        CONSTANT_SYMBOLS.put("Tau", "\\tau");
        CONSTANT_SYMBOLS.put("Upsilon", "\\upsilon");
        CONSTANT_SYMBOLS.put("Omega", "\\omega");
        CONSTANT_SYMBOLS.put("Xi", "\\xi");
        CONSTANT_SYMBOLS.put("Psi", "\\psi");
        CONSTANT_SYMBOLS.put("Zeta", "\\zeta");
        CONSTANT_SYMBOLS.put("alpha", "true");
        CONSTANT_SYMBOLS.put("beta", "true");
        CONSTANT_SYMBOLS.put("chi", "true");
        CONSTANT_SYMBOLS.put("delta", "true");
        CONSTANT_SYMBOLS.put("epsilon", "true");
        CONSTANT_SYMBOLS.put("phi", "true");
        CONSTANT_SYMBOLS.put("gamma", "true");
        CONSTANT_SYMBOLS.put("eta", "true");
        CONSTANT_SYMBOLS.put("iota", "true");
        CONSTANT_SYMBOLS.put("varphi", "true");
        CONSTANT_SYMBOLS.put("kappa", "true");
        CONSTANT_SYMBOLS.put("lambda", "true");
        CONSTANT_SYMBOLS.put("mu", "true");
        CONSTANT_SYMBOLS.put("nu", "true");
        CONSTANT_SYMBOLS.put("omicron", "true");
        CONSTANT_SYMBOLS.put("theta", "true");
        CONSTANT_SYMBOLS.put("rho", "true");
        CONSTANT_SYMBOLS.put("sigma", "true");
        CONSTANT_SYMBOLS.put("tau", "true");
        CONSTANT_SYMBOLS.put("upsilon", "true");
        CONSTANT_SYMBOLS.put("varomega", "true");
        CONSTANT_SYMBOLS.put("omega", "true");
        CONSTANT_SYMBOLS.put("xi", "true");
        CONSTANT_SYMBOLS.put("psi", "true");
        CONSTANT_SYMBOLS.put("zeta", "true");
        CONSTANT_EXPRS.put(S.Catalan, "C");
        CONSTANT_EXPRS.put(S.Degree, "{}^{\\circ}");
        CONSTANT_EXPRS.put(S.E, "e");
        CONSTANT_EXPRS.put(S.Glaisher, "A");
        CONSTANT_EXPRS.put(S.GoldenRatio, "\\phi");
        CONSTANT_EXPRS.put(S.EulerGamma, "\\gamma");
        CONSTANT_EXPRS.put(S.Khinchin, "K");
        CONSTANT_EXPRS.put(S.Pi, "\\pi");
        CONSTANT_EXPRS.put(F.CInfinity, "\\infty");
        CONSTANT_EXPRS.put(F.CNInfinity, "-\\infty");
    }

    private static final class Zeta
    extends AbstractConverter {
        private Zeta() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            this.fFactory.convertAST(buf, f, "zeta ");
            return true;
        }
    }

    private static final class UnaryFunction
    extends AbstractConverter {
        String pre;
        String post;

        public UnaryFunction(String pre, String post) {
            this.pre = pre;
            this.post = post;
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 2) {
                return false;
            }
            buf.append(this.pre);
            this.fFactory.convertInternal(buf, f.arg1(), 0);
            buf.append(this.post);
            return true;
        }
    }

    private static final class Times
    extends AbstractOperator {
        public static final int NO_SPECIAL_CALL = 0;
        public static final int PLUS_CALL = 1;

        public Times() {
            super(ASTNodeFactory.MMA_STYLE_FACTORY.get("Times").getPrecedence(), "\\,");
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            return this.convertTimesFraction(buf, f, precedence, 0);
        }

        public boolean convertTimesFraction(StringBuilder buf, IAST f, int precedence, int caller) {
            IExpr[] parts = Algebra.fractionalPartsTimesPower(f, false, true, false, false, false, false);
            if (parts == null) {
                this.convertTimesOperator(buf, f, precedence, caller);
                return true;
            }
            IExpr numerator = parts[0];
            IExpr denominator = parts[1];
            if (!denominator.isOne()) {
                if (caller == 1) {
                    buf.append('+');
                }
                this.precedenceOpen(buf, precedence);
                buf.append("\\frac{");
                if (numerator.isTimes()) {
                    this.convertTimesOperator(buf, (IAST)numerator, this.fPrecedence, 0);
                } else {
                    this.fFactory.convertInternal(buf, numerator, 0);
                }
                buf.append("}{");
                if (denominator.isTimes()) {
                    this.convertTimesOperator(buf, (IAST)denominator, this.fPrecedence, 0);
                } else {
                    this.fFactory.convertInternal(buf, denominator, 0);
                }
                buf.append('}');
                this.precedenceClose(buf, precedence);
            } else if (numerator.isTimes()) {
                this.convertTimesOperator(buf, (IAST)numerator, this.fPrecedence, 0);
            } else {
                this.fFactory.convertInternal(buf, numerator, precedence);
            }
            return true;
        }

        private boolean convertTimesOperator(StringBuilder buf, IAST timesAST, int precedence, int caller) {
            int i;
            int size = timesAST.size();
            IExpr arg1 = F.NIL;
            String timesOperator = "\\,";
            if (size > 1) {
                arg1 = timesAST.arg1();
                if (arg1.isMinusOne()) {
                    if (size == 2) {
                        this.precedenceOpen(buf, precedence);
                        this.fFactory.convertInternal(buf, arg1, this.fPrecedence);
                    } else if (caller == 1) {
                        buf.append(" - ");
                        if (size == 3) {
                            this.fFactory.convertInternal(buf, timesAST.arg2(), this.fPrecedence);
                            return true;
                        }
                    } else {
                        this.precedenceOpen(buf, precedence);
                        buf.append(" - ");
                    }
                } else if (arg1.isOne()) {
                    if (size == 2) {
                        this.precedenceOpen(buf, precedence);
                        this.fFactory.convertInternal(buf, arg1, this.fPrecedence);
                    } else if (caller == 1) {
                        if (size == 3) {
                            buf.append(" + ");
                            this.fFactory.convertInternal(buf, timesAST.arg2(), this.fPrecedence);
                            return true;
                        }
                    } else {
                        this.precedenceOpen(buf, precedence);
                    }
                } else {
                    if (caller == 1) {
                        if (arg1.isReal() && arg1.isNegative()) {
                            buf.append(" - ");
                            arg1 = ((ISignedNumber)arg1).opposite();
                        } else {
                            buf.append(" + ");
                        }
                    } else {
                        this.precedenceOpen(buf, precedence);
                    }
                    this.fFactory.convertInternal(buf, arg1, this.fPrecedence);
                    if (this.fOperator.compareTo("") != 0 && size > 2) {
                        if (this.isTeXNumberDigit(timesAST.arg1()) || this.isTeXNumberDigit(timesAST.arg2())) {
                            timesOperator = "\\cdot ";
                        } else {
                            for (i = 2; i < size; ++i) {
                                if (i >= timesAST.argSize() || !this.isTeXNumberDigit(timesAST.get(i)) || !this.isTeXNumberDigit(timesAST.get(i + 1))) continue;
                                timesOperator = "\\cdot ";
                                break;
                            }
                        }
                        buf.append(timesOperator);
                    }
                }
            }
            for (i = 2; i < size; ++i) {
                if (i == 2 && (arg1.isOne() || arg1.isMinusOne())) {
                    this.fFactory.convertInternal(buf, timesAST.get(i), precedence);
                } else {
                    this.fFactory.convertInternal(buf, timesAST.get(i), this.fPrecedence);
                }
                if (i >= timesAST.argSize()) continue;
                buf.append(timesOperator);
            }
            this.precedenceClose(buf, precedence);
            return true;
        }

        private boolean isTeXNumberDigit(IExpr expr) {
            if (expr.isNumber()) {
                return true;
            }
            return expr.isPower() && expr.base().isNumber() && !expr.exponent().isFraction();
        }
    }

    private static final class TeXFunction
    extends AbstractConverter {
        String fFunctionName;

        public TeXFunction(TeXFormFactory factory, String functionName) {
            super(factory);
            this.fFunctionName = functionName;
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            buf.append('\\');
            buf.append(this.fFunctionName);
            buf.append('(');
            for (int i = 1; i < f.size(); ++i) {
                this.fFactory.convertInternal(buf, f.get(i), 0);
                if (i >= f.argSize()) continue;
                buf.append(',');
            }
            buf.append(')');
            return true;
        }
    }

    private static final class Superscript
    extends AbstractConverter {
        private Superscript() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 3) {
                return false;
            }
            IExpr arg1 = f.arg1();
            IExpr arg2 = f.arg2();
            buf.append('{');
            this.fFactory.convertInternal(buf, arg1, 0);
            buf.append('}');
            buf.append("^");
            buf.append('{');
            this.fFactory.convertInternal(buf, arg2, 0);
            buf.append('}');
            return true;
        }
    }

    private static class Sum
    extends AbstractConverter {
        private Sum() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() >= 3) {
                return this.iteratorStep(buf, "\\sum", f, 2);
            }
            return false;
        }

        public boolean iteratorStep(StringBuilder buf, String mathSymbol, IAST f, int i) {
            if (i >= f.size()) {
                buf.append(" ");
                this.fFactory.convertSubExpr(buf, f.arg1(), 0);
                return true;
            }
            if (f.get(i).isList()) {
                try {
                    IIterator<IExpr> iterator = Iterator.create((IAST)f.get(i), i, EvalEngine.get());
                    if (iterator.isValidVariable() && iterator.getStep().isOne()) {
                        buf.append(mathSymbol);
                        buf.append("_{");
                        this.fFactory.convertSubExpr(buf, iterator.getVariable(), 0);
                        buf.append(" = ");
                        this.fFactory.convertSubExpr(buf, iterator.getLowerLimit(), 0);
                        buf.append("}^{");
                        this.fFactory.convertInternal(buf, iterator.getUpperLimit(), 0);
                        buf.append('}');
                        return this.iteratorStep(buf, mathSymbol, f, i + 1);
                    }
                }
                catch (ValidateException ve) {
                    IOFunctions.printMessage((ISymbol)S.Sum, ve, EvalEngine.get());
                }
                return false;
            }
            if (f.get(i).isSymbol()) {
                ISymbol symbol = (ISymbol)f.get(i);
                buf.append(mathSymbol);
                buf.append("_{");
                this.fFactory.convertSymbol(buf, symbol);
                buf.append("}");
                return this.iteratorStep(buf, mathSymbol, f, i + 1);
            }
            return false;
        }
    }

    private static final class Subsuperscript
    extends AbstractConverter {
        private Subsuperscript() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 4) {
                return false;
            }
            IExpr arg1 = f.arg1();
            IExpr arg2 = f.arg2();
            IExpr arg3 = f.arg3();
            buf.append('{');
            this.fFactory.convertInternal(buf, arg1, Integer.MAX_VALUE);
            buf.append('}');
            buf.append("_");
            buf.append('{');
            this.fFactory.convertInternal(buf, arg2, Integer.MAX_VALUE);
            buf.append('}');
            buf.append("^");
            buf.append('{');
            this.fFactory.convertInternal(buf, arg3, Integer.MAX_VALUE);
            buf.append('}');
            return true;
        }
    }

    private static final class Subscript
    extends AbstractConverter {
        private Subscript() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() < 3) {
                return false;
            }
            IExpr arg1 = f.arg1();
            buf.append('{');
            this.fFactory.convertInternal(buf, arg1, precedence);
            buf.append('}');
            buf.append("_");
            buf.append('{');
            for (int i = 2; i < f.size(); ++i) {
                this.fFactory.convertInternal(buf, f.get(i), precedence);
                if (i >= f.size() - 1) continue;
                buf.append(',');
            }
            buf.append('}');
            return true;
        }
    }

    private static final class Style
    extends AbstractConverter {
        private Style() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 3) {
                return false;
            }
            IExpr arg1 = f.arg1();
            IExpr arg2 = f.arg2();
            if (arg2.isBuiltInSymbol() && ((IBuiltInSymbol)arg2).isSymbolID(162, 184, 170, 308, 575, 1006, 1115, 1449, 1436)) {
                buf.append("\\textcolor{");
                buf.append(arg2.toString().toLowerCase());
                buf.append("}{");
                this.fFactory.convertInternal(buf, arg1, 0);
                buf.append("}");
                return true;
            }
            return false;
        }
    }

    private static final class Rational
    extends AbstractOperator {
        public Rational() {
            super(ASTNodeFactory.MMA_STYLE_FACTORY.get("Times").getPrecedence(), "/");
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 3) {
                return super.convert(buf, f, precedence);
            }
            this.precedenceOpen(buf, precedence);
            buf.append("\\frac{");
            this.fFactory.convertInternal(buf, f.arg1(), this.fPrecedence);
            buf.append("}{");
            this.fFactory.convertInternal(buf, f.arg2(), this.fPrecedence);
            buf.append('}');
            this.precedenceClose(buf, precedence);
            return true;
        }
    }

    private static final class Product
    extends Sum {
        private Product() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() >= 3) {
                return this.iteratorStep(buf, "\\prod", f, 2);
            }
            return false;
        }
    }

    private static final class PreOperator
    extends AbstractConverter {
        protected int fPrecedence;
        protected String fOperator;

        public PreOperator(TeXFormFactory factory, int precedence, String oper) {
            super(factory);
            this.fPrecedence = precedence;
            this.fOperator = oper;
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 2) {
                return false;
            }
            this.precedenceOpen(buf, precedence);
            buf.append(this.fOperator);
            this.fFactory.convertInternal(buf, f.arg1(), this.fPrecedence);
            this.precedenceClose(buf, precedence);
            return true;
        }

        public void precedenceClose(StringBuilder buf, int precedence) {
            if (precedence >= this.fPrecedence) {
                buf.append("\\right) ");
            }
        }

        public void precedenceOpen(StringBuilder buf, int precedence) {
            if (precedence >= this.fPrecedence) {
                buf.append("\\left( ");
            }
        }
    }

    private static final class Power
    extends AbstractOperator {
        public Power() {
            super(590, "^");
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 3) {
                return super.convert(buf, f, precedence);
            }
            IExpr arg1 = f.arg1();
            IExpr arg2 = f.arg2();
            if (arg2.isNegative()) {
                buf.append("\\frac{1}{");
                this.fFactory.convertInternal(buf, F.Power(arg1, arg2.negate()), 0);
                buf.append('}');
                return true;
            }
            if (arg2.isNumEqualRational(F.C1D2)) {
                buf.append("\\sqrt{");
                this.fFactory.convertInternal(buf, arg1, this.fPrecedence);
                buf.append('}');
                return true;
            }
            if (arg2.isFraction() && ((IFraction)arg2).numerator().isOne()) {
                buf.append("\\sqrt[");
                this.fFactory.convertInternal(buf, ((IFraction)arg2).denominator(), this.fPrecedence);
                buf.append("]{");
                this.fFactory.convertInternal(buf, arg1, this.fPrecedence);
                buf.append('}');
                return true;
            }
            this.precedenceOpen(buf, precedence);
            buf.append('{');
            this.fFactory.convertInternal(buf, arg1, this.fPrecedence);
            buf.append('}');
            if (this.fOperator.compareTo("") != 0) {
                buf.append(this.fOperator);
            }
            buf.append('{');
            this.fFactory.convertInternal(buf, arg2, 0);
            buf.append('}');
            this.precedenceClose(buf, precedence);
            return true;
        }
    }

    private static final class PostOperator
    extends AbstractConverter {
        protected int fPrecedence;
        protected String fOperator;

        public PostOperator(TeXFormFactory factory, int precedence, String oper) {
            super(factory);
            this.fPrecedence = precedence;
            this.fOperator = oper;
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 2) {
                return false;
            }
            this.precedenceOpen(buf, precedence);
            this.fFactory.convertInternal(buf, f.arg1(), this.fPrecedence);
            buf.append(this.fOperator);
            this.precedenceClose(buf, precedence);
            return true;
        }

        public void precedenceClose(StringBuilder buf, int precedence) {
            if (precedence >= this.fPrecedence) {
                buf.append("\\right) ");
            }
        }

        public void precedenceOpen(StringBuilder buf, int precedence) {
            if (precedence >= this.fPrecedence) {
                buf.append("\\left( ");
            }
        }
    }

    private static final class Plus
    extends AbstractOperator {
        public Plus() {
            super(310, "+");
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            this.precedenceOpen(buf, precedence);
            Times timesConverter = new Times();
            timesConverter.setFactory(this.fFactory);
            for (int i = 1; i < f.size(); ++i) {
                IExpr expr = f.get(i);
                if (i > 1 && expr instanceof IAST && expr.isTimes()) {
                    timesConverter.convertTimesFraction(buf, (IAST)expr, this.fPrecedence, 1);
                    continue;
                }
                if (i > 1) {
                    if (expr.isNumber() && ((INumber)expr).complexSign() < 0) {
                        buf.append("-");
                        expr = ((INumber)expr).negate();
                    } else if (!expr.isNegativeSigned()) {
                        buf.append("+");
                    }
                }
                this.fFactory.convertInternal(buf, expr, this.fPrecedence);
            }
            this.precedenceClose(buf, precedence);
            return true;
        }
    }

    private static final class Part
    extends AbstractConverter {
        private Part() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() > 2) {
                this.fFactory.convertHead(buf, f.arg1());
                buf.append("[[");
                int argSize = f.argSize();
                for (int i = 2; i <= argSize; ++i) {
                    this.fFactory.convertInternal(buf, f.get(i), 0);
                    if (i >= argSize) continue;
                    buf.append(",");
                }
                buf.append("]]");
                return true;
            }
            return false;
        }
    }

    private static final class Parenthesis
    extends AbstractConverter {
        private Parenthesis() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            buf.append("(");
            this.fFactory.convertInternal(buf, f.arg1(), 0);
            buf.append(")");
            return true;
        }
    }

    static class Operator {
        String fOperator;

        Operator(String oper) {
            this.fOperator = oper;
        }

        public void convert(StringBuilder buf) {
            buf.append(this.fOperator);
        }

        public String toString() {
            return this.fOperator;
        }
    }

    private static final class TableForm
    extends AbstractConverter {
        private TableForm() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 2) {
                return false;
            }
            int[] dims = f.arg1().isMatrix();
            if (dims == null) {
                int dim = f.arg1().isVector();
                if (dim < 0) {
                    return false;
                }
                IAST vector = (IAST)f.arg1();
                buf.append("\\begin{array}{c}\n");
                for (int i = 1; i < vector.size(); ++i) {
                    IExpr element = vector.get(i);
                    buf.append(' ');
                    this.fFactory.convertInternal(buf, element, 0);
                    buf.append(' ');
                    if (i >= vector.argSize()) continue;
                    buf.append("\\\\\n");
                }
                buf.append("\n\\end{array}");
            } else {
                IAST matrix = (IAST)f.arg1();
                buf.append("\\begin{array}{");
                for (int i = 0; i < dims[1]; ++i) {
                    buf.append("c");
                }
                buf.append("}\n");
                for (int i = 1; i < matrix.size(); ++i) {
                    IAST row = (IAST)matrix.get(i);
                    for (int j = 1; j < row.size(); ++j) {
                        buf.append(' ');
                        this.fFactory.convertInternal(buf, row.get(j), 0);
                        buf.append(' ');
                        if (j >= row.argSize()) continue;
                        buf.append('&');
                    }
                    buf.append("\\\\\n");
                }
                buf.append("\\end{array}");
            }
            return true;
        }
    }

    private static final class MatrixForm
    extends AbstractConverter {
        private MatrixForm() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 2) {
                return false;
            }
            int[] dims = f.arg1().isMatrix();
            if (dims == null) {
                int dim = f.arg1().isVector();
                if (dim < 0) {
                    return false;
                }
                IAST vector = (IAST)f.arg1();
                buf.append("\\begin{pmatrix}\n");
                for (int i = 1; i < vector.size(); ++i) {
                    IExpr element = vector.get(i);
                    buf.append(' ');
                    this.fFactory.convertInternal(buf, element, 0);
                    buf.append(' ');
                    if (i >= vector.argSize()) continue;
                    buf.append('&');
                }
                buf.append("\\end{pmatrix}");
            } else {
                IAST matrix = (IAST)f.arg1().normal(false);
                if (Config.MATRIX_TEXFORM) {
                    int i;
                    buf.append("\\left(\n\\begin{array}{");
                    for (i = 0; i < dims[1]; ++i) {
                        buf.append("c");
                    }
                    buf.append("}\n");
                    if (matrix.size() > 1) {
                        for (i = 1; i < matrix.size(); ++i) {
                            IAST row = matrix.getAST(i);
                            for (int j = 1; j < row.size(); ++j) {
                                this.fFactory.convert(buf, row.get(j), 0);
                                if (j >= row.argSize()) continue;
                                buf.append(" & ");
                            }
                            if (i < matrix.argSize()) {
                                buf.append(" \\\\\n");
                                continue;
                            }
                            buf.append(" \\\n");
                        }
                    }
                    buf.append("\\\\\n\\end{array}\n\\right) ");
                } else {
                    buf.append("\\begin{pmatrix}\n");
                    for (int i = 1; i < matrix.size(); ++i) {
                        IAST row = (IAST)matrix.get(i);
                        for (int j = 1; j < row.size(); ++j) {
                            buf.append(' ');
                            this.fFactory.convertInternal(buf, row.get(j), 0);
                            buf.append(' ');
                            if (j >= row.argSize()) continue;
                            buf.append('&');
                        }
                        buf.append("\\\\\n");
                    }
                    buf.append("\\end{pmatrix}");
                }
            }
            return true;
        }
    }

    private static final class List
    extends AbstractConverter {
        private List() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST ast, int precedence) {
            int[] dims;
            if ((ast.getEvalFlags() & 0x100000) == 0x100000 && this.convertMultiline(buf, ast)) {
                return true;
            }
            if ((ast instanceof ASTRealMatrix || ast.isEvalFlagOn(32)) && (dims = ast.isMatrix()) != null) {
                IAST matrix = ast;
                if (Config.MATRIX_TEXFORM) {
                    int i;
                    buf.append("\\left(\n\\begin{array}{");
                    for (i = 0; i < dims[1]; ++i) {
                        buf.append("c");
                    }
                    buf.append("}\n");
                    if (ast.size() > 1) {
                        for (i = 1; i < ast.size(); ++i) {
                            IAST row = ast.getAST(i);
                            for (int j = 1; j < row.size(); ++j) {
                                this.fFactory.convert(buf, row.get(j), 0);
                                if (j >= row.argSize()) continue;
                                buf.append(" & ");
                            }
                            if (i < ast.argSize()) {
                                buf.append(" \\\\\n");
                                continue;
                            }
                            buf.append(" \\\n");
                        }
                    }
                    buf.append("\\\\\n\\end{array}\n\\right) ");
                } else {
                    buf.append("\\begin{pmatrix}\n");
                    for (int i = 1; i < matrix.size(); ++i) {
                        IAST row = (IAST)matrix.get(i);
                        for (int j = 1; j < row.size(); ++j) {
                            buf.append(' ');
                            this.fFactory.convertInternal(buf, row.get(j), 0);
                            buf.append(' ');
                            if (j >= row.argSize()) continue;
                            buf.append('&');
                        }
                        buf.append("\\\\\n");
                    }
                    buf.append("\\end{pmatrix}");
                }
                return true;
            }
            if ((ast.getEvalFlags() & 0x40) == 64) {
                buf.append("\\begin{pmatrix} ");
                if (ast.size() > 1) {
                    for (int j = 1; j < ast.size(); ++j) {
                        this.fFactory.convertInternal(buf, ast.get(j), 0);
                        if (j >= ast.argSize()) continue;
                        buf.append(" & ");
                    }
                }
                buf.append(" \\end{pmatrix} ");
            } else {
                buf.append("\\{");
                if (ast.size() > 1) {
                    this.fFactory.convertInternal(buf, ast.arg1(), 0);
                    for (int i = 2; i < ast.size(); ++i) {
                        buf.append(',');
                        this.fFactory.convertInternal(buf, ast.get(i), 0);
                    }
                }
                buf.append("\\}");
            }
            return true;
        }

        private boolean convertMultiline(StringBuilder buf, IAST list) {
            buf.append("\\begin{array}{c}\n");
            for (int i = 1; i < list.size(); ++i) {
                IExpr element = list.get(i);
                buf.append(' ');
                this.fFactory.convertInternal(buf, element, 0);
                buf.append(' ');
                if (i >= list.argSize()) continue;
                buf.append("\\\\\n");
            }
            buf.append("\n\\end{array}");
            return true;
        }
    }

    private static final class Limit
    extends AbstractConverter {
        private Limit() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.isAST2() && f.arg2().isRuleAST()) {
                IAST rule = (IAST)f.arg2();
                buf.append("\\lim_{");
                this.fFactory.convertSubExpr(buf, rule.arg1(), 0);
                buf.append("\\to ");
                this.fFactory.convertSubExpr(buf, rule.arg2(), 0);
                buf.append(" }\\,");
                this.fFactory.convertSubExpr(buf, f.arg1(), 0);
                return true;
            }
            return false;
        }
    }

    private static final class Integrate
    extends AbstractConverter {
        private Integrate() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() >= 3) {
                return this.iteratorStep(buf, "\\int", f, 2);
            }
            return false;
        }

        public boolean iteratorStep(StringBuilder buf, String mathSymbol, IAST f, int i) {
            if (i >= f.size()) {
                buf.append(" ");
                this.fFactory.convertInternal(buf, f.arg1(), 0);
                return true;
            }
            if (f.get(i).isList()) {
                IAST list = (IAST)f.get(i);
                if (list.size() == 4 && list.arg1().isSymbol()) {
                    ISymbol symbol = (ISymbol)list.arg1();
                    buf.append(mathSymbol);
                    buf.append("_{");
                    this.fFactory.convertInternal(buf, list.arg2(), 0);
                    buf.append("}^{");
                    this.fFactory.convertInternal(buf, list.arg3(), 0);
                    buf.append('}');
                    if (!this.iteratorStep(buf, mathSymbol, f, i + 1)) {
                        return false;
                    }
                    buf.append("\\,\\mathrm{d}");
                    this.fFactory.convertSymbol(buf, symbol);
                    return true;
                }
            } else if (f.get(i).isSymbol()) {
                ISymbol symbol = (ISymbol)f.get(i);
                buf.append(mathSymbol);
                buf.append(" ");
                if (!this.iteratorStep(buf, mathSymbol, f, i + 1)) {
                    return false;
                }
                buf.append("\\,\\mathrm{d}");
                this.fFactory.convertSymbol(buf, symbol);
                return true;
            }
            return false;
        }
    }

    private static final class HarmonicNumber
    extends AbstractConverter {
        private HarmonicNumber() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.isAST1()) {
                buf.append("H_");
                this.fFactory.convertInternal(buf, f.arg1(), 0);
                return true;
            }
            if (f.isAST2()) {
                buf.append("H_");
                this.fFactory.convertInternal(buf, f.arg1(), 0);
                buf.append("^{(");
                this.fFactory.convertInternal(buf, f.arg2(), 0);
                buf.append(")}");
                return true;
            }
            return false;
        }
    }

    private static final class HoldForm
    extends AbstractConverter {
        private HoldForm() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() == 2) {
                this.fFactory.convertInternal(buf, f.arg1(), 0);
                return true;
            }
            return false;
        }
    }

    private static final class DirectedInfinity
    extends AbstractConverter {
        private DirectedInfinity() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.isComplexInfinity()) {
                buf.append("ComplexInfinity");
                return true;
            }
            if (f.isAST1()) {
                if (f.arg1().isOne()) {
                    buf.append("\\infty");
                    return true;
                }
                if (f.arg1().isMinusOne()) {
                    buf.append("- \\infty");
                    return true;
                }
            }
            return false;
        }
    }

    private static final class D
    extends AbstractConverter {
        private D() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.isAST2()) {
                IExpr arg2 = f.arg2();
                int n = 1;
                if (arg2.isAST(S.List, 3) && arg2.second().isInteger()) {
                    n = arg2.second().toIntDefault();
                    if (n <= 0) {
                        return false;
                    }
                    arg2 = arg2.first();
                }
                buf.append("\\frac{\\partial ");
                if (n > 1) {
                    buf.append("^" + n + " ");
                }
                this.fFactory.convertInternal(buf, f.arg1(), 0);
                buf.append("}{\\partial ");
                this.fFactory.convertInternal(buf, arg2, 0);
                if (n > 1) {
                    buf.append("^" + n);
                }
                buf.append("}");
                return true;
            }
            return false;
        }
    }

    private static final class Conjugate
    extends AbstractOperator {
        public Conjugate() {
            super(ASTNodeFactory.MMA_STYLE_FACTORY.get("Times").getPrecedence(), "^*");
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 2) {
                return false;
            }
            this.precedenceOpen(buf, precedence);
            this.fFactory.convertInternal(buf, f.arg1(), 0);
            buf.append("^*");
            this.precedenceClose(buf, precedence);
            return true;
        }
    }

    private static final class Complex
    extends AbstractOperator {
        public Complex() {
            super(ASTNodeFactory.MMA_STYLE_FACTORY.get("Plus").getPrecedence(), "+");
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 3) {
                return super.convert(buf, f, precedence);
            }
            this.precedenceOpen(buf, precedence);
            IExpr arg1 = f.arg1();
            boolean reZero = arg1.isZero();
            IExpr arg2 = f.arg2();
            boolean imZero = arg2.isZero();
            if (!reZero) {
                this.fFactory.convertInternal(buf, arg1, 0);
            }
            if (!imZero) {
                if (!reZero && !arg2.isNegativeSigned()) {
                    buf.append(" + ");
                }
                if (arg2.isMinusOne()) {
                    buf.append(" - ");
                } else if (!arg2.isOne()) {
                    this.fFactory.convertInternal(buf, arg2, 0);
                    buf.append("\\,");
                }
                buf.append("\\imag");
            }
            return true;
        }
    }

    private static final class Binomial
    extends AbstractConverter {
        private Binomial() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 3) {
                return false;
            }
            buf.append('{');
            this.fFactory.convertInternal(buf, f.arg1(), 0);
            buf.append("\\choose ");
            this.fFactory.convertInternal(buf, f.arg2(), 0);
            buf.append('}');
            return true;
        }
    }

    private static class AbstractOperator
    extends AbstractConverter {
        protected int fPrecedence;
        protected String fOperator;

        public AbstractOperator(int precedence, String oper) {
            this.fPrecedence = precedence;
            this.fOperator = oper;
        }

        public AbstractOperator(TeXFormFactory factory, int precedence, String oper) {
            super(factory);
            this.fPrecedence = precedence;
            this.fOperator = oper;
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            boolean isOr = f.isOr();
            this.precedenceOpen(buf, precedence);
            for (int i = 1; i < f.size(); ++i) {
                if (isOr && f.get(i).isAnd()) {
                    buf.append("\\left( ");
                }
                this.fFactory.convertInternal(buf, f.get(i), this.fPrecedence);
                if (isOr && f.get(i).isAnd()) {
                    buf.append("\\right) ");
                }
                if (i >= f.argSize() || this.fOperator.compareTo("") == 0) continue;
                buf.append(this.fOperator);
            }
            this.precedenceClose(buf, precedence);
            return true;
        }

        public void precedenceClose(StringBuilder buf, int precedence) {
            if (precedence > this.fPrecedence) {
                buf.append("\\right) ");
            }
        }

        public void precedenceOpen(StringBuilder buf, int precedence) {
            if (precedence > this.fPrecedence) {
                buf.append("\\left( ");
            }
        }
    }

    private static abstract class AbstractConverter {
        protected TeXFormFactory fFactory;

        public AbstractConverter() {
            this.fFactory = null;
        }

        public AbstractConverter(TeXFormFactory factory) {
            this.fFactory = factory;
        }

        public abstract boolean convert(StringBuilder var1, IAST var2, int var3);

        public void setFactory(TeXFormFactory factory) {
            this.fFactory = factory;
        }
    }
}

