/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.output;

import java.io.IOException;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.ISymbol;

public class WolframFormFactory
extends OutputFormFactory {
    private WolframFormFactory(boolean relaxedSyntax, boolean reversed, int exponentFigures, int significantFigures) {
        super(relaxedSyntax, reversed, exponentFigures, significantFigures);
        this.fInputForm = true;
    }

    @Override
    public void convertSymbol(Appendable buf, ISymbol symbol) throws IOException {
        Context context = symbol.getContext();
        if (context == Context.DUMMY) {
            this.append(buf, symbol.getSymbolName());
            return;
        }
        String str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(symbol.getSymbolName());
        if (str != null) {
            this.append(buf, str);
            return;
        }
        if (EvalEngine.get().getContextPath().contains(context)) {
            this.append(buf, symbol.getSymbolName());
        } else {
            this.append(buf, context.completeContextName() + symbol.getSymbolName());
        }
    }

    @Override
    public void convertPattern(Appendable buf, IPatternObject pattern) throws IOException {
        this.append(buf, pattern.toWolframString());
    }

    public static WolframFormFactory get() {
        return new WolframFormFactory(false, false, -1, -1);
    }
}

