/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.output;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Algebra;
import org.matheclipse.core.builtin.LinearAlgebra;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ASTRealMatrix;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.ASTSeriesData;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.ApfloatToMMA;
import org.matheclipse.core.form.DoubleToMMA;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.tensor.qty.IQuantity;
import org.matheclipse.parser.client.Characters;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.client.operator.ASTNodeFactory;
import org.matheclipse.parser.client.operator.InfixOperator;
import org.matheclipse.parser.client.operator.Operator;
import org.matheclipse.parser.client.operator.PostfixOperator;
import org.matheclipse.parser.client.operator.PrefixOperator;

public class OutputFormFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean NO_PLUS_CALL = false;
    public static final boolean PLUS_CALL = true;
    private final boolean fRelaxedSyntax;
    private final boolean fPlusReversed;
    private boolean fIgnoreNewLine = false;
    protected boolean fInputForm = false;
    private boolean fEmpty = true;
    private boolean fUseSignificantFiguresInApfloat = false;
    private int fColumnCounter = 0;
    private int fExponentFigures;
    private int fSignificantFigures;

    protected OutputFormFactory(boolean relaxedSyntax, boolean reversed, int exponentFigures, int significantFigures) {
        this.fRelaxedSyntax = relaxedSyntax;
        this.fPlusReversed = reversed;
        this.fExponentFigures = exponentFigures;
        this.fSignificantFigures = significantFigures;
    }

    public void reset(boolean useSignificantFiguresInApfloat) {
        this.fColumnCounter = 0;
        this.fUseSignificantFiguresInApfloat = useSignificantFiguresInApfloat;
    }

    public static OutputFormFactory get(boolean relaxedSyntax) {
        return OutputFormFactory.get(relaxedSyntax, false);
    }

    public static OutputFormFactory get(boolean relaxedSyntax, boolean plusReversed) {
        return OutputFormFactory.get(relaxedSyntax, plusReversed, -1, -1);
    }

    public static OutputFormFactory get(boolean relaxedSyntax, boolean plusReversed, int exponentFigures, int significantFigures) {
        return new OutputFormFactory(relaxedSyntax, plusReversed, exponentFigures, significantFigures);
    }

    public static OutputFormFactory get() {
        return OutputFormFactory.get(false);
    }

    public void convertDouble(Appendable buf, INum d, int precedence, boolean caller) throws IOException {
        double doubleValue = d.doubleValue();
        this.convertDouble(buf, doubleValue, d, precedence, caller);
    }

    private void convertDouble(Appendable buf, double doubleValue, INum d, int precedence, boolean caller) throws IOException {
        boolean isNegative = d.isNegative();
        if (d instanceof ApfloatNum) {
            Apfloat apfloat = ((ApfloatNum)d).apfloatValue();
            if (!isNegative && caller) {
                this.append(buf, this.fInputForm ? " + " : "+");
            }
            String str = this.fInputForm ? ApfloatNum.fullFormString(apfloat) : this.convertApfloatToFormattedString(apfloat);
            this.convertDoubleString(buf, str, precedence, isNegative);
            return;
        }
        if (F.isZero(doubleValue, Config.ZERO_IN_OUTPUT_FORMAT)) {
            if (this.fInputForm) {
                this.convertDoubleString(buf, d.fullFormString(), precedence, false);
            } else {
                this.convertDoubleString(buf, this.convertDoubleToFormattedString(0.0), precedence, false);
            }
            return;
        }
        if (!isNegative && caller) {
            this.append(buf, this.fInputForm ? " + " : "+");
        }
        if (d instanceof Num) {
            if (this.fInputForm) {
                this.convertDoubleString(buf, d.fullFormString(), precedence, isNegative);
            } else {
                this.convertDoubleString(buf, this.convertDoubleToFormattedString(doubleValue), precedence, isNegative);
            }
        }
    }

    private void convertDouble(Appendable buf, double doubleValue) throws IOException {
        if (F.isZero(doubleValue, Config.ZERO_IN_OUTPUT_FORMAT)) {
            this.convertDoubleString(buf, this.convertDoubleToFormattedString(0.0), 0, false);
            return;
        }
        this.convertDoubleString(buf, this.convertDoubleToFormattedString(doubleValue), 0, false);
    }

    private String convertApfloatToFormattedString(Apfloat value) {
        StringBuilder buf = new StringBuilder();
        int numericPrecision = (int)EvalEngine.get().getNumericPrecision();
        if (this.fUseSignificantFiguresInApfloat) {
            ApfloatToMMA.apfloatToMMA(buf, value, numericPrecision, this.fSignificantFigures, this.fUseSignificantFiguresInApfloat);
        } else {
            ApfloatToMMA.apfloatToMMA(buf, value, numericPrecision, numericPrecision, this.fUseSignificantFiguresInApfloat);
        }
        return buf.toString();
    }

    private String convertDoubleToFormattedString(double dValue) {
        if (this.fSignificantFigures > 0) {
            StringBuilder buf = new StringBuilder();
            DoubleToMMA.doubleToMMA(buf, dValue, this.fExponentFigures, this.fSignificantFigures);
            return buf.toString();
        }
        return Double.toString(dValue);
    }

    private void convertDoubleString(Appendable buf, String d, int precedence, boolean isNegative) throws IOException {
        if (isNegative && 310 < precedence) {
            this.append(buf, "(");
        }
        this.append(buf, d);
        if (isNegative && 310 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertDoubleComplex(Appendable buf, IComplexNum dc, int precedence, boolean caller) throws IOException {
        if (dc instanceof ApcomplexNum) {
            this.convertApcomplex(buf, ((ApcomplexNum)dc).apcomplexValue(), precedence, caller);
            return;
        }
        if (310 < precedence) {
            if (caller) {
                this.append(buf, this.fInputForm ? " + " : "+");
                caller = false;
            }
            this.append(buf, "(");
        }
        double realPart = dc.getRealPart();
        double imaginaryPart = dc.getImaginaryPart();
        boolean realZero = F.isZero(realPart);
        boolean imaginaryZero = F.isZero(imaginaryPart);
        if (realZero && imaginaryZero) {
            this.convertDoubleString(buf, this.convertDoubleToFormattedString(0.0), 310, false);
        } else if (!realZero) {
            String str = this.fInputForm ? Num.fullFormString(realPart) : this.convertDoubleToFormattedString(realPart);
            this.append(buf, str);
            if (!imaginaryZero) {
                this.append(buf, "+I*");
                boolean isNegative = imaginaryPart < 0.0;
                str = this.fInputForm ? Num.fullFormString(imaginaryPart) : this.convertDoubleToFormattedString(imaginaryPart);
                this.convertDoubleString(buf, str, 400, isNegative);
            }
        } else {
            if (caller) {
                this.append(buf, this.fInputForm ? " + " : "+");
                caller = false;
            }
            this.append(buf, "I*");
            boolean isNegative = imaginaryPart < 0.0;
            String str = this.fInputForm ? Num.fullFormString(imaginaryPart) : this.convertDoubleToFormattedString(imaginaryPart);
            this.convertDoubleString(buf, str, 400, isNegative);
        }
        if (310 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertApcomplex(Appendable buf, Apcomplex dc, int precedence, boolean caller) throws IOException {
        if (310 < precedence) {
            if (caller) {
                this.append(buf, this.fInputForm ? " + " : "+");
                caller = false;
            }
            this.append(buf, "(");
        }
        Apfloat realPart = dc.real();
        Apfloat imaginaryPart = dc.imag();
        boolean realZero = realPart.equals((Object)Apcomplex.ZERO);
        boolean imaginaryZero = imaginaryPart.equals((Object)Apcomplex.ZERO);
        if (realZero && imaginaryZero) {
            this.convertDoubleString(buf, "0.0", 310, false);
        } else if (!realZero) {
            String str = this.fInputForm ? ApfloatNum.fullFormString(realPart) : this.convertApfloatToFormattedString(realPart);
            this.append(buf, str);
            if (!imaginaryZero) {
                this.append(buf, "+I*");
                boolean isNegative = imaginaryPart.compareTo((Apfloat)Apcomplex.ZERO) < 0;
                str = this.fInputForm ? ApfloatNum.fullFormString(imaginaryPart) : this.convertApfloatToFormattedString(imaginaryPart);
                this.convertDoubleString(buf, str, 400, isNegative);
            }
        } else {
            if (caller) {
                this.append(buf, this.fInputForm ? " + " : "+");
                caller = false;
            }
            this.append(buf, "I*");
            boolean isNegative = imaginaryPart.compareTo((Apfloat)Apcomplex.ZERO) < 0;
            String str = this.fInputForm ? ApfloatNum.fullFormString(imaginaryPart) : this.convertApfloatToFormattedString(imaginaryPart);
            this.convertDoubleString(buf, str, 400, isNegative);
        }
        if (310 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertInteger(Appendable buf, IInteger i, int precedence, boolean caller) throws IOException {
        String str;
        boolean isNegative = i.isNegative();
        if (!isNegative && caller) {
            this.append(buf, this.fInputForm ? " + " : "+");
        }
        if (isNegative && 310 < precedence) {
            this.append(buf, "(");
        }
        if (isNegative) {
            str = i.toString().substring(1);
            this.append(buf, this.fInputForm && caller ? " - " : "-");
        } else {
            str = i.toString();
        }
        if (str.length() + this.getColumnCounter() > Config.MAX_OUTPUT_LINE) {
            if (this.getColumnCounter() > 40) {
                this.newLine(buf);
            }
            int len = str.length();
            for (int j = 0; j < len; j += 79) {
                if (j + 79 < len) {
                    this.append(buf, str.substring(j, j + 79));
                    this.append(buf, '\\');
                    this.newLine(buf);
                    continue;
                }
                this.append(buf, str.substring(j, len));
            }
        } else {
            this.append(buf, str);
        }
        if (isNegative && 310 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertFraction(Appendable buf, IRational f, int precedence, boolean caller) throws IOException {
        this.convertFraction(buf, f.toBigNumerator(), f.toBigDenominator(), precedence, caller);
    }

    public void convertFraction(Appendable buf, BigInteger numerator, BigInteger denominator, int precedence, boolean caller) throws IOException {
        int j;
        int len;
        String str;
        int prec;
        boolean isInteger = denominator.compareTo(BigInteger.ONE) == 0;
        boolean isNegative = numerator.compareTo(BigInteger.ZERO) < 0;
        int n = prec = isNegative ? 310 : 400;
        if (!isNegative && caller) {
            this.append(buf, this.fInputForm ? " + " : "+");
        }
        if (prec < precedence) {
            this.append(buf, "(");
        }
        if (isNegative) {
            numerator = numerator.negate();
            this.append(buf, this.fInputForm && caller ? " - " : "-");
        }
        if ((str = numerator.toString()).length() + this.getColumnCounter() > Config.MAX_OUTPUT_LINE) {
            if (this.getColumnCounter() > 40) {
                this.newLine(buf);
            }
            len = str.length();
            for (j = 0; j < len; j += 79) {
                if (j + 79 < len) {
                    this.append(buf, str.substring(j, j + 79));
                    this.append(buf, '\\');
                    this.newLine(buf);
                    continue;
                }
                this.append(buf, str.substring(j, len));
            }
        } else {
            this.append(buf, str);
        }
        if (!isInteger) {
            this.append(buf, "/");
            str = denominator.toString();
            if (str.length() + this.getColumnCounter() > Config.MAX_OUTPUT_LINE) {
                if (this.getColumnCounter() > 40) {
                    this.newLine(buf);
                }
                len = str.length();
                for (j = 0; j < len; j += 79) {
                    if (j + 79 < len) {
                        this.append(buf, str.substring(j, j + 79));
                        this.append(buf, '\\');
                        this.newLine(buf);
                        continue;
                    }
                    this.append(buf, str.substring(j, len));
                }
            } else {
                this.append(buf, str);
            }
        }
        if (prec < precedence) {
            this.append(buf, ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertComplex(Appendable buf, IComplex c, int precedence, boolean caller) throws IOException {
        boolean isReZero = c.getRealPart().isZero();
        boolean isImOne = c.getImaginaryPart().isOne();
        boolean isImMinusOne = c.getImaginaryPart().isMinusOne();
        if (!isReZero && 310 < precedence) {
            if (caller) {
                this.append(buf, this.fInputForm ? " + " : "+");
                caller = false;
            }
            this.append(buf, "(");
        }
        if (!isReZero) {
            this.convertFraction(buf, c.getRealPart(), 310, caller);
        }
        if (isImOne) {
            if (isReZero) {
                if (caller) {
                    this.append(buf, this.fInputForm ? " + " : "+");
                    caller = false;
                }
                this.append(buf, "I");
                return;
            }
            this.append(buf, this.fInputForm ? " + I" : "+I");
        } else if (isImMinusOne) {
            this.append(buf, this.fInputForm ? " - I" : "-I");
        } else {
            IRational im = c.getImaginaryPart();
            int oldColumnCounter = this.fColumnCounter;
            StringBuilder imagBuf = new StringBuilder();
            try {
                if (im.isNegative()) {
                    if (isReZero && 400 < precedence) {
                        if (caller) {
                            this.append(buf, this.fInputForm ? " + " : "+");
                        }
                        this.append(buf, "(");
                    }
                    this.append(buf, this.fInputForm ? " - " : "-");
                    oldColumnCounter = this.fColumnCounter;
                    this.fColumnCounter = 0;
                    this.append((Appendable)imagBuf, "I*");
                    this.convertFraction(imagBuf, im.negate(), 400, false);
                } else {
                    if (isReZero) {
                        if (caller) {
                            this.append(buf, this.fInputForm ? " + " : "+");
                        }
                        if (400 < precedence) {
                            this.append(buf, "(");
                        }
                        oldColumnCounter = this.fColumnCounter;
                        this.fColumnCounter = 0;
                        this.append((Appendable)imagBuf, "I*");
                    } else {
                        this.append(buf, this.fInputForm ? " + " : "+");
                        oldColumnCounter = this.fColumnCounter;
                        this.fColumnCounter = 0;
                        this.append((Appendable)imagBuf, "I*");
                    }
                    this.convertFraction(imagBuf, im, 400, false);
                }
            }
            finally {
                this.fColumnCounter = oldColumnCounter;
            }
            String str = imagBuf.toString();
            if (str.length() + this.getColumnCounter() > Config.MAX_OUTPUT_LINE) {
                this.newLine(buf);
            }
            this.append(buf, str);
            if (isReZero && 400 < precedence) {
                this.append(buf, ")");
            }
        }
        if (!isReZero && 310 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertString(Appendable buf, String str) throws IOException {
        if (this.fInputForm) {
            this.append(buf, "\"");
            this.append(buf, str);
            this.append(buf, "\"");
        } else {
            this.appendUnicodeMapped(buf, str);
        }
    }

    public void convertSymbol(Appendable buf, ISymbol symbol) throws IOException {
        String str;
        Context context = symbol.getContext();
        if (context == Context.DUMMY) {
            this.append(buf, symbol.getSymbolName());
            return;
        }
        if (context.equals(Context.SYSTEM) && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(symbol.getSymbolName())) != null) {
            this.append(buf, str);
            return;
        }
        if (EvalEngine.get().getContextPath().contains(context)) {
            this.append(buf, symbol.getSymbolName());
        } else {
            this.append(buf, context.completeContextName() + symbol.getSymbolName());
        }
    }

    public void convertPattern(Appendable buf, IPatternObject pattern) throws IOException {
        this.append(buf, pattern.toString());
    }

    public void convertHead(Appendable buf, IExpr obj) throws IOException {
        this.convert(buf, obj, Integer.MIN_VALUE, false);
    }

    private void convertPlusOperator(Appendable buf, IAST plusAST, InfixOperator oper, int precedence) throws IOException {
        int size;
        int operPrecedence = oper.getPrecedence();
        if (operPrecedence < precedence) {
            this.append(buf, "(");
        }
        if ((size = plusAST.size()) > 0) {
            this.convertPlusArgument(buf, plusAST.arg1(), false);
            for (int i = 2; i < size; ++i) {
                IExpr plusArg = plusAST.get(i);
                this.convertPlusArgument(buf, plusArg, true);
            }
        }
        if (operPrecedence < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertPlusArgument(Appendable buf, IExpr plusArg, boolean caller) throws IOException {
        if (plusArg.isTimes()) {
            IAST timesAST = (IAST)plusArg;
            InfixOperator TIMES_OPERATOR = (InfixOperator)ASTNodeFactory.MMA_STYLE_FACTORY.get("Times");
            this.convertTimesFraction(buf, timesAST, TIMES_OPERATOR, 400, caller);
        } else if (plusArg.isNegativeSigned()) {
            this.convert(buf, plusArg, Integer.MIN_VALUE, false);
        } else {
            if (caller) {
                this.append(buf, this.fInputForm ? " + " : "+");
            }
            this.convert(buf, plusArg, 310, false);
        }
    }

    private void convertPlusOperatorReversed(Appendable buf, IAST plusAST, InfixOperator oper, int precedence) throws IOException {
        int size;
        int operPrecedence = oper.getPrecedence();
        if (operPrecedence < precedence) {
            this.append(buf, "(");
        }
        String operatorStr = oper.getOperatorString();
        for (int i = size = plusAST.argSize(); i > 0; --i) {
            IExpr plusArg = plusAST.get(i);
            if (plusArg.isTimes()) {
                String multCh = ASTNodeFactory.MMA_STYLE_FACTORY.get("Times").getOperatorString();
                boolean showOperator = true;
                IAST timesAST = (IAST)plusArg;
                IExpr arg1 = timesAST.arg1();
                if (arg1.isNumber() && ((INumber)arg1).complexSign() < 0) {
                    if (((INumber)arg1).isOne()) {
                        showOperator = false;
                    } else if (arg1.isMinusOne()) {
                        this.append(buf, this.fInputForm ? " - " : "-");
                        showOperator = false;
                    } else {
                        this.convertNumber(buf, (INumber)arg1, operPrecedence, false);
                    }
                } else {
                    if (i < size) {
                        this.append(buf, operatorStr);
                    }
                    this.convert(buf, arg1, 400, false);
                }
                for (int j = 2; j < timesAST.size(); ++j) {
                    IExpr timesArg = timesAST.get(j);
                    if (showOperator) {
                        this.append(buf, multCh);
                    } else {
                        showOperator = true;
                    }
                    this.convert(buf, timesArg, 400, false);
                }
                continue;
            }
            if (plusArg.isNumber() && ((INumber)plusArg).complexSign() < 0) {
                this.convert(buf, plusArg, Integer.MIN_VALUE, false);
                continue;
            }
            if (i < size) {
                this.append(buf, operatorStr);
            }
            this.convert(buf, plusArg, 310, false);
        }
        if (operPrecedence < precedence) {
            this.append(buf, ")");
        }
    }

    private void convertTimesFraction(Appendable buf, IAST timesAST, InfixOperator oper, int precedence, boolean caller) throws IOException {
        IExpr[] parts = Algebra.fractionalPartsTimesPower(timesAST, true, false, false, false, false, false);
        if (parts == null) {
            this.convertTimesOperator(buf, timesAST, oper, precedence, caller);
            return;
        }
        IExpr numerator = parts[0];
        IExpr denominator = parts[1];
        if (!denominator.isOne()) {
            IExpr fraction;
            int currPrecedence = oper.getPrecedence();
            if (currPrecedence < precedence) {
                this.append(buf, "(");
            }
            if ((fraction = parts[2]) != null) {
                this.convertNumber(buf, (ISignedNumber)fraction, 310, caller);
                this.append(buf, "*");
                caller = false;
            }
            if (numerator.isReal()) {
                this.convertNumber(buf, (ISignedNumber)numerator, 310, caller);
            } else if (numerator.isComplex() || numerator.isComplexNumeric()) {
                this.convertNumber(buf, (INumber)numerator, 470, caller);
            } else if (numerator.isTimes() && numerator.isAST2() && numerator.first().isMinusOne()) {
                this.append(buf, this.fInputForm ? " - " : "-");
                this.convert(buf, numerator.second(), 400, false);
            } else {
                if (caller) {
                    this.append(buf, this.fInputForm ? " + " : "+");
                }
                if (numerator.isTimes()) {
                    this.convertTimesOperator(buf, (IAST)numerator, oper, 470, false);
                } else {
                    this.convert(buf, numerator, 470, false);
                }
            }
            this.append(buf, "/");
            if (denominator.isTimes()) {
                this.convertTimesOperator(buf, (IAST)denominator, oper, 470, false);
            } else {
                this.convert(buf, denominator, 470, false);
            }
            if (currPrecedence < precedence) {
                this.append(buf, ")");
            }
            return;
        }
        this.convertTimesOperator(buf, timesAST, oper, precedence, caller);
    }

    private void convertTimesOperator(Appendable buf, IAST timesAST, InfixOperator oper, int precedence, boolean caller) throws IOException {
        boolean showOperator = true;
        int currPrecedence = oper.getPrecedence();
        if (currPrecedence < precedence) {
            this.append(buf, "(");
        }
        if (timesAST.size() > 1) {
            IExpr arg1 = timesAST.arg1();
            if (arg1.isReal() && timesAST.size() > 2 && !timesAST.arg2().isNumber()) {
                if (arg1.isMinusOne()) {
                    this.append(buf, this.fInputForm && caller ? " - " : "-");
                    showOperator = false;
                } else {
                    this.convertNumber(buf, (ISignedNumber)arg1, 310, caller);
                }
            } else if (arg1.isComplex() && timesAST.size() > 2) {
                this.convertComplex(buf, (IComplex)arg1, oper.getPrecedence(), caller);
            } else {
                if (caller) {
                    this.append(buf, this.fInputForm ? " + " : "+");
                }
                this.convert(buf, arg1, oper.getPrecedence(), false);
            }
        }
        for (int i = 2; i < timesAST.size(); ++i) {
            if (showOperator) {
                this.append(buf, oper.getOperatorString());
            } else {
                showOperator = true;
            }
            this.convert(buf, timesAST.get(i), oper.getPrecedence(), false);
        }
        if (currPrecedence < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertPowerOperator(Appendable buf, IAST list, InfixOperator oper, int precedence) throws IOException {
        IExpr arg2 = list.arg2();
        if (arg2.isNumber()) {
            INumber exp = (INumber)arg2;
            if (exp.isNumEqualRational(F.C1D2)) {
                this.append(buf, "Sqrt");
                if (this.fRelaxedSyntax) {
                    this.append(buf, "(");
                } else {
                    this.append(buf, "[");
                }
                this.convert(buf, list.arg1(), 0, false);
                if (this.fRelaxedSyntax) {
                    this.append(buf, ")");
                } else {
                    this.append(buf, "]");
                }
                return;
            }
            if (exp.complexSign() < 0) {
                if (470 < precedence) {
                    this.append(buf, "(");
                }
                this.append(buf, "1/");
                if (exp.isMinusOne()) {
                    this.convert(buf, list.arg1(), 470, false);
                    if (470 < precedence) {
                        this.append(buf, ")");
                    }
                    return;
                }
                IASTMutable pow = list.setAtCopy(2, exp.opposite());
                this.convertPowerOperator(buf, pow, oper, 470);
                if (470 < precedence) {
                    this.append(buf, ")");
                }
                return;
            }
        }
        this.convertInfixOperator(buf, list, oper, precedence);
    }

    public void convertInfixOperator(Appendable buf, IAST list, InfixOperator oper, int precedence) throws IOException {
        boolean isOr = list.isOr();
        String operatorString = oper.getOperatorString();
        if (list.isAST2()) {
            Operator operator;
            IExpr arg1 = list.arg1();
            IExpr arg2 = list.arg2();
            if (oper.getPrecedence() < precedence) {
                this.append(buf, "(");
            }
            if (oper.getGrouping() == 1 && arg1.head().equals(list.head())) {
                this.append(buf, "(");
            } else if (operatorString.equals("^") && (operator = OutputFormFactory.getOperator(arg1.topHead())) instanceof PostfixOperator) {
                this.append(buf, "(");
            }
            if (isOr && arg1.isAnd()) {
                this.append(buf, "(");
            }
            this.convert(buf, arg1, oper.getPrecedence(), false);
            if (isOr && arg1.isAnd()) {
                this.append(buf, ")");
            }
            if (oper.getGrouping() == 1 && arg1.head().equals(list.head())) {
                this.append(buf, ")");
            } else if (operatorString.equals("^") && (operator = OutputFormFactory.getOperator(arg1.topHead())) instanceof PostfixOperator) {
                this.append(buf, ")");
            }
            this.appendUnicodeMapped(buf, operatorString);
            if (oper.getGrouping() == 2 && arg2.head().equals(list.head())) {
                this.append(buf, "(");
            }
            if (isOr && arg2.isAnd()) {
                this.append(buf, "(");
            }
            this.convert(buf, arg2, oper.getPrecedence(), false);
            if (isOr && arg2.isAnd()) {
                this.append(buf, ")");
            }
            if (oper.getGrouping() == 2 && arg2.head().equals(list.head())) {
                this.append(buf, ")");
            }
            if (oper.getPrecedence() < precedence) {
                this.append(buf, ")");
            }
            return;
        }
        if (oper.getPrecedence() < precedence) {
            this.append(buf, "(");
        }
        if (list.size() > 1) {
            if (isOr && list.arg1().isAnd()) {
                this.append(buf, "(");
            }
            this.convert(buf, list.arg1(), oper.getPrecedence(), false);
            if (isOr && list.arg1().isAnd()) {
                this.append(buf, ")");
            }
        }
        for (int i = 2; i < list.size(); ++i) {
            this.appendUnicodeMapped(buf, operatorString);
            if (isOr && list.get(i).isAnd()) {
                this.append(buf, "(");
            }
            this.convert(buf, list.get(i), oper.getPrecedence(), false);
            if (!isOr || !list.get(i).isAnd()) continue;
            this.append(buf, ")");
        }
        if (oper.getPrecedence() < precedence) {
            this.append(buf, ")");
        }
    }

    private void appendUnicodeMapped(Appendable buf, String operatorString) throws IOException {
        operatorString = Characters.mapWLUnicodeToEquivalent((String)operatorString);
        this.append(buf, operatorString);
    }

    public void convertPrefixOperator(Appendable buf, IAST list, PrefixOperator oper, int precedence) throws IOException {
        if (oper.getPrecedence() <= precedence) {
            this.append(buf, "(");
        }
        this.append(buf, oper.getOperatorString());
        this.convert(buf, list.arg1(), oper.getPrecedence(), false);
        if (oper.getPrecedence() <= precedence) {
            this.append(buf, ")");
        }
    }

    public void convertPostfixOperator(Appendable buf, IAST list, PostfixOperator oper, int precedence) throws IOException {
        if (oper.getPrecedence() <= precedence) {
            this.append(buf, "(");
        }
        this.convert(buf, list.arg1(), oper.getPrecedence(), false);
        this.append(buf, oper.getOperatorString());
        if (oper.getPrecedence() <= precedence) {
            this.append(buf, ")");
        }
    }

    public String toString(IExpr o, boolean useSignificantFigures) {
        this.reset(useSignificantFigures);
        StringBuilder buf = new StringBuilder();
        try {
            this.convert(buf, o, Integer.MIN_VALUE, false);
        }
        catch (IOException e) {
            LOGGER.debug("OutputFormFactory.toString() failed", (Throwable)e);
        }
        return buf.toString();
    }

    public String toString(IExpr o) {
        this.reset(false);
        StringBuilder buf = new StringBuilder();
        try {
            this.convert(buf, o, Integer.MIN_VALUE, false);
        }
        catch (IOException e) {
            LOGGER.debug("OutputFormFactory.toString() failed", (Throwable)e);
        }
        return buf.toString();
    }

    public boolean convert(Appendable buf, IExpr o) {
        try {
            this.convert(buf, o, Integer.MIN_VALUE, false);
            return !(buf instanceof CharSequence) || ((CharSequence)((Object)buf)).length() < Config.MAX_OUTPUT_SIZE;
        }
        catch (IOException | OutOfMemoryError | RuntimeException rex) {
            LOGGER.debug("OutputFormFactory.convert() failed", rex);
            return false;
        }
    }

    private void convertNumber(Appendable buf, INumber o, int precedence, boolean caller) throws IOException {
        if (o instanceof INum) {
            this.convertDouble(buf, (INum)o, precedence, caller);
        } else if (o instanceof IComplexNum) {
            this.convertDoubleComplex(buf, (IComplexNum)o, precedence, caller);
        } else if (o instanceof IInteger) {
            this.convertInteger(buf, (IInteger)o, precedence, caller);
        } else if (o instanceof IFraction) {
            this.convertFraction(buf, (IFraction)o, precedence, caller);
        } else if (o instanceof IComplex) {
            this.convertComplex(buf, (IComplex)o, precedence, caller);
        } else {
            LOGGER.error("OutputFormFactory.convertNumber() failed");
        }
    }

    private void convert(Appendable buf, IExpr o, int precedence, boolean isASTHead) throws IOException {
        block73: {
            block70: {
                IAST list;
                block71: {
                    block72: {
                        Operator operator;
                        if (!(o instanceof IAST)) break block70;
                        list = (IAST)o;
                        if (!list.isPresent()) {
                            this.append(buf, "NIL");
                            return;
                        }
                        if (o.isDataset()) {
                            buf.append(o.toString());
                            return;
                        }
                        if (o.isAssociation()) {
                            this.convertAssociation(buf, (IAssociation)o);
                            return;
                        }
                        if (o.isAST(S.Association, 1)) {
                            buf.append("<||>");
                            return;
                        }
                        IExpr header = list.head();
                        if (!header.isSymbol()) {
                            IAST[] derivStruct = list.isDerivativeAST1();
                            if (derivStruct != null) {
                                IAST a1Head = derivStruct[0];
                                IAST headAST = derivStruct[1];
                                if (a1Head.isAST1() && a1Head.arg1().isInteger() && headAST.isAST1() && (headAST.arg1().isSymbol() || headAST.arg1().isAST()) && derivStruct[2] != null) {
                                    try {
                                        int n = ((IInteger)a1Head.arg1()).toInt();
                                        if (n == 1 || n == 2) {
                                            IExpr symbolOrAST = headAST.arg1();
                                            this.convert(buf, symbolOrAST, Integer.MIN_VALUE, false);
                                            if (n == 1) {
                                                this.append(buf, "'");
                                            } else if (n == 2) {
                                                this.append(buf, "''");
                                            }
                                            this.convertArgs(buf, symbolOrAST, list);
                                            return;
                                        }
                                    }
                                    catch (ArithmeticException n) {
                                        // empty catch block
                                    }
                                }
                            }
                            this.convert(buf, header, Integer.MIN_VALUE, true);
                            this.append(buf, "[");
                            for (int i = 1; i < list.size(); ++i) {
                                this.convert(buf, list.get(i), Integer.MIN_VALUE, false);
                                if (i >= list.argSize()) continue;
                                this.append(buf, ",");
                            }
                            this.append(buf, "]");
                            return;
                        }
                        if (!header.isSymbol()) break block71;
                        ISymbol head = (ISymbol)header;
                        int functionID = head.ordinal();
                        if (functionID > -1) {
                            switch (functionID) {
                                case 1376: 
                                case 1380: {
                                    if (!list.isAST2()) break;
                                    this.convert(buf, list.arg1(), Integer.MIN_VALUE, false);
                                    buf.append("<->");
                                    this.convert(buf, list.arg2(), Integer.MIN_VALUE, false);
                                    return;
                                }
                                case 354: {
                                    if (!list.isAST2()) break;
                                    this.convert(buf, list.arg1(), Integer.MIN_VALUE, false);
                                    buf.append("->");
                                    this.convert(buf, list.arg2(), Integer.MIN_VALUE, false);
                                    return;
                                }
                            }
                        }
                        if ((operator = OutputFormFactory.getOperator(head)) != null) {
                            if (operator instanceof PostfixOperator) {
                                if (list.isAST1()) {
                                    this.convertPostfixOperator(buf, list, (PostfixOperator)operator, precedence);
                                    return;
                                }
                            } else if (this.convertOperator(operator, list, buf, isASTHead ? Integer.MAX_VALUE : precedence, head)) {
                                return;
                            }
                        }
                        if (functionID <= -1) break block72;
                        switch (functionID) {
                            case 644: {
                                if (list.size() <= 3 || !this.convertInequality(buf, list, precedence)) break;
                                return;
                            }
                            case 1070: {
                                if (!(list instanceof IQuantity) || !this.convertQuantityData(buf, (IQuantity)((Object)list), precedence)) break;
                                return;
                            }
                            case 1176: {
                                if (!(list instanceof ASTSeriesData) || !this.convertSeriesData(buf, (ASTSeriesData)list, precedence)) break;
                                return;
                            }
                            case 1207: {
                                if (!list.isSparseArray()) break;
                                buf.append(list.toString());
                                return;
                            }
                            case 977: {
                                this.convertArgs(buf, S.Parenthesis, list);
                                return;
                            }
                            case 786: {
                                this.convertList(buf, list, false);
                                return;
                            }
                            case 831: {
                                if (!list.isASTOrAssociation() || list.size() <= 1) break;
                                IExpr normal = list.arg1().normal(false);
                                if (normal.isList()) {
                                    IntArrayList dims = LinearAlgebra.dimensions((IAST)normal, S.List);
                                    this.convertList(buf, (IAST)normal, dims.size() >= 2);
                                    return;
                                }
                                this.convert(buf, normal, Integer.MIN_VALUE, false);
                                return;
                            }
                            case 966: {
                                if (!list.isAST1() || !list.arg1().isInteger()) break;
                                int lineNumber = list.arg1().toIntDefault();
                                if (lineNumber == -1) {
                                    buf.append("%");
                                    return;
                                }
                                if (lineNumber == -2) {
                                    buf.append("%%");
                                    return;
                                }
                                break block71;
                            }
                            case 979: {
                                if (list.size() < 3) break;
                                this.convertPart(buf, list);
                                return;
                            }
                            case 1198: {
                                if (!list.isAST1() || !list.arg1().isInteger()) break;
                                this.convertSlot(buf, list);
                                return;
                            }
                            case 1200: {
                                if (!list.isAST1() || !list.arg1().isInteger()) break;
                                this.convertSlotSequence(buf, list);
                                return;
                            }
                            case 324: 
                            case 603: {
                                if (!list.isAST1()) break;
                                this.convert(buf, list.arg1(), Integer.MIN_VALUE, false);
                                return;
                            }
                            case 355: {
                                if (!list.isDirectedInfinity()) break;
                                if (list.isAST0()) {
                                    this.append(buf, "ComplexInfinity");
                                    return;
                                }
                                if (!list.isAST1()) break;
                                if (list.arg1().isOne()) {
                                    this.append(buf, "Infinity");
                                    return;
                                }
                                if (list.arg1().isMinusOne()) {
                                    if (310 < precedence) {
                                        this.append(buf, "(");
                                    }
                                    this.append(buf, "-Infinity");
                                    if (310 < precedence) {
                                        this.append(buf, ")");
                                    }
                                    return;
                                }
                                if (list.arg1().isImaginaryUnit()) {
                                    this.append(buf, "I*Infinity");
                                    return;
                                }
                                if (!list.arg1().isNegativeImaginaryUnit()) break;
                                this.append(buf, "-I*Infinity");
                                return;
                            }
                            case 955: {
                                if (!list.isAST2() || !list.arg1().isBlank() && !list.arg1().isPattern()) break;
                                this.convert(buf, list.arg1(), Integer.MIN_VALUE, false);
                                buf.append(":");
                                this.convert(buf, list.arg2(), Integer.MIN_VALUE, false);
                                return;
                            }
                            case 257: {
                                int prec;
                                if (!list.isAST2()) break;
                                boolean isZeroRealPart = list.arg1().isZero();
                                int n = prec = isZeroRealPart ? 400 : 310;
                                if (prec < precedence) {
                                    this.append(buf, "(");
                                }
                                if (isZeroRealPart) {
                                    buf.append("I*");
                                    this.convert(buf, list.arg2(), 400, false);
                                } else {
                                    this.convert(buf, list.arg1(), 310, false);
                                    buf.append("+I*");
                                    this.convert(buf, list.arg2(), 400, false);
                                }
                                if (prec < precedence) {
                                    this.append(buf, ")");
                                }
                                return;
                            }
                            case 1096: {
                                int prec;
                                if (!list.isAST2()) break;
                                IExpr numerator = list.arg1();
                                boolean isNegative = numerator.isNegative();
                                int n = prec = isNegative ? 310 : 400;
                                if (prec < precedence) {
                                    this.append(buf, "(");
                                }
                                this.convert(buf, list.arg1(), 470, false);
                                buf.append("/");
                                this.convert(buf, list.arg2(), 470, false);
                                if (prec < precedence) {
                                    this.append(buf, ")");
                                }
                                return;
                            }
                        }
                        break block71;
                    }
                    if (list instanceof ASTRealVector || list instanceof ASTRealMatrix) {
                        this.convertList(buf, list, false);
                        return;
                    }
                }
                this.convertAST(buf, list);
                break block73;
            }
            if (o instanceof ISignedNumber) {
                this.convertNumber(buf, (ISignedNumber)o, precedence, false);
            } else if (o instanceof IComplexNum) {
                this.convertDoubleComplex(buf, (IComplexNum)o, precedence, false);
            } else if (o instanceof IComplex) {
                this.convertComplex(buf, (IComplex)o, precedence, false);
            } else if (o instanceof ISymbol) {
                this.convertSymbol(buf, (ISymbol)o);
            } else if (o instanceof IPatternObject) {
                this.convertPattern(buf, (IPatternObject)o);
            } else if (o instanceof IStringX) {
                this.convertString(buf, ((IStringX)o).toString());
            } else {
                this.convertString(buf, o.toString());
            }
        }
    }

    private void convertAssociation(Appendable buf, IAssociation association) throws IOException {
        this.append(buf, "<|");
        int size = association.size();
        if (size > 1) {
            this.convert(buf, association.getRule(1), Integer.MIN_VALUE, false);
        }
        for (int i = 2; i < size; ++i) {
            this.append(buf, ",");
            this.convert(buf, association.getRule(i), Integer.MIN_VALUE, false);
        }
        this.append(buf, "|>");
    }

    private boolean convertInequality(Appendable buf, IAST inequality, int precedence) throws IOException {
        StringBuilder tempBuffer = new StringBuilder();
        if (290 < precedence) {
            this.append((Appendable)tempBuffer, "(");
        }
        int listSize = inequality.size();
        int i = 1;
        while (i < listSize) {
            IExpr head;
            this.convert(tempBuffer, inequality.get(i++), Integer.MIN_VALUE, false);
            if (i == listSize) {
                if (290 < precedence) {
                    this.append((Appendable)tempBuffer, ")");
                }
                buf.append(tempBuffer);
                return true;
            }
            if ((head = inequality.get(i++)).isBuiltInSymbol()) {
                int id = ((IBuiltInSymbol)head).ordinal();
                switch (id) {
                    case 423: {
                        tempBuffer.append("==");
                        break;
                    }
                    case 571: {
                        tempBuffer.append(">");
                        break;
                    }
                    case 572: {
                        tempBuffer.append(">=");
                        break;
                    }
                    case 753: {
                        tempBuffer.append("<");
                        break;
                    }
                    case 754: {
                        tempBuffer.append("<=");
                        break;
                    }
                    case 1381: {
                        tempBuffer.append("!=");
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                continue;
            }
            return false;
        }
        if (290 < precedence) {
            this.append((Appendable)tempBuffer, ")");
        }
        buf.append(tempBuffer);
        return true;
    }

    private boolean convertOperator(Operator operator, IAST list, Appendable buf, int precedence, ISymbol head) throws IOException {
        if (operator instanceof PrefixOperator && list.isAST1()) {
            this.convertPrefixOperator(buf, list, (PrefixOperator)operator, precedence);
            return true;
        }
        if (operator instanceof InfixOperator && list.size() > 2) {
            InfixOperator infixOperator = (InfixOperator)operator;
            if (head.equals(S.Plus)) {
                if (this.fPlusReversed) {
                    this.convertPlusOperatorReversed(buf, list, infixOperator, precedence);
                } else {
                    this.convertPlusOperator(buf, list, infixOperator, precedence);
                }
                return true;
            }
            if (head.equals(S.Times)) {
                this.convertTimesFraction(buf, list, infixOperator, precedence, false);
                return true;
            }
            if (list.isPower()) {
                this.convertPowerOperator(buf, list, infixOperator, precedence);
                return true;
            }
            if (list.isAST(S.Apply)) {
                if (list.size() == 3) {
                    this.convertInfixOperator(buf, list, (InfixOperator)ASTNodeFactory.APPLY_OPERATOR, precedence);
                    return true;
                }
                if (list.size() == 4 && list.arg2().equals(F.CListC1)) {
                    this.convertInfixOperator(buf, list, (InfixOperator)ASTNodeFactory.APPLY_LEVEL_OPERATOR, precedence);
                    return true;
                }
                return false;
            }
            if (list.size() != 3 && infixOperator.getGrouping() != 0) {
                return false;
            }
            this.convertInfixOperator(buf, list, (InfixOperator)operator, precedence);
            return true;
        }
        if (operator instanceof PostfixOperator && list.isAST1()) {
            this.convertPostfixOperator(buf, list, (PostfixOperator)operator, precedence);
            return true;
        }
        return false;
    }

    public static Operator getOperator(ISymbol head) {
        String str;
        String headerStr = head.getSymbolName();
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && head.getContext().equals(Context.SYSTEM) && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(headerStr)) != null) {
            headerStr = str;
        }
        Operator operator = ASTNodeFactory.MMA_STYLE_FACTORY.get(headerStr);
        return operator;
    }

    public void convertSlot(Appendable buf, IAST list) throws IOException {
        try {
            int slot = ((ISignedNumber)list.arg1()).toInt();
            this.append(buf, "#" + slot);
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void convertSlotSequence(Appendable buf, IAST list) throws IOException {
        try {
            int slotSequenceStartPosition = ((ISignedNumber)list.arg1()).toInt();
            this.append(buf, "##" + slotSequenceStartPosition);
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void convertList(Appendable buf, IAST list, boolean isMatrix) throws IOException {
        if (list instanceof ASTRealVector) {
            try {
                RealVector vector = ((ASTRealVector)list).getRealVector();
                buf.append('{');
                int size = vector.getDimension();
                for (int i = 0; i < size; ++i) {
                    this.convertDouble(buf, vector.getEntry(i));
                    if (i >= size - 1) continue;
                    buf.append(",");
                }
                buf.append('}');
            }
            catch (IOException e) {
                LOGGER.debug("OutputFormFactory.convertList() failed", (Throwable)e);
            }
            return;
        }
        if (list instanceof ASTRealMatrix) {
            try {
                RealMatrix matrix = ((ASTRealMatrix)list).getRealMatrix();
                buf.append('{');
                int rows = matrix.getRowDimension();
                int cols = matrix.getColumnDimension();
                for (int i = 0; i < rows; ++i) {
                    if (i != 0) {
                        buf.append(" ");
                    }
                    buf.append("{");
                    for (int j = 0; j < cols; ++j) {
                        this.convertDouble(buf, matrix.getEntry(i, j));
                        if (j >= cols - 1) continue;
                        buf.append(",");
                    }
                    buf.append('}');
                    if (i >= rows - 1) continue;
                    buf.append(",");
                    buf.append('\n');
                }
                buf.append('}');
            }
            catch (IOException e) {
                LOGGER.debug("OutputFormFactory.convertList() failed", (Throwable)e);
            }
            return;
        }
        if ((list.isEvalFlagOn(32) || isMatrix) && !this.fEmpty) {
            this.newLine(buf);
        }
        this.append(buf, "{");
        int listSize = list.size();
        if (listSize > 1) {
            this.convert(buf, list.arg1(), Integer.MIN_VALUE, false);
        }
        for (int i = 2; i < listSize; ++i) {
            this.append(buf, ",");
            if (list.isEvalFlagOn(32) || isMatrix) {
                this.newLine(buf);
                this.append(buf, ' ');
            }
            this.convert(buf, list.get(i), Integer.MIN_VALUE, false);
        }
        this.append(buf, "}");
    }

    public void convertPart(Appendable buf, IAST list) throws IOException {
        IExpr arg1 = list.arg1();
        boolean parentheses = false;
        if (arg1.isASTOrAssociation()) {
            Operator operator = OutputFormFactory.getOperator(arg1.topHead());
            if (operator != null) {
                parentheses = true;
            }
        } else if (!arg1.isSymbol()) {
            parentheses = true;
        }
        if (parentheses) {
            this.append(buf, "(");
        }
        this.convert(buf, arg1, Integer.MIN_VALUE, false);
        if (parentheses) {
            this.append(buf, ")");
        }
        this.append(buf, "[[");
        for (int i = 2; i < list.size(); ++i) {
            this.convert(buf, list.get(i), Integer.MIN_VALUE, false);
            if (i >= list.argSize()) continue;
            this.append(buf, ",");
        }
        this.append(buf, "]]");
    }

    public boolean convertSeriesData(Appendable buf, ASTSeriesData seriesData, int precedence) throws IOException {
        if (this.fInputForm) {
            IAST series = seriesData.toSeriesData();
            this.append(buf, series.toString());
            return true;
        }
        StringBuilder tempBuffer = new StringBuilder();
        if (310 < precedence) {
            this.append((Appendable)tempBuffer, "(");
        }
        try {
            IAST plusArg;
            IExpr x = seriesData.getX();
            IExpr x0 = seriesData.getX0();
            int nmin = seriesData.getNMin();
            int nmax = seriesData.getNMax();
            int order = seriesData.order();
            long den = seriesData.getDenominator();
            boolean call = false;
            if (nmax > nmin) {
                IRational exp = F.fraction(nmin, den).normalize();
                IExpr pow = x.subtract(x0).power(exp);
                call = this.convertSeriesDataArg(tempBuffer, seriesData.coefficient(nmin), pow, call);
                for (int i = nmin + 1; i < nmax; ++i) {
                    exp = F.fraction(i, den).normalize();
                    pow = x.subtract(x0).power(exp);
                    call = this.convertSeriesDataArg(tempBuffer, seriesData.coefficient(i), pow, call);
                }
            }
            if (!(plusArg = F.Power((IExpr)F.O(x.subtract(x0)), F.fraction(order, den).normalize())).isZero()) {
                this.convertPlusArgument(tempBuffer, plusArg, call);
                call = true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        if (310 < precedence) {
            this.append((Appendable)tempBuffer, ")");
        }
        buf.append(tempBuffer);
        return true;
    }

    public boolean convertQuantityData(Appendable buf, IQuantity quantity, int precedence) throws IOException {
        StringBuilder tempBuffer = new StringBuilder();
        if (310 < precedence) {
            this.append((Appendable)tempBuffer, "(");
        }
        try {
            buf.append(quantity.toString());
        }
        catch (Exception ex) {
            return false;
        }
        if (310 < precedence) {
            this.append((Appendable)tempBuffer, ")");
        }
        buf.append(tempBuffer);
        return true;
    }

    private boolean convertSeriesDataArg(StringBuilder buf, IExpr coefficient, IExpr pow, boolean call) throws IOException {
        IExpr plusArg;
        if (coefficient.isZero()) {
            return call;
        }
        if (coefficient.isOne()) {
            if (pow.isPlus()) {
                if (call) {
                    this.append((Appendable)buf, this.fInputForm ? " + " : "+");
                }
                this.append((Appendable)buf, "(");
                this.convertPlusArgument(buf, pow, call);
                this.append((Appendable)buf, ")");
                call = true;
                return call;
            }
            plusArg = pow;
        } else if (pow.isOne()) {
            plusArg = coefficient;
        } else {
            IASTAppendable times = F.TimesAlloc(3);
            if (coefficient.isTimes()) {
                times.appendArgs((IAST)coefficient);
            } else {
                times.append(coefficient);
            }
            times.append(pow);
            plusArg = times;
        }
        if (!plusArg.isZero()) {
            this.convertPlusArgument(buf, plusArg, call);
            call = true;
        }
        return call;
    }

    public void convertAST(Appendable buf, IAST function) throws IOException {
        IExpr head = function.head();
        this.convert(buf, head, Integer.MIN_VALUE, false);
        this.convertArgs(buf, head, function);
    }

    public void convertArgs(Appendable buf, IExpr head, IAST function) throws IOException {
        if (head.isAST()) {
            this.append(buf, "[");
        } else {
            this.append(buf, this.fRelaxedSyntax ? "(" : "[");
        }
        int functionSize = function.size();
        if (functionSize > 1) {
            this.convert(buf, function.arg1(), Integer.MIN_VALUE, false);
        }
        for (int i = 2; i < functionSize; ++i) {
            this.append(buf, ",");
            this.convert(buf, function.get(i), Integer.MIN_VALUE, false);
        }
        if (head.isAST()) {
            this.append(buf, "]");
        } else {
            this.append(buf, this.fRelaxedSyntax ? ")" : "]");
        }
    }

    private void newLine(Appendable buf) throws IOException {
        if (!this.fIgnoreNewLine) {
            this.append(buf, '\n');
        }
        this.fColumnCounter = 0;
        this.fEmpty = false;
    }

    protected void append(Appendable buf, String str) throws IOException {
        buf.append(str);
        this.fColumnCounter += str.length();
        this.fEmpty = false;
    }

    private void append(Appendable buf, char c) throws IOException {
        buf.append(c);
        ++this.fColumnCounter;
        this.fEmpty = false;
    }

    public void setIgnoreNewLine(boolean ignoreNewLine) {
        this.fIgnoreNewLine = ignoreNewLine;
    }

    public void setInputForm(boolean inputForm) {
        this.fInputForm = inputForm;
    }

    public void setEmpty(boolean empty) {
        this.fEmpty = empty;
    }

    public int getColumnCounter() {
        return this.fColumnCounter;
    }

    public void setColumnCounter(int columnCounter) {
        this.fColumnCounter = columnCounter;
    }
}

