/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.output;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Arithmetic;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.output.DoubleFormFactory;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.operator.Operator;

public class JavaScriptFormFactory
extends DoubleFormFactory {
    public static final int USE_PURE_JS = 1;
    public static final int USE_MATHCELL = 2;
    public boolean INLINE_PIECEWISE = false;
    private final int javascriptFlavor;
    private List<String> sliderNames = new ArrayList<String>();
    private List<String> variableNames = new ArrayList<String>();
    private static final Map<ISymbol, String> FUNCTIONS_STR_MATHCELL = new HashMap<ISymbol, String>();
    private static final Map<ISymbol, String> FUNCTIONS_STR_PURE_JS = new HashMap<ISymbol, String>();

    public JavaScriptFormFactory(boolean relaxedSyntax, boolean reversed, int exponentFigures, int significantFigures) {
        this(relaxedSyntax, reversed, exponentFigures, significantFigures, 1);
    }

    public JavaScriptFormFactory(boolean relaxedSyntax, boolean reversed, int exponentFigures, int significantFigures, int javascriptFlavor) {
        super(relaxedSyntax, reversed, exponentFigures, significantFigures);
        this.javascriptFlavor = javascriptFlavor;
    }

    public void appendSlider(String sliderName) {
        this.sliderNames.add(sliderName);
    }

    public void setVariables(ISymbol sliderName) {
        this.variableNames.clear();
        this.variableNames.add(sliderName.toString());
    }

    public static JavaScriptFormFactory get(boolean relaxedSyntax) {
        return JavaScriptFormFactory.get(relaxedSyntax, false);
    }

    public static JavaScriptFormFactory get(boolean relaxedSyntax, boolean plusReversed) {
        return JavaScriptFormFactory.get(relaxedSyntax, plusReversed, -1, -1);
    }

    public static JavaScriptFormFactory get(boolean relaxedSyntax, boolean plusReversed, int exponentFigures, int significantFigures) {
        return new JavaScriptFormFactory(relaxedSyntax, plusReversed, exponentFigures, significantFigures);
    }

    @Override
    public String functionHead(ISymbol symbol) {
        if (this.javascriptFlavor == 2) {
            return FUNCTIONS_STR_MATHCELL.get(symbol);
        }
        return FUNCTIONS_STR_PURE_JS.get(symbol);
    }

    @Override
    public void convertSymbol(StringBuilder buf, ISymbol symbol) {
        String str;
        if (symbol.isBuiltInSymbol() && (str = this.functionHead(symbol)) != null) {
            buf.append(str);
            return;
        }
        if (this.sliderNames != null && this.sliderNames.contains(symbol.toString())) {
            buf.append(symbol.toString() + ".Value()");
            return;
        }
        if (symbol == S.Indeterminate) {
            buf.append("Number.NaN");
            return;
        }
        super.convertSymbol(buf, symbol);
    }

    public static JavaScriptFormFactory get() {
        return JavaScriptFormFactory.get(false);
    }

    @Override
    public void convertAST(StringBuilder buf, IAST function) {
        IAST piecewiseExpand;
        int[] dim;
        IExpr head;
        if (function.isNumericFunction(true)) {
            try {
                double value = EvalEngine.get().evalDouble(function);
                buf.append("(" + value + ")");
                return;
            }
            catch (RuntimeException value) {
                // empty catch block
            }
        }
        if ((head = function.head()).isSymbol()) {
            String str = this.functionHead((ISymbol)head);
            if (str != null) {
                if (function.isASTSizeGE(S.Round, 3)) {
                    throw new ArgumentTypeException("Cannot convert to JavaScript: " + function.toString());
                }
                if (function.isAST(S.ArcTan, 3)) {
                    IASTMutable arcTan2 = function.copy();
                    arcTan2.set(1, function.arg2());
                    arcTan2.set(2, function.arg1());
                    buf.append("Math.atan2");
                    this.convertArgs(buf, head, arcTan2);
                    return;
                }
                buf.append(str);
                this.convertArgs(buf, head, function);
                return;
            }
            if (this.javascriptFlavor == 2 && function.headID() < 0) {
                if (Config.FUZZY_PARSER) {
                    throw new ArgumentTypeException("Cannot convert to JavaScript. Function head: " + function.head());
                }
                buf.append("(window[");
                this.convertInternal(buf, head);
                buf.append("](");
                this.convertArgs(buf, head, function);
                buf.append("))");
                return;
            }
        }
        if (function.isList()) {
            buf.append("[");
            for (int i = 1; i < function.size(); ++i) {
                this.convertInternal(buf, function.get(i));
                if (i >= function.size() - 1) continue;
                buf.append(",");
            }
            buf.append("]");
            return;
        }
        if (function.isAST(S.Defer, 2) || function.isAST(S.Evaluate, 2) || function.isAST(S.Hold, 2) || function.isUnevaluated()) {
            this.convertInternal(buf, function.first());
            return;
        }
        if (this.javascriptFlavor == 2) {
            int[] dim2;
            if (function.isPlus() || function.isTimes()) {
                if (function.size() >= 3) {
                    int i;
                    for (i = 1; i < function.size() - 1; ++i) {
                        if (function.isPlus()) {
                            buf.append("add(");
                            continue;
                        }
                        buf.append("mul(");
                    }
                    this.convertInternal(buf, function.arg1());
                    buf.append(",");
                    for (i = 2; i < function.size(); ++i) {
                        this.convertInternal(buf, function.get(i));
                        buf.append(")");
                        if (i >= function.size() - 1) continue;
                        buf.append(",");
                    }
                    return;
                }
            } else {
                if (function.isPower()) {
                    this.convertPowerMathcell(buf, function);
                    return;
                }
                if (function.isInfinity()) {
                    buf.append("Number.POSITIVE_INFINITY");
                    return;
                }
                if (function.isNegativeInfinity()) {
                    buf.append("Number.NEGATIVE_INFINITY");
                    return;
                }
                if (function.head() == S.Log) {
                    IExpr arg1;
                    if (function.isAST1()) {
                        arg1 = function.first();
                        buf.append("log(");
                        this.convertInternal(buf, arg1);
                        buf.append(", Math.E)");
                        return;
                    }
                    if (function.isAST2()) {
                        arg1 = function.first();
                        IExpr arg2 = function.second();
                        buf.append("log(");
                        this.convertInternal(buf, arg1);
                        buf.append(", ");
                        this.convertInternal(buf, arg2);
                        buf.append(")");
                        return;
                    }
                } else if (function.head() == S.Piecewise && function.size() > 1) {
                    dim = function.isPiecewise();
                    if (dim != null && this.convertPiecewise(dim, function, buf)) {
                        return;
                    }
                } else {
                    if (function.head() == S.ConditionalExpression && function.size() == 3) {
                        this.convertConditionalExpression(function, buf);
                        return;
                    }
                    if (function.head() == S.HeavisideTheta && function.size() >= 2) {
                        this.convertHeavisideTheta(function, buf);
                        return;
                    }
                }
            }
            if ((dim2 = (piecewiseExpand = Arithmetic.piecewiseExpand(function, S.Reals)).isPiecewise()) != null && this.convertPiecewise(dim2, piecewiseExpand, buf)) {
                return;
            }
        } else {
            int[] dim3;
            if (function.isPower()) {
                this.convertPower(buf, function);
                return;
            }
            if (function.isInfinity()) {
                buf.append("Number.POSITIVE_INFINITY");
                return;
            }
            if (function.isNegativeInfinity()) {
                buf.append("Number.NEGATIVE_INFINITY");
                return;
            }
            if (function.head() == S.Piecewise && function.size() > 1) {
                dim = function.isPiecewise();
                if (dim != null && this.convertPiecewise(dim, function, buf)) {
                    return;
                }
            } else {
                if (function.head() == S.ConditionalExpression && function.size() == 3) {
                    this.convertConditionalExpression(function, buf);
                    return;
                }
                if (function.head() == S.Cot && function.size() == 2) {
                    buf.append("(1/Math.tan(");
                    this.convertInternal(buf, function.arg1());
                    buf.append("))");
                    return;
                }
                if (function.head() == S.ArcCot && function.size() == 2) {
                    buf.append("((Math.PI/2.0)-Math.atan(");
                    this.convertInternal(buf, function.arg1());
                    buf.append("))");
                    return;
                }
            }
            if ((dim3 = (piecewiseExpand = Arithmetic.piecewiseExpand(function, S.Reals)).isPiecewise()) != null && this.convertPiecewise(dim3, piecewiseExpand, buf)) {
                return;
            }
        }
        if (function.head() == S.If && function.size() >= 3 && function.size() <= 4) {
            buf.append("((");
            this.convertInternal(buf, function.arg1());
            buf.append(") ? (");
            this.convertInternal(buf, function.arg2());
            buf.append(") : ( ");
            if (function.size() == 4) {
                this.convertInternal(buf, function.arg3());
            } else {
                buf.append("Number.NaN");
            }
            buf.append(" ))");
            return;
        }
        if (function.isAST(S.Missing)) {
            buf.append("Number.NaN");
            return;
        }
        if (function.headID() > 0) {
            throw new ArgumentTypeException("Cannot convert to JavaScript. Function head: " + function.head());
        }
        this.convertInternal(buf, head);
        this.convertArgs(buf, head, function);
    }

    private void convertPower(StringBuilder buf, IAST powerAST) {
        IExpr base = powerAST.base();
        IExpr exponent = powerAST.exponent();
        if (exponent.isMinusOne()) {
            buf.append("1.0/(");
            this.convertInternal(buf, base);
            buf.append(")");
            return;
        }
        if (exponent.isNumEqualRational(F.C1D2)) {
            buf.append("Math.sqrt(");
            this.convertInternal(buf, base);
            buf.append(")");
            return;
        }
        if (exponent.isNumEqualRational(F.C1D3)) {
            buf.append("Math.cbrt(");
            this.convertInternal(buf, base);
            buf.append(")");
            return;
        }
        buf.append("Math.pow");
        this.convertArgs(buf, powerAST.head(), powerAST);
    }

    private void convertPowerMathcell(StringBuilder buf, IAST powerAST) {
        IExpr base = powerAST.base();
        IExpr exponent = powerAST.exponent();
        if (exponent.isMinusOne()) {
            buf.append("inv(");
            this.convertInternal(buf, base);
            buf.append(")");
            return;
        }
        if (exponent.isNumEqualRational(F.C1D2)) {
            buf.append("sqrt(");
            this.convertInternal(buf, base);
            buf.append(")");
            return;
        }
        buf.append("pow");
        this.convertArgs(buf, powerAST.head(), powerAST);
    }

    private void convertConditionalExpression(IAST function, StringBuilder buf) {
        IExpr arg1 = function.arg1();
        IExpr arg2 = function.arg2();
        buf.append("((");
        this.convertInternal(buf, arg2);
        buf.append(") ? (");
        this.convertInternal(buf, arg1);
        buf.append(") : ( Number.NaN ))");
    }

    private void convertHeavisideTheta(IAST function, StringBuilder buf) {
        IExpr arg1 = function.arg1();
        buf.append("((");
        this.convertInternal(buf, arg1);
        buf.append(" > 0 ) ");
        for (int i = 2; i < function.size(); ++i) {
            buf.append("&& (");
            this.convertInternal(buf, function.get(i));
            buf.append(" > 0 ) ");
        }
        buf.append("? 1:0)");
    }

    private boolean convertPiecewise(int[] dim, IAST function, StringBuilder buffer) {
        IAST list = (IAST)function.arg1();
        IExpr last = function.size() == 3 ? function.arg2() : F.C0;
        StringBuilder piecewiseBuffer = new StringBuilder();
        if (this.INLINE_PIECEWISE) {
            int i;
            int size = list.size();
            piecewiseBuffer.append("(");
            int countOpen = 0;
            for (i = 1; i < size; ++i) {
                IExpr arg = list.get(i);
                if (arg.isList2()) {
                    IAST row = (IAST)arg;
                    if (i > 1) {
                        piecewiseBuffer.append("(");
                        ++countOpen;
                    }
                    piecewiseBuffer.append("(");
                    this.convertInternal(piecewiseBuffer, row.second());
                    piecewiseBuffer.append(") ? ");
                    this.convertInternal(piecewiseBuffer, row.first());
                    piecewiseBuffer.append(" : ");
                    continue;
                }
                if (i == size - 1) {
                    last = arg;
                    continue;
                }
                return false;
            }
            piecewiseBuffer.append("( ");
            this.convertInternal(piecewiseBuffer, last);
            piecewiseBuffer.append(" )");
            for (i = 0; i < countOpen; ++i) {
                piecewiseBuffer.append(" )");
            }
            piecewiseBuffer.append(")");
            buffer.append((CharSequence)piecewiseBuffer);
            return true;
        }
        piecewiseBuffer.append("\n (function(");
        this.appendVariables(piecewiseBuffer);
        piecewiseBuffer.append(") {");
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            IExpr arg = list.get(i);
            if (arg.isList2()) {
                IAST row = (IAST)arg;
                piecewiseBuffer.append("\nif (");
                this.convertInternal(piecewiseBuffer, row.second());
                piecewiseBuffer.append(") {");
                piecewiseBuffer.append(" return ");
                this.convertInternal(piecewiseBuffer, row.first());
                piecewiseBuffer.append(";}");
                continue;
            }
            if (i == size - 1) {
                last = arg;
                continue;
            }
            return false;
        }
        piecewiseBuffer.append("\n return ");
        this.convertInternal(piecewiseBuffer, last);
        piecewiseBuffer.append(";})(");
        this.appendVariables(piecewiseBuffer);
        piecewiseBuffer.append(")\n");
        buffer.append((CharSequence)piecewiseBuffer);
        return true;
    }

    private void appendVariables(StringBuilder buf) {
        for (int i = 0; i < this.variableNames.size(); ++i) {
            buf.append(this.variableNames.get(i));
            if (i >= this.variableNames.size() - 1) continue;
            buf.append(",");
        }
    }

    @Override
    protected boolean convertOperator(Operator operator, IAST list, StringBuilder buf, int precedence, ISymbol head) {
        if (!super.convertOperator(operator, list, buf, precedence, head)) {
            if (this.javascriptFlavor == 2) {
                this.convertAST(buf, list);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Operator getOperator(ISymbol head) {
        if (this.javascriptFlavor == 2) {
            if (head.isSymbolID(423, 1381, 753, 754, 571, 572, 63, 958, 922)) {
                return OutputFormFactory.getOperator(head);
            }
            return null;
        }
        return super.getOperator(head);
    }

    @Override
    public void convertComplex(StringBuilder buf, IComplex c, int precedence, boolean caller) {
        buf.append("complex(");
        this.convertFraction(buf, c.getRealPart(), 0, false);
        buf.append(",");
        this.convertFraction(buf, c.getImaginaryPart(), 0, false);
        buf.append(")");
    }

    @Override
    public void convertDoubleComplex(StringBuilder buf, IComplexNum dc, int precedence, boolean caller) {
        buf.append("complex(");
        this.convertDoubleString(buf, this.convertDoubleToFormattedString(dc.getRealPart()), 0, false);
        buf.append(",");
        this.convertDoubleString(buf, this.convertDoubleToFormattedString(dc.getImaginaryPart()), 0, false);
        buf.append(")");
    }

    static {
        FUNCTIONS_STR_MATHCELL.put(S.BetaRegularized, "betaRegularized");
        FUNCTIONS_STR_MATHCELL.put(S.AiryAi, "airyAi");
        FUNCTIONS_STR_MATHCELL.put(S.AiryBi, "airyBi");
        FUNCTIONS_STR_MATHCELL.put(S.DirichletEta, "dirichletEta");
        FUNCTIONS_STR_MATHCELL.put(S.HankelH1, "hankel1");
        FUNCTIONS_STR_MATHCELL.put(S.HankelH2, "hankel2");
        FUNCTIONS_STR_MATHCELL.put(S.GammaRegularized, "gammaRegularized");
        FUNCTIONS_STR_MATHCELL.put(S.InverseWeierstrassP, "inverseWeierstrassP");
        FUNCTIONS_STR_MATHCELL.put(S.PolyGamma, "digamma");
        FUNCTIONS_STR_MATHCELL.put(S.SphericalBesselJ, "sphericalBesselJ");
        FUNCTIONS_STR_MATHCELL.put(S.SphericalBesselY, "sphericalBesselY");
        FUNCTIONS_STR_MATHCELL.put(S.SphericalHankelH1, "sphericalHankel1");
        FUNCTIONS_STR_MATHCELL.put(S.SphericalHankelH2, "sphericalHankel2");
        FUNCTIONS_STR_MATHCELL.put(S.WeierstrassHalfPeriods, "weierstrassHalfPeriods");
        FUNCTIONS_STR_MATHCELL.put(S.WeierstrassInvariants, "weierstrassInvariants");
        FUNCTIONS_STR_MATHCELL.put(S.WeierstrassP, "weierstrassP");
        FUNCTIONS_STR_MATHCELL.put(S.WeierstrassPPrime, "weierstrassPPrime");
        FUNCTIONS_STR_MATHCELL.put(S.WhittakerM, "whittakerM");
        FUNCTIONS_STR_MATHCELL.put(S.WhittakerW, "whittakerW");
        FUNCTIONS_STR_MATHCELL.put(S.Abs, "abs");
        FUNCTIONS_STR_MATHCELL.put(S.Arg, "arg");
        FUNCTIONS_STR_MATHCELL.put(S.Chop, "chop");
        FUNCTIONS_STR_MATHCELL.put(S.BesselJ, "besselJ");
        FUNCTIONS_STR_MATHCELL.put(S.BesselY, "besselY");
        FUNCTIONS_STR_MATHCELL.put(S.BesselI, "besselI");
        FUNCTIONS_STR_MATHCELL.put(S.BesselK, "besselK");
        FUNCTIONS_STR_MATHCELL.put(S.StruveH, "struveH");
        FUNCTIONS_STR_MATHCELL.put(S.StruveL, "struveL");
        FUNCTIONS_STR_MATHCELL.put(S.BesselJZero, "besselJZero ");
        FUNCTIONS_STR_MATHCELL.put(S.BesselYZero, "besselYZero ");
        FUNCTIONS_STR_MATHCELL.put(S.AiryAi, "airyAi");
        FUNCTIONS_STR_MATHCELL.put(S.AiryBi, "airyBi");
        FUNCTIONS_STR_MATHCELL.put(S.CarlsonRC, "carlsonRC");
        FUNCTIONS_STR_MATHCELL.put(S.CarlsonRD, "carlsonRD");
        FUNCTIONS_STR_MATHCELL.put(S.CarlsonRF, "carlsonRF");
        FUNCTIONS_STR_MATHCELL.put(S.CarlsonRG, "carlsonRG");
        FUNCTIONS_STR_MATHCELL.put(S.CarlsonRJ, "carlsonRJ");
        FUNCTIONS_STR_MATHCELL.put(S.EllipticF, "ellipticF");
        FUNCTIONS_STR_MATHCELL.put(S.EllipticK, "ellipticK");
        FUNCTIONS_STR_MATHCELL.put(S.EllipticE, "ellipticE");
        FUNCTIONS_STR_MATHCELL.put(S.EllipticPi, "ellipticPi");
        FUNCTIONS_STR_MATHCELL.put(S.EllipticTheta, "jacobiTheta");
        FUNCTIONS_STR_MATHCELL.put(S.JacobiAmplitude, "am");
        FUNCTIONS_STR_MATHCELL.put(S.JacobiCN, "cn");
        FUNCTIONS_STR_MATHCELL.put(S.JacobiDN, "dn");
        FUNCTIONS_STR_MATHCELL.put(S.JacobiSN, "sn");
        FUNCTIONS_STR_MATHCELL.put(S.JacobiZeta, "jacobiZeta");
        FUNCTIONS_STR_MATHCELL.put(S.KleinInvariantJ, "kleinJ");
        FUNCTIONS_STR_MATHCELL.put(S.Factorial, "factorial");
        FUNCTIONS_STR_MATHCELL.put(S.Factorial2, "factorial2");
        FUNCTIONS_STR_MATHCELL.put(S.Binomial, "binomial");
        FUNCTIONS_STR_MATHCELL.put(S.LogGamma, "logGamma");
        FUNCTIONS_STR_MATHCELL.put(S.Gamma, "gamma");
        FUNCTIONS_STR_MATHCELL.put(S.Beta, "beta");
        FUNCTIONS_STR_MATHCELL.put(S.Erf, "erf");
        FUNCTIONS_STR_MATHCELL.put(S.Erfc, "erfc");
        FUNCTIONS_STR_MATHCELL.put(S.FresnelC, "fresnelC");
        FUNCTIONS_STR_MATHCELL.put(S.FresnelS, "fresnelS");
        FUNCTIONS_STR_MATHCELL.put(S.Gudermannian, "gudermannian");
        FUNCTIONS_STR_MATHCELL.put(S.InverseGudermannian, "inverseGudermannian");
        FUNCTIONS_STR_MATHCELL.put(S.Haversine, "haversine");
        FUNCTIONS_STR_MATHCELL.put(S.InverseHaversine, "inverseHaversine");
        FUNCTIONS_STR_MATHCELL.put(S.PolyLog, "polylog");
        FUNCTIONS_STR_MATHCELL.put(S.CosIntegral, "cosIntegral");
        FUNCTIONS_STR_MATHCELL.put(S.CoshIntegral, "coshIntegral");
        FUNCTIONS_STR_MATHCELL.put(S.LogIntegral, "logIntegral");
        FUNCTIONS_STR_MATHCELL.put(S.SinIntegral, "sinIntegral");
        FUNCTIONS_STR_MATHCELL.put(S.SinhIntegral, "sinhIntegral");
        FUNCTIONS_STR_MATHCELL.put(S.ExpIntegralEi, "expIntegralEi");
        FUNCTIONS_STR_MATHCELL.put(S.ExpIntegralE, "expIntegralE");
        FUNCTIONS_STR_MATHCELL.put(S.Hypergeometric0F1, "hypergeometric0F1");
        FUNCTIONS_STR_MATHCELL.put(S.Hypergeometric1F1, "hypergeometric1F1");
        FUNCTIONS_STR_MATHCELL.put(S.Hypergeometric2F1, "hypergeometric2F1");
        FUNCTIONS_STR_MATHCELL.put(S.HypergeometricPFQ, "hypergeometricPFQ");
        FUNCTIONS_STR_MATHCELL.put(S.Exp, "exp");
        FUNCTIONS_STR_MATHCELL.put(S.Im, "im");
        FUNCTIONS_STR_MATHCELL.put(S.Log, "log");
        FUNCTIONS_STR_MATHCELL.put(S.Re, "re");
        FUNCTIONS_STR_MATHCELL.put(S.ProductLog, "lambertW");
        FUNCTIONS_STR_MATHCELL.put(S.KroneckerDelta, "kronecker");
        FUNCTIONS_STR_MATHCELL.put(S.HermiteH, "hermite");
        FUNCTIONS_STR_MATHCELL.put(S.LaguerreL, "laguerre");
        FUNCTIONS_STR_MATHCELL.put(S.ChebyshevT, "chebyshevT");
        FUNCTIONS_STR_MATHCELL.put(S.ChebyshevU, "chebyshevU");
        FUNCTIONS_STR_MATHCELL.put(S.LegendreP, "legendreP");
        FUNCTIONS_STR_MATHCELL.put(S.LegendreQ, "legendreQ");
        FUNCTIONS_STR_MATHCELL.put(S.Sin, "sin");
        FUNCTIONS_STR_MATHCELL.put(S.Cos, "cos");
        FUNCTIONS_STR_MATHCELL.put(S.Tan, "tan");
        FUNCTIONS_STR_MATHCELL.put(S.Cot, "cot");
        FUNCTIONS_STR_MATHCELL.put(S.Sec, "sec");
        FUNCTIONS_STR_MATHCELL.put(S.Csc, "csc");
        FUNCTIONS_STR_MATHCELL.put(S.ArcSin, "arcsin");
        FUNCTIONS_STR_MATHCELL.put(S.ArcCos, "arccos");
        FUNCTIONS_STR_MATHCELL.put(S.ArcTan, "arctan");
        FUNCTIONS_STR_MATHCELL.put(S.ArcCot, "arccot");
        FUNCTIONS_STR_MATHCELL.put(S.ArcSec, "arcsec");
        FUNCTIONS_STR_MATHCELL.put(S.ArcCsc, "arccsc");
        FUNCTIONS_STR_MATHCELL.put(S.Sinh, "sinh");
        FUNCTIONS_STR_MATHCELL.put(S.Cosh, "cosh");
        FUNCTIONS_STR_MATHCELL.put(S.Tanh, "tanh");
        FUNCTIONS_STR_MATHCELL.put(S.Coth, "coth");
        FUNCTIONS_STR_MATHCELL.put(S.Sech, "sech");
        FUNCTIONS_STR_MATHCELL.put(S.Csch, "csch");
        FUNCTIONS_STR_MATHCELL.put(S.ArcSinh, "arcsinh");
        FUNCTIONS_STR_MATHCELL.put(S.ArcCosh, "arccosh");
        FUNCTIONS_STR_MATHCELL.put(S.ArcTanh, "arctanh");
        FUNCTIONS_STR_MATHCELL.put(S.ArcCoth, "arccoth");
        FUNCTIONS_STR_MATHCELL.put(S.ArcSech, "arcsech");
        FUNCTIONS_STR_MATHCELL.put(S.ArcCsch, "arccsch");
        FUNCTIONS_STR_MATHCELL.put(S.Sinc, "sinc");
        FUNCTIONS_STR_MATHCELL.put(S.HurwitzZeta, "hurwitzZeta");
        FUNCTIONS_STR_MATHCELL.put(S.Zeta, "zeta");
        FUNCTIONS_STR_MATHCELL.put(S.BernoulliB, "bernoulli");
        FUNCTIONS_STR_MATHCELL.put(S.Ceiling, "ceiling");
        FUNCTIONS_STR_MATHCELL.put(S.Floor, "floor");
        FUNCTIONS_STR_MATHCELL.put(S.KroneckerDelta, "kronecker");
        FUNCTIONS_STR_MATHCELL.put(S.Round, "round");
        FUNCTIONS_STR_MATHCELL.put(S.IntegerPart, "integerPart");
        FUNCTIONS_STR_MATHCELL.put(S.FractionalPart, "fractionalPart");
        FUNCTIONS_STR_MATHCELL.put(S.Sign, "sign");
        FUNCTIONS_STR_MATHCELL.put(S.Max, "Math.max");
        FUNCTIONS_STR_MATHCELL.put(S.Min, "Math.min");
        FUNCTIONS_STR_MATHCELL.put(S.Surd, "surd");
        FUNCTIONS_STR_MATHCELL.put(S.Root, "root");
        FUNCTIONS_STR_PURE_JS.put(S.Abs, "Math.abs");
        FUNCTIONS_STR_PURE_JS.put(S.ArcCos, "Math.acos");
        FUNCTIONS_STR_PURE_JS.put(S.ArcCosh, "Math.acosh");
        FUNCTIONS_STR_PURE_JS.put(S.ArcSin, "Math.asin");
        FUNCTIONS_STR_PURE_JS.put(S.ArcSinh, "Math.asinh");
        FUNCTIONS_STR_PURE_JS.put(S.ArcTan, "Math.atan");
        FUNCTIONS_STR_PURE_JS.put(S.ArcTanh, "Math.atanh");
        FUNCTIONS_STR_PURE_JS.put(S.Ceiling, "Math.ceil");
        FUNCTIONS_STR_PURE_JS.put(S.Cos, "Math.cos");
        FUNCTIONS_STR_PURE_JS.put(S.Cosh, "Math.cosh");
        FUNCTIONS_STR_PURE_JS.put(S.Exp, "Math.exp");
        FUNCTIONS_STR_PURE_JS.put(S.Floor, "Math.floor");
        FUNCTIONS_STR_PURE_JS.put(S.IntegerPart, "Math.trunc");
        FUNCTIONS_STR_PURE_JS.put(S.Log, "Math.log");
        FUNCTIONS_STR_PURE_JS.put(S.Max, "Math.max");
        FUNCTIONS_STR_PURE_JS.put(S.Min, "Math.min");
        FUNCTIONS_STR_PURE_JS.put(S.Round, "Math.round");
        FUNCTIONS_STR_PURE_JS.put(S.Sign, "Math.sign");
        FUNCTIONS_STR_PURE_JS.put(S.Sin, "Math.sin");
        FUNCTIONS_STR_PURE_JS.put(S.Sinh, "Math.sinh");
        FUNCTIONS_STR_PURE_JS.put(S.Tan, "Math.tan");
        FUNCTIONS_STR_PURE_JS.put(S.Tanh, "Math.tanh");
    }
}

