/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.output;

import java.util.HashMap;
import java.util.Map;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.output.DoubleFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class JavaDoubleFormFactory
extends DoubleFormFactory {
    private static final Map<ISymbol, String> FUNCTIONS_STR = new HashMap<ISymbol, String>();

    private JavaDoubleFormFactory(boolean relaxedSyntax, boolean reversed, int exponentFigures, int significantFigures) {
        super(relaxedSyntax, reversed, exponentFigures, significantFigures);
    }

    public static JavaDoubleFormFactory get(boolean relaxedSyntax) {
        return JavaDoubleFormFactory.get(relaxedSyntax, false);
    }

    public static JavaDoubleFormFactory get(boolean relaxedSyntax, boolean plusReversed) {
        return JavaDoubleFormFactory.get(relaxedSyntax, plusReversed, -1, -1);
    }

    public static JavaDoubleFormFactory get(boolean relaxedSyntax, boolean plusReversed, int exponentFigures, int significantFigures) {
        return new JavaDoubleFormFactory(relaxedSyntax, plusReversed, exponentFigures, significantFigures);
    }

    @Override
    public String functionHead(ISymbol symbol) {
        return FUNCTIONS_STR.get(symbol);
    }

    public static JavaDoubleFormFactory get() {
        return JavaDoubleFormFactory.get(false);
    }

    @Override
    public void convertAST(StringBuilder buf, IAST function) {
        String str;
        IExpr head;
        if (function.isNumericFunction(true)) {
            try {
                double value = EvalEngine.get().evalDouble(function);
                buf.append("(");
                buf.append(value);
                buf.append(")");
                return;
            }
            catch (RuntimeException value) {
                // empty catch block
            }
        }
        if ((head = function.head()).isSymbol() && (str = this.functionHead((ISymbol)head)) != null) {
            buf.append(str);
            if (function.isAST(S.ArcTan, 3)) {
                buf.append("2");
            }
            this.convertArgs(buf, head, function);
            return;
        }
        if (function.headID() > 0) {
            if (function.isAST(S.Defer, 2) || function.isAST(S.Evaluate, 2) || function.isAST(S.Hold, 2) || function.isUnevaluated()) {
                this.convertInternal(buf, function.first());
                return;
            }
            if (function.isPower()) {
                IExpr base = function.base();
                IExpr exponent = function.exponent();
                if (exponent.isMinusOne()) {
                    buf.append("1.0/(");
                    this.convertInternal(buf, base);
                    buf.append(")");
                    return;
                }
                if (exponent.isNumEqualRational(F.C1D2)) {
                    buf.append("Math.sqrt(");
                    this.convertInternal(buf, base);
                    buf.append(")");
                    return;
                }
                if (exponent.isNumEqualRational(F.C1D3)) {
                    buf.append("Math.cbrt(");
                    this.convertInternal(buf, base);
                    buf.append(")");
                    return;
                }
                buf.append("Math.pow");
                this.convertArgs(buf, head, function);
                return;
            }
            buf.append("F.");
            buf.append(head.toString());
            buf.append(".ofN(");
            this.convertArgs(buf, head, function);
            buf.append(")");
            return;
        }
        if (function.isInfinity()) {
            buf.append("Double.POSITIVE_INFINITY");
            return;
        }
        if (function.isNegativeInfinity()) {
            buf.append("Double.NEGATIVE_INFINITY");
            return;
        }
        this.convertInternal(buf, head);
        this.convertArgs(buf, head, function);
    }

    static {
        FUNCTIONS_STR.put(S.Abs, "Math.abs");
        FUNCTIONS_STR.put(S.ArcCos, "Math.acos");
        FUNCTIONS_STR.put(S.ArcSin, "Math.asin");
        FUNCTIONS_STR.put(S.ArcTan, "Math.atan");
        FUNCTIONS_STR.put(S.Ceiling, "Math.ceil");
        FUNCTIONS_STR.put(S.Cos, "Math.cos");
        FUNCTIONS_STR.put(S.Cosh, "Math.cosh");
        FUNCTIONS_STR.put(S.Floor, "Math.floor");
        FUNCTIONS_STR.put(S.Log, "Math.log");
        FUNCTIONS_STR.put(S.Max, "Math.max");
        FUNCTIONS_STR.put(S.Min, "Math.min");
        FUNCTIONS_STR.put(S.Sin, "Math.sin");
        FUNCTIONS_STR.put(S.Sinh, "Math.sinh");
        FUNCTIONS_STR.put(S.Tan, "Math.tan");
        FUNCTIONS_STR.put(S.Tanh, "Math.tanh");
    }
}

