/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.output;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.output.ComplexFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class JavaComplexFormFactory
extends ComplexFormFactory {
    private static final Map<ISymbol, String> FUNCTIONS_STR = new HashMap<ISymbol, String>();

    private JavaComplexFormFactory(boolean relaxedSyntax, boolean reversed, int exponentFigures, int significantFigures) {
        this(relaxedSyntax, reversed, exponentFigures, significantFigures, false);
    }

    private JavaComplexFormFactory(boolean relaxedSyntax, boolean reversed, int exponentFigures, int significantFigures, boolean packagePrefix) {
        super(relaxedSyntax, reversed, exponentFigures, significantFigures, packagePrefix);
    }

    public static JavaComplexFormFactory get(boolean relaxedSyntax) {
        return JavaComplexFormFactory.get(relaxedSyntax, false);
    }

    public static JavaComplexFormFactory get(boolean relaxedSyntax, boolean plusReversed) {
        return JavaComplexFormFactory.get(relaxedSyntax, plusReversed, -1, -1, false);
    }

    public static JavaComplexFormFactory get(boolean relaxedSyntax, boolean plusReversed, int exponentFigures, int significantFigures, boolean packagePrefix) {
        return new JavaComplexFormFactory(relaxedSyntax, plusReversed, exponentFigures, significantFigures, packagePrefix);
    }

    @Override
    public String functionHead(ISymbol symbol) {
        return FUNCTIONS_STR.get(symbol);
    }

    public static JavaComplexFormFactory get() {
        return JavaComplexFormFactory.get(false);
    }

    @Override
    public void convertAST(StringBuilder buf, IAST function) {
        String str;
        IExpr head;
        if (function.isNumericFunction(true)) {
            try {
                Complex value = EvalEngine.get().evalComplex(function);
                if (value != null) {
                    buf.append("Complex.valueOf(");
                    buf.append(value.getReal());
                    buf.append(",");
                    buf.append(value.getImaginary());
                    buf.append(")");
                    return;
                }
            }
            catch (RuntimeException value) {
                // empty catch block
            }
        }
        if ((head = function.head()).isSymbol() && function.size() > 1 && (str = this.functionHead((ISymbol)head)) != null) {
            if (function.isPower()) {
                IExpr base = function.base();
                IExpr exponent = function.exponent();
                if (exponent.isNumEqualRational(F.C1D2)) {
                    buf.append("(");
                    this.convertInternal(buf, base);
                    buf.append(").sqrt()");
                    return;
                }
                if (exponent.isNumEqualRational(F.CN1D2)) {
                    buf.append("(");
                    this.convertInternal(buf, base);
                    buf.append(").reciprocal().sqrt()");
                    return;
                }
                if (exponent.isMinusOne()) {
                    buf.append("(");
                    this.convertInternal(buf, base);
                    buf.append(").reciprocal()");
                    return;
                }
            }
            buf.append("(");
            this.convertInternal(buf, function.first());
            buf.append(")" + str);
            if (function.isAST(S.ArcTan, 3)) {
                buf.append("2");
            }
            this.convertArgs(buf, head, function, 2);
            return;
        }
        if (function.headID() > 0) {
            if (function.isAST(S.Defer, 2) || function.isAST(S.Evaluate, 2) || function.isAST(S.Hold, 2) || function.isUnevaluated()) {
                this.convertInternal(buf, function.first());
                return;
            }
            if (function.isPower()) {
                IExpr base = function.base();
                IExpr exponent = function.exponent();
                if (exponent.isMinusOne()) {
                    buf.append("1.0/(");
                    this.convertInternal(buf, base);
                    buf.append(")");
                    return;
                }
                if (exponent.isNumEqualRational(F.C1D2)) {
                    buf.append("Math.sqrt(");
                    this.convertInternal(buf, base);
                    buf.append(")");
                    return;
                }
                if (exponent.isNumEqualRational(F.C1D3)) {
                    buf.append("Math.cbrt(");
                    this.convertInternal(buf, base);
                    buf.append(")");
                    return;
                }
                buf.append("Math.pow");
                this.convertArgs(buf, head, function, 1);
                return;
            }
            buf.append("F.");
            buf.append(head.toString());
            buf.append(".ofN(");
            this.convertArgs(buf, head, function, 1);
            buf.append(")");
            return;
        }
        if (function.isInfinity()) {
            buf.append("Double.POSITIVE_INFINITY");
            return;
        }
        if (function.isNegativeInfinity()) {
            buf.append("Double.NEGATIVE_INFINITY");
            return;
        }
        this.convertInternal(buf, head);
        this.convertArgs(buf, head, function, 1);
    }

    static {
        FUNCTIONS_STR.put(S.Abs, ".abs");
        FUNCTIONS_STR.put(S.ArcCos, ".acos");
        FUNCTIONS_STR.put(S.ArcSin, ".asin");
        FUNCTIONS_STR.put(S.ArcTan, ".atan");
        FUNCTIONS_STR.put(S.Ceiling, ".ceil");
        FUNCTIONS_STR.put(S.Cos, ".cos");
        FUNCTIONS_STR.put(S.Cosh, ".cosh");
        FUNCTIONS_STR.put(S.Floor, ".floor");
        FUNCTIONS_STR.put(S.Log, ".log");
        FUNCTIONS_STR.put(S.Max, ".max");
        FUNCTIONS_STR.put(S.Min, ".min");
        FUNCTIONS_STR.put(S.Power, ".pow");
        FUNCTIONS_STR.put(S.Sin, ".sin");
        FUNCTIONS_STR.put(S.Sinh, ".sinh");
        FUNCTIONS_STR.put(S.Tan, ".tan");
        FUNCTIONS_STR.put(S.Tanh, ".tanh");
    }
}

