/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.output;

import java.math.BigInteger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Algebra;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ASTRealMatrix;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.ASTSeriesData;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.DoubleToMMA;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.tensor.qty.IQuantity;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.client.operator.ASTNodeFactory;
import org.matheclipse.parser.client.operator.InfixOperator;
import org.matheclipse.parser.client.operator.Operator;
import org.matheclipse.parser.client.operator.PostfixOperator;
import org.matheclipse.parser.client.operator.PrefixOperator;

public abstract class DoubleFormFactory {
    public static final boolean NO_PLUS_CALL = false;
    public static final boolean PLUS_CALL = true;
    protected final boolean fRelaxedSyntax;
    protected final boolean fPlusReversed;
    protected boolean fIgnoreNewLine = false;
    private boolean fQuotes = false;
    private boolean fEmpty = true;
    private int fExponentFigures;
    private int fSignificantFigures;

    public DoubleFormFactory(boolean relaxedSyntax, boolean reversed, int exponentFigures, int significantFigures) {
        this.fRelaxedSyntax = relaxedSyntax;
        this.fPlusReversed = reversed;
        this.fExponentFigures = exponentFigures;
        this.fSignificantFigures = significantFigures;
    }

    public void reset() {
    }

    public void convertDouble(StringBuilder buf, INum d, int precedence, boolean caller) {
        double doubleValue = d.doubleValue();
        this.convertDouble(buf, doubleValue, d, precedence, caller);
    }

    private void convertDouble(StringBuilder buf, double doubleValue, INum d, int precedence, boolean caller) {
        if (F.isZero(doubleValue, Config.ZERO_IN_OUTPUT_FORMAT)) {
            this.convertDoubleString(buf, this.convertDoubleToFormattedString(0.0), precedence, false);
            return;
        }
        boolean isNegative = d.isNegative();
        if (!isNegative && caller) {
            this.append(buf, "+");
        }
        if (d instanceof Num) {
            this.convertDoubleString(buf, this.convertDoubleToFormattedString(doubleValue), precedence, isNegative);
        } else {
            this.convertDoubleString(buf, DoubleFormFactory.convertApfloat(d.apfloatValue()), precedence, isNegative);
        }
    }

    private void convertDouble(StringBuilder buf, double doubleValue) {
        if (F.isZero(doubleValue, Config.ZERO_IN_OUTPUT_FORMAT)) {
            this.convertDoubleString(buf, this.convertDoubleToFormattedString(0.0), 0, false);
            return;
        }
        this.convertDoubleString(buf, this.convertDoubleToFormattedString(doubleValue), 0, false);
    }

    protected String convertDoubleToFormattedString(double dValue) {
        if (this.fSignificantFigures > 0) {
            StringBuilder buf = new StringBuilder();
            DoubleToMMA.doubleToMMA(buf, dValue, this.fExponentFigures, this.fSignificantFigures);
            return buf.toString();
        }
        return Double.toString(dValue);
    }

    protected void convertDoubleString(StringBuilder buf, String d, int precedence, boolean isNegative) {
        if (isNegative && 310 < precedence) {
            this.append(buf, "(");
        }
        this.append(buf, d);
        if (isNegative && 310 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertDoubleComplex(StringBuilder buf, IComplexNum dc, int precedence, boolean caller) {
        if (dc instanceof ApcomplexNum) {
            this.convertApcomplex(buf, ((ApcomplexNum)dc).apcomplexValue(), precedence, caller);
            return;
        }
        if (310 < precedence) {
            if (caller) {
                this.append(buf, "+");
                caller = false;
            }
            this.append(buf, "(");
        }
        double realPart = dc.getRealPart();
        double imaginaryPart = dc.getImaginaryPart();
        boolean realZero = F.isZero(realPart);
        boolean imaginaryZero = F.isZero(imaginaryPart);
        if (realZero && imaginaryZero) {
            this.convertDoubleString(buf, this.convertDoubleToFormattedString(0.0), 310, false);
        } else if (!realZero) {
            this.append(buf, this.convertDoubleToFormattedString(realPart));
            if (!imaginaryZero) {
                this.append(buf, "+I*");
                boolean isNegative = imaginaryPart < 0.0;
                this.convertDoubleString(buf, this.convertDoubleToFormattedString(imaginaryPart), 400, isNegative);
            }
        } else {
            if (caller) {
                this.append(buf, "+");
                caller = false;
            }
            this.append(buf, "I*");
            boolean isNegative = imaginaryPart < 0.0;
            this.convertDoubleString(buf, this.convertDoubleToFormattedString(imaginaryPart), 400, isNegative);
        }
        if (310 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertApcomplex(StringBuilder buf, Apcomplex dc, int precedence, boolean caller) {
        if (310 < precedence) {
            if (caller) {
                this.append(buf, "+");
                caller = false;
            }
            this.append(buf, "(");
        }
        Apfloat realPart = dc.real();
        Apfloat imaginaryPart = dc.imag();
        boolean realZero = realPart.equals((Object)Apcomplex.ZERO);
        boolean imaginaryZero = imaginaryPart.equals((Object)Apcomplex.ZERO);
        if (realZero && imaginaryZero) {
            this.convertDoubleString(buf, "0.0", 310, false);
        } else if (!realZero) {
            this.append(buf, DoubleFormFactory.convertApfloat(realPart));
            if (!imaginaryZero) {
                this.append(buf, "+I*");
                boolean isNegative = imaginaryPart.compareTo((Apfloat)Apcomplex.ZERO) < 0;
                this.convertDoubleString(buf, DoubleFormFactory.convertApfloat(imaginaryPart), 400, isNegative);
            }
        } else {
            if (caller) {
                this.append(buf, "+");
                caller = false;
            }
            this.append(buf, "I*");
            boolean isNegative = imaginaryPart.compareTo((Apfloat)Apcomplex.ZERO) < 0;
            this.convertDoubleString(buf, DoubleFormFactory.convertApfloat(imaginaryPart), 400, isNegative);
        }
        if (310 < precedence) {
            this.append(buf, ")");
        }
    }

    public static String convertApfloat(Apfloat num) {
        String str = num.toString();
        int index = str.indexOf(101);
        if (index > 0) {
            String exponentStr = str.substring(index + 1);
            String result = str.substring(0, index);
            return result + "*10^" + exponentStr;
        }
        return str;
    }

    public void convertInteger(StringBuilder buf, IInteger i, int precedence, boolean caller) {
        boolean isNegative = i.isNegative();
        if (!isNegative && caller) {
            this.append(buf, "+");
        }
        if (isNegative && 310 < precedence) {
            this.append(buf, "(");
        }
        String str = i.toBigNumerator().toString();
        this.append(buf, str);
        if (isNegative && 310 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertFraction(StringBuilder buf, IRational f, int precedence, boolean caller) {
        this.convertFraction(buf, f.toBigNumerator(), f.toBigDenominator(), precedence, caller);
    }

    public void convertFraction(StringBuilder buf, BigInteger numerator, BigInteger denominator, int precedence, boolean caller) {
        int prec;
        boolean isInteger = denominator.compareTo(BigInteger.ONE) == 0;
        boolean isNegative = numerator.compareTo(BigInteger.ZERO) < 0;
        int n = prec = isNegative ? 310 : 400;
        if (!isNegative && caller) {
            this.append(buf, "+");
        }
        if (prec < precedence) {
            this.append(buf, "(");
        }
        String str = numerator.toString();
        this.append(buf, str);
        if (!isInteger) {
            this.append(buf, "/");
            str = denominator.toString();
            this.append(buf, str);
        }
        if (prec < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertComplex(StringBuilder buf, IComplex c, int precedence, boolean caller) {
        boolean isReZero = c.getRealPart().isZero();
        boolean isImOne = c.getImaginaryPart().isOne();
        boolean isImMinusOne = c.getImaginaryPart().isMinusOne();
        if (!isReZero && 310 < precedence) {
            if (caller) {
                this.append(buf, "+");
                caller = false;
            }
            this.append(buf, "(");
        }
        if (!isReZero) {
            this.convertFraction(buf, c.getRealPart(), 310, caller);
        }
        if (isImOne) {
            if (isReZero) {
                if (caller) {
                    this.append(buf, "+");
                    caller = false;
                }
                this.append(buf, "I");
                return;
            }
            this.append(buf, "+I");
        } else if (isImMinusOne) {
            this.append(buf, "-I");
        } else {
            IRational im = c.getImaginaryPart();
            StringBuilder imagBuf = new StringBuilder();
            if (im.isNegative()) {
                if (isReZero && 400 < precedence) {
                    this.append(buf, "(");
                }
                this.append(buf, "-");
                this.append(imagBuf, "I*");
                this.convertFraction(imagBuf, im.negate(), 400, false);
            } else {
                if (isReZero) {
                    if (caller) {
                        this.append(buf, "+");
                    }
                    if (400 < precedence) {
                        this.append(buf, "(");
                    }
                    this.append(imagBuf, "I*");
                } else {
                    this.append(buf, "+");
                    this.append(imagBuf, "I*");
                }
                this.convertFraction(imagBuf, im, 400, false);
            }
            String str = imagBuf.toString();
            this.append(buf, str);
            if (isReZero && 400 < precedence) {
                this.append(buf, ")");
            }
        }
        if (!isReZero && 310 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertString(StringBuilder buf, String str) {
        if (this.fQuotes) {
            this.append(buf, "\"");
            this.append(buf, str);
            this.append(buf, "\"");
        } else {
            this.append(buf, str);
        }
    }

    public void convertSymbol(StringBuilder buf, ISymbol symbol) {
        String str;
        Context context;
        if (symbol == S.E) {
            buf.append("Math.E");
            return;
        }
        if (symbol == S.Pi) {
            buf.append("Math.PI");
            return;
        }
        if (symbol == S.False) {
            buf.append("false");
            return;
        }
        if (symbol == S.True) {
            buf.append("true");
            return;
        }
        if (symbol == S.Indeterminate) {
            buf.append("Double.NaN");
            return;
        }
        if (symbol.isConstantAttribute()) {
            try {
                double value = EvalEngine.get().evalDouble(symbol);
                buf.append("(" + value + ")");
                return;
            }
            catch (RuntimeException value) {
                // empty catch block
            }
        }
        if ((context = symbol.getContext()) == Context.DUMMY) {
            this.append(buf, symbol.getSymbolName());
            return;
        }
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && context.equals(Context.SYSTEM) && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(symbol.getSymbolName())) != null) {
            this.append(buf, str);
            return;
        }
        if (EvalEngine.get().getContextPath().contains(context)) {
            this.append(buf, symbol.getSymbolName());
        } else {
            this.append(buf, context.completeContextName() + symbol.getSymbolName());
        }
    }

    public void convertPattern(StringBuilder buf, IPatternObject pattern) {
        this.append(buf, pattern.toString());
    }

    public void convertHead(StringBuilder buf, IExpr obj) {
        this.convertInternal(buf, obj);
    }

    private void convertPlusOperator(StringBuilder buf, IAST plusAST, InfixOperator oper, int precedence) {
        int size;
        int operPrecedence = oper.getPrecedence();
        if (operPrecedence < precedence) {
            this.append(buf, "(");
        }
        if ((size = plusAST.size()) > 0) {
            this.convertPlusArgument(buf, plusAST.arg1(), false);
            for (int i = 2; i < size; ++i) {
                IExpr plusArg = plusAST.get(i);
                this.convertPlusArgument(buf, plusArg, true);
            }
        }
        if (operPrecedence < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertPlusArgument(StringBuilder buf, IExpr plusArg, boolean caller) {
        if (plusArg.isTimes()) {
            IAST timesAST = (IAST)plusArg;
            InfixOperator TIMES_OPERATOR = (InfixOperator)ASTNodeFactory.MMA_STYLE_FACTORY.get("Times");
            this.convertTimesFraction(buf, timesAST, TIMES_OPERATOR, 400, caller);
        } else if (plusArg.isNegativeSigned()) {
            this.convertInternal(buf, plusArg);
        } else {
            if (caller) {
                this.append(buf, "+");
            }
            this.convertInternal(buf, plusArg, 310, false);
        }
    }

    private void convertPlusOperatorReversed(StringBuilder buf, IAST plusAST, InfixOperator oper, int precedence) {
        int size;
        int operPrecedence = oper.getPrecedence();
        if (operPrecedence < precedence) {
            this.append(buf, "(");
        }
        String operatorStr = oper.getOperatorString();
        for (int i = size = plusAST.argSize(); i > 0; --i) {
            IExpr plusArg = plusAST.get(i);
            if (plusArg.isTimes()) {
                String multCh = ASTNodeFactory.MMA_STYLE_FACTORY.get("Times").getOperatorString();
                boolean showOperator = true;
                IAST timesAST = (IAST)plusArg;
                IExpr arg1 = timesAST.arg1();
                if (arg1.isNumber() && ((INumber)arg1).complexSign() < 0) {
                    if (((INumber)arg1).isOne()) {
                        showOperator = false;
                    } else if (arg1.isMinusOne()) {
                        this.append(buf, "-");
                        showOperator = false;
                    } else {
                        this.convertNumber(buf, (INumber)arg1, operPrecedence, false);
                    }
                } else {
                    if (i < size) {
                        this.append(buf, operatorStr);
                    }
                    this.convertInternal(buf, arg1, 400, false);
                }
                for (int j = 2; j < timesAST.size(); ++j) {
                    IExpr timesArg = timesAST.get(j);
                    if (showOperator) {
                        this.append(buf, multCh);
                    } else {
                        showOperator = true;
                    }
                    this.convertInternal(buf, timesArg, 400, false);
                }
                continue;
            }
            if (plusArg.isNumber() && ((INumber)plusArg).complexSign() < 0) {
                this.convertInternal(buf, plusArg);
                continue;
            }
            if (i < size) {
                this.append(buf, operatorStr);
            }
            this.convertInternal(buf, plusArg, 310, false);
        }
        if (operPrecedence < precedence) {
            this.append(buf, ")");
        }
    }

    private void convertTimesFraction(StringBuilder buf, IAST timesAST, InfixOperator oper, int precedence, boolean caller) {
        IExpr[] parts = Algebra.fractionalPartsTimesPower(timesAST, true, false, false, false, false, false);
        if (parts == null) {
            this.convertTimesOperator(buf, timesAST, oper, precedence, caller);
            return;
        }
        IExpr numerator = parts[0];
        IExpr denominator = parts[1];
        if (!denominator.isOne()) {
            IExpr fraction;
            int currPrecedence = oper.getPrecedence();
            if (currPrecedence < precedence) {
                this.append(buf, "(");
            }
            if ((fraction = parts[2]) != null) {
                this.convertNumber(buf, (ISignedNumber)fraction, 310, caller);
                this.append(buf, "*");
                caller = false;
            }
            if (numerator.isReal()) {
                this.convertNumber(buf, (ISignedNumber)numerator, 310, caller);
            } else if (numerator.isComplex() || numerator.isComplexNumeric()) {
                this.convertNumber(buf, (INumber)numerator, 470, caller);
            } else if (numerator.isTimes() && numerator.isAST2() && numerator.first().isMinusOne()) {
                this.append(buf, "-");
                this.convertInternal(buf, numerator.second(), 400, false);
            } else {
                if (caller) {
                    this.append(buf, "+");
                }
                if (numerator.isTimes()) {
                    this.convertTimesOperator(buf, (IAST)numerator, oper, 470, false);
                } else {
                    this.convertInternal(buf, numerator, 470, false);
                }
            }
            this.append(buf, "/");
            if (denominator.isTimes()) {
                this.convertTimesOperator(buf, (IAST)denominator, oper, 470, false);
            } else {
                this.convertInternal(buf, denominator, 470, false);
            }
            if (currPrecedence < precedence) {
                this.append(buf, ")");
            }
            return;
        }
        this.convertTimesOperator(buf, timesAST, oper, precedence, caller);
    }

    private void convertTimesOperator(StringBuilder buf, IAST timesAST, InfixOperator oper, int precedence, boolean caller) {
        boolean showOperator = true;
        int currPrecedence = oper.getPrecedence();
        if (currPrecedence < precedence) {
            this.append(buf, "(");
        }
        if (timesAST.size() > 1) {
            IExpr arg1 = timesAST.arg1();
            if (arg1.isReal() && timesAST.size() > 2 && !timesAST.arg2().isNumber()) {
                if (arg1.isMinusOne()) {
                    this.append(buf, "-");
                    showOperator = false;
                } else {
                    this.convertNumber(buf, (ISignedNumber)arg1, 310, caller);
                }
            } else if (arg1.isComplex() && timesAST.size() > 2) {
                this.convertComplex(buf, (IComplex)arg1, oper.getPrecedence(), caller);
            } else {
                if (caller) {
                    this.append(buf, "+");
                }
                this.convertInternal(buf, arg1, oper.getPrecedence(), false);
            }
        }
        for (int i = 2; i < timesAST.size(); ++i) {
            if (showOperator) {
                this.append(buf, oper.getOperatorString());
            } else {
                showOperator = true;
            }
            this.convertInternal(buf, timesAST.get(i), oper.getPrecedence(), false);
        }
        if (currPrecedence < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertPowerOperator(StringBuilder buf, IAST list, InfixOperator oper, int precedence) {
        IExpr arg2 = list.arg2();
        if (arg2.isNumber()) {
            INumber exp = (INumber)arg2;
            if (exp.isNumEqualRational(F.C1D2)) {
                this.append(buf, "Sqrt");
                if (this.fRelaxedSyntax) {
                    this.append(buf, "(");
                } else {
                    this.append(buf, "[");
                }
                this.convertInternal(buf, list.arg1(), 0, false);
                if (this.fRelaxedSyntax) {
                    this.append(buf, ")");
                } else {
                    this.append(buf, "]");
                }
                return;
            }
            if (exp.complexSign() < 0) {
                if (470 < precedence) {
                    this.append(buf, "(");
                }
                this.append(buf, "1/");
                if (exp.isMinusOne()) {
                    this.convertInternal(buf, list.arg1(), 470, false);
                    if (470 < precedence) {
                        this.append(buf, ")");
                    }
                    return;
                }
                IASTMutable pow = list.setAtCopy(2, exp.opposite());
                this.convertPowerOperator(buf, pow, oper, 470);
                if (470 < precedence) {
                    this.append(buf, ")");
                }
                return;
            }
        }
        this.convertInfixOperator(S.Power, buf, list, oper, precedence);
    }

    public void convertInfixOperator(ISymbol head, StringBuilder buf, IAST list, InfixOperator oper, int precedence) {
        if (list.isAST2()) {
            Operator operator;
            if (oper.getPrecedence() < precedence) {
                this.append(buf, "(");
            }
            if (oper.getGrouping() == 1 && list.arg1().head().equals(list.head())) {
                this.append(buf, "(");
            } else if (oper.getOperatorString().equals("^") && (operator = this.getOperator(list.arg1().topHead())) instanceof PostfixOperator) {
                this.append(buf, "(");
            }
            this.convertInternal(buf, list.arg1(), oper.getPrecedence(), false);
            if (oper.getGrouping() == 1 && list.arg1().head().equals(list.head())) {
                this.append(buf, ")");
            } else if (oper.getOperatorString().equals("^") && (operator = this.getOperator(list.arg1().topHead())) instanceof PostfixOperator) {
                this.append(buf, ")");
            }
            this.append(buf, oper.getOperatorString());
            if (oper.getGrouping() == 2 && list.arg2().head().equals(list.head())) {
                this.append(buf, "(");
            }
            this.convertInternal(buf, list.arg2(), oper.getPrecedence(), false);
            if (oper.getGrouping() == 2 && list.arg2().head().equals(list.head())) {
                this.append(buf, ")");
            }
            if (oper.getPrecedence() < precedence) {
                this.append(buf, ")");
            }
            return;
        }
        if (oper.getPrecedence() < precedence) {
            this.append(buf, "(");
        }
        if (list.size() > 3 && (head.equals(S.Equal) || head.equals(S.Unequal) || head.equals(S.Greater) || head.equals(S.GreaterEqual) || head.equals(S.Less) || head.equals(S.LessEqual))) {
            this.convertInternal(buf, list.arg1(), oper.getPrecedence(), false);
            for (int i = 2; i < list.size(); ++i) {
                this.append(buf, oper.getOperatorString());
                this.convertInternal(buf, list.get(i), oper.getPrecedence(), false);
                if (i >= list.size() - 1) continue;
                buf.append(" && ");
                this.convertInternal(buf, list.get(i), oper.getPrecedence(), false);
            }
        } else {
            if (list.size() > 1) {
                this.convertInternal(buf, list.arg1(), oper.getPrecedence(), false);
            }
            for (int i = 2; i < list.size(); ++i) {
                this.append(buf, oper.getOperatorString());
                this.convertInternal(buf, list.get(i), oper.getPrecedence(), false);
            }
        }
        if (oper.getPrecedence() < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertPrefixOperator(StringBuilder buf, IAST list, PrefixOperator oper, int precedence) {
        if (oper.getPrecedence() <= precedence) {
            this.append(buf, "(");
        }
        this.append(buf, oper.getOperatorString());
        this.convertInternal(buf, list.arg1(), oper.getPrecedence(), false);
        if (oper.getPrecedence() <= precedence) {
            this.append(buf, ")");
        }
    }

    public void convertPostfixOperator(StringBuilder buf, IAST list, PostfixOperator oper, int precedence) {
        if (oper.getPrecedence() <= precedence) {
            this.append(buf, "(");
        }
        this.convertInternal(buf, list.arg1(), oper.getPrecedence(), false);
        this.append(buf, oper.getOperatorString());
        if (oper.getPrecedence() <= precedence) {
            this.append(buf, ")");
        }
    }

    public String toString(IExpr o) {
        this.reset();
        StringBuilder buf = new StringBuilder();
        this.convertInternal(buf, o, Integer.MIN_VALUE, false);
        return buf.toString();
    }

    public void convert(StringBuilder buf, IExpr o) {
        IExpr expr = EvalEngine.get().evaluate(F.PiecewiseExpand(o));
        this.convertInternal(buf, expr, Integer.MIN_VALUE, false);
    }

    protected void convertInternal(StringBuilder buf, IExpr o) {
        this.convertInternal(buf, o, Integer.MIN_VALUE, false);
    }

    private void convertNumber(StringBuilder buf, INumber o, int precedence, boolean caller) {
        if (o instanceof INum) {
            this.convertDouble(buf, (INum)o, precedence, caller);
            return;
        }
        if (o instanceof IComplexNum) {
            this.convertDoubleComplex(buf, (IComplexNum)o, precedence, caller);
            return;
        }
        if (o instanceof IInteger) {
            this.convertInteger(buf, (IInteger)o, precedence, caller);
            return;
        }
        if (o instanceof IFraction) {
            this.convertFraction(buf, (IFraction)o, precedence, caller);
            return;
        }
        if (o instanceof IComplex) {
            this.convertComplex(buf, (IComplex)o, precedence, caller);
        }
    }

    private void convertInternal(StringBuilder buf, IExpr o, int precedence, boolean isASTHead) {
        if (o instanceof IAST) {
            ISymbol head;
            Operator operator;
            IAST list = (IAST)o;
            if (list.head().isSymbol() && (operator = this.getOperator(head = (ISymbol)list.head())) != null) {
                if (operator instanceof PostfixOperator) {
                    if (list.isAST1()) {
                        this.convertPostfixOperator(buf, list, (PostfixOperator)operator, precedence);
                        return;
                    }
                } else if (this.convertOperator(operator, list, buf, isASTHead ? Integer.MAX_VALUE : precedence, head)) {
                    return;
                }
            }
            this.convertAST(buf, list);
            return;
        }
        if (o instanceof ISignedNumber) {
            this.convertNumber(buf, (ISignedNumber)o, precedence, false);
            return;
        }
        if (o instanceof IComplexNum) {
            this.convertDoubleComplex(buf, (IComplexNum)o, precedence, false);
            return;
        }
        if (o instanceof IComplex) {
            this.convertComplex(buf, (IComplex)o, precedence, false);
            return;
        }
        if (o instanceof ISymbol) {
            this.convertSymbol(buf, (ISymbol)o);
            return;
        }
        if (o instanceof IPatternObject) {
            this.convertPattern(buf, (IPatternObject)o);
            return;
        }
        this.convertString(buf, o.toString());
    }

    protected boolean convertOperator(Operator operator, IAST list, StringBuilder buf, int precedence, ISymbol head) {
        if (operator instanceof PrefixOperator && list.isAST1()) {
            this.convertPrefixOperator(buf, list, (PrefixOperator)operator, precedence);
            return true;
        }
        if (operator instanceof InfixOperator && list.size() > 2) {
            InfixOperator infixOperator = (InfixOperator)operator;
            if (head.equals(S.Plus)) {
                if (this.fPlusReversed) {
                    this.convertPlusOperatorReversed(buf, list, infixOperator, precedence);
                } else {
                    this.convertPlusOperator(buf, list, infixOperator, precedence);
                }
                return true;
            }
            if (head.equals(S.Times)) {
                this.convertTimesFraction(buf, list, infixOperator, precedence, false);
                return true;
            }
            if (list.isPower()) {
                this.convertPowerOperator(buf, list, infixOperator, precedence);
                return true;
            }
            if (list.isAST(S.Apply)) {
                if (list.size() == 3) {
                    this.convertInfixOperator(head, buf, list, (InfixOperator)ASTNodeFactory.APPLY_OPERATOR, precedence);
                    return true;
                }
                if (list.size() == 4 && list.arg2().equals(F.CListC1)) {
                    this.convertInfixOperator(head, buf, list, (InfixOperator)ASTNodeFactory.APPLY_LEVEL_OPERATOR, precedence);
                    return true;
                }
                return false;
            }
            if (list.size() != 3 && infixOperator.getGrouping() != 0) {
                return false;
            }
            this.convertInfixOperator(head, buf, list, (InfixOperator)operator, precedence);
            return true;
        }
        if (operator instanceof PostfixOperator && list.isAST1()) {
            this.convertPostfixOperator(buf, list, (PostfixOperator)operator, precedence);
            return true;
        }
        return false;
    }

    public Operator getOperator(ISymbol head) {
        if (head == S.Plus || head == S.Times || head == S.Equal || head == S.Unequal || head == S.Less || head == S.LessEqual || head == S.Greater || head == S.GreaterEqual || head == S.And || head == S.Or || head == S.Not) {
            return OutputFormFactory.getOperator(head);
        }
        return null;
    }

    public void convertSlot(StringBuilder buf, IAST list) {
        try {
            int slot = ((ISignedNumber)list.arg1()).toInt();
            this.append(buf, "#" + slot);
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void convertSlotSequence(StringBuilder buf, IAST list) {
        try {
            int slotSequenceStartPosition = ((ISignedNumber)list.arg1()).toInt();
            this.append(buf, "##" + slotSequenceStartPosition);
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void convertList(StringBuilder buf, IAST list) {
        if (list instanceof ASTRealVector) {
            RealVector vector = ((ASTRealVector)list).getRealVector();
            buf.append('{');
            int size = vector.getDimension();
            for (int i = 0; i < size; ++i) {
                this.convertDouble(buf, vector.getEntry(i));
                if (i >= size - 1) continue;
                buf.append(",");
            }
            buf.append('}');
            return;
        }
        if (list instanceof ASTRealMatrix) {
            RealMatrix matrix = ((ASTRealMatrix)list).getRealMatrix();
            buf.append('{');
            int rows = matrix.getRowDimension();
            int cols = matrix.getColumnDimension();
            for (int i = 0; i < rows; ++i) {
                if (i != 0) {
                    buf.append(" ");
                }
                buf.append("{");
                for (int j = 0; j < cols; ++j) {
                    this.convertDouble(buf, matrix.getEntry(i, j));
                    if (j >= cols - 1) continue;
                    buf.append(",");
                }
                buf.append('}');
                if (i >= rows - 1) continue;
                buf.append(",");
                buf.append('\n');
            }
            buf.append('}');
            return;
        }
        if (list.isEvalFlagOn(32) && !this.fEmpty) {
            this.newLine(buf);
        }
        this.append(buf, "{");
        int listSize = list.size();
        if (listSize > 1) {
            this.convertInternal(buf, list.arg1());
        }
        for (int i = 2; i < listSize; ++i) {
            this.append(buf, ",");
            if (list.isEvalFlagOn(32)) {
                this.newLine(buf);
                this.append(buf, ' ');
            }
            this.convertInternal(buf, list.get(i));
        }
        this.append(buf, "}");
    }

    public void convertPart(StringBuilder buf, IAST list) {
        IExpr arg1 = list.arg1();
        boolean parentheses = false;
        if (arg1.isAST()) {
            Operator operator = this.getOperator(arg1.topHead());
            if (operator != null) {
                parentheses = true;
            }
        } else if (!arg1.isSymbol()) {
            parentheses = true;
        }
        if (parentheses) {
            this.append(buf, "(");
        }
        this.convertInternal(buf, arg1);
        if (parentheses) {
            this.append(buf, ")");
        }
        this.append(buf, "[[");
        for (int i = 2; i < list.size(); ++i) {
            this.convertInternal(buf, list.get(i));
            if (i >= list.argSize()) continue;
            this.append(buf, ",");
        }
        this.append(buf, "]]");
    }

    public boolean convertSeriesData(StringBuilder buf, ASTSeriesData seriesData, int precedence) {
        StringBuilder tempBuffer = new StringBuilder();
        if (310 < precedence) {
            this.append(tempBuffer, "(");
        }
        try {
            IAST plusArg;
            IExpr x = seriesData.getX();
            IExpr x0 = seriesData.getX0();
            int nmin = seriesData.getNMin();
            int nmax = seriesData.getNMax();
            int order = seriesData.order();
            long den = seriesData.getDenominator();
            boolean call = false;
            if (nmax > nmin) {
                IRational exp = F.fraction(nmin, den).normalize();
                IExpr pow = x.subtract(x0).power(exp);
                call = this.convertSeriesDataArg(tempBuffer, seriesData.coefficient(nmin), pow, call);
                for (int i = nmin + 1; i < nmax; ++i) {
                    exp = F.fraction(i, den).normalize();
                    pow = x.subtract(x0).power(exp);
                    call = this.convertSeriesDataArg(tempBuffer, seriesData.coefficient(i), pow, call);
                }
            }
            if (!(plusArg = F.Power((IExpr)F.O(x.subtract(x0)), F.fraction(order, den).normalize())).isZero()) {
                this.convertPlusArgument(tempBuffer, plusArg, call);
                call = true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        if (310 < precedence) {
            this.append(tempBuffer, ")");
        }
        buf.append((CharSequence)tempBuffer);
        return true;
    }

    public boolean convertQuantityData(StringBuilder buf, IQuantity quantity, int precedence) {
        StringBuilder tempBuffer = new StringBuilder();
        if (310 < precedence) {
            this.append(tempBuffer, "(");
        }
        try {
            buf.append(quantity.toString());
        }
        catch (Exception ex) {
            return false;
        }
        if (310 < precedence) {
            this.append(tempBuffer, ")");
        }
        buf.append((CharSequence)tempBuffer);
        return true;
    }

    private boolean convertSeriesDataArg(StringBuilder buf, IExpr coefficient, IExpr pow, boolean call) {
        IExpr plusArg;
        if (coefficient.isZero()) {
            return call;
        }
        if (coefficient.isOne()) {
            if (pow.isPlus()) {
                if (call) {
                    this.append(buf, "+");
                }
                this.append(buf, "(");
                this.convertPlusArgument(buf, pow, call);
                this.append(buf, ")");
                call = true;
                return call;
            }
            plusArg = pow;
        } else if (pow.isOne()) {
            plusArg = coefficient;
        } else {
            IASTAppendable times = F.TimesAlloc(3);
            if (coefficient.isTimes()) {
                times.appendArgs((IAST)coefficient);
            } else {
                times.append(coefficient);
            }
            times.append(pow);
            plusArg = times;
        }
        if (!plusArg.isZero()) {
            this.convertPlusArgument(buf, plusArg, call);
            call = true;
        }
        return call;
    }

    public void convertFunctionArgs(StringBuilder buf, IAST list) {
        this.append(buf, "[");
        for (int i = 1; i < list.size(); ++i) {
            this.convertInternal(buf, list.get(i));
            if (i >= list.argSize()) continue;
            this.append(buf, ",");
        }
        this.append(buf, "]");
    }

    public abstract String functionHead(ISymbol var1);

    public void convertAST(StringBuilder buf, IAST function) {
        String str;
        IExpr head;
        if (function.isNumericFunction(true)) {
            try {
                double value = EvalEngine.get().evalDouble(function);
                buf.append("(" + value + ")");
                return;
            }
            catch (RuntimeException value) {
                // empty catch block
            }
        }
        if ((head = function.head()).isSymbol() && (str = this.functionHead((ISymbol)head)) != null) {
            buf.append(str);
            if (function.isAST(S.ArcTan, 3)) {
                buf.append("2");
            }
            this.convertArgs(buf, head, function);
            return;
        }
        this.convertInternal(buf, head);
        this.convertArgs(buf, head, function);
    }

    public void convertArgs(StringBuilder buf, IExpr head, IAST function) {
        if (head.isAST()) {
            this.append(buf, "[");
        } else if (this.fRelaxedSyntax) {
            this.append(buf, "(");
        } else {
            this.append(buf, "[");
        }
        int functionSize = function.size();
        if (functionSize > 1) {
            this.convertInternal(buf, function.arg1());
        }
        for (int i = 2; i < functionSize; ++i) {
            this.append(buf, ",");
            this.convertInternal(buf, function.get(i));
        }
        if (head.isAST()) {
            this.append(buf, "]");
        } else if (this.fRelaxedSyntax) {
            this.append(buf, ")");
        } else {
            this.append(buf, "]");
        }
    }

    private void newLine(StringBuilder buf) {
        this.append(buf, '\n');
        this.fEmpty = false;
    }

    private void append(StringBuilder buf, String str) {
        buf.append(str);
        this.fEmpty = false;
    }

    private void append(StringBuilder buf, char c) {
        buf.append(c);
        this.fEmpty = false;
    }

    public void setIgnoreNewLine(boolean ignoreNewLine) {
        this.fIgnoreNewLine = ignoreNewLine;
    }

    public void setQuotes(boolean quotes) {
        this.fQuotes = quotes;
    }

    public void setEmpty(boolean empty) {
        this.fEmpty = empty;
    }
}

