/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.output;

import java.math.BigInteger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.hipparchus.complex.Complex;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ASTRealMatrix;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.DoubleToMMA;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.tensor.qty.IQuantity;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.client.operator.ASTNodeFactory;
import org.matheclipse.parser.client.operator.InfixOperator;
import org.matheclipse.parser.client.operator.Operator;
import org.matheclipse.parser.client.operator.PostfixOperator;
import org.matheclipse.parser.client.operator.PrefixOperator;

public abstract class ComplexFormFactory {
    public static final boolean NO_PLUS_CALL = false;
    public static final boolean PLUS_CALL = true;
    protected final boolean fRelaxedSyntax;
    protected final boolean fPlusReversed;
    protected boolean fIgnoreNewLine = false;
    private boolean fQuotes = false;
    private boolean fEmpty = true;
    private int fExponentFigures;
    private int fSignificantFigures;
    private boolean fPackagePrefix;

    public ComplexFormFactory(boolean relaxedSyntax, boolean reversed, int exponentFigures, int significantFigures, boolean packagePrefix) {
        this.fRelaxedSyntax = relaxedSyntax;
        this.fPlusReversed = reversed;
        this.fExponentFigures = exponentFigures;
        this.fSignificantFigures = significantFigures;
        this.fPackagePrefix = packagePrefix;
    }

    public void reset() {
    }

    public void convertDouble(StringBuilder buf, INum d, int precedence, boolean caller) {
        double doubleValue = d.doubleValue();
        this.convertDouble(buf, doubleValue, d, precedence, caller);
    }

    private void convertDouble(StringBuilder buf, double doubleValue, INum d, int precedence, boolean caller) {
        if (F.isZero(doubleValue, Config.ZERO_IN_OUTPUT_FORMAT)) {
            this.convertDoubleString(buf, this.convertDoubleToFormattedString(0.0), precedence, false);
            return;
        }
        boolean isNegative = d.isNegative();
        if (!isNegative && caller) {
            this.append(buf, "+");
        }
        if (d instanceof Num) {
            this.convertDoubleString(buf, this.convertDoubleToFormattedString(doubleValue), precedence, isNegative);
        } else {
            this.convertDoubleString(buf, ComplexFormFactory.convertApfloat(d.apfloatValue()), precedence, isNegative);
        }
    }

    private void convertDouble(StringBuilder buf, double doubleValue) {
        if (F.isZero(doubleValue, Config.ZERO_IN_OUTPUT_FORMAT)) {
            this.convertDoubleString(buf, this.convertDoubleToFormattedString(0.0), 0, false);
            return;
        }
        this.convertDoubleString(buf, this.convertDoubleToFormattedString(doubleValue), 0, false);
    }

    protected String convertDoubleToFormattedString(double dValue) {
        if (this.fSignificantFigures > 0) {
            StringBuilder buf = new StringBuilder();
            DoubleToMMA.doubleToMMA(buf, dValue, this.fExponentFigures, this.fSignificantFigures);
            return buf.toString();
        }
        return Double.toString(dValue);
    }

    protected void convertDoubleString(StringBuilder buf, String d, int precedence, boolean isNegative) {
        if (isNegative && 310 < precedence) {
            this.append(buf, "(");
        }
        this.append(buf, d);
        if (isNegative && 310 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertDoubleComplex(StringBuilder buf, IComplexNum dc, int precedence, boolean caller) {
        if (dc instanceof ApcomplexNum) {
            this.convertApcomplex(buf, ((ApcomplexNum)dc).apcomplexValue(), precedence, caller);
            return;
        }
        if (310 < precedence) {
            if (caller) {
                this.append(buf, "+");
                caller = false;
            }
            this.append(buf, "(");
        }
        double realPart = dc.getRealPart();
        double imaginaryPart = dc.getImaginaryPart();
        boolean realZero = F.isZero(realPart);
        boolean imaginaryZero = F.isZero(imaginaryPart);
        if (realZero && imaginaryZero) {
            this.convertDoubleString(buf, this.convertDoubleToFormattedString(0.0), 310, false);
        } else if (!realZero) {
            this.append(buf, this.convertDoubleToFormattedString(realPart));
            if (!imaginaryZero) {
                this.append(buf, "+I*");
                boolean isNegative = imaginaryPart < 0.0;
                this.convertDoubleString(buf, this.convertDoubleToFormattedString(imaginaryPart), 400, isNegative);
            }
        } else {
            if (caller) {
                this.append(buf, "+");
                caller = false;
            }
            this.append(buf, "I*");
            boolean isNegative = imaginaryPart < 0.0;
            this.convertDoubleString(buf, this.convertDoubleToFormattedString(imaginaryPart), 400, isNegative);
        }
        if (310 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertApcomplex(StringBuilder buf, Apcomplex dc, int precedence, boolean caller) {
        if (310 < precedence) {
            if (caller) {
                this.append(buf, "+");
                caller = false;
            }
            this.append(buf, "(");
        }
        Apfloat realPart = dc.real();
        Apfloat imaginaryPart = dc.imag();
        boolean realZero = realPart.equals((Object)Apcomplex.ZERO);
        boolean imaginaryZero = imaginaryPart.equals((Object)Apcomplex.ZERO);
        if (realZero && imaginaryZero) {
            this.convertDoubleString(buf, "0.0", 310, false);
        } else if (!realZero) {
            this.append(buf, ComplexFormFactory.convertApfloat(realPart));
            if (!imaginaryZero) {
                this.append(buf, "+I*");
                boolean isNegative = imaginaryPart.compareTo((Apfloat)Apcomplex.ZERO) < 0;
                this.convertDoubleString(buf, ComplexFormFactory.convertApfloat(imaginaryPart), 400, isNegative);
            }
        } else {
            if (caller) {
                this.append(buf, "+");
                caller = false;
            }
            this.append(buf, "I*");
            boolean isNegative = imaginaryPart.compareTo((Apfloat)Apcomplex.ZERO) < 0;
            this.convertDoubleString(buf, ComplexFormFactory.convertApfloat(imaginaryPart), 400, isNegative);
        }
        if (310 < precedence) {
            this.append(buf, ")");
        }
    }

    public static String convertApfloat(Apfloat num) {
        String str = num.toString();
        int index = str.indexOf(101);
        if (index > 0) {
            String exponentStr = str.substring(index + 1);
            String result = str.substring(0, index);
            return result + "*10^" + exponentStr;
        }
        return str;
    }

    public void convertInteger(StringBuilder buf, IInteger i, int precedence, boolean caller) {
        boolean isNegative = i.isNegative();
        if (!isNegative && caller) {
            this.append(buf, "+");
        }
        if (isNegative && 310 < precedence) {
            this.append(buf, "(");
        }
        String str = i.toBigNumerator().toString();
        this.append(buf, str);
        if (isNegative && 310 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertFraction(StringBuilder buf, IRational f, int precedence, boolean caller) {
        this.convertFraction(buf, f.toBigNumerator(), f.toBigDenominator(), precedence, caller);
    }

    public void convertFraction(StringBuilder buf, BigInteger numerator, BigInteger denominator, int precedence, boolean caller) {
        int prec;
        boolean isInteger = denominator.compareTo(BigInteger.ONE) == 0;
        boolean isNegative = numerator.compareTo(BigInteger.ZERO) < 0;
        int n = prec = isNegative ? 310 : 400;
        if (!isNegative && caller) {
            this.append(buf, "+");
        }
        if (prec < precedence) {
            this.append(buf, "(");
        }
        String str = numerator.toString();
        this.append(buf, str);
        if (!isInteger) {
            this.append(buf, "/");
            str = denominator.toString();
            this.append(buf, str);
        }
        if (prec < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertString(StringBuilder buf, String str) {
        if (this.fQuotes) {
            this.append(buf, "\"");
            this.append(buf, str);
            this.append(buf, "\"");
        } else {
            this.append(buf, str);
        }
    }

    public void convertSymbol(StringBuilder buf, ISymbol symbol) {
        String str;
        Context context;
        if (symbol == S.E) {
            buf.append("Math.E");
            return;
        }
        if (symbol == S.Pi) {
            buf.append("Math.PI");
            return;
        }
        if (symbol == S.False) {
            buf.append("false");
            return;
        }
        if (symbol == S.True) {
            buf.append("true");
            return;
        }
        if (symbol == S.Indeterminate) {
            buf.append("Double.NaN");
            return;
        }
        if (symbol.isConstantAttribute()) {
            try {
                double value = EvalEngine.get().evalDouble(symbol);
                buf.append("(" + value + ")");
                return;
            }
            catch (RuntimeException value) {
                // empty catch block
            }
        }
        if ((context = symbol.getContext()) == Context.DUMMY) {
            this.append(buf, symbol.getSymbolName());
            return;
        }
        if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && context.equals(Context.SYSTEM) && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(symbol.getSymbolName())) != null) {
            this.append(buf, str);
            return;
        }
        if (EvalEngine.get().getContextPath().contains(context)) {
            this.append(buf, symbol.getSymbolName());
        } else {
            this.append(buf, context.completeContextName() + symbol.getSymbolName());
        }
    }

    public void convertPattern(StringBuilder buf, IPatternObject pattern) {
        this.append(buf, pattern.toString());
    }

    public void convertHead(StringBuilder buf, IExpr obj) {
        this.convertInternal(buf, obj);
    }

    private void convertInfixOperator(StringBuilder buf, IAST operatorAST, String operatorStr) {
        int i;
        int j = 0;
        for (i = 1; i < operatorAST.size(); ++i) {
            IExpr plusArg = operatorAST.get(i);
            this.convertInternal(buf, plusArg);
            if (i >= operatorAST.size() - 1) continue;
            buf.append("." + operatorStr + "(");
            ++j;
        }
        for (i = 0; i < j; ++i) {
            buf.append(")");
        }
    }

    private void convertInfixOperatorReversed(StringBuilder buf, IAST operatorAST, String operatorStr) {
        int i;
        int size = operatorAST.argSize();
        int j = 0;
        for (i = size; i > 0; --i) {
            IExpr plusArg = operatorAST.get(i);
            this.convertInternal(buf, plusArg);
            if (i <= 1) continue;
            buf.append("." + operatorStr + "(");
            ++j;
        }
        for (i = 0; i < j; ++i) {
            buf.append(")");
        }
    }

    public void convertPowerOperator(StringBuilder buf, IAST list, InfixOperator oper, int precedence) {
        IExpr arg2 = list.arg2();
        if (arg2.isNumber()) {
            INumber exp = (INumber)arg2;
            if (exp.isNumEqualRational(F.C1D2)) {
                this.append(buf, "Sqrt");
                if (this.fRelaxedSyntax) {
                    this.append(buf, "(");
                } else {
                    this.append(buf, "[");
                }
                this.convertInternal(buf, list.arg1(), 0, false);
                if (this.fRelaxedSyntax) {
                    this.append(buf, ")");
                } else {
                    this.append(buf, "]");
                }
                return;
            }
            if (exp.complexSign() < 0) {
                if (470 < precedence) {
                    this.append(buf, "(");
                }
                this.append(buf, "1/");
                if (exp.isMinusOne()) {
                    this.convertInternal(buf, list.arg1(), 470, false);
                    if (470 < precedence) {
                        this.append(buf, ")");
                    }
                    return;
                }
                IASTMutable pow = list.setAtCopy(2, exp.opposite());
                this.convertPowerOperator(buf, pow, oper, 470);
                if (470 < precedence) {
                    this.append(buf, ")");
                }
                return;
            }
        }
        this.convertInfixOperator(S.Power, buf, list, oper, precedence);
    }

    public void convertInfixOperator(ISymbol head, StringBuilder buf, IAST list, InfixOperator oper, int precedence) {
        if (list.isAST2()) {
            Operator operator;
            if (oper.getPrecedence() < precedence) {
                this.append(buf, "(");
            }
            if (oper.getGrouping() == 1 && list.arg1().head().equals(list.head())) {
                this.append(buf, "(");
            } else if (oper.getOperatorString().equals("^") && (operator = this.getOperator(list.arg1().topHead())) instanceof PostfixOperator) {
                this.append(buf, "(");
            }
            this.convertInternal(buf, list.arg1(), oper.getPrecedence(), false);
            if (oper.getGrouping() == 1 && list.arg1().head().equals(list.head())) {
                this.append(buf, ")");
            } else if (oper.getOperatorString().equals("^") && (operator = this.getOperator(list.arg1().topHead())) instanceof PostfixOperator) {
                this.append(buf, ")");
            }
            this.append(buf, oper.getOperatorString());
            if (oper.getGrouping() == 2 && list.arg2().head().equals(list.head())) {
                this.append(buf, "(");
            }
            this.convertInternal(buf, list.arg2(), oper.getPrecedence(), false);
            if (oper.getGrouping() == 2 && list.arg2().head().equals(list.head())) {
                this.append(buf, ")");
            }
            if (oper.getPrecedence() < precedence) {
                this.append(buf, ")");
            }
            return;
        }
        if (oper.getPrecedence() < precedence) {
            this.append(buf, "(");
        }
        if (list.size() > 3 && (head.equals(S.Equal) || head.equals(S.Unequal) || head.equals(S.Greater) || head.equals(S.GreaterEqual) || head.equals(S.Less) || head.equals(S.LessEqual))) {
            this.convertInternal(buf, list.arg1(), oper.getPrecedence(), false);
            for (int i = 2; i < list.size(); ++i) {
                this.append(buf, oper.getOperatorString());
                this.convertInternal(buf, list.get(i), oper.getPrecedence(), false);
                if (i >= list.size() - 1) continue;
                buf.append(" && ");
                this.convertInternal(buf, list.get(i), oper.getPrecedence(), false);
            }
        } else {
            if (list.size() > 1) {
                this.convertInternal(buf, list.arg1(), oper.getPrecedence(), false);
            }
            for (int i = 2; i < list.size(); ++i) {
                this.append(buf, oper.getOperatorString());
                this.convertInternal(buf, list.get(i), oper.getPrecedence(), false);
            }
        }
        if (oper.getPrecedence() < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertPrefixOperator(StringBuilder buf, IAST list, PrefixOperator oper, int precedence) {
        if (oper.getPrecedence() <= precedence) {
            this.append(buf, "(");
        }
        this.append(buf, oper.getOperatorString());
        this.convertInternal(buf, list.arg1(), oper.getPrecedence(), false);
        if (oper.getPrecedence() <= precedence) {
            this.append(buf, ")");
        }
    }

    public void convertPostfixOperator(StringBuilder buf, IAST list, PostfixOperator oper, int precedence) {
        if (oper.getPrecedence() <= precedence) {
            this.append(buf, "(");
        }
        this.convertInternal(buf, list.arg1(), oper.getPrecedence(), false);
        this.append(buf, oper.getOperatorString());
        if (oper.getPrecedence() <= precedence) {
            this.append(buf, ")");
        }
    }

    public String toString(IExpr o) {
        this.reset();
        StringBuilder buf = new StringBuilder();
        this.convertInternal(buf, o, Integer.MIN_VALUE, false);
        return buf.toString();
    }

    public void convert(StringBuilder buf, IExpr o) {
        IExpr expr = EvalEngine.get().evaluate(F.PiecewiseExpand(o));
        this.convertInternal(buf, expr, Integer.MIN_VALUE, false);
    }

    protected void convertInternal(StringBuilder buf, IExpr o) {
        this.convertInternal(buf, o, Integer.MIN_VALUE, false);
    }

    private void convertInternal(StringBuilder buf, IExpr o, int precedence, boolean isASTHead) {
        if (o instanceof IAST) {
            ISymbol head;
            Operator operator;
            IAST list = (IAST)o;
            if (list.head().isSymbol() && (operator = this.getOperator(head = (ISymbol)list.head())) != null) {
                if (operator instanceof PostfixOperator) {
                    if (list.isAST1()) {
                        this.convertPostfixOperator(buf, list, (PostfixOperator)operator, precedence);
                        return;
                    }
                } else if (this.convertOperator(operator, list, buf, isASTHead ? Integer.MAX_VALUE : precedence, head)) {
                    return;
                }
            }
            this.convertAST(buf, list);
            return;
        }
        if (o instanceof ISignedNumber) {
            double d = o.evalDouble();
            if (this.fPackagePrefix) {
                buf.append("org.hipparchus.complex.");
            }
            buf.append("Complex.valueOf(" + d + ")");
            return;
        }
        if (o instanceof INumber) {
            Complex c = o.evalComplex();
            if (c != null) {
                if (this.fPackagePrefix) {
                    buf.append("org.hipparchus.complex.");
                }
                buf.append("Complex.valueOf(" + c.getReal() + ", " + c.getImaginary() + ")");
            } else {
                buf.append("Complex.valueOf(" + o.toString() + ")");
            }
            return;
        }
        if (o instanceof ISymbol) {
            this.convertSymbol(buf, (ISymbol)o);
            return;
        }
        if (o instanceof IPatternObject) {
            this.convertPattern(buf, (IPatternObject)o);
            return;
        }
        this.convertString(buf, o.toString());
    }

    protected boolean convertOperator(Operator operator, IAST list, StringBuilder buf, int precedence, ISymbol head) {
        if (operator instanceof PrefixOperator && list.isAST1()) {
            this.convertPrefixOperator(buf, list, (PrefixOperator)operator, precedence);
            return true;
        }
        if (operator instanceof InfixOperator && list.size() > 2) {
            InfixOperator infixOperator = (InfixOperator)operator;
            if (head.equals(S.Plus)) {
                if (this.fPlusReversed) {
                    this.convertInfixOperatorReversed(buf, list, "add");
                } else {
                    this.convertInfixOperator(buf, list, "add");
                }
                return true;
            }
            if (head.equals(S.Times)) {
                this.convertInfixOperator(buf, list, "multiply");
                return true;
            }
            if (list.isPower()) {
                this.convertInfixOperator(buf, list, "pow");
                return true;
            }
            if (list.isAST(S.Apply)) {
                if (list.size() == 3) {
                    this.convertInfixOperator(head, buf, list, (InfixOperator)ASTNodeFactory.APPLY_OPERATOR, precedence);
                    return true;
                }
                if (list.size() == 4 && list.arg2().equals(F.CListC1)) {
                    this.convertInfixOperator(head, buf, list, (InfixOperator)ASTNodeFactory.APPLY_LEVEL_OPERATOR, precedence);
                    return true;
                }
                return false;
            }
            if (list.size() != 3 && infixOperator.getGrouping() != 0) {
                return false;
            }
            this.convertInfixOperator(head, buf, list, (InfixOperator)operator, precedence);
            return true;
        }
        if (operator instanceof PostfixOperator && list.isAST1()) {
            this.convertPostfixOperator(buf, list, (PostfixOperator)operator, precedence);
            return true;
        }
        return false;
    }

    public Operator getOperator(ISymbol head) {
        if (head == S.Plus || head == S.Times || head == S.Equal || head == S.Unequal || head == S.Less || head == S.LessEqual || head == S.Greater || head == S.GreaterEqual || head == S.And || head == S.Or || head == S.Not) {
            return OutputFormFactory.getOperator(head);
        }
        return null;
    }

    public void convertSlot(StringBuilder buf, IAST list) {
        try {
            int slot = ((ISignedNumber)list.arg1()).toInt();
            this.append(buf, "#" + slot);
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void convertSlotSequence(StringBuilder buf, IAST list) {
        try {
            int slotSequenceStartPosition = ((ISignedNumber)list.arg1()).toInt();
            this.append(buf, "##" + slotSequenceStartPosition);
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void convertList(StringBuilder buf, IAST list) {
        if (list instanceof ASTRealVector) {
            RealVector vector = ((ASTRealVector)list).getRealVector();
            buf.append('{');
            int size = vector.getDimension();
            for (int i = 0; i < size; ++i) {
                this.convertDouble(buf, vector.getEntry(i));
                if (i >= size - 1) continue;
                buf.append(",");
            }
            buf.append('}');
            return;
        }
        if (list instanceof ASTRealMatrix) {
            RealMatrix matrix = ((ASTRealMatrix)list).getRealMatrix();
            buf.append('{');
            int rows = matrix.getRowDimension();
            int cols = matrix.getColumnDimension();
            for (int i = 0; i < rows; ++i) {
                if (i != 0) {
                    buf.append(" ");
                }
                buf.append("{");
                for (int j = 0; j < cols; ++j) {
                    this.convertDouble(buf, matrix.getEntry(i, j));
                    if (j >= cols - 1) continue;
                    buf.append(",");
                }
                buf.append('}');
                if (i >= rows - 1) continue;
                buf.append(",");
                buf.append('\n');
            }
            buf.append('}');
            return;
        }
        if (list.isEvalFlagOn(32) && !this.fEmpty) {
            this.newLine(buf);
        }
        this.append(buf, "{");
        int listSize = list.size();
        if (listSize > 1) {
            this.convertInternal(buf, list.arg1());
        }
        for (int i = 2; i < listSize; ++i) {
            this.append(buf, ",");
            if (list.isEvalFlagOn(32)) {
                this.newLine(buf);
                this.append(buf, ' ');
            }
            this.convertInternal(buf, list.get(i));
        }
        this.append(buf, "}");
    }

    public void convertPart(StringBuilder buf, IAST list) {
        IExpr arg1 = list.arg1();
        boolean parentheses = false;
        if (arg1.isAST()) {
            Operator operator = this.getOperator(arg1.topHead());
            if (operator != null) {
                parentheses = true;
            }
        } else if (!arg1.isSymbol()) {
            parentheses = true;
        }
        if (parentheses) {
            this.append(buf, "(");
        }
        this.convertInternal(buf, arg1);
        if (parentheses) {
            this.append(buf, ")");
        }
        this.append(buf, "[[");
        for (int i = 2; i < list.size(); ++i) {
            this.convertInternal(buf, list.get(i));
            if (i >= list.argSize()) continue;
            this.append(buf, ",");
        }
        this.append(buf, "]]");
    }

    public boolean convertQuantityData(StringBuilder buf, IQuantity quantity, int precedence) {
        StringBuilder tempBuffer = new StringBuilder();
        if (310 < precedence) {
            this.append(tempBuffer, "(");
        }
        try {
            buf.append(quantity.toString());
        }
        catch (Exception ex) {
            return false;
        }
        if (310 < precedence) {
            this.append(tempBuffer, ")");
        }
        buf.append((CharSequence)tempBuffer);
        return true;
    }

    public void convertFunctionArgs(StringBuilder buf, IAST list) {
        this.append(buf, "(");
        for (int i = 1; i < list.size(); ++i) {
            this.convertInternal(buf, list.get(i));
            if (i >= list.argSize()) continue;
            this.append(buf, ",");
        }
        this.append(buf, ")");
    }

    public abstract String functionHead(ISymbol var1);

    public abstract void convertAST(StringBuilder var1, IAST var2);

    public void convertArgs(StringBuilder buf, IExpr head, IAST function, int startIndex) {
        this.append(buf, "(");
        int argumentSize = function.size() - 1;
        for (int i = startIndex; i <= argumentSize; ++i) {
            this.convertInternal(buf, function.get(i));
            if (i >= argumentSize) continue;
            this.append(buf, ",");
        }
        this.append(buf, ")");
    }

    private void newLine(StringBuilder buf) {
        this.append(buf, '\n');
        this.fEmpty = false;
    }

    private void append(StringBuilder buf, String str) {
        buf.append(str);
        this.fEmpty = false;
    }

    private void append(StringBuilder buf, char c) {
        buf.append(c);
        this.fEmpty = false;
    }

    public void setIgnoreNewLine(boolean ignoreNewLine) {
        this.fIgnoreNewLine = ignoreNewLine;
    }

    public void setQuotes(boolean quotes) {
        this.fQuotes = quotes;
    }

    public void setEmpty(boolean empty) {
        this.fEmpty = empty;
    }
}

