/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.output;

import java.io.PrintWriter;
import org.matheclipse.core.builtin.Algebra;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class ASCIIPrettyPrinter3 {
    public static final boolean NO_PLUS_CALL = false;
    public static final boolean PLUS_CALL = true;
    boolean fractionPrinted = false;
    StringBuilder line1 = new StringBuilder();
    StringBuilder line2 = new StringBuilder();
    StringBuilder line3 = new StringBuilder();

    public void print(String numerator) {
        this.printFraction(numerator, null);
        this.fractionPrinted = false;
    }

    public void printFraction(String numerator, String denominator) {
        int i;
        int len = numerator.length();
        if (denominator == null) {
            int i2;
            for (i2 = 0; i2 < len; ++i2) {
                this.line1.append(' ');
            }
            this.line2.append(numerator);
            for (i2 = 0; i2 < len; ++i2) {
                this.line3.append(' ');
            }
            this.fractionPrinted = false;
            return;
        }
        int diffN = 0;
        int diffD = 0;
        int rest = 0;
        if (len < denominator.length()) {
            diffN = denominator.length() - len;
            len = denominator.length();
        } else {
            diffD = len - denominator.length();
        }
        rest = len - numerator.length() - (diffN >>= 1);
        for (i = 0; i < diffN; ++i) {
            this.line1.append(" ");
        }
        this.line1.append(numerator);
        for (i = 0; i < rest; ++i) {
            this.line1.append(" ");
        }
        for (i = 0; i < len; ++i) {
            this.line2.append("-");
        }
        rest = len - denominator.length() - (diffD >>= 1);
        for (i = 0; i < diffD; ++i) {
            this.line3.append(" ");
        }
        this.line3.append(denominator);
        for (i = 0; i < rest; ++i) {
            this.line3.append(" ");
        }
        this.fractionPrinted = true;
    }

    public String toString() {
        return this.line1.toString() + "\n" + this.line2.toString() + "\n" + this.line3.toString();
    }

    public String[] toStringBuilder() {
        String[] buf = new String[]{this.line1.toString(), this.line2.toString(), this.line3.toString()};
        return buf;
    }

    public void convert(IExpr expr) {
        this.fractionPrinted = false;
        this.convert(expr, 0, false);
    }

    private void convert(IExpr expr, int precedence, boolean caller) {
        if (expr.isPlus()) {
            if (310 < precedence) {
                this.print(" ( ");
            }
            IAST plus = (IAST)expr;
            for (int i = 1; i < plus.size(); ++i) {
                this.convert(plus.get(i), 310, i != 1);
            }
            if (310 < precedence) {
                this.print(" ) ");
            }
        } else if (expr.isTimes()) {
            this.convertTimes((IAST)expr, precedence, caller);
        } else if (expr.isPower()) {
            if (caller) {
                this.print(" + ");
            }
            this.convertTimesPowerFraction((IAST)expr, precedence);
        } else if (expr.isAST() && expr.head().isSymbol()) {
            IAST ast;
            ISymbol head;
            if (caller) {
                this.print(" + ");
            }
            if ((head = (ISymbol)(ast = (IAST)expr).head()).equals(S.List)) {
                this.print("{");
            } else {
                this.print(head.toString() + "(");
            }
            for (int i = 1; i < ast.size(); ++i) {
                this.fractionPrinted = false;
                if (i != 1) {
                    this.print(", ");
                }
                this.convert(ast.get(i), 0, false);
            }
            if (head.equals(S.List)) {
                this.print("}");
            } else {
                this.print(")");
            }
        } else if (expr.isReal()) {
            this.convertNumber((ISignedNumber)expr, caller);
        } else {
            if (caller) {
                this.print(" + ");
            }
            this.print(expr.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void convertTimes(IAST times, int precedence, boolean caller) {
        IExpr arg1 = times.arg1();
        if (arg1.isReal()) {
            if (400 < precedence) {
                this.print(" ( ");
            }
            if (arg1.isMinusOne()) {
                this.print(" - ");
            } else if (this.convertNumber((ISignedNumber)arg1, caller)) {
                this.print(" * ");
            }
            IExpr timesExpr = times.rest().oneIdentity0();
            if (!timesExpr.isTimes()) {
                this.convert(timesExpr, 400, false);
                return;
            }
            times = (IAST)timesExpr;
        } else {
            if (caller) {
                this.print(" + ");
            }
            if (400 < precedence) {
                this.print(" ( ");
            }
        }
        this.convertTimesPowerFraction(times, 400);
        if (400 < precedence) {
            this.print(" ) ");
        }
    }

    private void convertTimesPowerFraction(IAST ast, int precedence) {
        IExpr[] parts = Algebra.fractionalPartsTimesPower(ast, true, false, false, false, false, false);
        if (parts == null) {
            this.print(ast.toString());
            return;
        }
        IExpr numerator = parts[0];
        IExpr denominator = parts[1];
        if (!denominator.isOne()) {
            this.printFraction(numerator.toString(), denominator.toString());
        } else {
            this.print(ast.toString());
        }
    }

    private boolean convertNumber(ISignedNumber number, boolean caller) {
        boolean negative = false;
        if (number.isNegative()) {
            number = number.negate();
            negative = true;
        }
        if (caller) {
            if (negative) {
                this.print(" - ");
            } else {
                this.print(" + ");
            }
            if (!number.isOne()) {
                if (number.isFraction()) {
                    IFraction frac = (IFraction)number;
                    this.printFraction(frac.toBigNumerator().toString(), frac.toBigDenominator().toString());
                } else {
                    this.convert(number, 0, false);
                }
                return true;
            }
        } else {
            if (number.isFraction()) {
                if (negative) {
                    if (this.fractionPrinted) {
                        this.print(" - ");
                    } else {
                        this.print("- ");
                    }
                }
                IFraction frac = (IFraction)number;
                this.printFraction(frac.toBigNumerator().toString(), frac.toBigDenominator().toString());
            } else {
                if (negative) {
                    this.print("-");
                }
                this.print(number.toString());
            }
            return true;
        }
        return false;
    }

    public static void prettyPrinter(PrintWriter out, String[] outputExpression, String prefix) {
        out.print(prefix);
        if (outputExpression != null) {
            if (outputExpression[0].trim().length() > 0) {
                int length = prefix.length();
                out.println(outputExpression[0]);
                ASCIIPrettyPrinter3.emptyPrefix(out, length);
                out.println(outputExpression[1]);
                ASCIIPrettyPrinter3.emptyPrefix(out, length);
                out.println(outputExpression[2]);
            } else {
                out.println(outputExpression[1]);
            }
        }
    }

    private static void emptyPrefix(PrintWriter out, int length) {
        StringBuilder s = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            s.append(' ');
        }
        out.print(s.toString());
    }
}

