/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.mathml;

import java.io.IOException;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Algebra;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.util.Iterator;
import org.matheclipse.core.expression.ASTRealMatrix;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.ASTSeriesData;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntervalSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.ApfloatToMMA;
import org.matheclipse.core.form.DoubleToMMA;
import org.matheclipse.core.form.mathml.AbstractMathMLFormFactory;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IIterator;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.Characters;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.client.operator.ASTNodeFactory;
import org.matheclipse.parser.client.operator.InfixOperator;
import org.matheclipse.parser.client.operator.PostfixOperator;
import org.matheclipse.parser.client.operator.PrefixOperator;
import org.matheclipse.parser.trie.TrieBuilder;
import org.matheclipse.parser.trie.TrieMatch;

public class MathMLFormFactory
extends AbstractMathMLFormFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean NO_PLUS_CALL = false;
    public static final boolean PLUS_CALL = true;
    public static final Map<ISymbol, IConverter> CONVERTERS = new HashMap<ISymbol, IConverter>(199);
    private static final TrieBuilder<String, Object, ArrayList<Object>> constantBuilder = TrieBuilder.create();
    public static final Map<String, Object> CONSTANT_SYMBOLS = constantBuilder.withMatch(TrieMatch.EXACT).build();
    private static final TrieBuilder<String, AbstractConverter, ArrayList<AbstractConverter>> converterBuilder = TrieBuilder.create();
    public static final Map<String, AbstractConverter> OPERATORS = converterBuilder.withMatch(TrieMatch.EXACT).build();
    public static final Map<IExpr, String> CONSTANT_EXPRS = new HashMap<IExpr, String>();
    private boolean fRelaxedSyntax;
    private boolean fUseSignificantFigures = false;
    private int fExponentFigures;
    private int fSignificantFigures;

    public MathMLFormFactory() {
        this("", null, -1, -1);
    }

    public MathMLFormFactory(String tagPrefix) {
        this(tagPrefix, null, -1, -1);
    }

    public MathMLFormFactory(String tagPrefix, NumberFormat numberFormat, int exponentFigures, int significantFigures) {
        super(tagPrefix, numberFormat);
        this.fRelaxedSyntax = true;
        this.fExponentFigures = exponentFigures;
        this.fSignificantFigures = significantFigures;
        this.init();
    }

    public MathMLFormFactory(String tagPrefix, boolean relaxedSyntax, NumberFormat numberFormat, int exponentFigures, int significantFigures) {
        super(tagPrefix, numberFormat);
        this.fRelaxedSyntax = relaxedSyntax;
        this.fExponentFigures = exponentFigures;
        this.fSignificantFigures = significantFigures;
        this.init();
    }

    @Override
    public boolean convert(StringBuilder buf, IExpr o, int precedence, boolean isASTHead) {
        try {
            this.convertInternal(buf, o, precedence, isASTHead);
            return buf.length() < Config.MAX_OUTPUT_SIZE;
        }
        catch (RuntimeException rex) {
            LOGGER.debug("OutputFormFactory.toString() failed", (Throwable)rex);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        return false;
    }

    @Override
    void convertInternal(StringBuilder buf, IExpr o, int precedence, boolean isASTHead) {
        String str = CONSTANT_EXPRS.get(o);
        if (str != null) {
            buf.append(str);
            return;
        }
        if (o instanceof IAST) {
            IConverter converter;
            IExpr h;
            IASTAppendable temp;
            IAST f;
            IAST ast = f = (IAST)o;
            if (f.topHead().hasFlatAttribute() && (temp = EvalAttributes.flattenDeep(f)).isPresent()) {
                ast = temp;
            }
            if ((h = ast.head()).isSymbol() && (converter = CONVERTERS.get(h)) != null) {
                converter.setFactory(this);
                StringBuilder sb = new StringBuilder();
                if (converter.convert(sb, ast, precedence)) {
                    buf.append((CharSequence)sb);
                    return;
                }
            }
            this.convertAST(buf, ast, 0);
            return;
        }
        if (this.convertNumber(buf, o, precedence, false)) {
            return;
        }
        if (o instanceof ISymbol) {
            this.convertSymbol(buf, (ISymbol)o);
            return;
        }
        this.convertString(buf, o.toString());
    }

    public void convertApcomplex(StringBuilder buf, Apcomplex ac, int precedence) {
        Apfloat realPart = ac.real();
        Apfloat imaginaryPart = ac.imag();
        boolean isImNegative = imaginaryPart.compareTo((Apfloat)Apcomplex.ZERO) < 0;
        this.tagStart(buf, "mrow");
        if (310 < precedence) {
            this.tag(buf, "mo", "(");
        }
        buf.append(this.convertApfloatToFormattedString(realPart));
        if (isImNegative) {
            this.tag(buf, "mo", "-");
            imaginaryPart = imaginaryPart.negate();
        } else {
            this.tag(buf, "mo", "+");
        }
        buf.append(this.convertApfloatToFormattedString(imaginaryPart));
        this.tag(buf, "mo", "&#0183;");
        this.tag(buf, "mi", "&#x2148;");
        if (310 < precedence) {
            this.tag(buf, "mo", ")");
        }
        this.tagEnd(buf, "mrow");
    }

    public void convertApfloat(StringBuilder buf, Apfloat realPart, int precedence) {
        buf.append(this.convertApfloatToFormattedString(realPart));
    }

    private String convertApfloatToFormattedString(Apfloat value) {
        StringBuilder buf = new StringBuilder();
        int numericPrecision = (int)EvalEngine.get().getNumericPrecision();
        ApfloatToMMA.apfloatToMathML(buf, value, numericPrecision, numericPrecision, this.fUseSignificantFigures);
        return buf.toString();
    }

    public void convertArgs(StringBuilder buf, IExpr head, IAST function) {
        this.tagStart(buf, "mrow");
        if (head.isAST() || !this.fRelaxedSyntax) {
            this.tag(buf, "mo", "[");
        } else {
            this.tag(buf, "mo", "(");
        }
        int functionSize = function.size();
        if (functionSize > 1) {
            this.convertInternal(buf, function.arg1(), Integer.MIN_VALUE, false);
        }
        for (int i = 2; i < functionSize; ++i) {
            this.tag(buf, "mo", ",");
            this.convertInternal(buf, function.get(i), Integer.MIN_VALUE, false);
        }
        if (head.isAST() || !this.fRelaxedSyntax) {
            this.tag(buf, "mo", "]");
        } else {
            this.tag(buf, "mo", ")");
        }
        this.tagEnd(buf, "mrow");
    }

    private void convertAST(StringBuilder buf, IAST ast, int precedence) {
        IAST list = ast;
        IExpr header = list.head();
        if (!header.isSymbol()) {
            IAST[] derivStruct = list.isDerivativeAST1();
            if (derivStruct != null) {
                IAST a1Head = derivStruct[0];
                IAST headAST = derivStruct[1];
                if (a1Head.isAST1() && headAST.isAST1() && (headAST.arg1().isSymbol() || headAST.arg1().isAST())) {
                    try {
                        int n = a1Head.arg1().toIntDefault();
                        if (n == 1 || n == 2) {
                            this.tagStart(buf, "mrow");
                            this.tagStart(buf, "msup");
                            IExpr symbolOrAST = headAST.arg1();
                            this.convertInternal(buf, symbolOrAST, Integer.MAX_VALUE, false);
                            if (n == 1) {
                                this.tag(buf, "mo", "&#8242;");
                            } else if (n == 2) {
                                this.tag(buf, "mo", "&#8242;&#8242;");
                            }
                            this.tagEnd(buf, "msup");
                            if (derivStruct[2] != null) {
                                this.convertArgs(buf, symbolOrAST, list);
                            }
                            this.tagEnd(buf, "mrow");
                            return;
                        }
                        this.tagStart(buf, "mrow");
                        IExpr symbolOrAST = headAST.arg1();
                        this.tagStart(buf, "msup");
                        this.convertInternal(buf, symbolOrAST, Integer.MAX_VALUE, false);
                        this.tagStart(buf, "mrow");
                        this.tag(buf, "mo", "(");
                        this.convertInternal(buf, a1Head.arg1(), Integer.MIN_VALUE, false);
                        this.tag(buf, "mo", ")");
                        this.tagEnd(buf, "mrow");
                        this.tagEnd(buf, "msup");
                        if (derivStruct[2] != null) {
                            this.convertArgs(buf, symbolOrAST, list);
                        }
                        this.tagEnd(buf, "mrow");
                        return;
                    }
                    catch (ArithmeticException n) {
                        // empty catch block
                    }
                }
            }
            this.convertInternal(buf, header, Integer.MIN_VALUE, false);
            this.convertFunctionArgs(buf, list);
            return;
        }
        ISymbol head = list.topHead();
        org.matheclipse.parser.client.operator.Operator operator = OutputFormFactory.getOperator(head);
        if (operator != null) {
            if (operator instanceof PostfixOperator) {
                if (list.isAST1()) {
                    this.convertPostfixOperator(buf, list, (PostfixOperator)operator, operator.getPrecedence());
                    return;
                }
            } else if (this.convertOperator(operator, list, buf, operator.getPrecedence(), head)) {
                return;
            }
        }
        if (list instanceof ASTSeriesData && this.convertSeriesData(buf, (ASTSeriesData)list, precedence)) {
            return;
        }
        if (list.isList() || list instanceof ASTRealVector || list instanceof ASTRealMatrix) {
            this.convertList(buf, list);
            return;
        }
        if (list.isAST(S.Parenthesis)) {
            this.convertArgs(buf, S.Parenthesis, list);
            return;
        }
        if (list.isInterval() && this.convertInterval(buf, list)) {
            return;
        }
        if (list.isAssociation()) {
            this.convertAssociation(buf, (IAssociation)list);
            return;
        }
        int functionID = ((ISymbol)list.head()).ordinal();
        if (functionID > -1) {
            switch (functionID) {
                case 644: {
                    if (list.size() <= 3 || !this.convertInequality(buf, list, precedence)) break;
                    return;
                }
                case 979: {
                    if (list.size() < 3) break;
                    this.convertPart(buf, list);
                    return;
                }
                case 1198: {
                    if (!list.isAST1() || !(list.arg1() instanceof IInteger)) break;
                    this.convertSlot(buf, list);
                    return;
                }
                case 1200: {
                    if (!list.isAST1() || !(list.arg1() instanceof IInteger)) break;
                    this.convertSlotSequence(buf, list);
                    return;
                }
                case 1207: {
                    if (!list.isSparseArray()) break;
                    this.tagStart(buf, "mtext");
                    buf.append(list.toString());
                    this.tagEnd(buf, "mtext");
                    return;
                }
                case 324: 
                case 603: {
                    if (!list.isAST1()) break;
                    this.convertInternal(buf, list.arg1(), precedence, false);
                    return;
                }
                case 355: {
                    if (!list.isDirectedInfinity()) break;
                    if (list.isAST0()) {
                        this.convertSymbol(buf, S.ComplexInfinity);
                        return;
                    }
                    if (!list.isAST1()) break;
                    if (list.arg1().isOne()) {
                        this.convertSymbol(buf, S.Infinity);
                        return;
                    }
                    if (list.arg1().isMinusOne()) {
                        this.convertInternal(buf, F.Times((IExpr)F.CN1, (IExpr)S.Infinity), precedence, false);
                        return;
                    }
                    if (list.arg1().isImaginaryUnit()) {
                        this.convertInternal(buf, F.Times((IExpr)F.CI, (IExpr)S.Infinity), precedence, false);
                        return;
                    }
                    if (!list.arg1().isNegativeImaginaryUnit()) break;
                    this.convertInternal(buf, F.Times((IExpr)F.CNI, (IExpr)S.Infinity), precedence, false);
                    return;
                }
            }
        }
        this.tagStart(buf, "mrow");
        this.convertHead(buf, ast.head());
        this.tagStart(buf, "mrow");
        if (this.fRelaxedSyntax) {
            this.tag(buf, "mo", "(");
        } else {
            this.tag(buf, "mo", "[");
        }
        this.tagStart(buf, "mrow");
        for (int i = 1; i < ast.size(); ++i) {
            this.convertInternal(buf, ast.get(i), Integer.MIN_VALUE, false);
            if (i >= ast.argSize()) continue;
            this.tag(buf, "mo", ",");
        }
        this.tagEnd(buf, "mrow");
        if (this.fRelaxedSyntax) {
            this.tag(buf, "mo", ")");
        } else {
            this.tag(buf, "mo", "]");
        }
        this.tagEnd(buf, "mrow");
        this.tagEnd(buf, "mrow");
    }

    private boolean convertInequality(StringBuilder buf, IAST inequality, int precedence) {
        StringBuilder tempBuffer = new StringBuilder();
        this.tagStart(tempBuffer, "mrow");
        if (290 < precedence) {
            this.tag(tempBuffer, "mo", "(");
        }
        int listSize = inequality.size();
        int i = 1;
        while (i < listSize) {
            IExpr head;
            this.convertInternal(tempBuffer, inequality.get(i++), 290, false);
            if (i == listSize) {
                if (290 < precedence) {
                    this.tag(tempBuffer, "mo", ")");
                }
                this.tagEnd(tempBuffer, "mrow");
                buf.append((CharSequence)tempBuffer);
                return true;
            }
            if ((head = inequality.get(i++)).isBuiltInSymbol()) {
                int id = ((IBuiltInSymbol)head).ordinal();
                switch (id) {
                    case 423: {
                        this.tag(tempBuffer, "mo", "==");
                        break;
                    }
                    case 571: {
                        this.tag(tempBuffer, "mo", "&gt;");
                        break;
                    }
                    case 572: {
                        this.tag(tempBuffer, "mo", "&gt;=");
                        break;
                    }
                    case 753: {
                        this.tag(tempBuffer, "mo", "&lt;");
                        break;
                    }
                    case 754: {
                        this.tag(tempBuffer, "mo", "&lt;=");
                        break;
                    }
                    case 1381: {
                        this.tag(tempBuffer, "mo", "!=");
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                continue;
            }
            return false;
        }
        if (290 < precedence) {
            this.tag(tempBuffer, "mo", ")");
        }
        this.tagEnd(tempBuffer, "mrow");
        buf.append((CharSequence)tempBuffer);
        return true;
    }

    @Override
    public void convertComplex(StringBuilder buf, IComplex c, int precedence, boolean caller) {
        boolean isReZero = c.getRealPart().isZero();
        IRational imaginaryPart = c.getImaginaryPart();
        boolean isImOne = imaginaryPart.isOne();
        boolean isImNegative = imaginaryPart.isNegative();
        boolean isImMinusOne = imaginaryPart.isMinusOne();
        if (isReZero && isImOne) {
            this.tagStart(buf, "mrow");
            this.tag(buf, "mi", "&#x2148;");
            this.tagEnd(buf, "mrow");
            return;
        }
        this.tagStart(buf, "mrow");
        if (!isReZero && 310 < precedence) {
            this.tag(buf, "mo", "(");
        }
        if (!isReZero) {
            this.convertFraction(buf, c.getRealPart(), 310, caller);
        }
        if (isImOne) {
            this.tagStart(buf, "mrow");
            if (isReZero) {
                if (caller) {
                    this.tag(buf, "mo", "+");
                }
                this.tag(buf, "mi", "&#x2148;");
            } else {
                this.tag(buf, "mo", "+");
                this.tag(buf, "mi", "&#x2148;");
            }
        } else if (isImMinusOne) {
            this.tagStart(buf, "mrow");
            this.tag(buf, "mo", "-");
            this.tag(buf, "mi", "&#x2148;");
        } else {
            this.tagStart(buf, "mrow");
            if (isImNegative) {
                imaginaryPart = imaginaryPart.negate();
            }
            if (!isReZero) {
                if (isImNegative) {
                    this.tag(buf, "mo", "-");
                } else {
                    this.tag(buf, "mo", "+");
                }
            } else {
                if (caller) {
                    this.tag(buf, "mo", "+");
                }
                if (isImNegative) {
                    this.tag(buf, "mo", "-");
                }
            }
            this.convertFraction(buf, imaginaryPart, 400, caller);
            this.tag(buf, "mo", "&#0183;");
            this.tag(buf, "mi", "&#x2148;");
        }
        this.tagEnd(buf, "mrow");
        if (!isReZero && 310 < precedence) {
            this.tag(buf, "mo", ")");
        }
        this.tagEnd(buf, "mrow");
    }

    @Override
    public void convertDouble(StringBuilder buf, INum d, int precedence, boolean caller) {
        if (d instanceof Num && F.isZero(d.doubleValue(), Config.ZERO_IN_OUTPUT_FORMAT)) {
            this.tagStart(buf, "mn");
            buf.append(this.convertDoubleToFormattedString(0.0));
            this.tagEnd(buf, "mn");
            return;
        }
        boolean isNegative = d.isNegative();
        if (isNegative && precedence > 310) {
            this.tagStart(buf, "mrow");
            this.tag(buf, "mo", "(");
        }
        if (d instanceof ApfloatNum) {
            this.convertApfloat(buf, d.apfloatValue(), precedence);
        } else {
            this.tagStart(buf, "mn");
            buf.append(this.convertDoubleToFormattedString(d.getRealPart()));
            this.tagEnd(buf, "mn");
        }
        if (isNegative && precedence > 310) {
            this.tag(buf, "mo", ")");
            this.tagEnd(buf, "mrow");
        }
    }

    @Override
    public void convertDoubleComplex(StringBuilder buf, IComplexNum dc, int precedence, boolean caller) {
        if (dc instanceof ApcomplexNum) {
            this.convertApcomplex(buf, ((ApcomplexNum)dc).apcomplexValue(), precedence);
            return;
        }
        double realPart = dc.getRealPart();
        double imaginaryPart = dc.getImaginaryPart();
        boolean isImNegative = imaginaryPart < 0.0;
        this.tagStart(buf, "mrow");
        if (310 < precedence) {
            this.tag(buf, "mo", "(");
        }
        this.tagStart(buf, "mn");
        buf.append(this.convertDoubleToFormattedString(realPart));
        this.tagEnd(buf, "mn");
        if (isImNegative) {
            this.tag(buf, "mo", "-");
            imaginaryPart *= -1.0;
        } else {
            this.tag(buf, "mo", "+");
        }
        this.tagStart(buf, "mn");
        buf.append(this.convertDoubleToFormattedString(imaginaryPart));
        this.tagEnd(buf, "mn");
        this.tag(buf, "mo", "&#0183;");
        this.tag(buf, "mi", "&#x2148;");
        if (310 < precedence) {
            this.tag(buf, "mo", ")");
        }
        this.tagEnd(buf, "mrow");
    }

    @Override
    protected String convertDoubleToFormattedString(double dValue) {
        if (this.fSignificantFigures > 0) {
            try {
                StringBuilder buf = new StringBuilder();
                DoubleToMMA.doubleToMMA(buf, dValue, this.fExponentFigures, this.fSignificantFigures, false);
                return buf.toString();
            }
            catch (IOException ioex) {
                LOGGER.error("MathMLFormFactory.convertDoubleToFormattedString() failed", (Throwable)ioex);
            }
        }
        return Double.toString(dValue);
    }

    public void convertFraction(StringBuilder buf, BigInteger n, BigInteger denominator, int precedence, boolean caller) {
        boolean isNegative;
        boolean isInteger = denominator.compareTo(BigInteger.ONE) == 0;
        BigInteger numerator = n;
        boolean bl = isNegative = numerator.compareTo(BigInteger.ZERO) < 0;
        if (isNegative) {
            numerator = numerator.negate();
        }
        int prec = isNegative ? 310 : 400;
        this.tagStart(buf, "mrow");
        if (!isNegative) {
            if (caller) {
                this.tag(buf, "mo", "-");
            }
        } else {
            this.tag(buf, "mo", "-");
        }
        if (prec < precedence) {
            this.tag(buf, "mo", "(");
        }
        String str = numerator.toString();
        if (!isInteger) {
            this.tagStart(buf, "mfrac");
            this.tagStart(buf, "mn");
            buf.append(str);
            this.tagEnd(buf, "mn");
            this.tagStart(buf, "mn");
            str = denominator.toString();
            buf.append(str);
            this.tagEnd(buf, "mn");
            this.tagEnd(buf, "mfrac");
        } else {
            this.tagStart(buf, "mn");
            buf.append(str);
            this.tagEnd(buf, "mn");
        }
        if (prec < precedence) {
            this.tag(buf, "mo", ")");
        }
        this.tagEnd(buf, "mrow");
    }

    public void convertFraction(StringBuilder buf, IFraction f, int precedence) {
        boolean isInteger = f.denominator().isOne();
        if (f.isNegative() && precedence > 310) {
            this.tagStart(buf, "mrow");
            this.tag(buf, "mo", "(");
        }
        if (isInteger) {
            this.tagStart(buf, "mn");
            buf.append(f.toBigNumerator().toString());
            this.tagEnd(buf, "mn");
        } else {
            this.tagStart(buf, "mfrac");
            this.tagStart(buf, "mn");
            buf.append(f.toBigNumerator().toString());
            this.tagEnd(buf, "mn");
            this.tagStart(buf, "mn");
            buf.append(f.toBigDenominator().toString());
            this.tagEnd(buf, "mn");
            this.tagEnd(buf, "mfrac");
        }
        if (f.isNegative() && precedence > 310) {
            this.tag(buf, "mo", ")");
            this.tagEnd(buf, "mrow");
        }
    }

    @Override
    public void convertFraction(StringBuilder buf, IRational f, int precedence, boolean caller) {
        this.convertFraction(buf, f.toBigNumerator(), f.toBigDenominator(), precedence, caller);
    }

    public void convertFunctionArgs(StringBuilder buf, IAST list) {
        this.tag(buf, "mo", "[");
        for (int i = 1; i < list.size(); ++i) {
            this.convertInternal(buf, list.get(i), Integer.MIN_VALUE, false);
            if (i >= list.argSize()) continue;
            this.tag(buf, "mo", ",");
        }
        this.tag(buf, "mo", "]");
    }

    @Override
    public void convertHead(StringBuilder buf, IExpr obj) {
        if (obj instanceof ISymbol) {
            String str;
            String headStr = ((ISymbol)obj).getSymbolName();
            if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(headStr)) != null) {
                headStr = str;
            }
            this.tagStart(buf, "mi");
            buf.append(headStr);
            this.tagEnd(buf, "mi");
            this.tag(buf, "mo", "&#x2061;");
            return;
        }
        this.convertInternal(buf, obj, Integer.MIN_VALUE, false);
    }

    public void convertInfixOperator(StringBuilder buf, IAST list, InfixOperator oper, int precedence) {
        if (list.isAST2()) {
            IExpr arg1 = list.arg1();
            IExpr arg2 = list.arg2();
            this.tagStart(buf, "mrow");
            if (oper.getPrecedence() < precedence) {
                this.tag(buf, "mo", "(");
            }
            if (oper.getGrouping() == 1 && list.arg1().head().equals(list.head())) {
                this.tag(buf, "mo", "(");
            }
            this.convertInternal(buf, arg1, oper.getPrecedence(), false);
            if (oper.getGrouping() == 1 && list.arg1().head().equals(list.head())) {
                this.tag(buf, "mo", ")");
            }
            this.appendOperatorUnicodeMapped(buf, oper.getOperatorString());
            if (oper.getGrouping() == 2 && list.arg2().head().equals(list.head())) {
                this.tag(buf, "mo", "(");
            }
            this.convertInternal(buf, arg2, oper.getPrecedence(), false);
            if (oper.getGrouping() == 2 && list.arg2().head().equals(list.head())) {
                this.tag(buf, "mo", ")");
            }
            if (oper.getPrecedence() < precedence) {
                this.tag(buf, "mo", ")");
            }
            this.tagEnd(buf, "mrow");
            return;
        }
        this.tagStart(buf, "mrow");
        if (oper.getPrecedence() < precedence) {
            this.tag(buf, "mo", "(");
        }
        if (list.size() > 1) {
            this.convertInternal(buf, list.arg1(), oper.getPrecedence(), false);
        }
        for (int i = 2; i < list.size(); ++i) {
            this.appendOperatorUnicodeMapped(buf, oper.getOperatorString());
            this.convertInternal(buf, list.get(i), oper.getPrecedence(), false);
        }
        if (oper.getPrecedence() < precedence) {
            this.tag(buf, "mo", ")");
        }
        this.tagEnd(buf, "mrow");
    }

    private void appendOperatorUnicodeMapped(StringBuilder buf, String operatorString) {
        operatorString = Characters.mapWLUnicodeToEquivalent((String)operatorString);
        this.tag(buf, "mo", operatorString);
    }

    private static void appendUnicodeMapped(StringBuilder buf, String str) {
        str = Characters.mapWLUnicodeToEquivalent((String)str);
        buf.append(str);
    }

    @Override
    public void convertInteger(StringBuilder buf, IInteger i, int precedence, boolean caller) {
        if (i.isNegative() && precedence > 310) {
            this.tagStart(buf, "mrow");
            this.tag(buf, "mo", "(");
        }
        this.tagStart(buf, "mn");
        buf.append(i.toBigNumerator().toString());
        this.tagEnd(buf, "mn");
        if (i.isNegative() && precedence > 310) {
            this.tag(buf, "mo", ")");
            this.tagEnd(buf, "mrow");
        }
    }

    public void convertList(StringBuilder buf, IAST list) {
        this.tagStart(buf, "mrow");
        this.tag(buf, "mo", "{");
        if (list.size() > 1) {
            this.tagStart(buf, "mrow");
            this.convertInternal(buf, list.arg1(), Integer.MIN_VALUE, false);
            for (int i = 2; i < list.size(); ++i) {
                this.tag(buf, "mo", ",");
                this.convertInternal(buf, list.get(i), Integer.MIN_VALUE, false);
            }
            this.tagEnd(buf, "mrow");
        }
        this.tag(buf, "mo", "}");
        this.tagEnd(buf, "mrow");
    }

    public void convertAssociation(StringBuilder buf, IAssociation association) {
        IASTMutable list = association.normal(false);
        this.tagStart(buf, "mrow");
        this.tag(buf, "mo", "&lt;|");
        if (list.size() > 1) {
            this.tagStart(buf, "mrow");
            this.convertInternal(buf, list.arg1(), 0, false);
            for (int i = 2; i < list.size(); ++i) {
                this.tag(buf, "mo", ",");
                this.convertInternal(buf, list.get(i), 0, false);
            }
            this.tagEnd(buf, "mrow");
        }
        this.tag(buf, "mo", "|&gt;");
        this.tagEnd(buf, "mrow");
    }

    public boolean convertInterval(StringBuilder buf, IAST f) {
        if (f.size() > 1 && f.first().isASTSizeGE(S.List, 2)) {
            IAST interval = IntervalSym.normalize(f);
            this.tagStart(buf, "mrow");
            this.tagStart(buf, "mi");
            buf.append("Interval");
            this.tagEnd(buf, "mi");
            this.tag(buf, "mo", "&#x2061;");
            this.tagStart(buf, "mrow");
            if (this.fRelaxedSyntax) {
                this.tag(buf, "mo", "(");
            } else {
                this.tag(buf, "mo", "[");
            }
            for (int i = 1; i < interval.size(); ++i) {
                this.tagStart(buf, "mrow");
                this.tag(buf, "mo", "{");
                IAST subList = (IAST)interval.get(i);
                IExpr min = subList.arg1();
                IExpr max = subList.arg2();
                if (min instanceof INum) {
                    this.convertDouble(buf, (INum)min, Integer.MIN_VALUE, false);
                } else {
                    this.convertInternal(buf, min, 0, false);
                }
                this.tag(buf, "mo", ",");
                if (max instanceof INum) {
                    this.convertDouble(buf, (INum)max, Integer.MIN_VALUE, false);
                } else {
                    this.convertInternal(buf, max, 0, false);
                }
                this.tag(buf, "mo", "}");
                this.tagEnd(buf, "mrow");
                if (i >= interval.size() - 1) continue;
                this.tag(buf, "mo", ",");
            }
            if (this.fRelaxedSyntax) {
                this.tag(buf, "mo", ")");
            } else {
                this.tag(buf, "mo", "]");
            }
            this.tagEnd(buf, "mrow");
            this.tagEnd(buf, "mrow");
            return true;
        }
        return false;
    }

    public boolean convertNumber(StringBuilder buf, IExpr o, int precedence, boolean caller) {
        if (o instanceof INum) {
            this.convertDouble(buf, (INum)o, precedence, caller);
            return true;
        }
        if (o instanceof IComplexNum) {
            this.convertDoubleComplex(buf, (IComplexNum)o, precedence, caller);
            return true;
        }
        if (o instanceof IInteger) {
            this.convertInteger(buf, (IInteger)o, precedence, caller);
            return true;
        }
        if (o instanceof IFraction) {
            this.convertFraction(buf, (IFraction)o, precedence, caller);
            return true;
        }
        if (o instanceof IComplex) {
            this.convertComplex(buf, (IComplex)o, precedence, caller);
            return true;
        }
        return false;
    }

    private boolean convertOperator(org.matheclipse.parser.client.operator.Operator operator, IAST list, StringBuilder buf, int precedence, ISymbol head) {
        if (operator instanceof PrefixOperator && list.isAST1()) {
            this.convertPrefixOperator(buf, list, (PrefixOperator)operator, precedence);
            return true;
        }
        if (operator instanceof InfixOperator && list.size() > 2) {
            InfixOperator infixOperator = (InfixOperator)operator;
            if (list.isAST(S.Apply)) {
                if (list.size() == 3) {
                    this.convertInfixOperator(buf, list, (InfixOperator)ASTNodeFactory.APPLY_OPERATOR, precedence);
                    return true;
                }
                if (list.size() == 4 && list.arg2().equals(F.CListC1)) {
                    this.convertInfixOperator(buf, list, (InfixOperator)ASTNodeFactory.APPLY_LEVEL_OPERATOR, precedence);
                    return true;
                }
                return false;
            }
            if (list.size() != 3 && infixOperator.getGrouping() != 0) {
                return false;
            }
            this.convertInfixOperator(buf, list, (InfixOperator)operator, precedence);
            return true;
        }
        if (operator instanceof PostfixOperator && list.isAST1()) {
            this.convertPostfixOperator(buf, list, (PostfixOperator)operator, precedence);
            return true;
        }
        return false;
    }

    public void convertPart(StringBuilder buf, IAST list) {
        IExpr arg1 = list.arg1();
        this.tagStart(buf, "mrow");
        if (!(arg1 instanceof IAST)) {
            this.tag(buf, "mo", "(");
        }
        this.convertInternal(buf, arg1, Integer.MIN_VALUE, false);
        this.tag(buf, "mo", "[[");
        for (int i = 2; i < list.size(); ++i) {
            this.convertInternal(buf, list.get(i), Integer.MIN_VALUE, false);
            if (i >= list.argSize()) continue;
            this.tag(buf, "mo", ",");
        }
        this.tag(buf, "mo", "]]");
        if (!(arg1 instanceof IAST)) {
            this.tag(buf, "mo", ")");
        }
        this.tagEnd(buf, "mrow");
    }

    public void convertPostfixOperator(StringBuilder buf, IAST list, PostfixOperator oper, int precedence) {
        this.tagStart(buf, "mrow");
        if (oper.getPrecedence() <= precedence) {
            this.tag(buf, "mo", "(");
        }
        this.convertInternal(buf, list.arg1(), oper.getPrecedence(), false);
        this.tag(buf, "mo", oper.getOperatorString());
        if (oper.getPrecedence() <= precedence) {
            this.tag(buf, "mo", ")");
        }
        this.tagEnd(buf, "mrow");
    }

    public void convertPrefixOperator(StringBuilder buf, IAST list, PrefixOperator oper, int precedence) {
        this.tagStart(buf, "mrow");
        if (oper.getPrecedence() <= precedence) {
            this.tag(buf, "mo", "(");
        }
        this.tag(buf, "mo", oper.getOperatorString());
        this.convertInternal(buf, list.arg1(), oper.getPrecedence(), false);
        if (oper.getPrecedence() <= precedence) {
            this.tag(buf, "mo", ")");
        }
        this.tagEnd(buf, "mrow");
    }

    public boolean convertSeriesData(StringBuilder buf, ASTSeriesData seriesData, int precedence) {
        StringBuilder tempBuffer = new StringBuilder();
        this.tagStart(tempBuffer, "mrow");
        if (310 < precedence) {
            this.tag(tempBuffer, "mo", "(");
        }
        try {
            IExpr x = seriesData.getX();
            IExpr x0 = seriesData.getX0();
            int nMin = seriesData.getNMin();
            int nMax = seriesData.getNMax();
            int power = seriesData.order();
            int den = seriesData.getDenominator();
            boolean call = false;
            boolean first = true;
            IExpr x0Term = x.subtract(x0);
            for (int i = nMin; i < nMax; ++i) {
                IExpr coefficient = seriesData.coefficient(i);
                if (coefficient.isZero()) continue;
                if (!first) {
                    this.tag(tempBuffer, "mo", "+");
                }
                IRational exp = F.fraction(i, den).normalize();
                IExpr pow = x0Term.power(exp);
                call = this.convertSeriesDataArg(tempBuffer, coefficient, pow, call);
                first = false;
            }
            IAST plusArg = F.Power((IExpr)F.O(x.subtract(x0)), F.fraction(power, den).normalize());
            if (!plusArg.isZero()) {
                this.tag(tempBuffer, "mo", "+");
                this.convertInternal(tempBuffer, plusArg, Integer.MIN_VALUE, false);
                call = true;
            }
        }
        catch (Exception ex) {
            LOGGER.debug("MathMLFormFactory.convertSeriesData() failed", (Throwable)ex);
            return false;
        }
        if (310 < precedence) {
            this.tag(tempBuffer, "mo", ")");
        }
        this.tagEnd(tempBuffer, "mrow");
        buf.append((CharSequence)tempBuffer);
        return true;
    }

    private boolean convertSeriesDataArg(StringBuilder buf, IExpr coefficient, IExpr pow, boolean call) {
        IExpr plusArg = coefficient.isZero() ? F.C0 : (coefficient.isOne() ? pow : (pow.isOne() ? coefficient : F.binaryAST2((IExpr)S.Times, coefficient, pow)));
        if (!plusArg.isZero()) {
            this.convertInternal(buf, plusArg, Integer.MIN_VALUE, false);
            call = true;
        }
        return call;
    }

    public void convertSlot(StringBuilder buf, IAST list) {
        try {
            int slot = ((ISignedNumber)list.arg1()).toInt();
            this.tag(buf, "mi", "#" + slot);
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void convertSlotSequence(StringBuilder buf, IAST list) {
        try {
            int slotSequenceStartPosition = ((ISignedNumber)list.arg1()).toInt();
            this.tag(buf, "mi", "##" + slotSequenceStartPosition);
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Override
    public void convertString(StringBuilder buf, String str) {
        String[] splittedStr = str.split("\\n");
        int splittedStrLength = splittedStr.length;
        for (int i = 0; i < splittedStrLength; ++i) {
            this.tagStart(buf, "mtext");
            String text = splittedStr[i].replaceAll("\\&", "&amp;").replaceAll("\\<", "&lt;").replaceAll("\\>", "&gt;");
            text = text.replaceAll("\\\"", "&quot;").replace(" ", "&nbsp;");
            MathMLFormFactory.appendUnicodeMapped(buf, text);
            this.tagEnd(buf, "mtext");
            if (splittedStrLength <= 1) continue;
            buf.append("<mspace linebreak='newline' />");
        }
    }

    public static String mathMLMtext(String str) {
        StringBuilder buf = new StringBuilder();
        String[] splittedStr = str.split("\\n");
        int splittedStrLength = splittedStr.length;
        for (int i = 0; i < splittedStrLength; ++i) {
            buf.append("<mtext>");
            String text = splittedStr[i].replaceAll("\\&", "&amp;").replaceAll("\\<", "&lt;").replaceAll("\\>", "&gt;");
            text = text.replaceAll("\\\"", "&quot;").replace(" ", "&nbsp;");
            MathMLFormFactory.appendUnicodeMapped(buf, text);
            buf.append("</mtext>");
            if (splittedStrLength <= 1) continue;
            buf.append("<mspace linebreak='newline' />");
        }
        return buf.toString();
    }

    @Override
    public void convertSymbol(StringBuilder buf, ISymbol sym) {
        Context context = sym.getContext();
        if (context == Context.DUMMY) {
            this.tagStart(buf, "mi");
            buf.append(sym.getSymbolName());
            this.tagEnd(buf, "mi");
            return;
        }
        String headStr = sym.getSymbolName();
        if (context.equals(Context.SYSTEM) || context.isGlobal()) {
            Object convertedSymbol;
            String str;
            if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(headStr)) != null) {
                headStr = str;
            }
            if ((convertedSymbol = CONSTANT_SYMBOLS.get(headStr)) == null) {
                this.tagStart(buf, "mi");
                buf.append(headStr);
                this.tagEnd(buf, "mi");
                return;
            }
            if (convertedSymbol instanceof Operator) {
                ((Operator)convertedSymbol).convert(buf);
                return;
            }
            this.tagStart(buf, "mi");
            buf.append(convertedSymbol.toString());
            this.tagEnd(buf, "mi");
            return;
        }
        if (EvalEngine.get().getContextPath().contains(context)) {
            this.tagStart(buf, "mi");
            buf.append(sym.getSymbolName());
        } else {
            this.tagStart(buf, "mi");
            buf.append(context.toString() + sym.getSymbolName());
        }
        this.tagEnd(buf, "mi");
    }

    public void init() {
        if (Config.MATHML_TRIG_LOWERCASE) {
            CONVERTERS.put(S.Sin, new MMLFunction(this, "sin"));
            CONVERTERS.put(S.Cos, new MMLFunction(this, "cos"));
            CONVERTERS.put(S.Csc, new MMLFunction(this, "csc"));
            CONVERTERS.put(S.Tan, new MMLFunction(this, "tan"));
            CONVERTERS.put(S.Sec, new MMLFunction(this, "sec"));
            CONVERTERS.put(S.Cot, new MMLFunction(this, "cot"));
            CONVERTERS.put(S.ArcSin, new MMLFunction(this, "arcsin"));
            CONVERTERS.put(S.ArcCos, new MMLFunction(this, "arccos"));
            CONVERTERS.put(S.ArcCsc, new MMLFunction(this, "arccsc"));
            CONVERTERS.put(S.ArcSec, new MMLFunction(this, "arcsec"));
            CONVERTERS.put(S.ArcTan, new MMLFunction(this, "arctan"));
            CONVERTERS.put(S.ArcCot, new MMLFunction(this, "arccot"));
            CONVERTERS.put(S.ArcSinh, new MMLFunction(this, "arcsinh"));
            CONVERTERS.put(S.ArcCosh, new MMLFunction(this, "arccosh"));
            CONVERTERS.put(S.ArcCsch, new MMLFunction(this, "arccsch"));
            CONVERTERS.put(S.ArcCoth, new MMLFunction(this, "arccoth"));
            CONVERTERS.put(S.ArcSech, new MMLFunction(this, "arcsech"));
            CONVERTERS.put(S.ArcTanh, new MMLFunction(this, "arctanh"));
            CONVERTERS.put(S.Log, new MMLFunction(this, "log"));
        }
        CONSTANT_SYMBOLS.put("E", "&#x2147;");
        CONSTANT_SYMBOLS.put("HEllipsis", new Operator("&#x2026;"));
        CONSTANT_SYMBOLS.put("Alpha", "&#x0391;");
        CONSTANT_SYMBOLS.put("Beta", "&#x0392;");
        CONSTANT_SYMBOLS.put("Gamma", "&#x0393;");
        CONSTANT_SYMBOLS.put("Delta", "&#x0394;");
        CONSTANT_SYMBOLS.put("Epsilon", "&#x0395;");
        CONSTANT_SYMBOLS.put("Zeta", "&#x0396;");
        CONSTANT_SYMBOLS.put("Eta", "&#x0397;");
        CONSTANT_SYMBOLS.put("Theta", "&#x0398;");
        CONSTANT_SYMBOLS.put("Iota", "&#x0399;");
        CONSTANT_SYMBOLS.put("Kappa", "&#x039A;");
        CONSTANT_SYMBOLS.put("Lambda", "&#x039B;");
        CONSTANT_SYMBOLS.put("Mu", "&#x039C;");
        CONSTANT_SYMBOLS.put("Nu", "&#x039D;");
        CONSTANT_SYMBOLS.put("Xi", "&#x039E;");
        CONSTANT_SYMBOLS.put("Omicron", "&#x039F;");
        CONSTANT_SYMBOLS.put("Rho", "&#x03A1;");
        CONSTANT_SYMBOLS.put("Sigma", "&#x03A3;");
        CONSTANT_SYMBOLS.put("Tau", "&#x03A4;");
        CONSTANT_SYMBOLS.put("Upsilon", "&#x03A5;");
        CONSTANT_SYMBOLS.put("Phi", "&#x03A6;");
        CONSTANT_SYMBOLS.put("Chi", "&#x03A7;");
        CONSTANT_SYMBOLS.put("Psi", "&#x03A8;");
        CONSTANT_SYMBOLS.put("Omega", "&#x03A9;");
        CONSTANT_SYMBOLS.put("varTheta", "&#x03D1;");
        CONSTANT_SYMBOLS.put("alpha", "&#x03B1;");
        CONSTANT_SYMBOLS.put("beta", "&#x03B2;");
        CONSTANT_SYMBOLS.put("chi", "&#x03C7;");
        CONSTANT_SYMBOLS.put("selta", "&#x03B4;");
        CONSTANT_SYMBOLS.put("epsilon", "&#x03B5;");
        CONSTANT_SYMBOLS.put("phi", "&#x03C7;");
        CONSTANT_SYMBOLS.put("gamma", "&#x03B3;");
        CONSTANT_SYMBOLS.put("eta", "&#x03B7;");
        CONSTANT_SYMBOLS.put("iota", "&#x03B9;");
        CONSTANT_SYMBOLS.put("varphi", "&#x03C6;");
        CONSTANT_SYMBOLS.put("kappa", "&#x03BA;");
        CONSTANT_SYMBOLS.put("lambda", "&#x03BB;");
        CONSTANT_SYMBOLS.put("mu", "&#x03BC;");
        CONSTANT_SYMBOLS.put("nu", "&#x03BD;");
        CONSTANT_SYMBOLS.put("omicron", "&#x03BF;");
        CONSTANT_SYMBOLS.put("theta", "&#x03B8;");
        CONSTANT_SYMBOLS.put("rho", "&#x03C1;");
        CONSTANT_SYMBOLS.put("sigma", "&#x03C3;");
        CONSTANT_SYMBOLS.put("tau", "&#x03C4;");
        CONSTANT_SYMBOLS.put("upsilon", "&#x03C5;");
        CONSTANT_SYMBOLS.put("varsigma", "&#x03C2;");
        CONSTANT_SYMBOLS.put("omega", "&#x03C9;");
        CONSTANT_SYMBOLS.put("xi", "&#x03BE;");
        CONSTANT_SYMBOLS.put("psi", "&#x03C8;");
        CONSTANT_SYMBOLS.put("zeta", "&#x03B6;");
        ENTITY_TABLE.put("&af;", "&#xE8A0;");
        ENTITY_TABLE.put("&dd;", "&#xF74C;");
        ENTITY_TABLE.put("&ImaginaryI;", "i");
        ENTITY_TABLE.put("&InvisibleTimes;", "&#xE89E;");
        ENTITY_TABLE.put("&Integral;", "&#x222B;");
        ENTITY_TABLE.put("&PartialD;", "&#x2202;");
        ENTITY_TABLE.put("&Product;", "&#x220F;");
        CONSTANT_EXPRS.put(S.GoldenRatio, "<mi>&#x03C7;</mi>");
        CONSTANT_EXPRS.put(S.Pi, "<mi>&#x03C0;</mi>");
        CONSTANT_EXPRS.put(F.CInfinity, "<mi>&#x221E;</mi>");
        CONSTANT_EXPRS.put(F.CNInfinity, "<mrow><mo>-</mo><mi>&#x221E;</mi></mrow>");
        CONSTANT_EXPRS.put(S.Catalan, "<mi>C</mi>");
        CONSTANT_EXPRS.put(S.Degree, "<mi>&#x00b0;</mi>");
        CONSTANT_EXPRS.put(S.Glaisher, "<mi>A</mi>");
        CONSTANT_EXPRS.put(S.EulerGamma, "<mi>&#x03B3;</mi>");
        CONSTANT_EXPRS.put(S.Khinchin, "<mi>K</mi>");
        CONSTANT_EXPRS.put(S.Complexes, "<mi>&#8450;</mi>");
        CONSTANT_EXPRS.put(S.Integers, "<mi>&#8484;</mi>");
        CONSTANT_EXPRS.put(S.Rationals, "<mi>&#8474;</mi>");
        CONSTANT_EXPRS.put(S.Reals, "<mi>&#8477;</mi>");
        CONVERTERS.put(S.Abs, new Abs());
        CONVERTERS.put(S.And, new MMLOperator(215, "&#x2227;"));
        CONVERTERS.put(S.Binomial, new Binomial());
        CONVERTERS.put(S.C, new C());
        CONVERTERS.put(S.Ceiling, new Ceiling());
        CONVERTERS.put(S.CompoundExpression, new MMLOperator(10, ";"));
        CONVERTERS.put(S.D, new D());
        CONVERTERS.put(S.DirectedEdge, new MMLOperator(120, "-&gt;"));
        CONVERTERS.put(S.Dot, new MMLOperator(490, "."));
        CONVERTERS.put(S.Element, new Element());
        CONVERTERS.put(S.Equal, new MMLOperator(290, "=="));
        CONVERTERS.put(S.Factorial, new MMLPostfix("!", 610));
        CONVERTERS.put(S.Factorial2, new MMLPostfix("!!", 610));
        CONVERTERS.put(S.Floor, new Floor());
        CONVERTERS.put(S.Function, new Function());
        CONVERTERS.put(S.Greater, new MMLOperator(290, "&gt;"));
        CONVERTERS.put(S.GreaterEqual, new MMLOperator(290, "&#x2265;"));
        CONVERTERS.put(S.Integrate, new Integrate());
        CONVERTERS.put(S.Less, new MMLOperator(290, "&lt;"));
        CONVERTERS.put(S.LessEqual, new MMLOperator(290, "&#x2264;"));
        CONVERTERS.put(S.MatrixForm, new MatrixForm(false));
        CONVERTERS.put(S.TableForm, new MatrixForm(true));
        CONVERTERS.put(S.Not, new Not());
        CONVERTERS.put(S.Or, new MMLOperator(213, "&#x2228;"));
        CONVERTERS.put(S.Plus, new Plus());
        CONVERTERS.put(S.Power, new Power());
        CONVERTERS.put(S.Product, new Product());
        CONVERTERS.put(S.Rational, new Rational());
        CONVERTERS.put(S.Rule, new MMLOperator(120, "-&gt;"));
        CONVERTERS.put(S.RuleDelayed, new MMLOperator(120, "&#x29F4;"));
        CONVERTERS.put(S.Set, new MMLOperator(40, "="));
        CONVERTERS.put(S.SetDelayed, new MMLOperator(40, ":="));
        CONVERTERS.put(S.Sqrt, new Sqrt());
        CONVERTERS.put(S.Subscript, new Subscript());
        CONVERTERS.put(S.Superscript, new Superscript());
        CONVERTERS.put(S.Sum, new Sum());
        CONVERTERS.put(S.Surd, new Surd());
        CONVERTERS.put(S.Times, new Times());
        CONVERTERS.put(S.TwoWayRule, new MMLOperator(125, "&lt;-&gt;"));
        CONVERTERS.put(S.UndirectedEdge, new MMLOperator(120, "&lt;-&gt;"));
        CONVERTERS.put(S.Unequal, new MMLOperator(290, "!="));
        CONVERTERS.put(S.CenterDot, new MMLOperator(410, "&#183;"));
        CONVERTERS.put(S.CircleDot, new MMLOperator(520, "&#8857;"));
    }

    private static final class Times
    extends MMLOperator {
        public Times() {
            super(400, "mrow", "&#0183;");
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            return this.convertTimesFraction(buf, f, precedence, false);
        }

        public boolean convertTimesFraction(StringBuilder buf, IAST f, int precedence, boolean caller) {
            IExpr[] parts = Algebra.fractionalPartsTimesPower(f, false, true, false, false, false, false);
            if (parts == null) {
                this.convertTimesOperator(buf, f, precedence, caller);
                return true;
            }
            IExpr numerator = parts[0];
            IExpr denominator = parts[1];
            this.precedenceOpen(buf, precedence);
            if (!denominator.isOne()) {
                if (caller) {
                    this.fFactory.tag(buf, "mo", "+");
                }
                this.fFactory.tagStart(buf, "mfrac");
                if (numerator.isTimes()) {
                    this.convertTimesOperator(buf, (IAST)numerator, Integer.MIN_VALUE, false);
                } else {
                    this.fFactory.convertInternal(buf, numerator, Integer.MIN_VALUE, false);
                }
                if (denominator.isTimes()) {
                    this.convertTimesOperator(buf, (IAST)denominator, Integer.MIN_VALUE, false);
                } else {
                    this.fFactory.convertInternal(buf, denominator, Integer.MIN_VALUE, false);
                }
                this.fFactory.tagEnd(buf, "mfrac");
            } else if (numerator.isTimes()) {
                this.convertTimesOperator(buf, (IAST)numerator, precedence, caller);
            } else {
                this.convertTimesOperator(buf, f, precedence, caller);
            }
            this.precedenceClose(buf, precedence);
            return true;
        }

        private boolean convertTimesOperator(StringBuilder buf, IAST timesAST, int precedence, boolean caller) {
            int size = timesAST.size();
            boolean noPrecedenceOpenCall = false;
            if (size > 1) {
                IExpr arg1 = timesAST.arg1();
                if (arg1.isMinusOne()) {
                    if (size == 2) {
                        this.fFactory.tagStart(buf, this.fFirstTag);
                        this.precedenceOpen(buf, precedence);
                        this.fFactory.convertInternal(buf, arg1, this.fPrecedence, false);
                    } else if (!caller) {
                        noPrecedenceOpenCall = true;
                        this.fFactory.tagStart(buf, this.fFirstTag);
                        this.fFactory.tag(buf, "mo", "-");
                        if (size == 3) {
                            this.fFactory.convertInternal(buf, timesAST.arg2(), this.fPrecedence, false);
                            this.fFactory.tagEnd(buf, this.fFirstTag);
                            return true;
                        }
                    } else {
                        this.fFactory.tagStart(buf, this.fFirstTag);
                        this.precedenceOpen(buf, precedence);
                        this.fFactory.tag(buf, "mo", "-");
                    }
                } else if (arg1.isOne()) {
                    if (size == 2) {
                        this.fFactory.tagStart(buf, this.fFirstTag);
                        this.precedenceOpen(buf, precedence);
                        this.fFactory.convertInternal(buf, arg1, this.fPrecedence, false);
                    } else if (caller) {
                        if (size == 3) {
                            this.fFactory.convertInternal(buf, timesAST.arg2(), this.fPrecedence, false);
                            return true;
                        }
                        this.fFactory.tagStart(buf, this.fFirstTag);
                    } else {
                        this.fFactory.tagStart(buf, this.fFirstTag);
                        this.precedenceOpen(buf, precedence);
                    }
                } else {
                    if (caller) {
                        if (arg1.isReal() && arg1.isNegative()) {
                            this.fFactory.tag(buf, "mo", "-");
                            this.fFactory.tagStart(buf, this.fFirstTag);
                            arg1 = ((ISignedNumber)arg1).negate();
                        } else {
                            this.fFactory.tag(buf, "mo", "+");
                            this.fFactory.tagStart(buf, this.fFirstTag);
                        }
                    } else {
                        this.fFactory.tagStart(buf, this.fFirstTag);
                        this.precedenceOpen(buf, precedence);
                    }
                    this.fFactory.convertInternal(buf, arg1, this.fPrecedence, false);
                    if (this.fOperator.length() > 0) {
                        this.fFactory.tag(buf, "mo", this.fOperator);
                    }
                }
            }
            for (int i = 2; i < size; ++i) {
                this.fFactory.convertInternal(buf, timesAST.get(i), this.fPrecedence, false);
                if (i >= timesAST.argSize() || this.fOperator.length() <= 0) continue;
                this.fFactory.tag(buf, "mo", this.fOperator);
            }
            if (!noPrecedenceOpenCall) {
                this.precedenceClose(buf, precedence);
            }
            this.fFactory.tagEnd(buf, this.fFirstTag);
            return true;
        }
    }

    private static class Sum
    extends AbstractConverter {
        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() >= 3) {
                return this.iteratorStep(buf, "&#x2211;", f, 2);
            }
            return false;
        }

        public boolean iteratorStep(StringBuilder buf, String mathSymbol, IAST f, int i) {
            block8: {
                if (i >= f.size()) {
                    this.fFactory.convertInternal(buf, f.arg1(), Integer.MIN_VALUE, false);
                    return true;
                }
                this.fFactory.tagStart(buf, "mrow");
                if (f.get(i).isList()) {
                    try {
                        IIterator<IExpr> iterator = Iterator.create((IAST)f.get(i), i, EvalEngine.get());
                        if (iterator.isValidVariable() && iterator.getStep().isOne()) {
                            this.fFactory.tagStart(buf, "munderover");
                            this.fFactory.tag(buf, "mo", mathSymbol);
                            this.fFactory.tagStart(buf, "mrow");
                            this.fFactory.convertSymbol(buf, iterator.getVariable());
                            this.fFactory.tag(buf, "mo", "=");
                            this.fFactory.convertInternal(buf, iterator.getLowerLimit(), Integer.MIN_VALUE, false);
                            this.fFactory.tagEnd(buf, "mrow");
                            this.fFactory.convertInternal(buf, iterator.getUpperLimit(), Integer.MIN_VALUE, false);
                            this.fFactory.tagEnd(buf, "munderover");
                            if (!this.iteratorStep(buf, mathSymbol, f, i + 1)) {
                                return false;
                            }
                            this.fFactory.tagEnd(buf, "mrow");
                            return true;
                        }
                        break block8;
                    }
                    catch (ArgumentTypeException e) {
                        return false;
                    }
                }
                if (f.get(i).isSymbol()) {
                    ISymbol symbol = (ISymbol)f.get(i);
                    this.fFactory.tagStart(buf, "munderover");
                    this.fFactory.tag(buf, "mo", mathSymbol);
                    this.fFactory.tagStart(buf, "mrow");
                    this.fFactory.convertSymbol(buf, symbol);
                    this.fFactory.tagEnd(buf, "mrow");
                    this.fFactory.tagStart(buf, "mi");
                    this.fFactory.tagEnd(buf, "mi");
                    this.fFactory.tagEnd(buf, "munderover");
                    if (!this.iteratorStep(buf, mathSymbol, f, i + 1)) {
                        return false;
                    }
                    this.fFactory.tagEnd(buf, "mrow");
                    return true;
                }
            }
            return false;
        }
    }

    private static final class Superscript
    extends MMLOperator {
        public Superscript() {
            super(0, "msup", "");
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 3) {
                return false;
            }
            IExpr arg1 = f.arg1();
            IExpr arg2 = f.arg2();
            this.fFactory.tagStart(buf, "msup");
            this.fFactory.convertInternal(buf, arg1, this.fPrecedence, false);
            this.fFactory.convertInternal(buf, arg2, this.fPrecedence, false);
            this.fFactory.tagEnd(buf, "msup");
            return true;
        }
    }

    private static final class Subscript
    extends MMLOperator {
        public Subscript() {
            super(0, "msub", "");
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() < 3) {
                return false;
            }
            if (f.isAST2()) {
                IExpr arg1 = f.arg1();
                IExpr arg2 = f.arg2();
                this.fFactory.tagStart(buf, "msub");
                this.fFactory.convertInternal(buf, arg1, this.fPrecedence, false);
                this.fFactory.convertInternal(buf, arg2, this.fPrecedence, false);
                this.fFactory.tagEnd(buf, "msub");
                return true;
            }
            this.fFactory.tagStart(buf, "msub");
            this.fFactory.convertInternal(buf, f.arg1(), this.fPrecedence, false);
            this.fFactory.tagStart(buf, "mrow");
            for (int i = 2; i < f.size(); ++i) {
                this.fFactory.convertInternal(buf, f.get(i), this.fPrecedence, false);
                if (i >= f.size() - 1) continue;
                buf.append("<mo>,</mo>");
            }
            this.fFactory.tagEnd(buf, "mrow");
            this.fFactory.tagEnd(buf, "msub");
            return true;
        }
    }

    private static final class Surd
    extends AbstractConverter {
        private Surd() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 3) {
                return false;
            }
            if (f.arg2().isNegative()) {
                this.fFactory.tagStart(buf, "mfrac");
                this.fFactory.tagStart(buf, "mn");
                buf.append("1");
                this.fFactory.tagEnd(buf, "mn");
                this.fFactory.tagStart(buf, "mroot");
                this.fFactory.convertInternal(buf, f.arg1(), Integer.MIN_VALUE, false);
                this.fFactory.convertInternal(buf, f.arg2().negate(), Integer.MIN_VALUE, false);
                this.fFactory.tagEnd(buf, "mroot");
                this.fFactory.tagEnd(buf, "mfrac");
            } else {
                this.fFactory.tagStart(buf, "mroot");
                this.fFactory.convertInternal(buf, f.arg1(), Integer.MIN_VALUE, false);
                this.fFactory.convertInternal(buf, f.arg2(), Integer.MIN_VALUE, false);
                this.fFactory.tagEnd(buf, "mroot");
            }
            return true;
        }
    }

    private static final class Sqrt
    extends AbstractConverter {
        private Sqrt() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 2) {
                return false;
            }
            this.fFactory.tagStart(buf, "msqrt");
            this.fFactory.convertInternal(buf, f.arg1(), Integer.MIN_VALUE, false);
            this.fFactory.tagEnd(buf, "msqrt");
            return true;
        }
    }

    private static final class Rational
    extends AbstractConverter {
        private Rational() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 3) {
                return false;
            }
            this.fFactory.tagStart(buf, "mfrac");
            this.fFactory.convertInternal(buf, f.arg1(), Integer.MIN_VALUE, false);
            this.fFactory.convertInternal(buf, f.arg2(), Integer.MIN_VALUE, false);
            this.fFactory.tagEnd(buf, "mfrac");
            return true;
        }
    }

    private static final class Product
    extends Sum {
        private Product() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() >= 3) {
                return this.iteratorStep(buf, "&#x220F;", f, 2);
            }
            return false;
        }
    }

    private static final class Power
    extends MMLOperator {
        public Power() {
            super(590, "msup", "");
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            IFraction f2;
            IExpr arg2;
            if (f.size() != 3) {
                return false;
            }
            IExpr arg1 = f.arg1();
            IExpr exp = arg2 = f.arg2();
            IInteger den = F.C1;
            int useMROOT = 0;
            if (arg2.isFraction() && (f2 = (IFraction)arg2).isPositive()) {
                exp = f2.numerator();
                if (f2.isNumEqualRational(F.C1D2)) {
                    this.fFactory.tagStart(buf, "msqrt");
                    useMROOT = 1;
                } else {
                    den = f2.denominator();
                    this.fFactory.tagStart(buf, "mroot");
                    useMROOT = 2;
                }
            }
            if (useMROOT > 0 && exp.isOne()) {
                this.fFactory.convertInternal(buf, arg1, Integer.MIN_VALUE, false);
            } else if (exp.isNegative()) {
                exp = exp.negate();
                this.fFactory.tagStart(buf, "mfrac");
                this.fFactory.convertInternal(buf, F.C1, Integer.MIN_VALUE, false);
                if (exp.isOne()) {
                    this.fFactory.convertInternal(buf, arg1, Integer.MIN_VALUE, false);
                } else {
                    this.convert(buf, F.Power(arg1, exp), Integer.MIN_VALUE);
                }
                this.fFactory.tagEnd(buf, "mfrac");
            } else {
                this.precedenceOpen(buf, precedence);
                this.fFactory.tagStart(buf, "msup");
                this.fFactory.convertInternal(buf, arg1, this.fPrecedence, false);
                this.fFactory.convertInternal(buf, exp, this.fPrecedence, false);
                this.fFactory.tagEnd(buf, "msup");
                this.precedenceClose(buf, precedence);
            }
            if (useMROOT == 1) {
                this.fFactory.tagEnd(buf, "msqrt");
            } else if (useMROOT == 2) {
                this.fFactory.convertInternal(buf, den, this.fPrecedence, false);
                this.fFactory.tagEnd(buf, "mroot");
            }
            return true;
        }
    }

    private static final class Plus
    extends MMLOperator {
        public Plus() {
            super(310, "mrow", "+");
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            int size;
            this.fFactory.tagStart(buf, this.fFirstTag);
            this.precedenceOpen(buf, precedence);
            Times timesConverter = new Times();
            timesConverter.setFactory(this.fFactory);
            for (int i = size = f.argSize(); i > 0; --i) {
                IExpr expr = f.get(i);
                if (i < size && expr.isAST(S.Times)) {
                    timesConverter.convertTimesFraction(buf, (IAST)expr, this.fPrecedence, true);
                    continue;
                }
                if (i < size) {
                    if (expr.isReal() && expr.isNegative()) {
                        this.fFactory.tag(buf, "mo", "-");
                        expr = ((ISignedNumber)expr).negate();
                    } else {
                        this.fFactory.tag(buf, "mo", "+");
                    }
                }
                this.fFactory.convertInternal(buf, expr, this.fPrecedence, false);
            }
            this.precedenceClose(buf, precedence);
            this.fFactory.tagEnd(buf, this.fFirstTag);
            return true;
        }
    }

    class Operator {
        String fOperator;

        Operator(String oper) {
            this.fOperator = oper;
        }

        public void convert(StringBuilder buf) {
            MathMLFormFactory.this.tagStart(buf, "mo");
            buf.append(this.fOperator);
            MathMLFormFactory.this.tagEnd(buf, "mo");
        }

        public String toString() {
            return this.fOperator;
        }
    }

    private static final class Not
    extends AbstractConverter {
        private Not() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 2) {
                return false;
            }
            this.fFactory.tagStart(buf, "mrow");
            this.fFactory.tag(buf, "mo", "&#x00AC;");
            this.fFactory.convertInternal(buf, f.arg1(), 230, false);
            this.fFactory.tagEnd(buf, "mrow");
            return true;
        }
    }

    private static final class MMLPostfix
    extends AbstractConverter {
        final String fOperator;
        final int fPrecedence;

        public MMLPostfix(String operator, int precedence) {
            this.fOperator = operator;
            this.fPrecedence = precedence;
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.isAST1()) {
                this.fFactory.tagStart(buf, "mrow");
                if (this.fPrecedence <= precedence) {
                    this.fFactory.tag(buf, "mo", "(");
                }
                this.fFactory.convertInternal(buf, f.arg1(), this.fPrecedence, false);
                this.fFactory.tag(buf, "mo", this.fOperator);
                if (this.fPrecedence <= precedence) {
                    this.fFactory.tag(buf, "mo", ")");
                }
                this.fFactory.tagEnd(buf, "mrow");
                return true;
            }
            return false;
        }
    }

    private static class MMLOperator
    extends AbstractConverter {
        protected int fPrecedence;
        protected String fFirstTag;
        protected String fOperator;

        public MMLOperator(int precedence, String oper) {
            this(precedence, "mrow", oper);
        }

        public MMLOperator(int precedence, String firstTag, String oper) {
            this.fPrecedence = precedence;
            this.fFirstTag = firstTag;
            this.fOperator = oper;
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            boolean isOr = f.isOr();
            this.fFactory.tagStart(buf, this.fFirstTag);
            this.precedenceOpen(buf, precedence);
            for (int i = 1; i < f.size(); ++i) {
                if (isOr && f.get(i).isAnd()) {
                    this.fFactory.tagStart(buf, "mrow");
                    this.fFactory.tag(buf, "mo", "(");
                }
                this.fFactory.convertInternal(buf, f.get(i), this.fPrecedence, false);
                if (isOr && f.get(i).isAnd()) {
                    this.fFactory.tag(buf, "mo", ")");
                    this.fFactory.tagEnd(buf, "mrow");
                }
                if (i >= f.argSize() || this.fOperator.compareTo("") == 0) continue;
                this.fFactory.tag(buf, "mo", this.fOperator);
            }
            this.precedenceClose(buf, precedence);
            this.fFactory.tagEnd(buf, this.fFirstTag);
            return true;
        }

        public void precedenceClose(StringBuilder buf, int precedence) {
            if (precedence > this.fPrecedence) {
                this.fFactory.tag(buf, "mo", ")");
                this.fFactory.tagEnd(buf, "mrow");
            }
        }

        public void precedenceOpen(StringBuilder buf, int precedence) {
            if (precedence > this.fPrecedence) {
                this.fFactory.tagStart(buf, "mrow");
                this.fFactory.tag(buf, "mo", "(");
            }
        }
    }

    private static class MMLFunction
    extends AbstractConverter {
        String fFunctionName;

        public MMLFunction(MathMLFormFactory factory, String functionName) {
            this.fFunctionName = functionName;
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            this.fFactory.tagStart(buf, "mrow");
            this.fFactory.tag(buf, "mi", this.fFunctionName);
            this.fFactory.tag(buf, "mo", "&#x2061;");
            this.fFactory.tag(buf, "mo", "(");
            for (int i = 1; i < f.size(); ++i) {
                this.fFactory.convertInternal(buf, f.get(i), Integer.MIN_VALUE, false);
                if (i >= f.argSize()) continue;
                this.fFactory.tag(buf, "mo", ",");
            }
            this.fFactory.tag(buf, "mo", ")");
            this.fFactory.tagEnd(buf, "mrow");
            return true;
        }
    }

    private static final class MatrixForm
    extends AbstractConverter {
        final boolean tableForm;

        public MatrixForm(boolean tableForm) {
            this.tableForm = tableForm;
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 2) {
                return false;
            }
            int[] dims = f.arg1().isMatrix();
            if (dims == null) {
                int dim = f.arg1().isVector();
                if (dim < 0) {
                    return false;
                }
                IAST vector = (IAST)f.arg1();
                if (!this.tableForm) {
                    this.fFactory.tagStart(buf, "mrow");
                    this.fFactory.tag(buf, "mo", "(");
                }
                this.fFactory.tagStart(buf, "mtable", "columnalign=\"center\"");
                for (int i = 1; i < vector.size(); ++i) {
                    IExpr temp = vector.get(i);
                    this.fFactory.tagStart(buf, "mtr");
                    this.fFactory.tagStart(buf, "mtd", "columnalign=\"center\"");
                    this.fFactory.convertInternal(buf, temp, Integer.MIN_VALUE, false);
                    this.fFactory.tagEnd(buf, "mtd");
                    this.fFactory.tagEnd(buf, "mtr");
                }
                this.fFactory.tagEnd(buf, "mtable");
                if (!this.tableForm) {
                    this.fFactory.tag(buf, "mo", ")");
                    this.fFactory.tagEnd(buf, "mrow");
                }
            } else {
                IAST matrix = (IAST)f.arg1().normal(false);
                if (!this.tableForm) {
                    this.fFactory.tagStart(buf, "mrow");
                    this.fFactory.tag(buf, "mo", "(");
                }
                this.fFactory.tagStart(buf, "mtable", "columnalign=\"center\"");
                for (int i = 1; i < matrix.size(); ++i) {
                    IAST temp = (IAST)matrix.get(i);
                    this.fFactory.tagStart(buf, "mtr");
                    for (int j = 1; j < temp.size(); ++j) {
                        this.fFactory.tagStart(buf, "mtd", "columnalign=\"center\"");
                        this.fFactory.convertInternal(buf, temp.get(j), Integer.MIN_VALUE, false);
                        this.fFactory.tagEnd(buf, "mtd");
                    }
                    this.fFactory.tagEnd(buf, "mtr");
                }
                this.fFactory.tagEnd(buf, "mtable");
                if (!this.tableForm) {
                    this.fFactory.tag(buf, "mo", ")");
                    this.fFactory.tagEnd(buf, "mrow");
                }
            }
            return true;
        }
    }

    private static final class Integrate
    extends AbstractConverter {
        private Integrate() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() >= 3) {
                return this.iteratorStep(buf, "&#x222B;", f, 2);
            }
            return false;
        }

        public boolean iteratorStep(StringBuilder buf, String mathSymbol, IAST f, int i) {
            if (i >= f.size()) {
                this.fFactory.convertInternal(buf, f.arg1(), Integer.MIN_VALUE, false);
                return true;
            }
            if (f.get(i).isList()) {
                IAST list = (IAST)f.get(i);
                if (list.isAST3() && list.arg1().isSymbol()) {
                    ISymbol symbol = (ISymbol)list.arg1();
                    this.fFactory.tagStart(buf, "msubsup");
                    this.fFactory.tag(buf, "mo", mathSymbol);
                    this.fFactory.convertInternal(buf, list.arg2(), Integer.MIN_VALUE, false);
                    this.fFactory.convertInternal(buf, list.arg3(), Integer.MIN_VALUE, false);
                    this.fFactory.tagEnd(buf, "msubsup");
                    if (!this.iteratorStep(buf, mathSymbol, f, i + 1)) {
                        return false;
                    }
                    this.fFactory.tagStart(buf, "mrow");
                    this.fFactory.tag(buf, "mo", "&#x2146;");
                    this.fFactory.convertSymbol(buf, symbol);
                    this.fFactory.tagEnd(buf, "mrow");
                    return true;
                }
            } else if (f.get(i).isSymbol()) {
                ISymbol symbol = (ISymbol)f.get(i);
                this.fFactory.tag(buf, "mo", mathSymbol);
                if (!this.iteratorStep(buf, mathSymbol, f, i + 1)) {
                    return false;
                }
                this.fFactory.tagStart(buf, "mrow");
                this.fFactory.tag(buf, "mo", "&#x2146;");
                this.fFactory.convertSymbol(buf, symbol);
                this.fFactory.tagEnd(buf, "mrow");
                return true;
            }
            return false;
        }
    }

    private static interface IConverter {
        public boolean convert(StringBuilder var1, IAST var2, int var3);

        public void setFactory(MathMLFormFactory var1);
    }

    private static final class Function
    extends AbstractConverter {
        private Function() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 2) {
                return false;
            }
            this.fFactory.tagStart(buf, "mrow");
            this.fFactory.convertInternal(buf, f.arg1(), Integer.MIN_VALUE, false);
            this.fFactory.tag(buf, "mo", "&amp;");
            this.fFactory.tagEnd(buf, "mrow");
            return true;
        }
    }

    private static final class Floor
    extends AbstractConverter {
        private Floor() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 2) {
                return false;
            }
            this.fFactory.tagStart(buf, "mrow");
            this.fFactory.tag(buf, "mo", "&#x230A;");
            this.fFactory.convertInternal(buf, f.arg1(), Integer.MIN_VALUE, false);
            this.fFactory.tag(buf, "mo", "&#x230B;");
            this.fFactory.tagEnd(buf, "mrow");
            return true;
        }
    }

    private static final class Element
    extends AbstractConverter {
        private Element() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.isAST2()) {
                this.fFactory.tagStart(buf, "mrow");
                this.fFactory.convertInternal(buf, f.arg1(), Integer.MIN_VALUE, false);
                buf.append("<mo>&#8712;</mo>");
                this.fFactory.convertInternal(buf, f.arg2(), Integer.MIN_VALUE, false);
                this.fFactory.tagEnd(buf, "mrow");
                return true;
            }
            return false;
        }
    }

    private static final class D
    extends AbstractConverter {
        private D() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.isAST2()) {
                this.fFactory.tagStart(buf, "mfrac");
                this.fFactory.tagStart(buf, "mrow");
                this.fFactory.tag(buf, "mo", "&#x2202;");
                this.fFactory.convertInternal(buf, f.arg1(), Integer.MIN_VALUE, false);
                this.fFactory.tagEnd(buf, "mrow");
                this.fFactory.tagStart(buf, "mrow");
                this.fFactory.tag(buf, "mo", "&#x2202;");
                this.fFactory.convertInternal(buf, f.arg2(), Integer.MIN_VALUE, false);
                this.fFactory.tagEnd(buf, "mrow");
                this.fFactory.tagEnd(buf, "mfrac");
                return true;
            }
            return false;
        }
    }

    private static final class Ceiling
    extends AbstractConverter {
        private Ceiling() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 2) {
                return false;
            }
            this.fFactory.tagStart(buf, "mrow");
            this.fFactory.tag(buf, "mo", "&#x2308;");
            this.fFactory.convertInternal(buf, f.arg1(), Integer.MIN_VALUE, false);
            this.fFactory.tag(buf, "mo", "&#x2309;");
            this.fFactory.tagEnd(buf, "mrow");
            return true;
        }
    }

    private static final class C
    extends AbstractConverter {
        private C() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.isAST1() && f.head().equals(S.C) && f.arg1().isInteger()) {
                this.fFactory.tagStart(buf, "msub");
                buf.append("<mi>c</mi>");
                this.fFactory.convertInternal(buf, f.arg1(), Integer.MIN_VALUE, false);
                this.fFactory.tagEnd(buf, "msub");
                return true;
            }
            return false;
        }
    }

    private static final class Binomial
    extends AbstractConverter {
        private Binomial() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 3) {
                return false;
            }
            this.fFactory.tagStart(buf, "mrow");
            this.fFactory.tag(buf, "mo", "(");
            this.fFactory.tagStart(buf, "mfrac", "linethickness=\"0\"");
            this.fFactory.convertInternal(buf, f.arg1(), Integer.MIN_VALUE, false);
            this.fFactory.convertInternal(buf, f.arg2(), Integer.MIN_VALUE, false);
            this.fFactory.tagEnd(buf, "mfrac");
            this.fFactory.tag(buf, "mo", ")");
            this.fFactory.tagEnd(buf, "mrow");
            return true;
        }
    }

    private static abstract class AbstractConverter
    implements IConverter {
        protected MathMLFormFactory fFactory;

        @Override
        public void setFactory(MathMLFormFactory factory) {
            this.fFactory = factory;
        }
    }

    private final class Abs
    extends AbstractConverter {
        private Abs() {
        }

        @Override
        public boolean convert(StringBuilder buf, IAST f, int precedence) {
            if (f.size() != 2) {
                return false;
            }
            this.fFactory.tagStart(buf, "mrow");
            this.fFactory.tag(buf, "mo", "&#10072;");
            this.fFactory.convertInternal(buf, f.arg1(), Integer.MIN_VALUE, false);
            this.fFactory.tag(buf, "mo", "&#10072;");
            this.fFactory.tagEnd(buf, "mrow");
            return true;
        }
    }
}

