/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.mathml;

import java.text.NumberFormat;
import java.util.Map;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.trie.TrieMatch;

public abstract class AbstractMathMLFormFactory {
    public static final boolean USE_IDENTIFIERS = false;
    public static final Map<String, String> ENTITY_TABLE = ParserConfig.TRIE_STRING2STRING_BUILDER.withMatch(TrieMatch.EXACT).build();
    protected NumberFormat fNumberFormat = null;
    private final String fTagPrefix;

    public AbstractMathMLFormFactory() {
        this("", null);
    }

    public AbstractMathMLFormFactory(String tagPrefix, NumberFormat numberFormat) {
        this.fTagPrefix = tagPrefix;
        this.fNumberFormat = numberFormat;
    }

    protected String convertDoubleToFormattedString(double dValue) {
        return this.fNumberFormat == null ? Double.toString(dValue) : this.fNumberFormat.format(dValue);
    }

    public void entity(StringBuilder buf, String tag) {
        String entityValue = ENTITY_TABLE.get(tag);
        if (entityValue != null) {
            buf.append(entityValue.toString());
        } else {
            buf.append(tag);
        }
    }

    public void tag(StringBuilder buf, String tag, String data) {
        this.tagStart(buf, tag);
        this.entity(buf, data);
        this.tagEnd(buf, tag);
    }

    public void tagStart(StringBuilder buf, String tag) {
        buf.append("<" + this.fTagPrefix + tag + ">");
    }

    public void tagStart(StringBuilder buf, String tag, String attr0) {
        buf.append("<" + this.fTagPrefix + tag + " " + attr0 + ">");
    }

    public void tagEnd(StringBuilder buf, String tag) {
        buf.append("</" + this.fTagPrefix + tag + ">");
    }

    public void tagStartEnd(StringBuilder buf, String tag) {
        buf.append("<" + this.fTagPrefix + tag + " />");
    }

    public abstract void convertDouble(StringBuilder var1, INum var2, int var3, boolean var4);

    public abstract void convertDoubleComplex(StringBuilder var1, IComplexNum var2, int var3, boolean var4);

    public abstract void convertInteger(StringBuilder var1, IInteger var2, int var3, boolean var4);

    public abstract void convertFraction(StringBuilder var1, IRational var2, int var3, boolean var4);

    public abstract void convertComplex(StringBuilder var1, IComplex var2, int var3, boolean var4);

    public abstract void convertString(StringBuilder var1, String var2);

    public abstract void convertSymbol(StringBuilder var1, ISymbol var2);

    public abstract void convertHead(StringBuilder var1, IExpr var2);

    public abstract boolean convert(StringBuilder var1, IExpr var2, int var3, boolean var4);

    abstract void convertInternal(StringBuilder var1, IExpr var2, int var3, boolean var4);
}

