/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DoubleToMMA {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String HASH_STR = "##############################";

    public static void doubleToMMA(Appendable buf, double value, int exponent, int significantFigures, boolean texScientificNotation) throws IOException {
        int start;
        if (Double.isNaN(value)) {
            buf.append("Indeterminate");
            return;
        }
        if (Double.isInfinite(value)) {
            if (value < 0.0) {
                buf.append("-Infinity");
            } else {
                buf.append("Infinity");
            }
            return;
        }
        String s = String.format(Locale.US, "%16.16E", value);
        String expStr = s.substring((start = s.indexOf(69)) + 1);
        if (expStr.startsWith("+")) {
            expStr = expStr.substring(1);
        }
        int exp = Integer.parseInt(expStr);
        if (exponent > 0 && -exponent <= exp && exp <= exponent) {
            DecimalFormat format;
            int hashSize;
            DecimalFormatSymbols usSymbols = new DecimalFormatSymbols(Locale.US);
            if (exp > 0) {
                hashSize = significantFigures - exp - 1;
                if (hashSize <= 0) {
                    hashSize = 1;
                }
                if (hashSize >= HASH_STR.length()) {
                    hashSize = HASH_STR.length();
                }
                format = new DecimalFormat(HASH_STR.substring(0, exp) + "0." + HASH_STR.substring(0, hashSize), usSymbols);
            } else {
                hashSize = -exp + significantFigures - 2;
                if (hashSize <= 0) {
                    hashSize = 1;
                }
                if (hashSize >= HASH_STR.length()) {
                    hashSize = HASH_STR.length();
                }
                format = new DecimalFormat("#." + HASH_STR.substring(0, -exp + significantFigures - 2), usSymbols);
            }
            String test = format.format(value);
            start = test.indexOf(69);
            if (start > 0) {
                test = test.substring(0, start);
            }
            if ((test = test.trim()).contains(".")) {
                for (int i = test.length() - 1; i >= 0; --i) {
                    if (test.charAt(i) == '0') continue;
                    if (test.charAt(i) == '.') {
                        test = test.substring(0, i + 2);
                        break;
                    }
                    test = test.substring(0, i + 1);
                    break;
                }
            }
            buf.append(test);
            if (test.indexOf(".") < 0) {
                buf.append(".0");
            }
            return;
        }
        DoubleToMMA.doubleToScientific(buf, value, significantFigures - 1, exp, texScientificNotation);
    }

    public static void doubleToMMA(StringBuilder buf, double value, int exponent, int significantFigures) {
        try {
            DoubleToMMA.doubleToMMA(buf, value, exponent, significantFigures, false);
        }
        catch (IOException ioex) {
            LOGGER.error("DoubleToMMA.doubleToMMA() failed", (Throwable)ioex);
        }
    }

    public static void doubleToScientific(Appendable buf, double value, int significantFigures, int exponent, boolean texScientificNotation) throws IOException {
        int indx;
        String s = String.format(Locale.US, "%1." + (significantFigures - 1) + "E", value);
        int start = s.indexOf(69);
        if (exponent == Integer.MIN_VALUE) {
            exponent = Integer.parseInt(s.substring(start + 1));
        }
        if ((s = s.substring(0, start)).charAt(s.length() - 1) == '0' && (indx = s.indexOf(".")) > 0) {
            s = DoubleToMMA.removeTrailingZeroes(s);
        }
        buf.append(s.trim());
        if (texScientificNotation) {
            buf.append("*10^{");
            buf.append(Integer.toString(exponent));
            buf.append("}");
        } else {
            buf.append("*10^");
            buf.append(Integer.toString(exponent));
        }
    }

    private static String removeTrailingZeroes(String s) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.charAt(sb.length() - 1) == '0') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void doubleToScientific(StringBuilder buf, double value, int significantFigures) {
        try {
            DoubleToMMA.doubleToScientific(buf, value, significantFigures, Integer.MIN_VALUE, false);
        }
        catch (IOException ioex) {
            LOGGER.error("DoubleToMMA.doubleToScientific() failed", (Throwable)ioex);
        }
    }

    private DoubleToMMA() {
    }
}

