/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.SourceCodeFunctions;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.Scanner;

public class Documentation {
    private static final Logger LOGGER = LogManager.getLogger();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean getMarkdown(Appendable out, String builinFunctionName) {
        ISymbol symbol = F.symbol(builinFunctionName);
        String url = null;
        if (symbol instanceof IBuiltInSymbol) {
            url = SourceCodeFunctions.functionURL(symbol);
        }
        String fileName = Documentation.buildFunctionFilename(builinFunctionName);
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try (BufferedReader f = Documentation.getResourceReader(classloader, fileName);){
            String line;
            if (f == null) return false;
            while ((line = f.readLine()) != null) {
                out.append(line);
                out.append("\n");
            }
            if (url != null) {
                out.append("[Github master](");
                out.append(url);
                out.append(")\n\n");
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("Documentation.getMarkdown() failed", (Throwable)e);
        }
        return false;
    }

    public static void findDocumentation(Appendable out, String trimmedInput) {
        String name = trimmedInput.substring(1);
        Documentation.usageDocumentation(out, name);
    }

    public static IExpr findDocumentation(String trimmedInput) {
        StringBuilder out = new StringBuilder();
        String name = trimmedInput.substring(1);
        Documentation.usageDocumentation(out, name);
        String str = out.toString();
        if (str.length() == 0) {
            return F.Missing(F.stringx("UnknownSymbol"), F.stringx(trimmedInput));
        }
        return F.stringx(str);
    }

    public static void usageDocumentation(Appendable out, String name) {
        try {
            IAST list;
            ISymbol symbol;
            IExpr temp;
            if (Scanner.isIdentifier((String)name) && (temp = (symbol = F.symbol(name)).evalMessage("usage")).isPresent()) {
                out.append(temp.toString());
            }
            if ((list = IOFunctions.getNamesByPrefix(name)).size() > 2) {
                for (int i = 1; i < list.size(); ++i) {
                    out.append(list.get(i).toString());
                    if (i == list.argSize()) continue;
                    out.append(", ");
                }
                out.append("\n");
            }
            if (list.size() == 2) {
                Documentation.printDocumentation(out, list.arg1().toString());
            } else if (list.isEmpty() && (name.equals("C") || name.equals("D") || name.equals("E") || name.equals("I") || name.equals("N"))) {
                Documentation.printDocumentation(out, name);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean printDocumentation(Appendable out, String symbolName) {
        ISymbol symbol = F.symbol(symbolName);
        String url = null;
        if (symbol instanceof IBuiltInSymbol) {
            url = SourceCodeFunctions.functionURL(symbol);
        }
        String fileName = Documentation.buildFunctionFilename(symbolName);
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try (BufferedReader f = Documentation.getResourceReader(classloader, fileName);){
            String line;
            if (f == null) return false;
            boolean emptyLine = false;
            while ((line = f.readLine()) != null) {
                if (line.startsWith("```")) continue;
                if (line.trim().length() == 0) {
                    if (emptyLine) continue;
                    emptyLine = true;
                } else {
                    emptyLine = false;
                }
                out.append(line);
                out.append("\n");
            }
            if (url != null) {
                out.append("[Github master](");
                out.append(url);
                out.append(")\n\n");
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("Documentation.printDocumentation() failed", (Throwable)e);
        }
        return false;
    }

    public static String buildFunctionFilename(String symbolName) {
        return "doc/functions/" + symbolName + ".md";
    }

    public static String buildDocFilename(String docName) {
        return "doc/" + docName + ".md";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int extraxtJavadoc(Appendable out, String symbolName) {
        String fileName = Documentation.buildFunctionFilename(symbolName);
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try (BufferedReader f = Documentation.getResourceReader(classloader, fileName);){
            String line;
            if (f == null) return -1;
            String shortdesc = null;
            while ((line = f.readLine()) != null) {
                if (line.startsWith("```")) {
                    if (shortdesc != null || (line = f.readLine()) == null) continue;
                    shortdesc = line.trim();
                    continue;
                }
                if (line.startsWith("### ")) {
                    int n = 0;
                    return n;
                }
                if (!line.startsWith("> ")) continue;
                out.append("\n        /**");
                out.append(" ");
                if (shortdesc != null) {
                    out.append(shortdesc);
                    out.append(" - ");
                }
                out.append(line.substring(2));
                out.append("\n         * ");
                out.append("@see <a href=\"https://raw.githubusercontent.com/axkr/symja_android_library/master/symja_android_library/doc/functions/" + symbolName + ".md\">" + symbolName + " documentation</a>");
                out.append(" */");
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (IOException e) {
            LOGGER.error("Documentation.extraxtJavadoc() failed", (Throwable)e);
        }
        return -1;
    }

    private static BufferedReader getResourceReader(ClassLoader classloader, String resource) {
        InputStream in = classloader.getResourceAsStream(resource);
        return in != null ? new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)) : null;
    }
}

