/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apfloat;
import org.matheclipse.core.form.OutputStyle;

public class ApfloatToMMA {
    private static final Logger LOGGER = LogManager.getLogger();

    private static void toMMA(Apfloat x, Writer out, long significantFigures, OutputStyle style) throws IOException {
        long exponent;
        if (style == OutputStyle.MATHML) {
            out.write("<mrow><mn>");
        }
        FormattingWriter formattingWriter = new FormattingWriter(out);
        x.writeTo((Writer)formattingWriter);
        long count = formattingWriter.getCount();
        if (count < significantFigures) {
            if (!formattingWriter.isDotWritten()) {
                out.write(46);
            }
            while (count < significantFigures) {
                out.write(48);
                ++count;
            }
        }
        if (style == OutputStyle.MATHML) {
            out.write("</mn>");
        }
        if ((exponent = formattingWriter.getExponent()) != 0L) {
            if (style == OutputStyle.MATHML) {
                out.write("<mo>&#0183;</mo><msup><mn>10</mn><mn>");
                out.write(String.valueOf(exponent));
                out.write("</mn></msup>");
            } else if (style == OutputStyle.TEX) {
                out.write("*10^");
                out.write(123);
                out.write(String.valueOf(exponent));
                out.write(125);
            } else {
                out.write("*10^");
                out.write(String.valueOf(exponent));
            }
        }
        if (style == OutputStyle.MATHML) {
            out.write("</mrow>");
        }
    }

    public static void apfloatToMMA(Appendable buf, Apfloat value, int exponent, long significantFigures, boolean useSignificantFiguresInApfloat, OutputStyle style) throws IOException {
        long scale = value.scale();
        if (exponent > 0 && (long)(-exponent) <= scale && scale <= (long)exponent) {
            int indx;
            if (style == OutputStyle.MATHML) {
                buf.append("<mn>");
            }
            String str = value.toString(true);
            if (useSignificantFiguresInApfloat && (indx = str.indexOf(46)) > 0 && indx + (int)significantFigures <= str.length()) {
                str = str.substring(0, indx + 1 + (int)significantFigures);
            }
            buf.append(str);
            if (style == OutputStyle.MATHML) {
                buf.append("</mn>");
            }
            return;
        }
        Object str = value.toString();
        int index = ((String)str).indexOf(101);
        if (index > 0) {
            StringWriter stw = new StringWriter();
            try {
                int lastIndex;
                int firstIndex;
                ApfloatToMMA.toMMA(value, stw, significantFigures, style);
                str = stw.toString();
                if (useSignificantFiguresInApfloat && (firstIndex = ((String)str).indexOf(46)) > 0 && (lastIndex = ((String)str).indexOf(42, firstIndex + 1)) > 0 && (long)(lastIndex - firstIndex) > significantFigures) {
                    String preStr = ((String)str).substring(0, firstIndex + 1);
                    String infixStr = ((String)str).substring(firstIndex + 1, firstIndex + 1 + (int)significantFigures);
                    String postStr = ((String)str).substring(lastIndex, ((String)str).length());
                    str = preStr + infixStr + postStr;
                }
                buf.append((CharSequence)str);
                return;
            }
            catch (IOException e) {
                LOGGER.error("ApfloatToMMA.apfloatToMMA() failed", (Throwable)e);
            }
        }
        if (style == OutputStyle.MATHML) {
            buf.append("<mn>");
        }
        buf.append((CharSequence)str);
        if (style == OutputStyle.MATHML) {
            buf.append("</mn>");
        }
    }

    public static void apfloatToMMA(StringBuilder buf, Apfloat value, int exponent, long significantFigures, boolean useSignificantFiguresInApfloat) {
        try {
            ApfloatToMMA.apfloatToMMA(buf, value, exponent, significantFigures, useSignificantFiguresInApfloat, OutputStyle.OUTPUT);
        }
        catch (IOException ioex) {
            LOGGER.error("ApfloatToMMA.apfloatToMMA() failed", (Throwable)ioex);
        }
    }

    public static void apfloatToTeX(StringBuilder buf, Apfloat value, int exponent, long significantFigures, boolean useSignificantFiguresInApfloat) {
        try {
            ApfloatToMMA.apfloatToMMA(buf, value, exponent, significantFigures, useSignificantFiguresInApfloat, OutputStyle.TEX);
        }
        catch (IOException ioex) {
            LOGGER.error("ApfloatToMMA.apfloatToTeX() failed", (Throwable)ioex);
        }
    }

    public static void apfloatToMathML(StringBuilder buf, Apfloat value, int exponent, long significantFigures, boolean useSignificantFiguresInApfloat) {
        try {
            ApfloatToMMA.apfloatToMMA(buf, value, exponent, significantFigures, useSignificantFiguresInApfloat, OutputStyle.MATHML);
        }
        catch (IOException ioex) {
            LOGGER.error("ApfloatToMMA.apfloatToMathML() failed", (Throwable)ioex);
        }
    }

    public static void apfloatToMMA(StringBuilder buf, double value, int exponent, int significantFigures) {
        ApfloatToMMA.apfloatToMMA(buf, new Apfloat(value), exponent, significantFigures, false);
    }

    private ApfloatToMMA() {
    }

    private static final class FormattingWriter
    extends FilterWriter {
        private long count;
        private boolean dotWritten;
        private boolean eWritten;
        private StringWriter exponent = new StringWriter();

        public FormattingWriter(Writer out) {
            super(out);
        }

        @Override
        public void write(int c) throws IOException {
            switch (c) {
                case 46: {
                    this.out.write(c);
                    this.dotWritten = true;
                    break;
                }
                case 101: {
                    this.eWritten = true;
                    break;
                }
                default: {
                    (this.eWritten ? this.exponent : this.out).write(c);
                    if (this.eWritten) break;
                    ++this.count;
                }
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            while (len-- > 0) {
                this.write(cbuf[off++]);
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            while (len-- > 0) {
                this.write(str.charAt(off++));
            }
        }

        public boolean isDotWritten() {
            return this.dotWritten;
        }

        public long getCount() {
            return this.count;
        }

        public long getExponent() {
            return this.exponent.getBuffer().length() > 0 ? Long.parseLong(this.exponent.toString()) : 0L;
        }
    }
}

