/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression.data;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.Field;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.AbstractFieldMatrix;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.OpenMapRealMatrix;
import org.hipparchus.linear.OpenMapRealVector;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.MathUtils;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.LinearAlgebra;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.DataExpr;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.Tensors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISparseArray;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.core.patternmatching.PatternMatcherAndEvaluator;
import org.matheclipse.parser.trie.Trie;
import org.matheclipse.parser.trie.TrieNode;

public class SparseArrayExpr
extends DataExpr<Trie<int[], IExpr>>
implements ISparseArray,
Externalizable {
    private static final Logger LOGGER = LogManager.getLogger();
    protected int fEvalFlags = 0;
    private int[] fDimension;
    private IExpr fDefaultValue;

    public static IAST arrayRules(IAST nestedListsOfValues, IExpr defaultValue) {
        int depth = SparseArrayExpr.depth(nestedListsOfValues, 1);
        if (depth < 0) {
            return F.NIL;
        }
        IASTAppendable result = F.ListAlloc(F.allocMin32(F.allocLevel1(nestedListsOfValues, x -> x.isList()) + 2));
        IASTAppendable positions = F.constantArray(F.C1, depth);
        if (SparseArrayExpr.arrayRulesRecursive(nestedListsOfValues, depth + 1, depth, positions, defaultValue, result)) {
            result.append(F.Rule((IExpr)F.constantArray(F.$b(), depth), defaultValue));
            return result;
        }
        return F.NIL;
    }

    private static boolean arrayRulesRecursive(IAST nestedListsOfValues, int count, int level, IASTMutable positions, IExpr defaultValue, IASTAppendable result) {
        int position = count - level;
        --level;
        for (int i = 1; i < nestedListsOfValues.size(); ++i) {
            IExpr arg = nestedListsOfValues.get(i);
            positions.set(position, F.ZZ(i));
            if (level == 0) {
                if (arg.isList()) {
                    return false;
                }
                if (arg.equals(defaultValue)) continue;
                result.append(F.Rule((IExpr)positions.copy(), arg));
                continue;
            }
            if (arg.isList() && SparseArrayExpr.arrayRulesRecursive((IAST)arg, count, level, positions, defaultValue, result)) continue;
            return false;
        }
        return true;
    }

    private static int[] checkPositions(IAST ast, IExpr arg, EvalEngine engine) {
        if (arg.isNonEmptyList()) {
            IAST list = (IAST)arg;
            int[] result = new int[list.argSize()];
            try {
                for (int i = 1; i < list.size(); ++i) {
                    IExpr expr = list.get(i);
                    int intValue = expr.toIntDefault();
                    if (intValue == Integer.MIN_VALUE) {
                        return null;
                    }
                    if (intValue <= 0) {
                        return null;
                    }
                    result[i - 1] = intValue;
                }
                return result;
            }
            catch (RuntimeException rex) {
                LOGGER.debug("SparseArrayExpr.checkPositions() failed", (Throwable)rex);
            }
        }
        return null;
    }

    private static int[] createTrie(IAST arrayRulesList, Trie<int[], IExpr> trie, int[] dimension, int defaultDimension, IExpr[] defaultValue, EvalEngine engine) {
        boolean determineDimension = defaultDimension < 0 || dimension == null;
        int[] positions = null;
        int depth = 1;
        if (dimension != null) {
            depth = dimension.length;
        }
        if (arrayRulesList.isNonEmptyList()) {
            IExpr arg1 = arrayRulesList.arg1();
            IAST rule1 = (IAST)arg1;
            if (rule1.arg1().isList()) {
                IAST positionList = (IAST)rule1.arg1();
                if (dimension == null) {
                    depth = positionList.argSize();
                    dimension = new int[depth];
                } else {
                    if (dimension.length != positionList.argSize()) {
                        return null;
                    }
                    depth = dimension.length;
                }
                positions = SparseArrayExpr.checkPositions(arrayRulesList, positionList, engine);
                if (positions == null && !SparseArrayExpr.checkPatternPositions(trie, positionList, rule1.arg2(), dimension, defaultValue, arrayRulesList, engine)) {
                    return null;
                }
            } else {
                int n = rule1.arg1().toIntDefault();
                if (n > 0) {
                    if (dimension == null) {
                        depth = 1;
                        dimension = new int[depth];
                    } else {
                        if (dimension.length != 1) {
                            return null;
                        }
                        depth = 1;
                    }
                    positions = new int[]{n};
                } else if (rule1.arg1().isBlank()) {
                    if (!defaultValue[0].isPresent()) {
                        defaultValue[0] = rule1.arg2();
                    } else if (!defaultValue[0].equals(rule1.arg2())) {
                        IOFunctions.printMessage(S.SparseArray, "posr", F.list(arrayRulesList, rule1.arg1(), F.ZZ(depth)), engine);
                        return null;
                    }
                } else if (!SparseArrayExpr.patternPositionsList(trie, rule1.arg1(), rule1.arg2(), dimension, arrayRulesList, engine)) {
                    return null;
                }
            }
            if (positions != null) {
                if (defaultDimension > 0) {
                    for (int i = 0; i < depth; ++i) {
                        dimension[i] = defaultDimension;
                    }
                } else if (determineDimension) {
                    for (int i = 0; i < depth; ++i) {
                        if (positions[i] <= dimension[i]) continue;
                        dimension[i] = positions[i];
                    }
                }
                trie.put((Object)positions, (Object)rule1.arg2());
            }
        }
        for (int j = 2; j < arrayRulesList.size(); ++j) {
            IExpr arg = arrayRulesList.get(j);
            if (!arg.isRuleAST()) continue;
            IAST rule = (IAST)arg;
            if (rule.arg1().isList()) {
                IAST positionList = (IAST)rule.arg1();
                positions = SparseArrayExpr.checkPositions(arrayRulesList, positionList, engine);
                if (positions == null) {
                    if (SparseArrayExpr.checkPatternPositions(trie, positionList, rule.arg2(), dimension, defaultValue, arrayRulesList, engine)) continue;
                    return null;
                }
                if (positions.length != depth) {
                    IOFunctions.printMessage(S.SparseArray, "posr", F.list(arrayRulesList, rule.arg1(), F.ZZ(depth)), engine);
                    return null;
                }
                if (determineDimension) {
                    for (int i = 0; i < depth; ++i) {
                        if (positions[i] <= dimension[i]) continue;
                        dimension[i] = positions[i];
                    }
                }
                trie.putIfAbsent((Object)positions, (Object)rule.arg2());
                continue;
            }
            int n = rule.arg1().toIntDefault();
            if (n > 0) {
                positions = new int[]{n};
                if (determineDimension && n > dimension[0]) {
                    dimension[0] = n;
                }
                trie.putIfAbsent((Object)positions, (Object)rule.arg2());
                continue;
            }
            if (rule.arg1().isBlank()) {
                if (!defaultValue[0].isPresent()) {
                    defaultValue[0] = rule.arg2();
                    continue;
                }
                if (defaultValue[0].equals(rule.arg2())) continue;
                IOFunctions.printMessage(S.SparseArray, "posr", F.list(arrayRulesList, rule.arg1(), F.ZZ(depth)), engine);
                return null;
            }
            if (SparseArrayExpr.patternPositionsList(trie, rule.arg1(), rule.arg2(), dimension, arrayRulesList, engine)) continue;
            return null;
        }
        return dimension;
    }

    private static boolean checkPatternPositions(Trie<int[], IExpr> trie, IAST ruleLHSPositionsList, IExpr ruleRHS, int[] dimension, IExpr[] defaultValue, IAST arrayRulesList, EvalEngine engine) {
        int depth = dimension.length;
        if (ruleLHSPositionsList.forAll(x -> x.isBlank())) {
            if (!defaultValue[0].isPresent()) {
                defaultValue[0] = ruleRHS;
                return true;
            }
            if (!defaultValue[0].equals(ruleRHS)) {
                IOFunctions.printMessage(S.SparseArray, "posr", F.list(arrayRulesList, ruleLHSPositionsList, F.ZZ(depth)), engine);
                return false;
            }
        } else if (ruleLHSPositionsList.argSize() == depth) {
            if (!SparseArrayExpr.patternPositionsList(trie, ruleLHSPositionsList, ruleRHS, dimension, arrayRulesList, engine)) {
                return false;
            }
        } else {
            IOFunctions.printMessage(S.SparseArray, "posr", F.list(arrayRulesList, ruleLHSPositionsList, F.ZZ(depth)), engine);
            return false;
        }
        return true;
    }

    private static int depth(IAST list, int count) {
        if (list.size() > 1) {
            if (list.arg1().isList()) {
                return SparseArrayExpr.depth((IAST)list.arg1(), ++count);
            }
            return count;
        }
        return -1;
    }

    public static SparseArrayExpr newArrayRules(IAST arrayRulesList, int[] dimension, int defaultDimension, IExpr defaultValue) {
        IExpr[] defValue = new IExpr[]{defaultValue};
        Trie trie = Config.TRIE_INT2EXPR_BUILDER.build();
        int[] determinedDimension = SparseArrayExpr.createTrie(arrayRulesList, (Trie<int[], IExpr>)trie, dimension, defaultDimension, defValue, EvalEngine.get());
        if (determinedDimension == null) {
            determinedDimension = dimension;
        }
        if (determinedDimension != null) {
            defaultValue = defValue[0].orElse(F.C0);
            SparseArrayExpr.removeValue((Trie<int[], IExpr>)trie, defaultValue);
            return new SparseArrayExpr((Trie<int[], IExpr>)trie, determinedDimension, defaultValue, false);
        }
        return null;
    }

    private static void removeValue(Trie<int[], IExpr> trie, IExpr value) {
        for (TrieNode entry : trie.nodeSet()) {
            if (!value.equals(entry.getValue())) continue;
            trie.remove(entry.getKey());
        }
    }

    public static SparseArrayExpr newDenseList(IAST denseList, IExpr defaultValue) {
        IAST listOfRules;
        IntArrayList dims = LinearAlgebra.dimensions(denseList);
        int dimsSize = dims.size();
        if (dimsSize > 0 && (listOfRules = SparseArrayExpr.arrayRules(denseList, defaultValue = defaultValue.orElse(F.C0))).isPresent()) {
            SparseArrayExpr result = SparseArrayExpr.newArrayRules(listOfRules, null, -1, defaultValue);
            int[] dimension = new int[dimsSize];
            for (int i = 0; i < dimsSize; ++i) {
                dimension[i] = dims.getInt(i);
            }
            result.fDimension = dimension;
            return result;
        }
        return null;
    }

    public static SparseArrayExpr newInputForm(int[] dimension, IExpr defaultValue, int[] rowPointers, IAST columnIndiceMatrix, IAST nonZeroValues) {
        int first = 0;
        Trie trie = Config.TRIE_INT2EXPR_BUILDER.build();
        int depth = dimension.length;
        int k = 0;
        for (int i = 1; i < columnIndiceMatrix.size(); ++i) {
            int p;
            int j;
            IAST row = (IAST)columnIndiceMatrix.get(i);
            int[] key = new int[depth];
            if (depth == 1) {
                for (j = 1; j < row.size(); ++j) {
                    p = row.get(j).toIntDefault();
                    if (p < 1) {
                        return null;
                    }
                    key[0] = p;
                }
            } else {
                while (rowPointers[k] < i) {
                    ++k;
                    ++first;
                }
                key[0] = first;
                for (j = 1; j < row.size(); ++j) {
                    p = row.get(j).toIntDefault();
                    if (p < 1) {
                        return null;
                    }
                    key[j] = p;
                }
            }
            trie.put((Object)key, (Object)nonZeroValues.get(i));
        }
        return new SparseArrayExpr((Trie<int[], IExpr>)trie, dimension, defaultValue, false);
    }

    private static boolean patternPositionsList(Trie<int[], IExpr> trie, IExpr ruleLHS, IExpr ruleRHS, int[] dimension, IAST arrayRulesList, EvalEngine engine) {
        if (dimension == null) {
            return false;
        }
        int depth = dimension.length;
        PatternMatcherAndEvaluator matcher = new PatternMatcherAndEvaluator(ruleLHS, ruleRHS);
        if (matcher.isRuleWithoutPatterns()) {
            IOFunctions.printMessage(S.SparseArray, "posr", F.list(arrayRulesList, ruleLHS, F.ZZ(depth)), EvalEngine.get());
            return false;
        }
        IASTAppendable positionList = F.constantArray(F.C1, depth);
        int[] positionsKey = new int[depth];
        IPatternMap patternMap = matcher.getPatternMap();
        IExpr[] patternValuesArray = patternMap.copyPattern();
        SparseArrayExpr.patternPositionsRecursive(trie, dimension, engine, matcher, positionList, 0, positionsKey, patternMap, patternValuesArray);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void patternPositionsRecursive(Trie<int[], IExpr> trie, int[] dimension, EvalEngine engine, PatternMatcherAndEvaluator matcher, IASTMutable positionList, int pointer, int[] positionsKey, IPatternMap patternMap, IExpr[] patternValuesArray) {
        if (pointer == dimension.length) {
            try {
                IExpr result = matcher.eval(positionList, engine);
                if (!result.isPresent()) return;
                trie.putIfAbsent((Object)((int[])positionsKey.clone()), (Object)result);
                return;
            }
            finally {
                patternMap.resetPattern(patternValuesArray);
            }
        } else {
            for (int i = 1; i <= dimension[pointer]; ++i) {
                positionsKey[pointer] = i;
                positionList.set(pointer + 1, F.ZZ(i));
                SparseArrayExpr.patternPositionsRecursive(trie, dimension, engine, matcher, positionList, pointer + 1, positionsKey, patternMap, patternValuesArray);
            }
        }
    }

    private static int totalSize(int[] dimension) {
        int total = 1;
        for (int i = 0; i < dimension.length; ++i) {
            total *= dimension[i];
        }
        return total;
    }

    public SparseArrayExpr() {
        super(S.SparseArray, null);
    }

    public SparseArrayExpr(Trie<int[], IExpr> trie, int[] dimension, IExpr defaultValue, boolean deepCopy) {
        super(S.SparseArray, trie);
        if (deepCopy) {
            this.fData = Config.TRIE_INT2EXPR_BUILDER.build();
            for (TrieNode entry : trie.nodeSet()) {
                int[] key = (int[])entry.getKey();
                int[] newKey = new int[key.length];
                System.arraycopy(key, 0, newKey, 0, key.length);
                ((Trie)this.fData).put((Object)newKey, (Object)((IExpr)entry.getValue()));
            }
            this.fDimension = new int[dimension.length];
            System.arraycopy(dimension, 0, this.fDimension, 0, dimension.length);
        } else {
            this.fDimension = dimension;
        }
        this.fDefaultValue = defaultValue;
    }

    @Override
    public final ISparseArray addEvalFlags(int i) {
        this.fEvalFlags |= i;
        return this;
    }

    @Override
    public IAST arrayRules() {
        IASTAppendable result = F.ListAlloc(((Trie)this.fData).size() + 1);
        for (TrieNode entry : ((Trie)this.fData).nodeSet()) {
            int[] key = (int[])entry.getKey();
            IExpr value = (IExpr)entry.getValue();
            IASTAppendable lhs = F.ast((ISymbol)S.List, key);
            result.append(F.Rule((IExpr)lhs, value));
        }
        result.append(F.Rule((IExpr)F.constantArray(F.$b(), this.fDimension.length), this.fDefaultValue));
        return result;
    }

    public SparseArrayExpr copy() {
        return new SparseArrayExpr((Trie<int[], IExpr>)((Trie)this.fData), this.fDimension, this.fDefaultValue, true);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SparseArrayExpr) {
            SparseArrayExpr s = (SparseArrayExpr)obj;
            if (Arrays.equals(this.fDimension, s.fDimension) && this.fDefaultValue.equals(s.fDefaultValue)) {
                Trie trie = (Trie)s.fData;
                if (((Trie)this.fData).size() == trie.size()) {
                    for (TrieNode entry : ((Trie)this.fData).nodeSet()) {
                        int[] sequence = (int[])entry.getKey();
                        IExpr sValue = (IExpr)trie.get((Object)sequence);
                        if (sValue == null) {
                            return false;
                        }
                        IExpr value = (IExpr)entry.getValue();
                        if (value.equals(sValue)) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (this.isEvalFlagOff(262144)) {
            boolean evaled = false;
            IExpr newDefaultValue = this.fDefaultValue;
            IExpr temp = engine.evaluateNIL(this.fDefaultValue);
            if (temp.isPresent()) {
                evaled = true;
                newDefaultValue = temp;
            }
            Trie trie = Config.TRIE_INT2EXPR_BUILDER.build();
            for (TrieNode entry : ((Trie)this.fData).nodeSet()) {
                IExpr value = (IExpr)entry.getValue();
                temp = engine.evaluateNIL(value);
                if (temp.isPresent()) {
                    evaled = true;
                    trie.put((Object)((int[])entry.getKey()), (Object)temp);
                    continue;
                }
                trie.put((Object)((int[])entry.getKey()), (Object)value);
            }
            if (evaled) {
                SparseArrayExpr result = new SparseArrayExpr((Trie<int[], IExpr>)trie, this.fDimension, newDefaultValue, false);
                result.addEvalFlags(262144);
                return result;
            }
            this.addEvalFlags(262144);
        }
        return F.NIL;
    }

    @Override
    public IExpr first() {
        return this.get(1);
    }

    @Override
    public ISparseArray flatten() {
        if (this.fDimension.length <= 1) {
            return this;
        }
        int vectorDim = SparseArrayExpr.totalSize(this.fDimension);
        int[] offsets = new int[this.fDimension.length];
        int val = this.fDimension[this.fDimension.length - 1];
        for (int i = offsets.length - 1; i >= 0; --i) {
            offsets[i] = val;
            if (i <= 0) continue;
            val *= this.fDimension[i - 1];
        }
        Trie trie = Config.TRIE_INT2EXPR_BUILDER.build();
        for (TrieNode entry : ((Trie)this.fData).nodeSet()) {
            int[] key = (int[])entry.getKey();
            int keyDim = key[key.length - 1];
            for (int i = 0; i < key.length - 1; ++i) {
                keyDim += (key[i] - 1) * offsets[i + 1];
            }
            trie.put((Object)new int[]{keyDim}, (Object)((IExpr)entry.getValue()));
        }
        return new SparseArrayExpr((Trie<int[], IExpr>)trie, new int[]{vectorDim}, this.fDefaultValue, false);
    }

    @Override
    public String fullFormString() {
        IASTAppendable result = this.fullForm();
        return result.fullFormString();
    }

    public IASTAppendable fullForm() {
        IASTAppendable dimensionList = F.ast((ISymbol)S.List, this.fDimension);
        IASTAppendable result = F.ast((IExpr)S.SparseArray, 6);
        result.append(S.Automatic);
        result.append(dimensionList);
        result.append(this.fDefaultValue);
        IASTAppendable list1 = F.ListAlloc(4);
        result.append(list1);
        list1.append(F.C1);
        IASTAppendable subList = F.ListAlloc(2);
        list1.append(subList);
        IASTAppendable rowPointers = F.ListAlloc(((Trie)this.fData).size());
        subList.append(rowPointers);
        IASTAppendable columnIndiceMatrix = F.ListAlloc(((Trie)this.fData).size());
        subList.append(columnIndiceMatrix);
        IASTAppendable nonZeroValues = F.ListAlloc(((Trie)this.fData).size());
        int columnIndex = 0;
        int rowCounter = 0;
        if (this.fDimension.length > 1) {
            for (TrieNode entry : ((Trie)this.fData).nodeSet()) {
                int[] key = (int[])entry.getKey();
                int row = key[0];
                while (rowCounter < row) {
                    rowPointers.append(columnIndex);
                    ++rowCounter;
                }
                ++columnIndex;
                int[] newKey = new int[key.length - 1];
                System.arraycopy(key, 1, newKey, 0, newKey.length);
                IASTAppendable indice = F.ast((ISymbol)S.List, newKey);
                columnIndiceMatrix.append(indice);
                nonZeroValues.append((IExpr)entry.getValue());
            }
        } else {
            rowPointers.append(columnIndex);
            for (TrieNode entry : ((Trie)this.fData).nodeSet()) {
                int[] key = (int[])entry.getKey();
                ++columnIndex;
                IASTAppendable indice = F.ast((ISymbol)S.List, key);
                columnIndiceMatrix.append(indice);
                nonZeroValues.append((IExpr)entry.getValue());
            }
        }
        rowPointers.append(columnIndex);
        list1.append(nonZeroValues);
        return result;
    }

    @Override
    public IExpr get(int position) {
        int[] dims = this.getDimension();
        boolean partSize = true;
        int len = 0;
        int[] partIndex = new int[dims.length];
        int count = 0;
        partIndex[0] = position;
        for (int i = 1; i < dims.length; ++i) {
            partIndex[i] = -1;
            ++count;
        }
        if (count == 0 && 1 == dims.length) {
            return this.getIndex(partIndex);
        }
        int[] newDimension = new int[count];
        count = 0;
        for (int i = 0; i < partIndex.length; ++i) {
            if (partIndex[i] != -1) continue;
            ++len;
            newDimension[count++] = dims[i];
        }
        Trie trie = Config.TRIE_INT2EXPR_BUILDER.build();
        for (TrieNode entry : ((Trie)this.fData).nodeSet()) {
            int[] key = (int[])entry.getKey();
            boolean evaled = true;
            for (int i = 0; i < partIndex.length; ++i) {
                if (partIndex[i] == -1 || partIndex[i] == key[i]) continue;
                evaled = false;
                break;
            }
            if (!evaled) continue;
            int[] newKey = new int[len];
            int j = 0;
            for (int i = 0; i < partIndex.length; ++i) {
                if (partIndex[i] != -1) continue;
                newKey[j++] = key[i];
            }
            trie.put((Object)newKey, (Object)((IExpr)entry.getValue()));
        }
        return new SparseArrayExpr((Trie<int[], IExpr>)trie, newDimension, this.fDefaultValue.orElse(F.C0), false);
    }

    @Override
    public IExpr getDefaultValue() {
        return this.fDefaultValue;
    }

    @Override
    public int[] getDimension() {
        return this.fDimension;
    }

    @Override
    public IExpr getPart(IAST ast, int startPosition) {
        int partSize;
        int[] dims = this.getDimension();
        if (dims.length >= (partSize = ast.size() - startPosition)) {
            int i;
            int len = 0;
            int[] partIndex = new int[dims.length];
            int count = 0;
            for (i = startPosition; i < ast.size(); ++i) {
                partIndex[i - startPosition] = ast.get(i).toIntDefault(-1);
                if (partIndex[i - startPosition] == -1) {
                    ++count;
                    continue;
                }
                if (partIndex[i - startPosition] <= dims[i - startPosition] && partIndex[i - startPosition] > 0) continue;
                return IOFunctions.printMessage(S.Part, "partw", F.list(ast.get(i), ast), EvalEngine.get());
            }
            for (i = partSize; i < dims.length; ++i) {
                partIndex[i] = -1;
                ++count;
            }
            if (count == 0 && partSize == dims.length) {
                return this.getIndex(partIndex);
            }
            int[] newDimension = new int[count];
            count = 0;
            for (int i2 = 0; i2 < partIndex.length; ++i2) {
                if (partIndex[i2] != -1) continue;
                ++len;
                newDimension[count++] = dims[i2];
            }
            Trie trie = Config.TRIE_INT2EXPR_BUILDER.build();
            for (TrieNode entry : ((Trie)this.fData).nodeSet()) {
                int[] key = (int[])entry.getKey();
                boolean evaled = true;
                for (int i3 = 0; i3 < partIndex.length; ++i3) {
                    if (partIndex[i3] == -1 || partIndex[i3] == key[i3]) continue;
                    evaled = false;
                    break;
                }
                if (!evaled) continue;
                int[] newKey = new int[len];
                int j = 0;
                for (int i4 = 0; i4 < partIndex.length; ++i4) {
                    if (partIndex[i4] != -1) continue;
                    newKey[j++] = key[i4];
                }
                trie.put((Object)newKey, (Object)((IExpr)entry.getValue()));
            }
            return new SparseArrayExpr((Trie<int[], IExpr>)trie, newDimension, this.fDefaultValue.orElse(F.C0), false);
        }
        return IOFunctions.printMessage(S.Part, "partd", F.list(ast), EvalEngine.get());
    }

    @Override
    public IExpr getPart(int ... partIndex) {
        int partSize;
        int[] dims = this.getDimension();
        if (dims.length >= (partSize = partIndex.length)) {
            int len = 0;
            int count = 0;
            for (int i = partSize; i < dims.length; ++i) {
                partIndex[i] = -1;
                ++count;
            }
            if (count == 0 && partSize == dims.length) {
                return this.getIndex(partIndex);
            }
            int[] newDimension = new int[count];
            count = 0;
            for (int i = 0; i < partIndex.length; ++i) {
                if (partIndex[i] != -1) continue;
                ++len;
                newDimension[count++] = dims[i];
            }
            Trie trie = Config.TRIE_INT2EXPR_BUILDER.build();
            for (TrieNode entry : ((Trie)this.fData).nodeSet()) {
                int[] key = (int[])entry.getKey();
                boolean evaled = true;
                for (int i = 0; i < partIndex.length; ++i) {
                    if (partIndex[i] == -1 || partIndex[i] == key[i]) continue;
                    evaled = false;
                    break;
                }
                if (!evaled) continue;
                int[] newKey = new int[len];
                int j = 0;
                for (int i = 0; i < partIndex.length; ++i) {
                    if (partIndex[i] != -1) continue;
                    newKey[j++] = key[i];
                }
                trie.put((Object)newKey, (Object)((IExpr)entry.getValue()));
            }
            return new SparseArrayExpr((Trie<int[], IExpr>)trie, newDimension, this.fDefaultValue.orElse(F.C0), false);
        }
        return F.NIL;
    }

    @Override
    public int hashCode() {
        return this.fData == null ? 541 : 541 + ((Trie)this.fData).size() + this.fDefaultValue.hashCode();
    }

    @Override
    public int hierarchy() {
        return 32795;
    }

    @Override
    public int[] isMatrix(boolean setMatrixFormat) {
        return this.fDimension.length == 2 ? this.fDimension : null;
    }

    @Override
    public boolean isSparseArray() {
        return true;
    }

    @Override
    public int isVector() {
        return this.fDimension.length == 1 ? this.fDimension[0] : -1;
    }

    @Override
    public ISparseArray join(ISparseArray that) {
        SparseArrayExpr thatArray = (SparseArrayExpr)that;
        SparseArrayExpr result = this.copy();
        int rowDimension = result.fDimension[0];
        for (TrieNode entry : ((Trie)thatArray.fData).nodeSet()) {
            int[] key = (int[])entry.getKey();
            int[] newKey = new int[key.length];
            System.arraycopy(key, 0, newKey, 0, key.length);
            newKey[0] = newKey[0] + rowDimension;
            ((Trie)result.fData).put((Object)newKey, (Object)((IExpr)entry.getValue()));
        }
        result.fDimension[0] = result.fDimension[0] + thatArray.fDimension[0];
        return result;
    }

    @Override
    public IExpr last() {
        return this.get(this.fDimension[0]);
    }

    @Override
    public SparseArrayExpr map(Function<IExpr, IExpr> function) {
        SparseArrayExpr result = this.copy();
        for (TrieNode entry : ((Trie)result.fData).nodeSet()) {
            IExpr value = (IExpr)entry.getValue();
            IExpr temp = function.apply(value);
            if (!temp.isPresent()) continue;
            ((Trie)result.fData).put((Object)((int[])entry.getKey()), (Object)temp);
        }
        IExpr temp = function.apply(result.fDefaultValue);
        if (temp.isPresent()) {
            result.fDefaultValue = temp;
        }
        return result;
    }

    @Override
    public IExpr mapMatrixColumns(int[] dim, Function<IExpr, IExpr> f) {
        IASTMutable matrix = this.normal(false);
        return matrix.mapMatrixColumns(dim, f);
    }

    @Override
    public final SparseArrayExpr mapThread(IAST replacement, int position) {
        Function<IExpr, IExpr> function = x -> replacement.setAtCopy(position, (IExpr)x);
        return this.map((Function)function);
    }

    @Override
    public IASTMutable normal(boolean nilIfUnevaluated) {
        return this.normal(this.fDimension);
    }

    @Override
    public IASTMutable normal(int[] dimension) {
        if (dimension.length > 0) {
            IASTMutable result = Tensors.build(index -> this.getIndex(index), dimension);
            if (this.fDimension.length == 1) {
                result.addEvalFlags(64);
            } else if (this.fDimension.length == 2) {
                result.addEvalFlags(32);
            }
            return result;
        }
        return F.headAST0(S.List);
    }

    @Override
    public IExpr getIndex(int ... index) {
        IExpr expr = (IExpr)((Trie)this.fData).get((Object)index);
        if (expr == null) {
            return this.fDefaultValue;
        }
        return expr;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fDefaultValue = (IExpr)in.readObject();
        int len = in.readInt();
        this.fDimension = new int[len];
        for (int i = 0; i < len; ++i) {
            this.fDimension[i] = in.readInt();
        }
        IAST arrayRulesList = (IAST)in.readObject();
        this.fData = Config.TRIE_INT2EXPR_BUILDER.build();
        IExpr[] defValue = new IExpr[]{this.fDefaultValue};
        int[] determinedDimension = SparseArrayExpr.createTrie(arrayRulesList, (Trie<int[], IExpr>)((Trie)this.fData), this.fDimension, -1, defValue, EvalEngine.get());
        if (determinedDimension == null) {
            throw new InvalidClassException("no valid Trie creation");
        }
    }

    public IExpr set(int i, IExpr value) {
        if (this.fDimension.length == 1 && i > 0 && i <= this.fDimension[0]) {
            int[] positions = new int[]{i};
            IExpr old = (IExpr)((Trie)this.fData).get((Object)positions);
            ((Trie)this.fData).put((Object)positions, (Object)value);
            return old == null ? this.fDefaultValue : old;
        }
        throw new IndexOutOfBoundsException("Index: " + i + ", Size: " + this.fDimension[0]);
    }

    @Override
    public IExpr set(int[] positions, IExpr value) {
        if (positions.length == this.fDimension.length) {
            for (int i = 0; i < positions.length; ++i) {
                if (positions[i] > 0 && positions[i] <= this.fDimension[i]) continue;
                throw new IndexOutOfBoundsException("Index: " + i + " Position: " + positions[i] + ", Size: " + this.fDimension[i]);
            }
            IExpr old = (IExpr)((Trie)this.fData).get((Object)positions);
            ((Trie)this.fData).put((Object)positions, (Object)value);
            return old == null ? this.fDefaultValue : old;
        }
        throw new IndexOutOfBoundsException("Indeces: " + Arrays.toString(positions) + ", Size: " + this.fDimension[0]);
    }

    @Override
    public int size() {
        return this.fDimension[0] + 1;
    }

    @Override
    public double[][] toDoubleMatrix() {
        if (this.fDimension.length == 2 && this.fDimension[0] > 0 && this.fDimension[1] > 0) {
            try {
                double[][] result = new double[this.fDimension[0]][this.fDimension[1]];
                if (!this.fDefaultValue.isZero()) {
                    double d = this.fDefaultValue.evalDouble();
                    for (int i = 0; i < this.fDimension[0]; ++i) {
                        for (int j = 0; j < this.fDimension[1]; ++j) {
                            result[i][j] = d;
                        }
                    }
                }
                for (TrieNode entry : ((Trie)this.fData).nodeSet()) {
                    int[] key = (int[])entry.getKey();
                    IExpr value = (IExpr)entry.getValue();
                    result[key[0] - 1][key[1] - 1] = value.evalDouble();
                }
                return result;
            }
            catch (ArgumentTypeException argumentTypeException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public double[] toDoubleVector() {
        if (this.fDimension.length == 1 && this.fDimension[0] > 0) {
            try {
                double[] result = new double[this.fDimension[0]];
                if (!this.fDefaultValue.isZero()) {
                    double d = this.fDefaultValue.evalDouble();
                    for (int i = 0; i < result.length; ++i) {
                        result[i] = d;
                    }
                }
                for (TrieNode entry : ((Trie)this.fData).nodeSet()) {
                    int[] key = (int[])entry.getKey();
                    IExpr value = (IExpr)entry.getValue();
                    result[key[0] - 1] = value.evalDouble();
                }
                return result;
            }
            catch (ArgumentTypeException argumentTypeException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public FieldMatrix<IExpr> toFieldMatrix(boolean copyArray) {
        if (this.fDimension.length == 2 && this.fDimension[0] > 0 && this.fDimension[1] > 0) {
            return new SparseExprMatrix(this, copyArray);
        }
        return null;
    }

    @Override
    public FieldVector<IExpr> toFieldVector(boolean copyArray) {
        if (this.fDimension.length == 1 && this.fDimension[0] > 0) {
            return new SparseExprVector(this, copyArray);
        }
        return null;
    }

    @Override
    public RealMatrix toRealMatrix() {
        if (this.fDimension.length == 2 && this.fDimension[0] > 0 && this.fDimension[1] > 0) {
            try {
                OpenMapRealMatrix result = new OpenMapRealMatrix(this.fDimension[0], this.fDimension[1]);
                if (!this.fDefaultValue.isZero()) {
                    double d = this.fDefaultValue.evalDouble();
                    for (int i = 0; i < this.fDimension[0]; ++i) {
                        for (int j = 0; j < this.fDimension[1]; ++j) {
                            result.setEntry(i, j, d);
                        }
                    }
                }
                for (TrieNode entry : ((Trie)this.fData).nodeSet()) {
                    int[] key = (int[])entry.getKey();
                    IExpr value = (IExpr)entry.getValue();
                    result.setEntry(key[0] - 1, key[1] - 1, value.evalDouble());
                }
                return result;
            }
            catch (ArgumentTypeException argumentTypeException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public RealVector toRealVector() {
        if (this.fDimension.length == 1 && this.fDimension[0] > 0) {
            try {
                OpenMapRealVector result = new OpenMapRealVector(this.fDimension[0]);
                if (!this.fDefaultValue.isZero()) {
                    double d = this.fDefaultValue.evalDouble();
                    for (int i = 0; i < this.fDimension[0]; ++i) {
                        result.setEntry(i, d);
                    }
                }
                for (TrieNode entry : ((Trie)this.fData).nodeSet()) {
                    int[] key = (int[])entry.getKey();
                    IExpr value = (IExpr)entry.getValue();
                    result.setEntry(key[0] - 1, value.evalDouble());
                }
                return result;
            }
            catch (ArgumentTypeException argumentTypeException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("SparseArray(Number of elements: ");
        buf.append(((Trie)this.fData).size());
        buf.append(" Dimensions: {");
        for (int i = 0; i < this.fDimension.length; ++i) {
            buf.append(this.fDimension[i]);
            if (i >= this.fDimension.length - 1) continue;
            buf.append(",");
        }
        buf.append("} Default value: ");
        buf.append(this.fDefaultValue.toString());
        buf.append(")");
        return buf.toString();
    }

    @Override
    public IExpr total(IExpr head) {
        if (head.equals(S.Plus) && this.fDefaultValue.isZero()) {
            IASTAppendable result = F.PlusAlloc(((Trie)this.fData).size());
            for (TrieNode entry : ((Trie)this.fData).nodeSet()) {
                result.append((IExpr)entry.getValue());
            }
            return result;
        }
        IASTAppendable result = F.ast(head, SparseArrayExpr.totalSize(this.fDimension));
        return this.totalAppendable(result);
    }

    private void total(Trie<int[], IExpr> trie, int[] dimension, int position, int[] index, IASTAppendable result) {
        if (dimension.length - 1 == position) {
            int size = dimension[position];
            for (int i = 1; i <= size; ++i) {
                index[position] = i;
                IExpr expr = (IExpr)trie.get((Object)index);
                if (expr == null) {
                    result.append(this.fDefaultValue);
                    continue;
                }
                result.append(expr);
            }
            return;
        }
        int size1 = dimension[position];
        int i = 1;
        while (i <= size1) {
            index[position] = i++;
            this.total(trie, dimension, position + 1, index, result);
        }
    }

    private IASTAppendable totalAppendable(IASTAppendable result) {
        int[] index = new int[this.fDimension.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = 1;
        }
        this.total((Trie<int[], IExpr>)((Trie)this.fData), this.fDimension, 0, index, result);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeObject(this.fDefaultValue);
        output.writeInt(this.fDimension.length);
        for (int i = 0; i < this.fDimension.length; ++i) {
            output.writeInt(this.fDimension[i]);
        }
        IAST rules = this.arrayRules();
        output.writeObject(rules);
    }

    public static class SparseExprVector
    implements FieldVector<IExpr> {
        final SparseArrayExpr array;
        private final int virtualSize;

        public SparseExprVector(int dimension, IExpr defaultValue) {
            this.array = new SparseArrayExpr((Trie<int[], IExpr>)Config.TRIE_INT2EXPR_BUILDER.build(), new int[]{dimension}, defaultValue, false);
            this.virtualSize = dimension;
        }

        public SparseExprVector(SparseArrayExpr array, boolean copyArray) {
            this.array = copyArray ? new SparseArrayExpr((Trie<int[], IExpr>)Config.TRIE_INT2EXPR_BUILDER.build(), new int[]{array.fDimension[0]}, array.fDefaultValue, false) : array;
            this.virtualSize = array.fDimension[0];
        }

        protected SparseExprVector(SparseArrayExpr array, int resize) {
            this.array = new SparseArrayExpr((Trie<int[], IExpr>)((Trie)array.fData), array.fDimension, array.fDefaultValue, true);
            this.virtualSize = array.fDimension[0] + resize;
        }

        public SparseExprVector(SparseExprVector other) {
            this.array = new SparseArrayExpr((Trie<int[], IExpr>)((Trie)other.array.fData), other.array.fDimension, other.array.fDefaultValue, true);
            this.virtualSize = other.array.fDimension[0];
        }

        protected SparseExprVector(SparseExprVector v, int resize) {
            this.array = new SparseArrayExpr((Trie<int[], IExpr>)((Trie)v.array.fData), v.array.fDimension, v.array.fDefaultValue, true);
            this.virtualSize = v.array.fDimension[0] + resize;
        }

        public SparseExprVector add(FieldVector<IExpr> v) throws MathIllegalArgumentException {
            int n = v.getDimension();
            this.checkVectorDimensions(n);
            SparseExprVector res = new SparseExprVector(this.getDimension(), this.array.fDefaultValue);
            for (int i = 0; i < n; ++i) {
                res.setEntry(i, ((IExpr)v.getEntry(i)).add(this.getEntry(i)));
            }
            return res;
        }

        public SparseExprVector append(FieldVector<IExpr> v) {
            int n = v.getDimension();
            SparseExprVector res = new SparseExprVector(this.array, n);
            for (int i = 0; i < n; ++i) {
                res.setEntry(i + this.virtualSize, (IExpr)v.getEntry(i));
            }
            return res;
        }

        public SparseExprVector append(IExpr d) {
            MathUtils.checkNotNull((Object)d);
            SparseExprVector res = new SparseExprVector(this, 1);
            res.setEntry(this.virtualSize, d);
            return res;
        }

        private void checkIndex(int index) throws MathIllegalArgumentException {
            MathUtils.checkRangeInclusive((long)index, (long)0L, (long)(this.getDimension() - 1));
        }

        private void checkIndices(int start, int end) throws MathIllegalArgumentException {
            int dim = this.getDimension();
            if (start < 0 || start >= dim) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INDEX, new Object[]{start, 0, dim - 1});
            }
            if (end < 0 || end >= dim) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INDEX, new Object[]{end, 0, dim - 1});
            }
            if (end < start) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INITIAL_ROW_AFTER_FINAL_ROW, new Object[]{end, start, false});
            }
        }

        protected void checkVectorDimensions(int n) throws MathIllegalArgumentException {
            if (this.getDimension() != n) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{this.getDimension(), n});
            }
        }

        public SparseExprVector copy() {
            return new SparseExprVector(this);
        }

        public IExpr dotProduct(FieldVector<IExpr> v) throws MathIllegalArgumentException {
            this.checkVectorDimensions(v.getDimension());
            IASTAppendable plus = F.PlusAlloc(((Trie)this.array.fData).size());
            for (TrieNode entry : ((Trie)this.array.fData).nodeSet()) {
                int[] key = (int[])entry.getKey();
                IExpr value = (IExpr)entry.getValue();
                plus.append(((IExpr)v.getEntry(key[0] - 1)).multiply(value));
            }
            return EvalEngine.get().evaluate(plus.oneIdentity(F.C0));
        }

        public SparseExprVector ebeDivide(FieldVector<IExpr> v) throws MathIllegalArgumentException, MathRuntimeException {
            this.checkVectorDimensions(v.getDimension());
            SparseExprVector res = new SparseExprVector(this);
            for (TrieNode entry : ((Trie)this.array.fData).nodeSet()) {
                int[] key = (int[])entry.getKey();
                IExpr value = (IExpr)entry.getValue();
                IExpr newEntry = value.divide((IExpr)v.getEntry(key[0] - 1));
                res.setEntry(key[0] - 1, newEntry);
            }
            return res;
        }

        public SparseExprVector ebeMultiply(FieldVector<IExpr> v) throws MathIllegalArgumentException {
            this.checkVectorDimensions(v.getDimension());
            SparseExprVector res = new SparseExprVector(this);
            for (TrieNode entry : ((Trie)this.array.fData).nodeSet()) {
                int[] key = (int[])entry.getKey();
                IExpr value = (IExpr)entry.getValue();
                IExpr newEntry = value.times((IExpr)v.getEntry(key[0] - 1));
                res.setEntry(key[0] - 1, newEntry);
            }
            return res;
        }

        public int getDimension() {
            return this.array.fDimension[0];
        }

        public IExpr getEntry(int index) throws MathIllegalArgumentException {
            IExpr value = (IExpr)((Trie)this.array.fData).get((Object)new int[]{index + 1});
            return value == null ? this.array.fDefaultValue : value;
        }

        public Field<IExpr> getField() {
            return F.EXPR_FIELD;
        }

        public SparseArrayExpr getSparseArray() {
            return this.array;
        }

        public SparseExprVector getSubVector(int index, int n) throws MathIllegalArgumentException {
            if (n < 0) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, new Object[]{n});
            }
            this.checkIndex(index);
            this.checkIndex(index + n - 1);
            SparseExprVector res = new SparseExprVector(n, this.array.fDefaultValue);
            int end = index + n;
            for (TrieNode entry : ((Trie)this.array.fData).nodeSet()) {
                int[] key = (int[])entry.getKey();
                IExpr value = (IExpr)entry.getValue();
                if (key[0] < index + 1 || key[0] >= end + 1) continue;
                res.setEntry(key[0] - index + 1, value);
            }
            return res;
        }

        public SparseExprVector mapAdd(IExpr d) throws NullArgumentException {
            return this.copy().mapAddToSelf(d);
        }

        public SparseExprVector mapAddToSelf(IExpr d) throws NullArgumentException {
            for (int i = 0; i < this.virtualSize; ++i) {
                this.setEntry(i, this.getEntry(i).add(d));
            }
            return this;
        }

        public SparseExprVector mapDivide(IExpr d) throws NullArgumentException, MathRuntimeException {
            return this.copy().mapDivideToSelf(d);
        }

        public SparseExprVector mapDivideToSelf(IExpr d) throws NullArgumentException, MathRuntimeException {
            Trie trie = (Trie)this.array.fData;
            for (TrieNode entry : trie.nodeSet()) {
                int[] key = (int[])entry.getKey();
                IExpr value = (IExpr)entry.getValue();
                trie.put((Object)key, (Object)value.divide(d));
            }
            return this;
        }

        public SparseExprVector mapInv() throws MathRuntimeException {
            return this.copy().mapInvToSelf();
        }

        public SparseExprVector mapInvToSelf() throws MathRuntimeException {
            for (int i = 0; i < this.virtualSize; ++i) {
                this.setEntry(i, this.getEntry(i).inverse());
            }
            return this;
        }

        public SparseExprVector mapMultiply(IExpr d) throws NullArgumentException {
            return this.copy().mapMultiplyToSelf(d);
        }

        public SparseExprVector mapMultiplyToSelf(IExpr d) throws NullArgumentException {
            Trie trie = (Trie)this.array.fData;
            for (TrieNode entry : trie.nodeSet()) {
                int[] key = (int[])entry.getKey();
                IExpr value = (IExpr)entry.getValue();
                trie.put((Object)key, (Object)value.multiply(d));
            }
            return this;
        }

        public SparseExprVector mapSubtract(IExpr d) throws NullArgumentException {
            return this.copy().mapSubtractToSelf(d);
        }

        public SparseExprVector mapSubtractToSelf(IExpr d) throws NullArgumentException {
            return this.mapAddToSelf(d.negate());
        }

        public SparseExprMatrix outerProduct(FieldVector<IExpr> fv) {
            if (fv instanceof SparseExprVector) {
                SparseExprVector v = (SparseExprVector)fv;
                int n = v.getDimension();
                SparseExprMatrix res = new SparseExprMatrix(this.virtualSize, n, this.array.fDefaultValue);
                Trie trie1 = (Trie)this.array.fData;
                for (TrieNode entry1 : trie1.nodeSet()) {
                    int[] key1 = (int[])entry1.getKey();
                    IExpr value1 = (IExpr)entry1.getValue();
                    Trie trie2 = (Trie)v.array.fData;
                    for (TrieNode entry2 : trie2.nodeSet()) {
                        int[] key2 = (int[])entry2.getKey();
                        IExpr value2 = (IExpr)entry2.getValue();
                        res.setEntry(key1[0] - 1, key2[0] - 1, value1.multiply(value2));
                    }
                }
                return res;
            }
            return null;
        }

        public SparseExprVector projection(FieldVector<IExpr> fv) throws MathIllegalArgumentException, MathRuntimeException {
            if (fv instanceof SparseExprVector) {
                SparseExprVector v = (SparseExprVector)fv;
                this.checkVectorDimensions(v.getDimension());
                return v.mapMultiply(this.dotProduct(v).divide(v.dotProduct(v)));
            }
            return null;
        }

        public void set(IExpr value) {
            MathUtils.checkNotNull((Object)value);
            for (int i = 0; i < this.virtualSize; ++i) {
                this.setEntry(i, value);
            }
        }

        public void setEntry(int index, IExpr value) throws MathIllegalArgumentException {
            Trie trie = (Trie)this.array.fData;
            int[] key = new int[]{index + 1};
            if (value.equals(this.array.fDefaultValue)) {
                trie.remove((Object)key);
            } else {
                trie.put((Object)key, (Object)value);
            }
        }

        public void setSubVector(int index, FieldVector<IExpr> v) throws MathIllegalArgumentException {
            this.checkIndex(index);
            this.checkIndex(index + v.getDimension() - 1);
            int n = v.getDimension();
            for (int i = 0; i < n; ++i) {
                this.setEntry(i + index, (IExpr)v.getEntry(i));
            }
        }

        public SparseExprVector subtract(FieldVector<IExpr> fv) throws MathIllegalArgumentException {
            if (fv instanceof SparseExprVector) {
                SparseExprVector v = (SparseExprVector)fv;
                this.checkVectorDimensions(v.getDimension());
                SparseExprVector res = this.copy();
                Trie trie = (Trie)v.array.fData;
                for (TrieNode entry : trie.nodeSet()) {
                    int[] key = (int[])entry.getKey();
                    int position = key[0];
                    IExpr value = (IExpr)entry.getValue();
                    if (((Trie)this.array.fData).containsKey((Object)key)) {
                        res.setEntry(position, ((IExpr)((Trie)this.array.fData).get((Object)key)).subtract(value));
                        continue;
                    }
                    res.setEntry(position, value.negate());
                }
                return res;
            }
            return null;
        }

        public IExpr[] toArray() {
            IExpr[] res = new IExpr[this.virtualSize];
            for (int i = 0; i < res.length; ++i) {
                res[i] = this.array.fDefaultValue;
            }
            Trie trie = (Trie)this.array.fData;
            for (TrieNode entry : trie.nodeSet()) {
                res[((int[])entry.getKey())[0]] = (IExpr)entry.getValue();
            }
            return res;
        }
    }

    public static class SparseExprMatrix
    extends AbstractFieldMatrix<IExpr> {
        final SparseArrayExpr array;

        public SparseExprMatrix(int rowDimension, int columnDimension, IExpr defaultValue) {
            super(F.EXPR_FIELD, rowDimension, columnDimension);
            this.array = new SparseArrayExpr((Trie<int[], IExpr>)Config.TRIE_INT2EXPR_BUILDER.build(), new int[]{rowDimension, columnDimension}, defaultValue, false);
        }

        public SparseExprMatrix(SparseArrayExpr array, boolean copyArray) {
            super(F.EXPR_FIELD, array.fDimension[0], array.fDimension[1]);
            this.array = copyArray ? new SparseArrayExpr((Trie<int[], IExpr>)((Trie)array.fData), array.fDimension, array.fDefaultValue, true) : array;
        }

        public SparseExprMatrix(SparseExprMatrix other) {
            super(F.EXPR_FIELD, other.array.fDimension[0], other.array.fDimension[1]);
            this.array = new SparseArrayExpr((Trie<int[], IExpr>)((Trie)other.array.fData), other.array.fDimension, other.array.fDefaultValue, true);
        }

        public void addToEntry(int row, int column, IExpr increment) throws MathIllegalArgumentException {
            Trie trie = (Trie)this.array.fData;
            int[] key = new int[]{row + 1, column + 1};
            IExpr value = (IExpr)trie.get((Object)key);
            if ((value = S.Plus.of(value != null ? value : this.array.fDefaultValue, increment)).equals(this.array.fDefaultValue)) {
                trie.remove((Object)key);
            } else {
                trie.put((Object)key, (Object)value);
            }
        }

        public FieldMatrix<IExpr> copy() {
            return new SparseExprMatrix(this);
        }

        public SparseExprMatrix createMatrix(int rowDimension, int columnDimension) throws MathIllegalArgumentException {
            return new SparseExprMatrix(rowDimension, columnDimension, F.C0);
        }

        public int getColumnDimension() {
            return this.array.fDimension[1];
        }

        public IExpr getEntry(int row, int column) throws MathIllegalArgumentException {
            IExpr value = (IExpr)((Trie)this.array.fData).get((Object)new int[]{row + 1, column + 1});
            return value == null ? this.array.fDefaultValue : value;
        }

        public int getRowDimension() {
            return this.array.fDimension[0];
        }

        public SparseArrayExpr getSparseArray() {
            return this.array;
        }

        public SparseExprMatrix multiply(FieldMatrix<IExpr> m) throws MathIllegalArgumentException {
            this.checkMultiplicationCompatible(m);
            int nRows = this.getRowDimension();
            int nCols = m.getColumnDimension();
            int nSum = this.getColumnDimension();
            SparseExprMatrix out = this.createMatrix(nRows, nCols);
            for (int row = 0; row < nRows; ++row) {
                for (int col = 0; col < nCols; ++col) {
                    IExpr sum = F.C0;
                    for (int i = 0; i < nSum; ++i) {
                        sum = sum.add(this.getEntry(row, i).multiply((IExpr)m.getEntry(i, col)));
                    }
                    out.setEntry(row, col, sum);
                }
            }
            return out;
        }

        public void multiplyEntry(int row, int column, IExpr factor) throws MathIllegalArgumentException {
            Trie trie = (Trie)this.array.fData;
            int[] key = new int[]{row + 1, column + 1};
            IExpr value = (IExpr)trie.get((Object)key);
            if ((value = S.Times.of(value != null ? value : this.array.fDefaultValue, factor)).equals(this.array.fDefaultValue)) {
                trie.remove((Object)key);
            } else {
                trie.put((Object)key, (Object)value);
            }
        }

        public SparseExprVector operate(FieldVector<IExpr> fv) throws MathIllegalArgumentException {
            if (fv instanceof SparseExprVector) {
                SparseExprVector v = (SparseExprVector)fv;
                int nRows = this.getRowDimension();
                int nCols = this.getColumnDimension();
                if (v.getDimension() != nCols) {
                    throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{v.getDimension(), nCols});
                }
                SparseExprVector out = new SparseExprVector(nRows, this.array.fDefaultValue);
                for (int row = 0; row < nRows; ++row) {
                    IExpr sum = F.C0;
                    for (int i = 0; i < nCols; ++i) {
                        sum = sum.add(this.getEntry(row, i).multiply(v.getEntry(i)));
                    }
                    out.setEntry(row, sum);
                }
                return out;
            }
            return null;
        }

        public void setEntry(int row, int column, IExpr value) throws MathIllegalArgumentException {
            Trie trie = (Trie)this.array.fData;
            int[] key = new int[]{row + 1, column + 1};
            if (value.equals(this.array.fDefaultValue)) {
                trie.remove((Object)key);
            } else {
                trie.put((Object)key, (Object)value);
            }
        }
    }
}

