/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression.data;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.channels.Channels;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.expression.DataExpr;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.InputStreamExpr;
import org.matheclipse.core.interfaces.IExpr;

public class OutputStreamExpr
extends DataExpr<OutputStream>
implements Externalizable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int uniqueID = InputStreamExpr.STREAM_COUNTER.getAndIncrement();
    private final String streamName;
    private Writer writer;
    private DataOutput dataOut;

    public DataOutput getDataOutput() {
        if (this.dataOut == null) {
            this.dataOut = new DataOutputStream((OutputStream)this.fData);
        }
        return this.dataOut;
    }

    public Writer getWriter() {
        if (this.writer == null) {
            this.writer = new OutputStreamWriter((OutputStream)this.fData);
        }
        return this.writer;
    }

    public OutputStreamExpr() {
        super(S.OutputStream, null);
        this.streamName = "String";
    }

    public static OutputStreamExpr newInstance(String fileName, boolean append) throws IOException {
        File file = new File(fileName);
        return OutputStreamExpr.newInstance(file, append);
    }

    public static OutputStreamExpr newInstance() throws IOException {
        File file = File.createTempFile("symja", "");
        return OutputStreamExpr.newInstance(file, false);
    }

    public static OutputStreamExpr newInstance(RandomAccessFile file, String streamName) {
        OutputStream outputStream = Channels.newOutputStream(file.getChannel());
        return new OutputStreamExpr(outputStream, streamName);
    }

    public static OutputStreamExpr newInstance(File file, boolean append) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, append);
        if (append) {
            try {
                fos.write(10);
            }
            catch (IOException e) {
                LOGGER.error("OutputStreamExpr.newInstance() failed", (Throwable)e);
            }
        }
        return new OutputStreamExpr(fos, file.getCanonicalPath());
    }

    protected OutputStreamExpr(OutputStream stream, String streamName) {
        super(S.OutputStream, stream);
        this.streamName = streamName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OutputStreamExpr) {
            return ((OutputStream)this.fData).equals(((OutputStreamExpr)obj).fData);
        }
        return false;
    }

    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public int hashCode() {
        return this.fData == null ? 353 : 353 + ((OutputStream)this.fData).hashCode();
    }

    @Override
    public int hierarchy() {
        return 32802;
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        ((OutputStream)this.fData).close();
        this.dataOut = null;
    }

    public IExpr copy() {
        return new OutputStreamExpr((OutputStream)this.fData, this.streamName);
    }

    @Override
    public String toString() {
        return this.fHead + "[Name: " + this.streamName + " Unique-ID: " + this.uniqueID + "]";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fData = (OutputStream)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeObject(this.fData);
    }
}

