/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression.data;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import com.google.common.primitives.UnsignedInts;
import com.google.common.primitives.UnsignedLong;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.LinearAlgebra;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.DataExpr;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumericArray;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.parser.trie.Trie;

public class NumericArrayExpr
extends DataExpr<Object>
implements INumericArray,
Externalizable {
    public static final byte UNDEFINED = -1;
    public static final byte Integer8 = 0;
    public static final byte Integer16 = 1;
    public static final byte Integer32 = 2;
    public static final byte Integer64 = 3;
    public static final byte UnsignedInteger8 = 16;
    public static final byte UnsignedInteger16 = 17;
    public static final byte UnsignedInteger32 = 18;
    public static final byte UnsignedInteger64 = 19;
    public static final byte Real32 = 34;
    public static final byte Real64 = 35;
    public static final byte ComplexReal32 = 51;
    public static final byte ComplexReal64 = 52;
    private static final Map<String, Byte> TYPE_MAP = new HashMap<String, Byte>();
    private static final Map<Byte, String> TYPE_STRING_MAP = new HashMap<Byte, String>();
    int[] fDimension;
    byte fType;

    private static boolean arrayComplexFloatRecursive(IAST nestedListsOfValues, int level, float[] floatArr, int[] index) throws RangeException, TypeException {
        --level;
        for (int i = 1; i < nestedListsOfValues.size(); ++i) {
            IExpr arg = nestedListsOfValues.get(i);
            if (level == 0) {
                if (arg.isList()) {
                    return false;
                }
                Complex value = arg.evalComplex();
                int n = index[0];
                index[0] = n + 1;
                floatArr[n] = (float)value.getReal();
                int n2 = index[0];
                index[0] = n2 + 1;
                floatArr[n2] = (float)value.getImaginary();
                continue;
            }
            if (arg.isList() && NumericArrayExpr.arrayComplexFloatRecursive((IAST)arg, level, floatArr, index)) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayComplexDoubleRecursive(IAST nestedListsOfValues, int level, double[] doubleArr, int[] index) throws RangeException, TypeException {
        --level;
        for (int i = 1; i < nestedListsOfValues.size(); ++i) {
            IExpr arg = nestedListsOfValues.get(i);
            if (level == 0) {
                if (arg.isList()) {
                    return false;
                }
                Complex value = arg.evalComplex();
                int n = index[0];
                index[0] = n + 1;
                doubleArr[n] = value.getReal();
                int n2 = index[0];
                index[0] = n2 + 1;
                doubleArr[n2] = value.getImaginary();
                continue;
            }
            if (arg.isList() && NumericArrayExpr.arrayDoubleRecursive((IAST)arg, level, doubleArr, index)) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayDoubleRecursive(IAST nestedListsOfValues, int level, double[] doubleArr, int[] index) throws RangeException, TypeException {
        --level;
        for (int i = 1; i < nestedListsOfValues.size(); ++i) {
            IExpr arg = nestedListsOfValues.get(i);
            if (level == 0) {
                if (arg.isList()) {
                    return false;
                }
                int n = index[0];
                index[0] = n + 1;
                doubleArr[n] = arg.evalDouble();
                continue;
            }
            if (arg.isList() && NumericArrayExpr.arrayDoubleRecursive((IAST)arg, level, doubleArr, index)) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayFloatRecursive(IAST nestedListsOfValues, int level, float[] floatArr, int[] index) throws RangeException, TypeException {
        --level;
        for (int i = 1; i < nestedListsOfValues.size(); ++i) {
            IExpr arg = nestedListsOfValues.get(i);
            if (level == 0) {
                if (arg.isList()) {
                    return false;
                }
                int n = index[0];
                index[0] = n + 1;
                floatArr[n] = (float)arg.evalDouble();
                continue;
            }
            if (arg.isList() && NumericArrayExpr.arrayFloatRecursive((IAST)arg, level, floatArr, index)) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayByteRecursive(IAST nestedListsOfValues, int level, byte[] byteArr, int[] index) throws RangeException, TypeException {
        --level;
        for (int i = 1; i < nestedListsOfValues.size(); ++i) {
            IExpr arg = nestedListsOfValues.get(i);
            if (level == 0) {
                byte b = NumericArrayExpr.getByte(arg);
                int n = index[0];
                index[0] = n + 1;
                byteArr[n] = b;
                continue;
            }
            if (arg.isList() && NumericArrayExpr.arrayByteRecursive((IAST)arg, level, byteArr, index)) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayShortRecursive(IAST nestedListsOfValues, int level, short[] shortArr, int[] index) throws RangeException, TypeException {
        --level;
        for (int i = 1; i < nestedListsOfValues.size(); ++i) {
            IExpr arg = nestedListsOfValues.get(i);
            if (level == 0) {
                if (!arg.isInteger()) {
                    throw new TypeException("Not a valid Integers type");
                }
                int value = ((ISignedNumber)arg).toInt();
                if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                    throw new RangeException("Value " + value + " out of Integer16 range");
                }
                int n = index[0];
                index[0] = n + 1;
                shortArr[n] = (short)value;
                continue;
            }
            if (arg.isList() && NumericArrayExpr.arrayShortRecursive((IAST)arg, level, shortArr, index)) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayIntRecursive(IAST nestedListsOfValues, int level, int[] intArr, int[] index) throws RangeException, TypeException {
        --level;
        for (int i = 1; i < nestedListsOfValues.size(); ++i) {
            IExpr arg = nestedListsOfValues.get(i);
            if (level == 0) {
                if (!arg.isInteger()) {
                    throw new TypeException("Not a valid Integers type");
                }
                int n = index[0];
                index[0] = n + 1;
                intArr[n] = ((ISignedNumber)arg).toInt();
                continue;
            }
            if (arg.isList() && NumericArrayExpr.arrayIntRecursive((IAST)arg, level, intArr, index)) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayLongRecursive(IAST nestedListsOfValues, int level, long[] longArr, int[] index) throws RangeException, TypeException {
        --level;
        for (int i = 1; i < nestedListsOfValues.size(); ++i) {
            IExpr arg = nestedListsOfValues.get(i);
            if (level == 0) {
                if (!arg.isInteger()) {
                    throw new TypeException("Not a valid Integers type");
                }
                int n = index[0];
                index[0] = n + 1;
                longArr[n] = ((ISignedNumber)arg).toLong();
                continue;
            }
            if (arg.isList() && NumericArrayExpr.arrayLongRecursive((IAST)arg, level, longArr, index)) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayUnsignedByteRecursive(IAST nestedListsOfValues, int level, byte[] byteArr, int[] index) throws RangeException, TypeException {
        --level;
        for (int i = 1; i < nestedListsOfValues.size(); ++i) {
            IExpr arg = nestedListsOfValues.get(i);
            if (level == 0) {
                byte b = NumericArrayExpr.getUnsignedByte(arg);
                int n = index[0];
                index[0] = n + 1;
                byteArr[n] = b;
                continue;
            }
            if (arg.isList() && NumericArrayExpr.arrayUnsignedByteRecursive((IAST)arg, level, byteArr, index)) continue;
            return false;
        }
        return true;
    }

    public static byte getByte(IExpr arg) throws TypeException, RangeException {
        if (!arg.isInteger()) {
            throw new TypeException("Not a valid Integers type");
        }
        int value = arg.toIntDefault();
        if (value < -128 || value > 127) {
            throw new RangeException("Value " + value + " out of Integer8 range");
        }
        byte b = (byte)value;
        return b;
    }

    public static byte getUnsignedByte(IExpr arg) throws IllegalArgumentException, TypeException {
        if (!arg.isInteger()) {
            throw new TypeException("Not a valid Integers type");
        }
        long value = ((ISignedNumber)arg).toLong();
        byte b = UnsignedBytes.checkedCast((long)value);
        return b;
    }

    private static short checkedCastUnsignedShort(int value) {
        Preconditions.checkArgument((value >> 16 == 0 ? 1 : 0) != 0, (String)"out of range: %s", (int)value);
        return (short)value;
    }

    private static boolean arrayUnsignedShortRecursive(IAST nestedListsOfValues, int level, short[] shortArr, int[] index) throws RangeException, TypeException {
        --level;
        for (int i = 1; i < nestedListsOfValues.size(); ++i) {
            IExpr arg = nestedListsOfValues.get(i);
            if (level == 0) {
                if (!arg.isInteger()) {
                    throw new TypeException("Not a valid Integers type");
                }
                int value = ((ISignedNumber)arg).toInt();
                int n = index[0];
                index[0] = n + 1;
                shortArr[n] = NumericArrayExpr.checkedCastUnsignedShort(value);
                continue;
            }
            if (arg.isList() && NumericArrayExpr.arrayUnsignedShortRecursive((IAST)arg, level, shortArr, index)) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayUnsignedIntRecursive(IAST nestedListsOfValues, int level, int[] intArr, int[] index) throws RangeException, TypeException {
        --level;
        for (int i = 1; i < nestedListsOfValues.size(); ++i) {
            IExpr arg = nestedListsOfValues.get(i);
            if (level == 0) {
                if (!arg.isInteger()) {
                    throw new TypeException("Not a valid Integers type");
                }
                long value = ((ISignedNumber)arg).toLong();
                int n = index[0];
                index[0] = n + 1;
                intArr[n] = UnsignedInts.checkedCast((long)value);
                continue;
            }
            if (arg.isList() && NumericArrayExpr.arrayUnsignedIntRecursive((IAST)arg, level, intArr, index)) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayUnsignedLongRecursive(IAST nestedListsOfValues, int level, long[] longArr, int[] index) throws RangeException, TypeException {
        --level;
        for (int i = 1; i < nestedListsOfValues.size(); ++i) {
            IExpr arg = nestedListsOfValues.get(i);
            if (level == 0) {
                if (!arg.isInteger()) {
                    throw new TypeException("Not a valid Integers type");
                }
                BigInteger value = ((IInteger)arg).toBigNumerator();
                UnsignedLong uint64 = UnsignedLong.valueOf((BigInteger)value);
                int n = index[0];
                index[0] = n + 1;
                longArr[n] = uint64.longValue();
                continue;
            }
            if (arg.isList() && NumericArrayExpr.arrayUnsignedLongRecursive((IAST)arg, level, longArr, index)) continue;
            return false;
        }
        return true;
    }

    public static byte toType(String typeAsString) {
        Byte result = TYPE_MAP.get(typeAsString);
        if (result != null) {
            return result;
        }
        return -1;
    }

    public static NumericArrayExpr newInstance(Object value, int[] dimension, byte type) {
        return new NumericArrayExpr(value, dimension, type);
    }

    public static NumericArrayExpr newListByType(IAST list, byte type, IBuiltInSymbol symbol) {
        if (type == -1) {
            NumericArrayExpr result;
            NumericArrayExpr result2;
            if (symbol == S.Integers || symbol == S.All) {
                try {
                    result2 = NumericArrayExpr.newList(list, (byte)0);
                    if (result2 != null) {
                        return result2;
                    }
                }
                catch (ArithmeticException | IllegalArgumentException | RangeException rex) {
                    try {
                        result = NumericArrayExpr.newList(list, (byte)1);
                        if (result != null) {
                            return result;
                        }
                    }
                    catch (ArithmeticException | IllegalArgumentException | RangeException rex2) {
                        try {
                            NumericArrayExpr result3 = NumericArrayExpr.newList(list, (byte)2);
                            if (result3 != null) {
                                return result3;
                            }
                        }
                        catch (ArithmeticException | IllegalArgumentException | RangeException rex3) {
                            try {
                                NumericArrayExpr result4 = NumericArrayExpr.newList(list, (byte)3);
                                if (result4 != null) {
                                    return result4;
                                }
                            }
                            catch (ArithmeticException | IllegalArgumentException | ArgumentTypeException | RangeException | TypeException object) {}
                        }
                        catch (ArgumentTypeException | TypeException object) {
                        }
                    }
                    catch (ArgumentTypeException | TypeException rex2) {}
                }
                catch (ArgumentTypeException | TypeException rex) {
                    // empty catch block
                }
            }
            if (symbol == S.Reals || symbol == S.All) {
                try {
                    result2 = NumericArrayExpr.newList(list, (byte)34);
                    if (result2 != null) {
                        return result2;
                    }
                }
                catch (ArithmeticException | IllegalArgumentException | RangeException rex) {
                    try {
                        result = NumericArrayExpr.newList(list, (byte)35);
                        if (result != null) {
                            return result;
                        }
                    }
                    catch (ArithmeticException | IllegalArgumentException | ArgumentTypeException | RangeException | TypeException result5) {}
                }
                catch (ArgumentTypeException | TypeException rex) {
                    // empty catch block
                }
            }
            if (symbol == S.Complexes || symbol == S.All) {
                try {
                    result2 = NumericArrayExpr.newList(list, (byte)51);
                    if (result2 != null) {
                        return result2;
                    }
                }
                catch (ArithmeticException | IllegalArgumentException | RangeException rex) {
                    try {
                        result = NumericArrayExpr.newList(list, (byte)52);
                        if (result != null) {
                            return result;
                        }
                    }
                    catch (ArithmeticException | ArgumentTypeException | RangeException | TypeException object) {}
                }
                catch (ArgumentTypeException | TypeException object) {
                    // empty catch block
                }
            }
            return null;
        }
        try {
            return NumericArrayExpr.newList(list, type);
        }
        catch (RangeException | TypeException exception) {
            return null;
        }
    }

    private static NumericArrayExpr newList(IAST list, byte type) throws RangeException, TypeException {
        int[] dimension = null;
        IntArrayList dims = LinearAlgebra.dimensions(list);
        int dimsSize = dims.size();
        if (dimsSize > 0) {
            int size = 1;
            dimension = new int[dimsSize];
            for (int i = 0; i < dimsSize; ++i) {
                dimension[i] = dims.getInt(i);
                size *= dimension[i];
            }
            try {
                int[] index = new int[1];
                switch (type) {
                    case 0: {
                        byte[] byteArr = new byte[size];
                        if (!NumericArrayExpr.arrayByteRecursive(list, dimension.length, byteArr, index)) break;
                        return new NumericArrayExpr(byteArr, dimension, type);
                    }
                    case 1: {
                        short[] shortArr = new short[size];
                        if (!NumericArrayExpr.arrayShortRecursive(list, dimension.length, shortArr, index)) break;
                        return new NumericArrayExpr(shortArr, dimension, type);
                    }
                    case 2: {
                        int[] intArr = new int[size];
                        if (!NumericArrayExpr.arrayIntRecursive(list, dimension.length, intArr, index)) break;
                        return new NumericArrayExpr(intArr, dimension, type);
                    }
                    case 3: {
                        long[] longArr = new long[size];
                        if (!NumericArrayExpr.arrayLongRecursive(list, dimension.length, longArr, index)) break;
                        return new NumericArrayExpr(longArr, dimension, type);
                    }
                    case 16: {
                        byte[] unsignedByteArr = new byte[size];
                        if (!NumericArrayExpr.arrayUnsignedByteRecursive(list, dimension.length, unsignedByteArr, index)) break;
                        return new NumericArrayExpr(unsignedByteArr, dimension, type);
                    }
                    case 17: {
                        short[] unsignedShortArr = new short[size];
                        if (!NumericArrayExpr.arrayUnsignedShortRecursive(list, dimension.length, unsignedShortArr, index)) break;
                        return new NumericArrayExpr(unsignedShortArr, dimension, type);
                    }
                    case 18: {
                        int[] unsignedIntArr = new int[size];
                        if (!NumericArrayExpr.arrayUnsignedIntRecursive(list, dimension.length, unsignedIntArr, index)) break;
                        return new NumericArrayExpr(unsignedIntArr, dimension, type);
                    }
                    case 19: {
                        long[] unsignedLongArr = new long[size];
                        if (!NumericArrayExpr.arrayUnsignedLongRecursive(list, dimension.length, unsignedLongArr, index)) break;
                        return new NumericArrayExpr(unsignedLongArr, dimension, type);
                    }
                    case 34: {
                        float[] floatArr = new float[size];
                        if (!NumericArrayExpr.arrayFloatRecursive(list, dimension.length, floatArr, index)) break;
                        return new NumericArrayExpr(floatArr, dimension, type);
                    }
                    case 35: {
                        double[] doubleArr = new double[size];
                        if (NumericArrayExpr.arrayDoubleRecursive(list, dimension.length, doubleArr, index)) {
                            return new NumericArrayExpr(doubleArr, dimension, type);
                        }
                        break;
                    }
                    case 51: {
                        float[] complexFloatArr = new float[size * 2];
                        if (NumericArrayExpr.arrayComplexFloatRecursive(list, dimension.length, complexFloatArr, index)) {
                            return new NumericArrayExpr(complexFloatArr, dimension, type);
                        }
                        break;
                    }
                    case 52: {
                        double[] complexDoubleArr = new double[size * 2];
                        if (!NumericArrayExpr.arrayComplexDoubleRecursive(list, dimension.length, complexDoubleArr, index)) break;
                        return new NumericArrayExpr(complexDoubleArr, dimension, type);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void normalRecursive(float[] floatArray, IASTMutable list, int[] dimension, int position, int[] index) {
        int size = dimension[position];
        if (dimension.length - 1 == position) {
            for (int i = 1; i <= size; ++i) {
                int n = index[0];
                index[0] = n + 1;
                list.set(i, F.num(floatArray[n]));
            }
            return;
        }
        int size2 = dimension[position + 1];
        for (int i = 1; i <= size; ++i) {
            IASTMutable currentList = F.astMutable(S.List, size2);
            list.set(i, currentList);
            NumericArrayExpr.normalRecursive(floatArray, currentList, dimension, position + 1, index);
        }
    }

    private static void normalRecursive(double[] doubleArray, IASTMutable list, int[] dimension, int position, int[] index) {
        int size = dimension[position];
        if (dimension.length - 1 == position) {
            for (int i = 1; i <= size; ++i) {
                int n = index[0];
                index[0] = n + 1;
                list.set(i, F.num(doubleArray[n]));
            }
            return;
        }
        int size2 = dimension[position + 1];
        for (int i = 1; i <= size; ++i) {
            IASTMutable currentList = F.astMutable(S.List, size2);
            list.set(i, currentList);
            NumericArrayExpr.normalRecursive(doubleArray, currentList, dimension, position + 1, index);
        }
    }

    private static void normalRecursiveComplex(float[] floatArray, IASTMutable list, int[] dimension, int position, int[] index) {
        int size = dimension[position];
        if (dimension.length - 1 == position) {
            for (int i = 1; i <= size; ++i) {
                int n = index[0];
                index[0] = n + 1;
                int n2 = index[0];
                index[0] = n2 + 1;
                list.set(i, F.complexNum(floatArray[n], floatArray[n2]));
            }
            return;
        }
        int size2 = dimension[position + 1];
        for (int i = 1; i <= size; ++i) {
            IASTMutable currentList = F.astMutable(S.List, size2);
            list.set(i, currentList);
            NumericArrayExpr.normalRecursiveComplex(floatArray, currentList, dimension, position + 1, index);
        }
    }

    private static void normalRecursiveComplex(double[] doubleArray, IASTMutable list, int[] dimension, int position, int[] index) {
        int size = dimension[position];
        if (dimension.length - 1 == position) {
            for (int i = 1; i <= size; ++i) {
                int n = index[0];
                index[0] = n + 1;
                int n2 = index[0];
                index[0] = n2 + 1;
                list.set(i, F.complexNum(doubleArray[n], doubleArray[n2]));
            }
            return;
        }
        int size2 = dimension[position + 1];
        for (int i = 1; i <= size; ++i) {
            IASTMutable currentList = F.astMutable(S.List, size2);
            list.set(i, currentList);
            NumericArrayExpr.normalRecursiveComplex(doubleArray, currentList, dimension, position + 1, index);
        }
    }

    private static void normalRecursive(byte[] byteArray, boolean unsigned, IASTMutable list, int[] dimension, int position, int[] index) {
        int size = dimension[position];
        if (dimension.length - 1 == position) {
            for (int i = 1; i <= size; ++i) {
                IInteger iInteger;
                if (unsigned) {
                    int n = index[0];
                    index[0] = n + 1;
                    iInteger = F.ZZ(Byte.toUnsignedInt(byteArray[n]));
                } else {
                    int n = index[0];
                    index[0] = n + 1;
                    iInteger = F.ZZ(byteArray[n]);
                }
                IInteger intValue = iInteger;
                list.set(i, intValue);
            }
            return;
        }
        int size2 = dimension[position + 1];
        for (int i = 1; i <= size; ++i) {
            IASTMutable currentList = F.astMutable(S.List, size2);
            list.set(i, currentList);
            NumericArrayExpr.normalRecursive(byteArray, unsigned, currentList, dimension, position + 1, index);
        }
    }

    private static void normalRecursive(short[] shortArray, boolean unsigned, IASTMutable list, int[] dimension, int position, int[] index) {
        int size = dimension[position];
        if (dimension.length - 1 == position) {
            for (int i = 1; i <= size; ++i) {
                IInteger iInteger;
                if (unsigned) {
                    int n = index[0];
                    index[0] = n + 1;
                    iInteger = F.ZZ(Short.toUnsignedInt(shortArray[n]));
                } else {
                    int n = index[0];
                    index[0] = n + 1;
                    iInteger = F.ZZ(shortArray[n]);
                }
                IInteger intValue = iInteger;
                list.set(i, intValue);
            }
            return;
        }
        int size2 = dimension[position + 1];
        for (int i = 1; i <= size; ++i) {
            IASTMutable currentList = F.astMutable(S.List, size2);
            list.set(i, currentList);
            NumericArrayExpr.normalRecursive(shortArray, unsigned, currentList, dimension, position + 1, index);
        }
    }

    private static void normalRecursive(int[] intArray, boolean unsigned, IASTMutable list, int[] dimension, int position, int[] index) {
        int size = dimension[position];
        if (dimension.length - 1 == position) {
            for (int i = 1; i <= size; ++i) {
                long l;
                if (unsigned) {
                    int n = index[0];
                    index[0] = n + 1;
                    l = Integer.toUnsignedLong(intArray[n]);
                } else {
                    int n = index[0];
                    index[0] = n + 1;
                    l = intArray[n];
                }
                long value = l;
                list.set(i, F.ZZ(value));
            }
            return;
        }
        int size2 = dimension[position + 1];
        for (int i = 1; i <= size; ++i) {
            IASTMutable currentList = F.astMutable(S.List, size2);
            list.set(i, currentList);
            NumericArrayExpr.normalRecursive(intArray, unsigned, currentList, dimension, position + 1, index);
        }
    }

    private static void normalRecursive(long[] longArray, boolean unsigned, IASTMutable list, int[] dimension, int position, int[] index) {
        int size = dimension[position];
        if (dimension.length - 1 == position) {
            for (int i = 1; i <= size; ++i) {
                IInteger iInteger;
                if (unsigned) {
                    int n = index[0];
                    index[0] = n + 1;
                    iInteger = F.ZZ(UnsignedLong.fromLongBits((long)longArray[n]).bigIntegerValue());
                } else {
                    int n = index[0];
                    index[0] = n + 1;
                    iInteger = F.ZZ(longArray[n]);
                }
                IInteger intValue = iInteger;
                list.set(i, intValue);
            }
            return;
        }
        int size2 = dimension[position + 1];
        for (int i = 1; i <= size; ++i) {
            IASTMutable currentList = F.astMutable(S.List, size2);
            list.set(i, currentList);
            NumericArrayExpr.normalRecursive(longArray, unsigned, currentList, dimension, position + 1, index);
        }
    }

    public NumericArrayExpr() {
        super(S.NumericArray, null);
        this.fType = (byte)-1;
    }

    public NumericArrayExpr(Object array, int[] dimension, byte type) {
        super(S.NumericArray, array);
        this.fDimension = dimension;
        this.fType = type;
    }

    public IExpr copy() {
        return new NumericArrayExpr(this.fData, this.fDimension, this.fType);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NumericArrayExpr) {
            NumericArrayExpr numericArray = (NumericArrayExpr)obj;
            if (this.fType == numericArray.fType) {
                switch (this.fType) {
                    case 0: {
                        return Arrays.equals((byte[])this.fData, (byte[])numericArray.fData);
                    }
                    case 1: {
                        return Arrays.equals((short[])this.fData, (short[])numericArray.fData);
                    }
                    case 2: {
                        return Arrays.equals((int[])this.fData, (int[])numericArray.fData);
                    }
                    case 3: {
                        return Arrays.equals((long[])this.fData, (long[])numericArray.fData);
                    }
                    case 34: {
                        return Arrays.equals((float[])this.fData, (float[])numericArray.fData);
                    }
                    case 35: {
                        return Arrays.equals((double[])this.fData, (double[])numericArray.fData);
                    }
                    case 51: {
                        return Arrays.equals((float[])this.fData, (float[])numericArray.fData);
                    }
                    case 52: {
                        return Arrays.equals((double[])this.fData, (double[])numericArray.fData);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public IExpr get(int position) {
        int[] dims = this.getDimension();
        boolean partSize = true;
        int len = 0;
        int[] partIndex = new int[dims.length];
        int count = 0;
        partIndex[0] = position;
        for (int i = 1; i < dims.length; ++i) {
            partIndex[i] = -1;
            ++count;
        }
        if (count == 0 && 1 == dims.length) {
            return F.NIL;
        }
        int[] newDimension = new int[count];
        count = 0;
        for (int i = 0; i < partIndex.length; ++i) {
            if (partIndex[i] != -1) continue;
            ++len;
            newDimension[count++] = dims[i];
        }
        Trie value = Config.TRIE_INT2EXPR_BUILDER.build();
        return new NumericArrayExpr(value, newDimension, this.fType);
    }

    @Override
    public int[] getDimension() {
        return this.fDimension;
    }

    private IExpr getPart(int[] position) {
        int index = 1;
        for (int i = 0; i < position.length; ++i) {
            index *= position[i];
        }
        return F.NIL;
    }

    @Override
    public String getStringType() {
        return TYPE_STRING_MAP.get(this.fType);
    }

    @Override
    public byte getType() {
        return this.fType;
    }

    @Override
    public int hashCode() {
        return this.fData == null ? 541 : 541 + this.fType;
    }

    @Override
    public int hierarchy() {
        return 32796;
    }

    @Override
    public boolean isNumericArray() {
        return true;
    }

    @Override
    public IASTMutable normal(boolean nilIfUnevaluated) {
        if (this.fDimension.length > 0) {
            return this.normalAppendable(S.List, this.fDimension);
        }
        return F.headAST0(S.List);
    }

    @Override
    public IASTMutable normal(int[] dims) {
        return this.normalAppendable(S.List, dims);
    }

    private IASTMutable normalAppendable(IExpr head, int[] dims) {
        IASTMutable list = F.astMutable(head, dims[0]);
        int[] index = new int[1];
        switch (this.fType) {
            case 0: {
                NumericArrayExpr.normalRecursive((byte[])this.fData, false, list, dims, 0, index);
                break;
            }
            case 1: {
                NumericArrayExpr.normalRecursive((short[])this.fData, false, list, dims, 0, index);
                break;
            }
            case 2: {
                NumericArrayExpr.normalRecursive((int[])this.fData, false, list, dims, 0, index);
                break;
            }
            case 3: {
                NumericArrayExpr.normalRecursive((long[])this.fData, false, list, dims, 0, index);
                break;
            }
            case 16: {
                NumericArrayExpr.normalRecursive((byte[])this.fData, true, list, dims, 0, index);
                break;
            }
            case 17: {
                NumericArrayExpr.normalRecursive((short[])this.fData, true, list, dims, 0, index);
                break;
            }
            case 18: {
                NumericArrayExpr.normalRecursive((int[])this.fData, true, list, dims, 0, index);
                break;
            }
            case 19: {
                NumericArrayExpr.normalRecursive((long[])this.fData, true, list, dims, 0, index);
                break;
            }
            case 34: {
                NumericArrayExpr.normalRecursive((float[])this.fData, list, dims, 0, index);
                break;
            }
            case 35: {
                NumericArrayExpr.normalRecursive((double[])this.fData, list, dims, 0, index);
                break;
            }
            case 51: {
                NumericArrayExpr.normalRecursiveComplex((float[])this.fData, list, dims, 0, index);
                break;
            }
            case 52: {
                NumericArrayExpr.normalRecursiveComplex((double[])this.fData, list, dims, 0, index);
            }
        }
        return list;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte type;
        this.fType = type = in.readByte();
        this.fDimension = (int[])in.readObject();
        this.fData = in.readObject();
    }

    @Override
    public int size() {
        return this.fDimension[0] + 1;
    }

    @Override
    public Object toData() {
        return this.fData;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("NumericArray(Type: ");
        buf.append(TYPE_STRING_MAP.get(this.fType));
        buf.append(" Dimensions: {");
        for (int i = 0; i < this.fDimension.length; ++i) {
            buf.append(this.fDimension[i]);
            if (i >= this.fDimension.length - 1) continue;
            buf.append(",");
        }
        buf.append("})");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeByte(this.fType);
        output.writeObject(this.fDimension);
        output.writeObject(this.fData);
    }

    static {
        TYPE_MAP.put("Integer8", (byte)0);
        TYPE_MAP.put("Integer16", (byte)1);
        TYPE_MAP.put("Integer32", (byte)2);
        TYPE_MAP.put("Integer64", (byte)3);
        TYPE_MAP.put("UnsignedInteger8", (byte)16);
        TYPE_MAP.put("UnsignedInteger16", (byte)17);
        TYPE_MAP.put("UnsignedInteger32", (byte)18);
        TYPE_MAP.put("UnsignedInteger64", (byte)19);
        TYPE_MAP.put("Real32", (byte)34);
        TYPE_MAP.put("Real64", (byte)35);
        TYPE_MAP.put("ComplexReal32", (byte)51);
        TYPE_MAP.put("ComplexReal64", (byte)52);
        TYPE_STRING_MAP.put((byte)0, "Integer8");
        TYPE_STRING_MAP.put((byte)1, "Integer16");
        TYPE_STRING_MAP.put((byte)2, "Integer32");
        TYPE_STRING_MAP.put((byte)3, "Integer64");
        TYPE_STRING_MAP.put((byte)16, "UnsignedInteger8");
        TYPE_STRING_MAP.put((byte)17, "UnsignedInteger16");
        TYPE_STRING_MAP.put((byte)18, "UnsignedInteger32");
        TYPE_STRING_MAP.put((byte)19, "UnsignedInteger64");
        TYPE_STRING_MAP.put((byte)34, "Real32");
        TYPE_STRING_MAP.put((byte)35, "Real64");
        TYPE_STRING_MAP.put((byte)51, "ComplexReal32");
        TYPE_STRING_MAP.put((byte)52, "ComplexReal64");
    }

    public static class TypeException
    extends Exception {
        private static final long serialVersionUID = -8868546084855177025L;

        TypeException(String message) {
            super(message);
        }
    }

    public static class RangeException
    extends Exception {
        private static final long serialVersionUID = 5301913995459242598L;

        RangeException(String message) {
            super(message);
        }
    }
}

