/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression.data;

import org.hipparchus.FieldElement;
import org.hipparchus.complex.Complex;
import org.hipparchus.linear.FieldDecompositionSolver;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.DataExpr;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class LinearSolveFunctionExpr<T extends FieldElement<T>>
extends DataExpr<FieldDecompositionSolver<T>> {
    private static final long serialVersionUID = 1010655513699079968L;
    private final boolean complexNumeric;
    private final long precision;

    public static LinearSolveFunctionExpr<Complex> createComplex(FieldDecompositionSolver<Complex> solver) {
        return new LinearSolveFunctionExpr<Complex>(solver, true, 16L);
    }

    public static LinearSolveFunctionExpr<IExpr> createIExpr(FieldDecompositionSolver<IExpr> solver, long precision) {
        return new LinearSolveFunctionExpr<IExpr>(solver, false, precision);
    }

    protected LinearSolveFunctionExpr(FieldDecompositionSolver<T> solver, boolean complexNumeric, long precision) {
        super(S.LinearSolveFunction, solver);
        this.complexNumeric = complexNumeric;
        this.precision = precision;
    }

    public IExpr copy() {
        return new LinearSolveFunctionExpr<T>((FieldDecompositionSolver)this.fData, this.complexNumeric, 16L);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinearSolveFunctionExpr) {
            return ((FieldDecompositionSolver)this.fData).equals(((LinearSolveFunctionExpr)obj).fData);
        }
        return false;
    }

    public IExpr evaluate(IAST ast, EvalEngine engine) {
        return F.NIL;
    }

    public int getColumnDimension() {
        return ((FieldDecompositionSolver)this.fData).getColumnDimension();
    }

    public int getRowDimension() {
        return ((FieldDecompositionSolver)this.fData).getRowDimension();
    }

    @Override
    public int hashCode() {
        return this.fData == null ? 463 : 463 + ((FieldDecompositionSolver)this.fData).hashCode();
    }

    @Override
    public int hierarchy() {
        return 32806;
    }

    @Override
    public boolean isComplexNumeric() {
        return this.complexNumeric;
    }

    public long getNumericPrecision() {
        return this.precision;
    }

    @Override
    public IAST normal(boolean nilIfUnevaluated) {
        return F.NIL;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("LinearSolveFunction(Matrix dimensions: {");
        buf.append(this.getRowDimension());
        buf.append(",");
        buf.append(this.getColumnDimension());
        buf.append("})");
        return buf.toString();
    }
}

