/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression.data;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.matheclipse.core.expression.DataExpr;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IExpr;

public class JavaClassExpr
extends DataExpr<Class<?>>
implements Externalizable {
    public JavaClassExpr() {
        super(S.JavaClass, null);
    }

    public static JavaClassExpr newInstance(Class<?> clazz) {
        return new JavaClassExpr(clazz);
    }

    public static JavaClassExpr newInstance(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(className);
        return new JavaClassExpr(clazz);
    }

    protected JavaClassExpr(Class<?> value) {
        super(S.JavaClass, value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JavaClassExpr) {
            return ((Class)this.fData).equals(((JavaClassExpr)obj).fData);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.fData == null ? 353 : 353 + ((Class)this.fData).hashCode();
    }

    @Override
    public int hierarchy() {
        return 32804;
    }

    public IExpr copy() {
        return new JavaClassExpr((Class)this.fData);
    }

    @Override
    public String toString() {
        return this.fHead + "[" + ((Class)this.fData).getCanonicalName() + "]";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fData = (Class)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeObject(this.fData);
    }
}

