/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression.data;

import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.stat.regression.SimpleRegression;
import org.hipparchus.stat.regression.UpdatingMultipleLinearRegression;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.DataExpr;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class InterpolatingFunctionExpr<T>
extends DataExpr<T> {
    double min;
    double max;
    private static final long serialVersionUID = -3183236658957651705L;

    public static InterpolatingFunctionExpr newInstance(FieldHermiteInterpolator<IExpr> interpolator, double min, double max) {
        return new HermiteFunctionExpr(interpolator, min, max);
    }

    public static InterpolatingFunctionExpr newInstance(IAST interpolator, double min, double max) {
        return new ASTFunctionExpr(interpolator, min, max);
    }

    public static InterpolatingFunctionExpr newInstance(UpdatingMultipleLinearRegression value, double min, double max) {
        return new InterpolatingFunctionExpr<UpdatingMultipleLinearRegression>(value, min, max);
    }

    protected InterpolatingFunctionExpr(T function, double min, double max) {
        super(S.InterpolatingFunction, function);
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InterpolatingFunctionExpr) {
            return this.fData.equals(((InterpolatingFunctionExpr)obj).fData);
        }
        if (obj instanceof ASTFunctionExpr) {
            return this.fData.equals(((ASTFunctionExpr)obj).fData);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.fData == null ? 461 : 461 + this.fData.hashCode();
    }

    @Override
    public int hierarchy() {
        return 32794;
    }

    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (ast.head() instanceof InterpolatingFunctionExpr && ast.isAST1()) {
            IExpr arg1 = ast.arg1();
            if (arg1.isComplex() || arg1.isComplexNumeric()) {
                return F.NIL;
            }
            boolean evaled = false;
            try {
                double value = arg1.evalDouble();
                evaled = true;
                if (value < this.min || value > this.max) {
                    IOFunctions.printMessage(ast.topHead(), "dmval", F.list(F.list(arg1)), engine);
                }
            }
            catch (ArgumentTypeException value) {
                // empty catch block
            }
            if (ast.head() instanceof HermiteFunctionExpr) {
                InterpolatingFunctionExpr function;
                Object model;
                if (evaled && (model = (function = (InterpolatingFunctionExpr)ast.head()).toData()) instanceof FieldHermiteInterpolator) {
                    FieldHermiteInterpolator interpolator = (FieldHermiteInterpolator)model;
                    IExpr[] arr = (IExpr[])interpolator.value((FieldElement)arg1);
                    if (arr.length == 1) {
                        return arr[0];
                    }
                    return F.List(arr);
                }
                return F.NIL;
            }
            if (ast.head() instanceof ASTFunctionExpr) {
                ASTFunctionExpr function = (ASTFunctionExpr)ast.head();
                Object model = function.toData();
                if (model instanceof IAST) {
                    IAST interpolator = (IAST)model;
                    return F.unaryAST1(interpolator, arg1);
                }
                return F.NIL;
            }
        }
        return F.NIL;
    }

    public IExpr copy() {
        return new InterpolatingFunctionExpr<Object>(this.fData, this.min, this.max);
    }

    @Override
    public IAST normal(boolean nilIfUnevaluated) {
        Object model = this.toData();
        if (model instanceof SimpleRegression) {
            SimpleRegression simpleModel = (SimpleRegression)model;
            return F.Plus((IExpr)F.num(simpleModel.getIntercept()), (IExpr)F.Times((IExpr)F.num(simpleModel.getSlope()), (IExpr)S.C));
        }
        return F.NIL;
    }

    private static class HermiteFunctionExpr
    extends InterpolatingFunctionExpr<FieldHermiteInterpolator> {
        private static final long serialVersionUID = 5139557783149167160L;

        public HermiteFunctionExpr(FieldHermiteInterpolator interpolator, double min, double max) {
            super(interpolator, min, max);
        }
    }

    private static class ASTFunctionExpr
    extends InterpolatingFunctionExpr<IAST> {
        private static final long serialVersionUID = 7355009868203033788L;

        @Override
        public IAST normal(boolean nilIfUnevaluated) {
            return (IAST)this.toData();
        }

        public ASTFunctionExpr(IAST interpolator, double min, double max) {
            super(interpolator, min, max);
        }
    }
}

