/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression.data;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.atomic.AtomicInteger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.DataExpr;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.FileExpr;
import org.matheclipse.core.interfaces.IExpr;

public class InputStreamExpr
extends DataExpr<InputStream>
implements Externalizable {
    public static AtomicInteger STREAM_COUNTER = new AtomicInteger(1);
    private final int uniqueID = STREAM_COUNTER.getAndIncrement();
    private final String streamName;
    private DataInput dataIn;
    private Reader reader;

    public DataInput getDataInput() throws IOException {
        if (this.dataIn == null) {
            this.dataIn = new DataInputStream((InputStream)this.fData);
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        return this.dataIn;
    }

    public Reader getReader() throws IOException {
        if (this.reader == null) {
            String str = CharStreams.toString((Readable)new InputStreamReader((InputStream)this.fData, Charsets.UTF_8));
            if (this.dataIn != null) {
                this.dataIn = null;
            }
            this.reader = new StringReader(str);
        }
        return this.reader;
    }

    public InputStreamExpr() {
        super(S.InputStream, null);
        this.streamName = "String";
    }

    public static InputStreamExpr getFromFile(FileExpr fileExpr, String streamName, EvalEngine engine) throws FileNotFoundException {
        File file = (File)fileExpr.toData();
        IExpr temp = engine.rememberMap.get(file);
        if (temp == null || !(temp instanceof InputStreamExpr)) {
            InputStreamExpr stream = new InputStreamExpr(new FileInputStream(file));
            engine.rememberMap.put(file, stream);
            return stream;
        }
        return (InputStreamExpr)temp;
    }

    public static InputStreamExpr newInstance(String fileName, String streamName) throws FileNotFoundException {
        File file = new File(fileName);
        return new InputStreamExpr(new FileInputStream(file), streamName);
    }

    public static InputStreamExpr newInstance(File file, String streamName, Reader reader) throws FileNotFoundException {
        return new InputStreamExpr(new FileInputStream(file), streamName, reader);
    }

    public static InputStreamExpr newInstance(Reader reader) throws IOException, FileNotFoundException {
        ByteArrayInputStream targetStream = new ByteArrayInputStream(CharStreams.toString((Readable)reader).getBytes(Charsets.UTF_8));
        reader.reset();
        return new InputStreamExpr(targetStream, "String", reader);
    }

    protected InputStreamExpr(InputStream value) {
        this(value, "String");
    }

    protected InputStreamExpr(InputStream value, String streamName, Reader reader) {
        super(S.InputStream, value);
        this.streamName = streamName;
        this.reader = reader;
    }

    protected InputStreamExpr(InputStream value, String streamName) {
        super(S.InputStream, value);
        this.streamName = streamName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InputStreamExpr) {
            return ((InputStream)this.fData).equals(((InputStreamExpr)obj).fData);
        }
        return false;
    }

    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public int hashCode() {
        return this.fData == null ? 353 : 353 + ((InputStream)this.fData).hashCode();
    }

    @Override
    public int hierarchy() {
        return 32803;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        ((InputStream)this.fData).close();
    }

    public IExpr copy() {
        return new InputStreamExpr((InputStream)this.fData);
    }

    @Override
    public String toString() {
        return this.fHead + "[Name: " + this.streamName + " Unique-ID: " + this.uniqueID + "]";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fData = (InputStream)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeObject(this.fData);
    }
}

